/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1;

import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v1.JavaLexer;
import oracle.javatools.parser.java.v1.JavaTokens;

class CommentPreprocessor
extends JavaLexer
implements JavaTokens {
    public static final int COMMENTS_NONE = 0;
    public static final int COMMENTS_JAVADOC_ONLY = 1;
    public static final int COMMENTS_ALL = 2;
    private boolean prevCommentSaved;
    private LexerToken prevComment;
    private boolean commentSaved;
    private LexerToken curComment;
    private int nonCommentLastToken;
    private int nonCommentStartOffset;
    private int nonCommentEndOffset;
    private boolean backedup;
    private int collectComments;

    public void setCommentLevel(int n) {
        this.collectComments = n;
    }

    public boolean hasSavedComment() {
        return this.backedup ? this.prevCommentSaved : this.commentSaved;
    }

    public boolean grabSavedComment(LexerToken lexerToken) {
        boolean bl = this.hasSavedComment();
        if (bl) {
            AbstractLexer.DefaultLexerToken defaultLexerToken = (AbstractLexer.DefaultLexerToken)lexerToken;
            if (this.backedup) {
                defaultLexerToken.setToken(this.prevComment.getToken());
                defaultLexerToken.setStartOffset(this.prevComment.getStartOffset());
                defaultLexerToken.setEndOffset(this.prevComment.getEndOffset());
            } else {
                defaultLexerToken.setToken(this.curComment.getToken());
                defaultLexerToken.setStartOffset(this.curComment.getStartOffset());
                defaultLexerToken.setEndOffset(this.curComment.getEndOffset());
            }
        }
        return bl;
    }

    void $init$() {
        this.prevCommentSaved = false;
        this.commentSaved = false;
        this.backedup = false;
        this.collectComments = 0;
    }

    public CommentPreprocessor() {
        this.$init$();
        super.setSkipComments(false);
        this.prevComment = this.createLexerToken();
        this.curComment = this.createLexerToken();
    }

    public void backup() {
        this.backedup = true;
    }

    public int lex(LexerToken lexerToken) {
        if (this.backedup) {
            this.backedup = false;
            AbstractLexer.DefaultLexerToken defaultLexerToken = (AbstractLexer.DefaultLexerToken)lexerToken;
            defaultLexerToken.setToken(this.nonCommentLastToken);
            defaultLexerToken.setStartOffset(this.nonCommentStartOffset);
            defaultLexerToken.setEndOffset(this.nonCommentEndOffset);
            return this.nonCommentLastToken;
        }
        this.nonCommentLastToken = 0;
        this.prevCommentSaved = this.commentSaved;
        if (this.prevCommentSaved) {
            LexerToken lexerToken2 = this.prevComment;
            this.prevComment = this.curComment;
            this.curComment = lexerToken2;
        }
        this.commentSaved = false;
        while (true) {
            int n;
            if ((n = super.lex(lexerToken)) == 26) {
                if (this.collectComments < 1) continue;
                this.saveComment(lexerToken);
                continue;
            }
            if (n != 25 && n != 24) break;
            if (this.collectComments != 2) continue;
            this.saveComment(lexerToken);
        }
        this.nonCommentLastToken = lexerToken.getToken();
        this.nonCommentStartOffset = lexerToken.getStartOffset();
        this.nonCommentEndOffset = lexerToken.getEndOffset();
        return this.nonCommentLastToken;
    }

    public void setSkipComments(boolean bl) {
        this.setCommentLevel(bl ? 0 : 2);
    }

    private void saveComment(LexerToken lexerToken) {
        AbstractLexer.DefaultLexerToken defaultLexerToken = (AbstractLexer.DefaultLexerToken)this.curComment;
        defaultLexerToken.setToken(lexerToken.getToken());
        defaultLexerToken.setStartOffset(lexerToken.getStartOffset());
        defaultLexerToken.setEndOffset(lexerToken.getEndOffset());
        this.commentSaved = true;
    }
}

