/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1;

import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v1.JavaTokens;
import oracle.javatools.parser.util.KeywordTable;

public class JavaLexer
extends AbstractLexer
implements JavaTokens {
    private static final int MASK_ID_START = 0x1000000;
    private static final int MASK_SIMPLE_OP = 0x2000000;
    private static final int MASK_DECIMAL = 0x4000000;
    private static final int MASK_COMP_EQ_OP = 0x8000000;
    private static final int MASK_TK = 4095;
    private int lastToken = -1;
    private int startOffset = -1;
    private int endOffset = -1;
    private boolean useLastToken = false;
    private boolean skipComments = false;
    private boolean recognizeSQLJ = true;
    private static KeywordTable keywordTable;
    private static boolean[] identifierPart;
    private static int[] quickTable;

    static {
        JavaLexer.initialize();
    }

    public JavaLexer() {
        this.setTextBuffer(null);
        this.setPosition(0);
    }

    public void setSkipComments(boolean bl) {
        this.skipComments = bl;
    }

    public void setRecognizeSQLJ(boolean bl) {
        this.recognizeSQLJ = bl;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int lex(LexerToken var1_1) {
        block87: {
            block88: {
                if (this.useLastToken) {
                    this.useLastToken = false;
                    return this.fillLexerToken(var1_1);
                }
                this.lastToken = 0;
                try {
                    block63: while (true) {
                        var2_2 = this.textBuffer.getChar(this.currentPos++);
                        switch (var2_2) {
                            case '\t': 
                            case '\n': 
                            case '\f': 
                            case '\r': 
                            case ' ': {
                                continue block63;
                            }
                        }
                        this.startOffset = this.currentPos - 1;
                        if (var2_2 < '\u0100') {
                            var3_3 = JavaLexer.quickTable[var2_2];
                            if ((var3_3 & 0x1000000) != 0) {
                                this.handleIdentifier(var2_2);
                                break block87;
                            }
                            if ((var3_3 & 0x2000000) != 0) {
                                this.lastToken = var3_3 & 4095;
                                break block87;
                            }
                            if ((var3_3 & 0x4000000) != 0) {
                                this.handleDecimal(var2_2);
                                break block87;
                            }
                            if ((var3_3 & 0x8000000) != 0) {
                                this.lastToken = var3_3 & 4095;
                                if (this.textBuffer.getChar(this.currentPos) == '=') {
                                    this.lastToken = var3_3 >> 12 & 4095;
                                    ++this.currentPos;
                                }
                                break block87;
                            }
                        }
                        switch (var2_2) {
                            case '&': {
                                this.lastToken = 34;
                                var2_2 = this.textBuffer.getChar(this.currentPos);
                                switch (var2_2) {
                                    case '&': {
                                        this.lastToken = 52;
                                        ++this.currentPos;
                                        break;
                                    }
                                    case '=': {
                                        this.lastToken = 32;
                                        ++this.currentPos;
                                        break block87;
                                    }
                                }
                                break block87;
                            }
                            case '|': {
                                this.lastToken = 36;
                                var2_2 = this.textBuffer.getChar(this.currentPos);
                                switch (var2_2) {
                                    case '|': {
                                        this.lastToken = 54;
                                        ++this.currentPos;
                                        break;
                                    }
                                    case '=': {
                                        this.lastToken = 66;
                                        ++this.currentPos;
                                        break block87;
                                    }
                                }
                                break block87;
                            }
                            case '+': {
                                this.lastToken = 67;
                                var2_2 = this.textBuffer.getChar(this.currentPos);
                                switch (var2_2) {
                                    case '+': {
                                        this.lastToken = 48;
                                        ++this.currentPos;
                                        break;
                                    }
                                    case '=': {
                                        this.lastToken = 68;
                                        ++this.currentPos;
                                        break block87;
                                    }
                                }
                                break block87;
                            }
                            case '-': {
                                this.lastToken = 59;
                                var2_2 = this.textBuffer.getChar(this.currentPos);
                                switch (var2_2) {
                                    case '-': {
                                        this.lastToken = 40;
                                        ++this.currentPos;
                                        break;
                                    }
                                    case '=': {
                                        this.lastToken = 60;
                                        ++this.currentPos;
                                        break block87;
                                    }
                                }
                                break block87;
                            }
                            case '<': {
                                this.lastToken = 58;
                                var2_2 = this.textBuffer.getChar(this.currentPos);
                                switch (var2_2) {
                                    case '=': {
                                        this.lastToken = 51;
                                        ++this.currentPos;
                                        break;
                                    }
                                    case '<': {
                                        this.lastToken = 56;
                                        ++this.currentPos;
                                        var2_2 = this.textBuffer.getChar(this.currentPos);
                                        if (var2_2 == '=') {
                                            this.lastToken = 57;
                                            ++this.currentPos;
                                        }
                                        break block87;
                                    }
                                }
                                break block87;
                            }
                            case '>': {
                                this.lastToken = 46;
                                var2_2 = this.textBuffer.getChar(this.currentPos);
                                block39 : switch (var2_2) {
                                    case '=': {
                                        this.lastToken = 45;
                                        ++this.currentPos;
                                        break;
                                    }
                                    case '>': {
                                        this.lastToken = 73;
                                        ++this.currentPos;
                                        var2_2 = this.textBuffer.getChar(this.currentPos);
                                        switch (var2_2) {
                                            case '=': {
                                                this.lastToken = 74;
                                                ++this.currentPos;
                                                break block39;
                                            }
                                            case '>': {
                                                this.lastToken = 76;
                                                ++this.currentPos;
                                                var2_2 = this.textBuffer.getChar(this.currentPos);
                                                if (var2_2 != '=') break;
                                                this.lastToken = 77;
                                                ++this.currentPos;
                                            }
                                        }
                                        break block87;
                                    }
                                }
                                break block87;
                            }
                            case '/': {
                                this.lastToken = 41;
                                var2_2 = this.textBuffer.getChar(this.currentPos);
                                switch (var2_2) {
                                    case '=': {
                                        this.lastToken = 42;
                                        ++this.currentPos;
                                        break;
                                    }
                                    case '*': {
                                        this.lastToken = 25;
                                        ++this.currentPos;
                                        this.skipMultiLineComment();
                                        if (this.textBuffer.getChar(this.startOffset + 2) == '*') {
                                            this.lastToken = 26;
                                        }
                                        if (this.skipComments) {
                                            this.lastToken = 0;
                                            continue block63;
                                        }
                                        break block87;
                                    }
                                    case '/': {
                                        this.lastToken = 24;
                                        ++this.currentPos;
                                        this.skipLineComment();
                                        if (this.skipComments) {
                                            this.lastToken = 0;
                                            continue block63;
                                        } else {
                                            break;
                                        }
                                    }
                                }
                                break block87;
                            }
                            case '\"': {
                                this.lastToken = 14;
                                this.skipStringLiteral();
                                break block63;
                            }
                            case '\'': {
                                this.lastToken = 13;
                                this.skipCharacterLiteral();
                                break block63;
                            }
                            case '.': {
                                this.lastToken = 43;
                                var2_2 = this.textBuffer.getChar(this.currentPos);
                                if (JavaLexer.isDecimalDigit(var2_2)) {
                                    ++this.currentPos;
                                    this.lastToken = 10;
                                    this.skipFloatLiteral();
                                    break block63;
                                }
                                break block87;
                            }
                            case '0': {
                                this.lastToken = 8;
                                var2_2 = this.textBuffer.getChar(this.currentPos);
                                switch (var2_2) {
                                    case 'X': 
                                    case 'x': {
                                        ++this.currentPos;
                                        this.skipHexDigits();
                                        break block63;
                                    }
                                    case '0': 
                                    case '1': 
                                    case '2': 
                                    case '3': 
                                    case '4': 
                                    case '5': 
                                    case '6': 
                                    case '7': 
                                    case '8': 
                                    case '9': {
                                        ++this.currentPos;
                                        this.skipDecimalDigits();
                                        break;
                                    }
                                }
                                var2_2 = this.textBuffer.getChar(this.currentPos);
                                switch (var2_2) {
                                    case '.': {
                                        ++this.currentPos;
                                        this.lastToken = 10;
                                        this.skipFloatLiteral();
                                        break;
                                    }
                                    case 'E': 
                                    case 'e': {
                                        this.lastToken = 10;
                                        this.skipFloatLiteral();
                                        break;
                                    }
                                    case 'L': 
                                    case 'l': {
                                        ++this.currentPos;
                                        break;
                                    }
                                    case 'D': 
                                    case 'F': 
                                    case 'd': 
                                    case 'f': {
                                        ++this.currentPos;
                                        this.lastToken = 10;
                                        break block87;
                                    }
                                }
                                break block87;
                            }
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                this.handleDecimal(var2_2);
                                break block63;
                            }
                            case '#': {
                                if (this.recognizeSQLJ && this.textBuffer.getLength() - this.currentPos >= 3 && this.textBuffer.getChar(this.currentPos) == 's' && this.textBuffer.getChar(this.currentPos + 1) == 'q' && this.textBuffer.getChar(this.currentPos + 2) == 'l') {
                                    if (this.textBuffer.getLength() - this.currentPos > 3) {
                                        var2_2 = this.textBuffer.getChar(this.currentPos + 3);
                                        if (Character.isWhitespace(var2_2) || var2_2 == '{' || var2_2 == '[') {
                                            this.lastToken = 6;
                                            this.currentPos += 4;
                                            this.skipSQLJStatement();
                                            break block63;
                                        }
                                    } else {
                                        this.lastToken = 6;
                                        this.currentPos += 3;
                                        this.skipSQLJStatement();
                                        break block63;
                                    }
                                }
                            }
                            default: {
                                if (!Character.isJavaIdentifierStart(var2_2)) {
                                    this.lastToken = 0;
                                    continue block63;
                                }
                                this.handleIdentifier(var2_2);
                            }
                        }
                        break;
                    }
                    break block87;
                }
                catch (IndexOutOfBoundsException var4_4) {
                    this.currentPos = this.textBuffer.getLength();
                    if (this.lastToken == 0) {
                        this.startOffset = this.currentPos;
                        break block88;
                    }
                    if (this.lastToken != 4) break block88;
                    var5_5 = 0;
                    var6_6 = this.startOffset;
                    ** while (var6_6 < this.currentPos)
                }
lbl-1000:
                // 1 sources

                {
                    var7_7 = this.textBuffer.getChar(var6_6);
                    var5_5 = KeywordTable.computePartialHash(var7_7, var5_5);
                    ++var6_6;
                    continue;
                }
lbl235:
                // 1 sources

                var8_8 = JavaLexer.keywordTable.lookupKeyword(this.textBuffer, this.startOffset, this.currentPos, var5_5);
                if (var8_8 != -1) {
                    this.lastToken = var8_8;
                }
            }
            if (this.skipComments && (this.lastToken == 24 || this.lastToken == 25 || this.lastToken == 26)) {
                this.lastToken = 0;
                this.startOffset = this.currentPos;
            } else if (this.lastToken == 25 && this.startOffset + 2 < this.currentPos && this.textBuffer.getChar(this.startOffset + 2) == '*') {
                this.lastToken = 26;
            }
        }
        this.endOffset = this.currentPos;
        this.useLastToken = false;
        return this.fillLexerToken(var1_1);
    }

    public void backup() {
        this.useLastToken = true;
    }

    public void setPosition(int n) {
        super.setPosition(n);
        this.useLastToken = false;
    }

    private void handleIdentifier(char c) {
        int n;
        this.lastToken = 4;
        int n2 = KeywordTable.computePartialHash(c, 0);
        while ((c = this.textBuffer.getChar(this.currentPos)) < '\u0100' && identifierPart[c]) {
            n2 = KeywordTable.computePartialHash(c, n2);
            ++this.currentPos;
        }
        if (c >= '\u0100') {
            while (Character.isJavaIdentifierPart(c = this.textBuffer.getChar(this.currentPos))) {
                n2 = KeywordTable.computePartialHash(c, n2);
                ++this.currentPos;
            }
        }
        if ((n = keywordTable.lookupKeyword(this.textBuffer, this.startOffset, this.currentPos, n2)) != -1) {
            this.lastToken = n;
        }
    }

    private void handleDecimal(char c) {
        this.lastToken = 8;
        this.skipDecimalDigits();
        c = this.textBuffer.getChar(this.currentPos);
        switch (c) {
            case 'L': 
            case 'l': {
                ++this.currentPos;
                break;
            }
            case 'D': 
            case 'F': 
            case 'd': 
            case 'f': {
                ++this.currentPos;
                this.lastToken = 10;
                break;
            }
            case '.': {
                ++this.currentPos;
                this.lastToken = 10;
                this.skipFloatLiteral();
                break;
            }
            case 'E': 
            case 'e': {
                this.lastToken = 10;
                this.skipFloatLiteral();
            }
        }
    }

    private void skipStringLiteral() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\n': 
                case '\r': {
                    --this.currentPos;
                }
                case '\"': {
                    return;
                }
                case '\\': {
                    ++this.currentPos;
                }
            }
        }
    }

    private void skipCharacterLiteral() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\n': 
                case '\r': {
                    --this.currentPos;
                }
                case '\'': {
                    return;
                }
                case '\\': {
                    ++this.currentPos;
                }
            }
        }
    }

    private void skipLineComment() {
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos);
            switch (c) {
                case '\n': 
                case '\r': {
                    return;
                }
            }
            ++this.currentPos;
        }
    }

    private void skipMultiLineComment() {
        ++this.currentPos;
        while (true) {
            char c = this.textBuffer.getChar(this.currentPos);
            switch (c) {
                case '*': {
                    c = this.textBuffer.getChar(this.currentPos + 1);
                    if (c != '/') break;
                    this.currentPos += 2;
                    return;
                }
                case '/': {
                    c = this.textBuffer.getChar(this.currentPos - 1);
                    if (c != '*') break;
                    ++this.currentPos;
                    return;
                }
            }
            this.currentPos += 2;
        }
    }

    private void skipSQLJStatement() {
        boolean bl = false;
        block8: while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case ';': {
                    if (bl) continue block8;
                    return;
                }
                case '{': {
                    bl = true;
                    break;
                }
                case '}': {
                    bl = false;
                    break;
                }
                case '/': {
                    c = this.textBuffer.getChar(this.currentPos);
                    if (c == '/') {
                        this.skipLineComment();
                        break;
                    }
                    if (c != '*') continue block8;
                    this.skipMultiLineComment();
                    break;
                }
                case '-': {
                    c = this.textBuffer.getChar(this.currentPos);
                    if (c != '-') continue block8;
                    this.skipLineComment();
                    break;
                }
                case '\"': 
                case '\'': {
                    char c2 = c;
                    while ((c = this.textBuffer.getChar(this.currentPos++)) != c2) {
                    }
                    break;
                }
            }
        }
    }

    private void skipFloatLiteral() {
        char c = this.textBuffer.getChar(this.currentPos);
        while (JavaLexer.isDecimalDigit(c)) {
            ++this.currentPos;
            c = this.textBuffer.getChar(this.currentPos);
        }
        switch (c) {
            case 'E': 
            case 'e': {
                ++this.currentPos;
                c = this.textBuffer.getChar(this.currentPos);
                if (c == '+' || c == '-') {
                    ++this.currentPos;
                    c = this.textBuffer.getChar(this.currentPos);
                }
                while (JavaLexer.isDecimalDigit(c)) {
                    ++this.currentPos;
                    c = this.textBuffer.getChar(this.currentPos);
                }
                break;
            }
        }
        switch (c) {
            case 'D': 
            case 'F': 
            case 'd': 
            case 'f': {
                ++this.currentPos;
            }
        }
    }

    private void skipDecimalDigits() {
        char c;
        while (JavaLexer.isDecimalDigit(c = this.textBuffer.getChar(this.currentPos))) {
            ++this.currentPos;
        }
        return;
    }

    private void skipHexDigits() {
        while (true) {
            char c;
            if (!JavaLexer.isHexDigit(c = this.textBuffer.getChar(this.currentPos))) {
                if (c == 'l' || c == 'L') {
                    ++this.currentPos;
                }
                return;
            }
            ++this.currentPos;
        }
    }

    private int fillLexerToken(LexerToken lexerToken) {
        AbstractLexer.DefaultLexerToken defaultLexerToken = (AbstractLexer.DefaultLexerToken)lexerToken;
        defaultLexerToken.setToken(this.lastToken);
        defaultLexerToken.setStartOffset(this.startOffset);
        defaultLexerToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    public static boolean isDecimalDigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    public static boolean isOctalDigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                return true;
            }
        }
        return false;
    }

    public static boolean isHexDigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return true;
            }
        }
        return false;
    }

    private static void initialize() {
        String string;
        keywordTable = new KeywordTable(52);
        keywordTable.addKeyword("abstract", 96);
        keywordTable.addKeyword("boolean", 97);
        keywordTable.addKeyword("break", 98);
        keywordTable.addKeyword("byte", 99);
        keywordTable.addKeyword("case", 100);
        keywordTable.addKeyword("catch", 101);
        keywordTable.addKeyword("char", 102);
        keywordTable.addKeyword("class", 103);
        keywordTable.addKeyword("const", 104);
        keywordTable.addKeyword("continue", 105);
        keywordTable.addKeyword("default", 106);
        keywordTable.addKeyword("do", 107);
        keywordTable.addKeyword("double", 108);
        keywordTable.addKeyword("else", 109);
        keywordTable.addKeyword("extends", 110);
        keywordTable.addKeyword("final", 111);
        keywordTable.addKeyword("finally", 112);
        keywordTable.addKeyword("float", 113);
        keywordTable.addKeyword("for", 114);
        keywordTable.addKeyword("goto", 115);
        keywordTable.addKeyword("if", 116);
        keywordTable.addKeyword("implements", 117);
        keywordTable.addKeyword("import", 118);
        keywordTable.addKeyword("instanceof", 119);
        keywordTable.addKeyword("int", 120);
        keywordTable.addKeyword("interface", 121);
        keywordTable.addKeyword("long", 122);
        keywordTable.addKeyword("native", 123);
        keywordTable.addKeyword("new", 124);
        keywordTable.addKeyword("package", 125);
        keywordTable.addKeyword("private", 126);
        keywordTable.addKeyword("protected", 127);
        keywordTable.addKeyword("public", 128);
        keywordTable.addKeyword("return", 129);
        keywordTable.addKeyword("short", 130);
        keywordTable.addKeyword("static", 131);
        keywordTable.addKeyword("strictfp", 132);
        keywordTable.addKeyword("super", 133);
        keywordTable.addKeyword("switch", 134);
        keywordTable.addKeyword("synchronized", 135);
        keywordTable.addKeyword("this", 136);
        keywordTable.addKeyword("throw", 137);
        keywordTable.addKeyword("throws", 138);
        keywordTable.addKeyword("transient", 139);
        keywordTable.addKeyword("try", 140);
        keywordTable.addKeyword("void", 141);
        keywordTable.addKeyword("volatile", 142);
        keywordTable.addKeyword("while", 143);
        keywordTable.addKeyword("true", 12);
        keywordTable.addKeyword("false", 12);
        keywordTable.addKeyword("null", 15);
        String string2 = System.getProperty("EDITOR_J2SE_VERSION");
        boolean bl = string2 != null ? (string2.equals("1.3") || string2.equals("13") ? false : (string2.equals("1.4") || string2.equals("14") ? true : (string2.equals("1.5") || string2.equals("15") ? true : true))) : (string = System.getProperty("EDITOR_ENABLE_ASSERT")) != null && string.equals("true");
        if (bl) {
            keywordTable.addKeyword("assert", 144);
        }
        identifierPart = new boolean[256];
        int n = 0;
        while (n < 256) {
            JavaLexer.identifierPart[n] = Character.isJavaIdentifierPart((char)n);
            ++n;
        }
        quickTable = new int[256];
        int n2 = 0;
        while (n2 < 256) {
            int n3 = 0;
            if (Character.isJavaIdentifierStart((char)n2)) {
                n3 |= 0x1000000;
            }
            if (n2 != 48 && Character.isDigit((char)n2)) {
                n3 |= 0x4000000;
            }
            JavaLexer.quickTable[n2] = n3;
            ++n2;
        }
        JavaLexer.setSimpleOp(123, 49);
        JavaLexer.setSimpleOp(125, 70);
        JavaLexer.setSimpleOp(91, 50);
        JavaLexer.setSimpleOp(93, 71);
        JavaLexer.setSimpleOp(40, 55);
        JavaLexer.setSimpleOp(41, 72);
        JavaLexer.setSimpleOp(44, 39);
        JavaLexer.setSimpleOp(59, 75);
        JavaLexer.setSimpleOp(126, 35);
        JavaLexer.setSimpleOp(63, 69);
        JavaLexer.setSimpleOp(58, 38);
        JavaLexer.setCompoundEqualsOp(33, 53, 65);
        JavaLexer.setCompoundEqualsOp(42, 63, 64);
        JavaLexer.setCompoundEqualsOp(61, 33, 44);
        JavaLexer.setCompoundEqualsOp(37, 61, 62);
        JavaLexer.setCompoundEqualsOp(94, 37, 78);
        JavaLexer.setCompoundEqualsOp(33, 53, 65);
    }

    private static void setSimpleOp(int n, int n2) {
        JavaLexer.quickTable[n] = 0x2000000 | n2 & 0xFFF;
    }

    private static void setCompoundEqualsOp(int n, int n2, int n3) {
        JavaLexer.quickTable[n] = 0x8000000 | n2 & 0xFFF | (n3 & 0xFFF) << 12;
    }

    public static String tokenToString(int n) {
        switch (n) {
            case 4: {
                return "TK_IDENTIFIER";
            }
            case 8: {
                return "TK_INT_LITERAL";
            }
            case 10: {
                return "TK_FLOAT_LITERAL";
            }
            case 12: {
                return "TK_BOOLEAN_LITERAL";
            }
            case 13: {
                return "TK_CHAR_LITERAL";
            }
            case 14: {
                return "TK_STRING_LITERAL";
            }
            case 15: {
                return "TK_NULL_LITERAL";
            }
            case 24: {
                return "TK_SINGLE_COMMENT";
            }
            case 25: {
                return "TK_MULTI_COMMENT";
            }
            case 26: {
                return "TK_DOC_COMMENT";
            }
            case 49: {
                return "TK_LBRACE";
            }
            case 70: {
                return "TK_RBRACE";
            }
            case 55: {
                return "TK_LPAREN";
            }
            case 72: {
                return "TK_RPAREN";
            }
            case 50: {
                return "TK_LBRACKET";
            }
            case 71: {
                return "TK_RBRACKET";
            }
            case 43: {
                return "TK_DOT";
            }
            case 75: {
                return "TK_SEMI";
            }
            case 39: {
                return "TK_COMMA";
            }
            case 69: {
                return "TK_QUES";
            }
            case 38: {
                return "TK_COLON";
            }
            case 33: {
                return "TK_ASG";
            }
            case 44: {
                return "TK_EQ";
            }
            case 67: {
                return "TK_PLUS";
            }
            case 68: {
                return "TK_PLUS_ASG";
            }
            case 48: {
                return "TK_INC";
            }
            case 59: {
                return "TK_MINUS";
            }
            case 60: {
                return "TK_MINUS_ASG";
            }
            case 40: {
                return "TK_DEC";
            }
            case 63: {
                return "TK_MUL";
            }
            case 64: {
                return "TK_MUL_ASG";
            }
            case 41: {
                return "TK_DIV";
            }
            case 42: {
                return "TK_DIV_ASG";
            }
            case 61: {
                return "TK_MOD";
            }
            case 62: {
                return "TK_MOD_ASG";
            }
            case 56: {
                return "TK_LSH";
            }
            case 57: {
                return "TK_LSH_ASG";
            }
            case 73: {
                return "TK_RSH";
            }
            case 74: {
                return "TK_RSH_ASG";
            }
            case 76: {
                return "TK_URSH";
            }
            case 77: {
                return "TK_URSH_ASG";
            }
            case 35: {
                return "TK_BINNOT";
            }
            case 34: {
                return "TK_BINAND";
            }
            case 32: {
                return "TK_AND_ASG";
            }
            case 52: {
                return "TK_LOGAND";
            }
            case 36: {
                return "TK_BINOR";
            }
            case 66: {
                return "TK_OR_ASG";
            }
            case 54: {
                return "TK_LOGOR";
            }
            case 37: {
                return "TK_BINXOR";
            }
            case 78: {
                return "TK_XOR_ASG";
            }
            case 58: {
                return "TK_LT";
            }
            case 51: {
                return "TK_LE";
            }
            case 46: {
                return "TK_GT";
            }
            case 45: {
                return "TK_GE";
            }
            case 53: {
                return "TK_LOGNOT";
            }
            case 65: {
                return "TK_NE";
            }
            case 96: {
                return "TK_ABSTRACT";
            }
            case 144: {
                return "TK_ASSERT";
            }
            case 97: {
                return "TK_BOOLEAN";
            }
            case 98: {
                return "TK_BREAK";
            }
            case 99: {
                return "TK_BYTE";
            }
            case 100: {
                return "TK_CASE";
            }
            case 101: {
                return "TK_CATCH";
            }
            case 102: {
                return "TK_CHAR";
            }
            case 103: {
                return "TK_CLASS";
            }
            case 104: {
                return "TK_CONST";
            }
            case 105: {
                return "TK_CONTINUE";
            }
            case 106: {
                return "TK_DEFAULT";
            }
            case 107: {
                return "TK_DO";
            }
            case 108: {
                return "TK_DOUBLE";
            }
            case 109: {
                return "TK_ELSE";
            }
            case 110: {
                return "TK_EXTENDS";
            }
            case 111: {
                return "TK_FINAL";
            }
            case 112: {
                return "TK_FINALLY";
            }
            case 113: {
                return "TK_FLOAT";
            }
            case 114: {
                return "TK_FOR";
            }
            case 115: {
                return "TK_GOTO";
            }
            case 116: {
                return "TK_IF";
            }
            case 117: {
                return "TK_IMPLEMENTS";
            }
            case 118: {
                return "TK_IMPORT";
            }
            case 119: {
                return "TK_INSTANCEOF";
            }
            case 120: {
                return "TK_INT";
            }
            case 121: {
                return "TK_INTERFACE";
            }
            case 122: {
                return "TK_LONG";
            }
            case 123: {
                return "TK_NATIVE";
            }
            case 124: {
                return "TK_NEW";
            }
            case 125: {
                return "TK_PACKAGE";
            }
            case 126: {
                return "TK_PRIVATE";
            }
            case 127: {
                return "TK_PROTECTED";
            }
            case 128: {
                return "TK_PUBLIC";
            }
            case 129: {
                return "TK_RETURN";
            }
            case 130: {
                return "TK_SHORT";
            }
            case 131: {
                return "TK_STATIC";
            }
            case 132: {
                return "TK_STRICTFP";
            }
            case 133: {
                return "TK_SUPER";
            }
            case 134: {
                return "TK_SWITCH";
            }
            case 135: {
                return "TK_SYNCHRONIZED";
            }
            case 136: {
                return "TK_THIS";
            }
            case 137: {
                return "TK_THROW";
            }
            case 138: {
                return "TK_THROWS";
            }
            case 139: {
                return "TK_TRANSIENT";
            }
            case 140: {
                return "TK_TRY";
            }
            case 141: {
                return "TK_VOID";
            }
            case 142: {
                return "TK_VOLATILE";
            }
            case 143: {
                return "TK_WHILE";
            }
        }
        return "**UNKNOWN**";
    }

    public static String tokenToText(int n) {
        switch (n) {
            case 4: {
                return "identifier";
            }
            case 8: {
                return "int_literal";
            }
            case 10: {
                return "float_literal";
            }
            case 12: {
                return "boolean_literal";
            }
            case 13: {
                return "char_literal";
            }
            case 14: {
                return "string_literal";
            }
            case 15: {
                return "null";
            }
            case 24: {
                return "single_comment";
            }
            case 25: {
                return "multi_comment";
            }
            case 26: {
                return "doc_comment";
            }
            case 49: {
                return "{";
            }
            case 70: {
                return "}";
            }
            case 55: {
                return "(";
            }
            case 72: {
                return ")";
            }
            case 50: {
                return "[";
            }
            case 71: {
                return "]";
            }
            case 43: {
                return ".";
            }
            case 75: {
                return ";";
            }
            case 39: {
                return ",";
            }
            case 69: {
                return "?";
            }
            case 38: {
                return ":";
            }
            case 33: {
                return "=";
            }
            case 44: {
                return "==";
            }
            case 67: {
                return "+";
            }
            case 68: {
                return "+=";
            }
            case 48: {
                return "++";
            }
            case 59: {
                return "-";
            }
            case 60: {
                return "-=";
            }
            case 40: {
                return "--";
            }
            case 63: {
                return "*";
            }
            case 64: {
                return "*=";
            }
            case 41: {
                return "/";
            }
            case 42: {
                return "/=";
            }
            case 61: {
                return "%";
            }
            case 62: {
                return "%=";
            }
            case 56: {
                return "<<";
            }
            case 57: {
                return "<<=";
            }
            case 73: {
                return ">>";
            }
            case 74: {
                return ">>=";
            }
            case 76: {
                return ">>>";
            }
            case 77: {
                return ">>>=";
            }
            case 35: {
                return "~";
            }
            case 34: {
                return "&";
            }
            case 32: {
                return "&=";
            }
            case 52: {
                return "&&";
            }
            case 36: {
                return "|";
            }
            case 66: {
                return "|=";
            }
            case 54: {
                return "||";
            }
            case 37: {
                return "^";
            }
            case 78: {
                return "^=";
            }
            case 58: {
                return "<";
            }
            case 51: {
                return "<=";
            }
            case 46: {
                return ">";
            }
            case 45: {
                return ">=";
            }
            case 53: {
                return "!";
            }
            case 65: {
                return "!=";
            }
            case 96: {
                return "abstract";
            }
            case 144: {
                return "assert";
            }
            case 97: {
                return "boolean";
            }
            case 98: {
                return "break";
            }
            case 99: {
                return "byte";
            }
            case 100: {
                return "case";
            }
            case 101: {
                return "catch";
            }
            case 102: {
                return "char";
            }
            case 103: {
                return "class";
            }
            case 104: {
                return "const";
            }
            case 105: {
                return "continue";
            }
            case 106: {
                return "default";
            }
            case 107: {
                return "do";
            }
            case 108: {
                return "double";
            }
            case 109: {
                return "else";
            }
            case 110: {
                return "extends";
            }
            case 111: {
                return "final";
            }
            case 112: {
                return "finally";
            }
            case 113: {
                return "float";
            }
            case 114: {
                return "for";
            }
            case 115: {
                return "goto";
            }
            case 116: {
                return "if";
            }
            case 117: {
                return "implements";
            }
            case 118: {
                return "import";
            }
            case 119: {
                return "instanceof";
            }
            case 120: {
                return "int";
            }
            case 121: {
                return "interface";
            }
            case 122: {
                return "long";
            }
            case 123: {
                return "native";
            }
            case 124: {
                return "new";
            }
            case 125: {
                return "package";
            }
            case 126: {
                return "private";
            }
            case 127: {
                return "protected";
            }
            case 128: {
                return "public";
            }
            case 129: {
                return "return";
            }
            case 130: {
                return "short";
            }
            case 131: {
                return "static";
            }
            case 132: {
                return "strictfp";
            }
            case 133: {
                return "super";
            }
            case 134: {
                return "switch";
            }
            case 135: {
                return "synchronized";
            }
            case 136: {
                return "this";
            }
            case 137: {
                return "throw";
            }
            case 138: {
                return "throws";
            }
            case 139: {
                return "transient";
            }
            case 140: {
                return "try";
            }
            case 141: {
                return "void";
            }
            case 142: {
                return "volatile";
            }
            case 143: {
                return "while";
            }
        }
        return "**UNKNOWN**";
    }
}

