/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.SyntaxListener;
import oracle.javatools.parser.SyntaxToken;
import oracle.javatools.parser.java.v1.JavaSyntaxCodes;
import oracle.javatools.parser.java.v1.JavaSyntaxRecognizer;
import oracle.javatools.parser.java.v1.symbol.CommonRoot;
import oracle.javatools.parser.java.v1.symbol.JavaSymbol;
import oracle.javatools.parser.java.v1.symbol.JavaSymbolFactory;
import oracle.javatools.parser.java.v1.symbol.Scope;

public class JavaTreeGenerator
implements SyntaxListener,
JavaSyntaxCodes {
    private static final int FORCE_FINISH_THRESHOLD = 25;
    private ReadTextBuffer textBuffer;
    private JavaSyntaxRecognizer recognizer;
    private JavaSymbolFactory factory;
    private JavaSymbol currentParent;
    private CommonRoot currentRoot;
    private int lastOffset;

    void $init$() {
        this.currentParent = null;
        this.currentRoot = null;
        this.lastOffset = 0;
    }

    void initialize(ReadTextBuffer readTextBuffer) {
        this.initialize(readTextBuffer, null);
    }

    void initialize(ReadTextBuffer readTextBuffer, Scope scope) {
        JavaSyntaxRecognizer javaSyntaxRecognizer = JavaSyntaxRecognizer.newRecognizer();
        javaSyntaxRecognizer.initialize(readTextBuffer);
        this.initialize(javaSyntaxRecognizer, scope);
    }

    void initialize(JavaSyntaxRecognizer javaSyntaxRecognizer) {
        this.initialize(javaSyntaxRecognizer, null);
    }

    void initialize(JavaSyntaxRecognizer javaSyntaxRecognizer, Scope scope) {
        this.recognizer = javaSyntaxRecognizer;
        this.recognizer.setListener(this);
        this.textBuffer = this.recognizer.getLexer().getTextBuffer();
        this.factory = new JavaSymbolFactory(this.textBuffer, scope);
    }

    public JavaSyntaxRecognizer getRecognizer() {
        return this.recognizer;
    }

    private void forceFinish() {
        int n = 0;
        while (this.currentParent != null) {
            JavaSymbol javaSymbol = this.currentParent.getParent();
            if (!this.factory.forceFinishSymbol(this.currentParent, this.lastOffset) && 25 < n++ && this.currentParent != this.currentRoot) {
                this.factory.forceFinishSymbol(this.currentRoot, this.lastOffset);
                return;
            }
            this.currentParent = javaSymbol;
        }
    }

    public CommonRoot generate() {
        block3: {
            this.currentRoot = (CommonRoot)this.factory.createSymbol(10, -1, -1, null);
            this.currentParent = this.currentRoot;
            try {
                this.recognizer.parse();
            }
            catch (RuntimeException runtimeException) {
                if (this.recognizer.getDebugLevel() != 0) break block3;
                CommonRoot commonRoot = null;
                return commonRoot;
            }
        }
        if (this.currentParent != null) {
            this.forceFinish();
        }
        return this.currentRoot;
    }

    private void debug(SyntaxToken syntaxToken) {
        int n = syntaxToken.getCode();
        int n2 = syntaxToken.getStartOffset();
        int n3 = syntaxToken.getEndOffset();
        String string = this.recognizer._codeToString(n);
        if (n == 1) {
            System.out.println("Error message: " + syntaxToken.getContextString());
        }
        if (n3 == -1) {
            System.out.println("begin> " + string + ". Start = " + n2);
        } else {
            System.out.println("  " + string + ". (  Start, End  ) = (  " + n2 + ", " + n3 + "  )");
            String string2 = "";
            string2 = n3 != -1 && n2 != -1 ? new String(this.textBuffer.getChars(n2, n3 - n2)) : "empty>";
            System.out.println("\t\"" + string2 + "\"");
            System.out.println("");
        }
    }

    public void receive(SyntaxToken syntaxToken, int n) {
        boolean bl;
        if (n == 1) {
            this.factory.createAndFinishErrorSymbol(syntaxToken, this.currentRoot);
            return;
        }
        boolean bl2 = bl = syntaxToken.getEndOffset() == -1;
        if (bl) {
            this.currentParent = this.factory.createSymbol(syntaxToken, this.currentParent);
        } else if (this.currentParent.getCode() == n) {
            this.lastOffset = syntaxToken.getEndOffset();
            JavaSymbol javaSymbol = this.currentParent.getParent();
            this.factory.finishSymbol(this.currentParent, syntaxToken);
            this.currentParent = javaSymbol;
        } else if (n != 0) {
            JavaSymbol javaSymbol = this.factory.createSymbol(syntaxToken, this.currentParent);
            this.factory.finishSymbol(javaSymbol, syntaxToken);
        } else {
            throw new RuntimeException("EOF!!!");
        }
    }

    public JavaTreeGenerator() {
        this.$init$();
    }
}

