/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Segment;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v1.JavaParser;
import oracle.javatools.parser.java.v1.symbol.ClassSymbol;
import oracle.javatools.parser.java.v1.symbol.ExpressionSymbol;
import oracle.javatools.parser.java.v1.symbol.ImportSymbol;
import oracle.javatools.parser.java.v1.symbol.JavaSymbol;
import oracle.javatools.parser.java.v1.symbol.MethodSymbol;
import oracle.javatools.parser.java.v1.symbol.NameSymbol;
import oracle.javatools.parser.java.v1.symbol.Nameable;
import oracle.javatools.parser.java.v1.symbol.PackageSymbol;
import oracle.javatools.parser.java.v1.symbol.RootSymbol;
import oracle.javatools.parser.java.v1.symbol.Scope;
import oracle.javatools.parser.java.v1.symbol.TypeSymbol;
import oracle.javatools.parser.java.v1.symbol.VariableSymbol;

public final class JavaUtilities {
    private static final int IMPORTS_EXPLICIT_ONLY = 1;
    private static final int IMPORTS_MULTI_ONLY = 2;
    private static final int IMPORTS_ALL = 3;

    private JavaUtilities() {
    }

    public static RootSymbol getParseTree(ReadTextBuffer readTextBuffer) {
        return JavaUtilities.getParseTree(readTextBuffer, false);
    }

    public static RootSymbol getParseTree(ReadTextBuffer readTextBuffer, boolean bl) {
        RootSymbol rootSymbol = null;
        readTextBuffer.readLock();
        try {
            try {
                JavaParser.ParsingOptions parsingOptions = new JavaParser.ParsingOptions();
                parsingOptions.parseDepth = bl ? 3 : 2;
                parsingOptions.reportErrors = true;
                rootSymbol = (RootSymbol)JavaParser.parse(readTextBuffer, parsingOptions);
            }
            catch (Exception exception) {
                rootSymbol = null;
            }
        }
        finally {
            readTextBuffer.readUnlock();
        }
        return rootSymbol;
    }

    public static RootSymbol getImportsParseTree(TextBuffer textBuffer) {
        RootSymbol rootSymbol = null;
        textBuffer.readLock();
        try {
            try {
                JavaParser.ParsingOptions parsingOptions = new JavaParser.ParsingOptions();
                parsingOptions.parseDepth = 1;
                parsingOptions.reportErrors = true;
                rootSymbol = (RootSymbol)JavaParser.parse(textBuffer, parsingOptions);
            }
            catch (Exception exception) {
                rootSymbol = null;
            }
        }
        finally {
            textBuffer.readUnlock();
        }
        return rootSymbol;
    }

    public static ExpressionSymbol parseExpression(String string) {
        ReadTextBuffer readTextBuffer = TextBufferFactory.createReadTextBuffer(string);
        JavaParser.ParsingOptions parsingOptions = new JavaParser.ParsingOptions();
        parsingOptions.inputType = 3;
        ExpressionSymbol expressionSymbol = (ExpressionSymbol)JavaParser.parse(readTextBuffer, parsingOptions);
        return expressionSymbol;
    }

    public static ExpressionSymbol parseExpression(ReadTextBuffer readTextBuffer, int n, int n2, Scope scope) {
        EofTextBuffer eofTextBuffer = new EofTextBuffer(readTextBuffer, n2, null);
        JavaParser.ParsingOptions parsingOptions = new JavaParser.ParsingOptions();
        parsingOptions.inputType = 3;
        parsingOptions.startOffset = n;
        parsingOptions.scope = scope;
        return (ExpressionSymbol)JavaParser.parse(eofTextBuffer, parsingOptions);
    }

    public static MethodSymbol parseMethodDeclaration(String string) {
        String string2 = "class __aoeunth__ { " + string + " { } }";
        ReadTextBuffer readTextBuffer = TextBufferFactory.createReadTextBuffer(string2);
        RootSymbol rootSymbol = JavaParser.parse(readTextBuffer);
        if (rootSymbol == null) {
            return null;
        }
        try {
            ClassSymbol[] classSymbolArray = rootSymbol.getClasses();
            ClassSymbol classSymbol = classSymbolArray[0];
            MethodSymbol[] methodSymbolArray = classSymbol.getMethods();
            MethodSymbol methodSymbol = methodSymbolArray[0];
            if (methodSymbol != null) {
                MethodSymbol methodSymbol2 = methodSymbol;
                return methodSymbol2;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    public static String[] getExplicitImports(RootSymbol rootSymbol) {
        List list = JavaUtilities.getImports(rootSymbol, 1);
        String[] stringArray = JavaUtilities.convertListToArray(list);
        return stringArray;
    }

    public static String[] getMultiImports(RootSymbol rootSymbol) {
        List list = JavaUtilities.getImports(rootSymbol, 2);
        String[] stringArray = JavaUtilities.convertListToArray(list);
        return stringArray;
    }

    public static String[] getMultiImportPackages(RootSymbol rootSymbol) {
        List list = JavaUtilities.getImports(rootSymbol, 2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            int n = string.lastIndexOf(46);
            String string2 = string.substring(0, n);
            arrayList.add(string2);
        }
        String[] stringArray = JavaUtilities.convertListToArray(arrayList);
        return stringArray;
    }

    public static String[] getAllImports(RootSymbol rootSymbol) {
        List list = JavaUtilities.getImports(rootSymbol, 3);
        String[] stringArray = JavaUtilities.convertListToArray(list);
        return stringArray;
    }

    public static String getPackageName(RootSymbol rootSymbol) {
        String string = "";
        if (rootSymbol != null) {
            PackageSymbol packageSymbol = rootSymbol.getPackage();
            string = JavaUtilities.getSymbolName(packageSymbol);
        }
        return string;
    }

    public static String getClassName(ClassSymbol classSymbol) {
        return JavaUtilities.getSymbolName(classSymbol);
    }

    public static String getMethodName(MethodSymbol methodSymbol) {
        return JavaUtilities.getSymbolName(methodSymbol);
    }

    public static String getVariableName(VariableSymbol variableSymbol) {
        return JavaUtilities.getSymbolName(variableSymbol);
    }

    public static String getTypeName(TypeSymbol typeSymbol) {
        return JavaUtilities.getSymbolName(typeSymbol);
    }

    public static int getSymbolNameOffset(Nameable nameable) {
        int n = -1;
        if (nameable != null) {
            NameSymbol nameSymbol = nameable.getName();
            if (nameSymbol != null) {
                return nameSymbol.getStartOffset();
            }
            return ((JavaSymbol)((Object)nameable)).getStartOffset();
        }
        return n;
    }

    public static int getSymbolNameLength(Nameable nameable) {
        NameSymbol nameSymbol;
        int n = 0;
        if (nameable != null && (nameSymbol = nameable.getName()) != null) {
            return nameSymbol.getEndOffset() - nameSymbol.getStartOffset();
        }
        return n;
    }

    public static String getSymbolName(Nameable nameable) {
        String string = "";
        if (nameable != null) {
            NameSymbol nameSymbol = nameable.getName();
            string = JavaUtilities.getSymbolName(nameSymbol);
        }
        return string;
    }

    public static String getSymbolName(NameSymbol nameSymbol) {
        String string;
        String string2 = "";
        if (nameSymbol != null && (string = nameSymbol.getValue()) != null) {
            string2 = string;
        }
        return string2;
    }

    public static int getArrayDimension(TypeSymbol typeSymbol) {
        int n = 0;
        if (typeSymbol != null) {
            n = typeSymbol.getArrayDimension();
        }
        return n;
    }

    public static String[] convertListToArray(List list) {
        int n = list.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)list.get(n2);
            ++n2;
        }
        return stringArray;
    }

    public static boolean inJavaSymbol(int n, JavaSymbol javaSymbol) {
        return n >= javaSymbol.getStartOffset() && n <= javaSymbol.getEndOffset();
    }

    /*
     * Unable to fully structure code
     */
    public static String trimWhitespace(String var0, int var1_1, int var2_2) {
        while (var1_1 < var2_2 && Character.isWhitespace(var0.charAt(var1_1))) {
            ++var1_1;
        }
        if (var1_1 != var2_2) ** GOTO lbl7
        return "";
lbl-1000:
        // 1 sources

        {
            --var2_2;
lbl7:
            // 2 sources

            ** while (Character.isWhitespace((char)var0.charAt((int)(var2_2 - 1))))
        }
lbl8:
        // 1 sources

        return var0.substring(var1_1, var2_2);
    }

    public static String trimWhitespace(String string, int n) {
        return JavaUtilities.trimWhitespace(string, n, string.length());
    }

    public static String trimWhitespace(String string) {
        return JavaUtilities.trimWhitespace(string, 0, string.length());
    }

    public static String[] breakUpQualifiedName(String string) {
        int n = string.length();
        int n2 = 1;
        int n3 = 0;
        while (n3 < n) {
            if (string.charAt(n3) == '.') {
                ++n2;
            }
            ++n3;
        }
        int n4 = n2;
        String[] stringArray = new String[n4];
        int n5 = -1;
        int n6 = string.indexOf(46);
        int n7 = 0;
        while (n7 < n4 - 1) {
            stringArray[n7] = JavaUtilities.trimWhitespace(string, n5 + 1, n6);
            n5 = n6;
            n6 = string.indexOf(46, n5 + 1);
            ++n7;
        }
        stringArray[n4 - 1] = JavaUtilities.trimWhitespace(string, n5 + 1);
        return stringArray;
    }

    private static List getImports(RootSymbol rootSymbol, int n) {
        ImportSymbol[] importSymbolArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (rootSymbol != null && (importSymbolArray = rootSymbol.getImports()) != null) {
            int n2 = importSymbolArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ImportSymbol importSymbol = importSymbolArray[n3];
                String string = JavaUtilities.getSymbolName(importSymbol);
                if (string != null && string.length() > 0) {
                    int n4;
                    int n5 = n4 = string.endsWith(".*") ? 2 : 1;
                    if ((n4 & n) != 0) {
                        arrayList.add(string);
                    }
                }
                ++n3;
            }
        }
        return arrayList;
    }

    private static class EofTextBuffer
    implements ReadTextBuffer {
        private ReadTextBuffer textBuffer;
        private int eofOffset;

        private EofTextBuffer(ReadTextBuffer readTextBuffer, int n) {
            this.textBuffer = readTextBuffer;
            this.eofOffset = n;
        }

        public int getLength() {
            return this.eofOffset;
        }

        public char getChar(int n) throws IndexOutOfBoundsException {
            if (this.eofOffset < n + 1) {
                throw new IndexOutOfBoundsException("Index out of range: " + n);
            }
            return this.textBuffer.getChar(n);
        }

        public char[] getChars(int n, int n2) throws IndexOutOfBoundsException {
            if (this.eofOffset < n + n2) {
                throw new IndexOutOfBoundsException("Index out of range: " + (n + n2));
            }
            return this.textBuffer.getChars(n, n2);
        }

        public String getString(int n, int n2) throws IndexOutOfBoundsException {
            if (this.eofOffset < n + n2) {
                throw new IndexOutOfBoundsException("Index out of range: " + (n + n2));
            }
            return this.textBuffer.getString(n, n2);
        }

        public void getText(int n, int n2, Segment segment) throws IndexOutOfBoundsException {
            if (this.eofOffset < n + n2) {
                throw new IndexOutOfBoundsException("Index out of range: " + (n + n2));
            }
            this.textBuffer.getText(n, n2, segment);
        }

        public void readLock() {
            this.textBuffer.readLock();
        }

        public boolean tryReadLock() {
            return this.textBuffer.tryReadLock();
        }

        public int getLockStatus() {
            return this.textBuffer.getLockStatus();
        }

        public void readUnlock() {
            this.textBuffer.readUnlock();
        }

        EofTextBuffer(ReadTextBuffer readTextBuffer, int n, 1 var3_3) {
            this(readTextBuffer, n);
        }

        public final class 1 {
        }
    }
}

