/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1.symbol;

import java.util.ArrayList;
import oracle.javatools.parser.java.v1.symbol.ClassSymbol;
import oracle.javatools.parser.java.v1.symbol.CommentSymbol;
import oracle.javatools.parser.java.v1.symbol.FieldSymbol;
import oracle.javatools.parser.java.v1.symbol.InnerClassSymbol;
import oracle.javatools.parser.java.v1.symbol.JavaSymbol;
import oracle.javatools.parser.java.v1.symbol.MemberSymbol;
import oracle.javatools.parser.java.v1.symbol.MethodSymbol;

public class ClassBodySymbol
extends JavaSymbol {
    private ArrayList members;
    private ArrayList constructors;
    private ArrayList fields;
    private ArrayList methods;
    private ArrayList innerClasses;
    private ArrayList initializers;
    private MemberSymbol[] memberArray;
    private MethodSymbol[] constructorArray;
    private MethodSymbol[] methodArray;
    private FieldSymbol[] fieldArray;
    private InnerClassSymbol[] innerClassArray;
    private MemberSymbol[] initializerArray;

    void $init$() {
        this.members = ClassBodySymbol.allocArrayList();
        this.constructors = ClassBodySymbol.allocArrayList();
        this.fields = ClassBodySymbol.allocArrayList();
        this.methods = ClassBodySymbol.allocArrayList();
        this.innerClasses = ClassBodySymbol.allocArrayList();
        this.initializers = ClassBodySymbol.allocArrayList();
        this.memberArray = null;
        this.constructorArray = null;
        this.methodArray = null;
        this.fieldArray = null;
        this.innerClassArray = null;
        this.initializerArray = null;
    }

    ClassBodySymbol() {
        super(65);
        this.$init$();
    }

    void addInitializer(MemberSymbol memberSymbol) {
        this.initializers.add(memberSymbol);
        this.members.add(memberSymbol);
    }

    void addConstructor(MethodSymbol methodSymbol) {
        this.constructors.add(methodSymbol);
        this.members.add(methodSymbol);
    }

    void addMethod(MethodSymbol methodSymbol) {
        this.methods.add(methodSymbol);
        this.members.add(methodSymbol);
    }

    void addField(FieldSymbol fieldSymbol) {
        this.fields.add(fieldSymbol);
        this.members.add(fieldSymbol);
    }

    void addInnerClass(InnerClassSymbol innerClassSymbol) {
        this.innerClasses.add(innerClassSymbol);
        this.members.add(innerClassSymbol);
    }

    void doneParsing() {
        this.generateMemberArray();
        this.generateMethodArray();
        this.generateConstructorArray();
        this.generateFieldArray();
        this.generateInnerClassArray();
        this.generateInitializerArray();
        ((ClassSymbol)this.parent).setBody(this);
    }

    void doneParsingLocalClass(boolean bl, ClassSymbol classSymbol) {
        MemberSymbol[] memberSymbolArray = this.listMembers();
        int n = memberSymbolArray.length;
        int n2 = 0;
        while (n2 < n) {
            CommentSymbol commentSymbol = memberSymbolArray[n2].getComment();
            if (commentSymbol != null) {
                commentSymbol.useDefaultFlags();
            }
            ++n2;
        }
        JavaSymbol javaSymbol = this.parent;
        while (javaSymbol != null) {
            if (javaSymbol instanceof MemberSymbol) {
                MemberSymbol memberSymbol = (MemberSymbol)javaSymbol;
                memberSymbol.addLocalClass(classSymbol);
                break;
            }
            javaSymbol = javaSymbol.parent;
        }
    }

    public MemberSymbol[] listMembers() {
        if (this.memberArray == null) {
            this.generateMemberArray();
        }
        return this.memberArray;
    }

    public MethodSymbol[] listMethods() {
        if (this.methodArray == null) {
            this.generateMethodArray();
        }
        return this.methodArray;
    }

    public MethodSymbol[] listConstructors() {
        if (this.constructorArray == null) {
            this.generateConstructorArray();
        }
        return this.constructorArray;
    }

    public FieldSymbol[] listFields() {
        if (this.fieldArray == null) {
            this.generateFieldArray();
        }
        return this.fieldArray;
    }

    public InnerClassSymbol[] listInnerClasses() {
        if (this.innerClassArray == null) {
            this.generateInnerClassArray();
        }
        return this.innerClassArray;
    }

    public MemberSymbol[] listInitializers() {
        if (this.initializerArray == null) {
            this.generateInitializerArray();
        }
        return this.initializerArray;
    }

    ClassSymbol getEnclosingClass() {
        return (ClassSymbol)this.parent;
    }

    private void generateMemberArray() {
        int n = this.members.size();
        this.memberArray = n > 0 ? this.members.toArray(new MemberSymbol[n]) : MemberSymbol.EMPTY_ARRAY;
        ClassBodySymbol.freeArrayList(this.members);
        this.members = null;
    }

    private void generateMethodArray() {
        int n = this.methods.size();
        this.methodArray = n > 0 ? this.methods.toArray(new MethodSymbol[n]) : MethodSymbol.EMPTY_ARRAY;
        ClassBodySymbol.freeArrayList(this.methods);
        this.methods = null;
    }

    private void generateConstructorArray() {
        int n = this.constructors.size();
        this.constructorArray = n > 0 ? this.constructors.toArray(new MethodSymbol[n]) : MethodSymbol.EMPTY_ARRAY;
        ClassBodySymbol.freeArrayList(this.constructors);
        this.constructors = null;
    }

    private void generateFieldArray() {
        int n = this.fields.size();
        this.fieldArray = n > 0 ? this.fields.toArray(new FieldSymbol[n]) : FieldSymbol.EMPTY_ARRAY;
        ClassBodySymbol.freeArrayList(this.fields);
        this.fields = null;
    }

    private void generateInnerClassArray() {
        int n = this.innerClasses.size();
        this.innerClassArray = n > 0 ? this.innerClasses.toArray(new InnerClassSymbol[n]) : InnerClassSymbol.EMPTY_ARRAY;
        ClassBodySymbol.freeArrayList(this.innerClasses);
        this.innerClasses = null;
    }

    private void generateInitializerArray() {
        int n = this.initializers.size();
        this.initializerArray = n > 0 ? this.initializers.toArray(new MemberSymbol[n]) : MemberSymbol.EMPTY_ARRAY;
        ClassBodySymbol.freeArrayList(this.initializers);
        this.initializers = null;
    }
}

