/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1.symbol;

import java.util.ArrayList;
import oracle.javatools.parser.java.v1.symbol.JavaSymbol;
import oracle.javatools.parser.java.v1.symbol.NameSymbol;
import oracle.javatools.parser.java.v1.symbol.TypeSymbol;

class ClassListSymbol
extends JavaSymbol {
    private ArrayList types;
    private NameSymbol[] nameArray;
    private TypeSymbol[] typeArray;

    void $init$() {
        this.types = ClassListSymbol.allocArrayList();
        this.nameArray = null;
        this.typeArray = null;
    }

    ClassListSymbol(int n) {
        super(n);
        this.$init$();
        if (n != 352 && n != 212) {
            this.internalError("Wrong code for a ClassListSymbol");
        }
    }

    void addClass(TypeSymbol typeSymbol) {
        this.types.add(typeSymbol);
    }

    void doneParsing() {
        this.generateNameArray();
    }

    NameSymbol[] listClasses() {
        if (this.nameArray == null) {
            this.generateNameArray();
        }
        return this.nameArray;
    }

    TypeSymbol[] listClassTypes() {
        if (this.typeArray == null) {
            this.generateTypeArray();
        }
        return this.typeArray;
    }

    private void generateNameArray() {
        int n;
        if (this.typeArray == null) {
            this.generateTypeArray();
        }
        if ((n = this.typeArray.length) == 0) {
            this.nameArray = NameSymbol.EMPTY_ARRAY;
        } else {
            this.nameArray = new NameSymbol[n];
            int n2 = 0;
            while (n2 < n) {
                this.nameArray[n2] = this.typeArray[n2].getName();
                ++n2;
            }
        }
    }

    private void generateTypeArray() {
        int n = this.types.size();
        this.typeArray = n > 0 ? this.types.toArray(new TypeSymbol[n]) : TypeSymbol.EMPTY_ARRAY;
        ClassListSymbol.freeArrayList(this.types);
        this.types = null;
    }
}

