/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1.symbol;

import java.util.ArrayList;
import oracle.javatools.parser.java.v1.symbol.CatchClause;
import oracle.javatools.parser.java.v1.symbol.ClassBodySymbol;
import oracle.javatools.parser.java.v1.symbol.ClassListSymbol;
import oracle.javatools.parser.java.v1.symbol.CodeElement;
import oracle.javatools.parser.java.v1.symbol.CommentSymbol;
import oracle.javatools.parser.java.v1.symbol.Commentable;
import oracle.javatools.parser.java.v1.symbol.CreatorExpressionSymbol;
import oracle.javatools.parser.java.v1.symbol.FieldSymbol;
import oracle.javatools.parser.java.v1.symbol.HasModifiers;
import oracle.javatools.parser.java.v1.symbol.InnerClassSymbol;
import oracle.javatools.parser.java.v1.symbol.MemberSymbol;
import oracle.javatools.parser.java.v1.symbol.MethodSymbol;
import oracle.javatools.parser.java.v1.symbol.NameSymbol;
import oracle.javatools.parser.java.v1.symbol.Nameable;
import oracle.javatools.parser.java.v1.symbol.RootSymbol;
import oracle.javatools.parser.java.v1.symbol.Scope;
import oracle.javatools.parser.java.v1.symbol.TypeSymbol;
import oracle.javatools.parser.java.v1.symbol.VariableSymbol;

public class ClassSymbol
extends HasModifiers
implements Scope,
Nameable,
Commentable {
    private CommentSymbol comment;
    private NameSymbol name;
    private int modifiers;
    private int classIndex;
    private TypeSymbol baseClass;
    private ClassListSymbol baseInterfaces;
    private ClassBodySymbol body;
    private Scope scope;
    static final ClassSymbol[] EMPTY_ARRAY = new ClassSymbol[0];

    public boolean isClass() {
        return this.code == 200 || this.code == 760;
    }

    public NameSymbol getBaseClass() {
        if (this.baseClass == null) {
            return null;
        }
        return this.baseClass.getName();
    }

    public TypeSymbol getBaseClassType() {
        return this.baseClass;
    }

    public ClassBodySymbol getBody() {
        return this.body;
    }

    public NameSymbol[] getBaseInterfaces() {
        return this.baseInterfaces != null ? this.baseInterfaces.listClasses() : NameSymbol.EMPTY_ARRAY;
    }

    public TypeSymbol[] getBaseInterfaceTypes() {
        return this.baseInterfaces != null ? this.baseInterfaces.listClassTypes() : TypeSymbol.EMPTY_ARRAY;
    }

    public MemberSymbol[] getMembers() {
        return this.body.listMembers();
    }

    public MethodSymbol[] getMethods() {
        return this.body.listMethods();
    }

    public FieldSymbol[] getFields() {
        return this.body.listFields();
    }

    public MethodSymbol[] getConstructors() {
        return this.body.listConstructors();
    }

    public InnerClassSymbol[] getInnerClasses() {
        return this.body.listInnerClasses();
    }

    public MemberSymbol[] getInitializers() {
        return this.body.listInitializers();
    }

    public boolean isDeprecated() {
        if (this.comment != null) {
            return this.comment.isDeprecated();
        }
        return false;
    }

    public boolean isHidden() {
        if (this.comment != null) {
            return this.comment.isHidden();
        }
        return false;
    }

    public int getScopeType() {
        return 1;
    }

    public Scope getEnclosingScope() {
        return this.scope;
    }

    public void setEnclosingScope(Scope scope) {
        this.scope = scope;
    }

    public boolean findLabel(String string) {
        return false;
    }

    public VariableSymbol findVariable(String string) {
        FieldSymbol[] fieldSymbolArray = this.getFields();
        int n = fieldSymbolArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldSymbol fieldSymbol = fieldSymbolArray[n2];
            if (fieldSymbol != null) {
                VariableSymbol[] variableSymbolArray = fieldSymbol.getVariables();
                int n3 = variableSymbolArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    VariableSymbol variableSymbol = variableSymbolArray[n4];
                    if (ClassSymbol.matches(variableSymbol, string)) {
                        return variableSymbol;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    public ClassSymbol findType(String string) {
        InnerClassSymbol[] innerClassSymbolArray = this.getInnerClasses();
        int n = innerClassSymbolArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassSymbol classSymbol = innerClassSymbolArray[n2].getClassDefinition();
            if (ClassSymbol.matches(classSymbol, string)) {
                return classSymbol;
            }
            ++n2;
        }
        return null;
    }

    public NameSymbol[] getLabels() {
        return NameSymbol.EMPTY_ARRAY;
    }

    public VariableSymbol[] getVariables() {
        FieldSymbol[] fieldSymbolArray = this.getFields();
        ArrayList arrayList = ClassSymbol.allocArrayList();
        int n = fieldSymbolArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableSymbol[] variableSymbolArray;
            FieldSymbol fieldSymbol = fieldSymbolArray[n2];
            if (fieldSymbol != null && (variableSymbolArray = fieldSymbol.getVariables()) != null) {
                int n3 = variableSymbolArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    VariableSymbol variableSymbol = variableSymbolArray[n4];
                    if (variableSymbol != null) {
                        arrayList.add(variableSymbol);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        int n5 = arrayList.size();
        VariableSymbol[] variableSymbolArray = n5 > 0 ? arrayList.toArray(new VariableSymbol[n5]) : VariableSymbol.EMPTY_ARRAY;
        ClassSymbol.freeArrayList(arrayList);
        return variableSymbolArray;
    }

    public ClassSymbol[] getClasses() {
        InnerClassSymbol[] innerClassSymbolArray = this.getInnerClasses();
        int n = innerClassSymbolArray.length;
        ClassSymbol[] classSymbolArray = new ClassSymbol[n];
        int n2 = 0;
        while (n2 < n) {
            InnerClassSymbol innerClassSymbol = innerClassSymbolArray[n2];
            if (innerClassSymbol != null) {
                classSymbolArray[n2] = innerClassSymbol.getClassDefinition();
            }
            ++n2;
        }
        return classSymbolArray;
    }

    public CatchClause[] getCatchClauses() {
        return CatchClause.EMPTY_ARRAY;
    }

    public int getClassIndex() {
        return this.classIndex;
    }

    void $init$() {
        this.comment = null;
        this.name = null;
        this.modifiers = 0;
    }

    ClassSymbol(int n, int n2) {
        super(n);
        this.$init$();
        this.classIndex = n2;
    }

    void setBody(ClassBodySymbol classBodySymbol) {
        this.body = classBodySymbol;
    }

    void setBaseClass(TypeSymbol typeSymbol) {
        this.baseClass = typeSymbol;
    }

    void setBaseInterfaces(ClassListSymbol classListSymbol) {
        this.baseInterfaces = classListSymbol;
    }

    void doneParsing() {
        if (this.code == 200 || this.code == 400) {
            this.setModifiers(((HasModifiers)this.parent).getModifiers());
            if (this.parent.code == 280) {
                MemberSymbol memberSymbol = (MemberSymbol)this.parent;
                this.setComment(memberSymbol.getComment());
                new InnerClassSymbol(this);
            } else if (this.parent.parent.code == 510) {
                ((CodeElement)this.parent.parent).setClass(this);
                this.body.doneParsingLocalClass(true, this);
            } else {
                this.setComment(((Commentable)((Object)this.parent)).getComment());
                RootSymbol rootSymbol = (RootSymbol)this.parent.parent;
                rootSymbol.addClass(this);
            }
        } else if (this.code == 760) {
            ((CreatorExpressionSymbol)this.parent).setClass(this);
        }
    }

    public CommentSymbol getComment() {
        return this.comment;
    }

    public void setComment(CommentSymbol commentSymbol) {
        this.comment = commentSymbol;
    }

    public NameSymbol getName() {
        return this.name;
    }

    public void setName(NameSymbol nameSymbol) {
        this.name = nameSymbol;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int n) {
        this.modifiers = n;
    }
}

