/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1.symbol;

import java.util.ArrayList;
import oracle.javatools.parser.java.v1.symbol.CatchClause;
import oracle.javatools.parser.java.v1.symbol.ClassSymbol;
import oracle.javatools.parser.java.v1.symbol.CodeElement;
import oracle.javatools.parser.java.v1.symbol.ErrorReporter;
import oracle.javatools.parser.java.v1.symbol.ErrorSymbol;
import oracle.javatools.parser.java.v1.symbol.JavaSymbol;
import oracle.javatools.parser.java.v1.symbol.NameSymbol;
import oracle.javatools.parser.java.v1.symbol.Scope;
import oracle.javatools.parser.java.v1.symbol.VariableSymbol;

public class CodeBlockSymbol
extends JavaSymbol
implements Scope,
ErrorReporter {
    private CodeElement[] codeElementArray;
    private ErrorSymbol[] errorArray;
    private ArrayList codeElements;
    private Scope scope;

    public CodeElement[] getCodeElements() {
        if (this.codeElementArray == null) {
            this.generateCodeElementArray();
        }
        return this.codeElementArray;
    }

    public boolean isFilledIn() {
        return this.code != 509;
    }

    public boolean hasErrors() {
        if (this.errorArray == null) {
            this.errorArray = ErrorSymbol.EMPTY_ARRAY;
        }
        return this.errorArray.length > 0;
    }

    public ErrorSymbol[] getErrors() {
        if (this.errorArray == null) {
            this.errorArray = ErrorSymbol.EMPTY_ARRAY;
        }
        return this.errorArray;
    }

    public final void setErrorArray(ErrorSymbol[] errorSymbolArray) {
        this.errorArray = errorSymbolArray;
    }

    public int getScopeType() {
        return 4;
    }

    public Scope getEnclosingScope() {
        return this.scope;
    }

    public void setEnclosingScope(Scope scope) {
        this.scope = scope;
    }

    public int getModifiers() {
        return 0;
    }

    public boolean findLabel(String string) {
        return false;
    }

    public VariableSymbol findVariable(String string) {
        CodeElement[] codeElementArray = this.getCodeElements();
        int n = codeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            CodeElement codeElement = codeElementArray[n2];
            if (codeElement != null && codeElement.getType() == 2) {
                VariableSymbol[] variableSymbolArray = codeElement.getVariables();
                int n3 = variableSymbolArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    VariableSymbol variableSymbol = variableSymbolArray[n4];
                    if (variableSymbol != null && CodeBlockSymbol.matches(variableSymbol, string)) {
                        return variableSymbol;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    public ClassSymbol findType(String string) {
        CodeElement[] codeElementArray = this.getCodeElements();
        int n = codeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassSymbol classSymbol;
            CodeElement codeElement = codeElementArray[n2];
            if (codeElement != null && codeElement.getType() == 1 && CodeBlockSymbol.matches(classSymbol = codeElement.getClassDefinition(), string)) {
                return classSymbol;
            }
            ++n2;
        }
        return null;
    }

    public NameSymbol[] getLabels() {
        return NameSymbol.EMPTY_ARRAY;
    }

    public VariableSymbol[] getVariables() {
        CodeElement[] codeElementArray = this.getCodeElements();
        int n = codeElementArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            CodeElement codeElement = codeElementArray[n3];
            if (codeElement != null && codeElement.getType() == 2) {
                VariableSymbol[] variableSymbolArray = codeElement.getVariables();
                n2 += variableSymbolArray.length;
            }
            ++n3;
        }
        if (n2 == 0) {
            return VariableSymbol.EMPTY_ARRAY;
        }
        VariableSymbol[] variableSymbolArray = new VariableSymbol[n2];
        n2 = 0;
        int n4 = 0;
        while (n4 < n) {
            CodeElement codeElement = codeElementArray[n4];
            if (codeElement != null && codeElement.getType() == 2) {
                VariableSymbol[] variableSymbolArray2 = codeElement.getVariables();
                int n5 = variableSymbolArray2.length;
                int n6 = 0;
                while (n6 < n5) {
                    variableSymbolArray[n2++] = variableSymbolArray2[n6];
                    ++n6;
                }
            }
            ++n4;
        }
        return variableSymbolArray;
    }

    public ClassSymbol[] getClasses() {
        CodeElement[] codeElementArray = this.getCodeElements();
        int n = codeElementArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            CodeElement codeElement = codeElementArray[n3];
            if (codeElement != null && codeElement.getType() == 1) {
                ++n2;
            }
            ++n3;
        }
        if (n2 == 0) {
            return ClassSymbol.EMPTY_ARRAY;
        }
        ClassSymbol[] classSymbolArray = new ClassSymbol[n2];
        n2 = 0;
        int n4 = 0;
        while (n4 < n) {
            CodeElement codeElement = codeElementArray[n4];
            if (codeElement != null && codeElement.getType() == 1) {
                classSymbolArray[n2++] = codeElement.getClassDefinition();
            }
            ++n4;
        }
        return classSymbolArray;
    }

    public CatchClause[] getCatchClauses() {
        return CatchClause.EMPTY_ARRAY;
    }

    void $init$() {
        this.codeElementArray = null;
        this.errorArray = null;
        this.codeElements = CodeBlockSymbol.allocArrayList();
    }

    CodeBlockSymbol(int n) {
        super(n);
        this.$init$();
    }

    void addCodeElement(CodeElement codeElement) {
        this.codeElements.add(codeElement);
    }

    void doneParsing() {
        super.doneParsing();
        this.generateCodeElementArray();
    }

    private void generateCodeElementArray() {
        int n = this.codeElements.size();
        this.codeElementArray = n > 0 ? this.codeElements.toArray(new CodeElement[n]) : CodeElement.EMPTY_ARRAY;
        CodeBlockSymbol.freeArrayList(this.codeElements);
        this.codeElements = null;
    }
}

