/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1.symbol;

import java.util.ArrayList;
import oracle.javatools.parser.java.v1.symbol.ClassSymbol;
import oracle.javatools.parser.java.v1.symbol.ControlStatement;
import oracle.javatools.parser.java.v1.symbol.ExpressionSymbol;
import oracle.javatools.parser.java.v1.symbol.HasModifiers;
import oracle.javatools.parser.java.v1.symbol.StatementSymbol;
import oracle.javatools.parser.java.v1.symbol.VariableSymbol;

public class CodeElement
extends HasModifiers {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_LOCAL_CLASS = 1;
    public static final int TYPE_VARDECL = 2;
    public static final int TYPE_STATEMENT = 3;
    public static final int TYPE_EXPRESSION = 4;
    private int type;
    private ClassSymbol clazz;
    private VariableSymbol[] variableArray;
    private StatementSymbol statement;
    private ExpressionSymbol expression;
    private ArrayList variables;
    static final CodeElement[] EMPTY_ARRAY = new CodeElement[0];

    public int getType() {
        return this.type;
    }

    public ClassSymbol getClassDefinition() {
        return this.clazz;
    }

    public VariableSymbol[] getVariables() {
        return this.variableArray;
    }

    public StatementSymbol getStatement() {
        return this.statement;
    }

    public ExpressionSymbol getExpression() {
        return this.expression;
    }

    void $init$() {
        this.type = 0;
        this.clazz = null;
        this.variableArray = null;
        this.statement = null;
        this.expression = null;
        this.variables = null;
    }

    CodeElement(int n) {
        super(n);
        this.$init$();
    }

    void setClass(ClassSymbol classSymbol) {
        this.clazz = classSymbol;
        this.type = 1;
    }

    void addVariable(VariableSymbol variableSymbol) {
        if (this.parent.code == 520) {
            if (this.parent.parent instanceof ControlStatement) {
                this.internalError("CodeElement: vardecl in ctrl stmt.");
            } else {
                ((CodeElement)this.parent.parent).addVariable(variableSymbol);
            }
        } else {
            if (this.variables == null) {
                this.variables = CodeElement.allocArrayList();
            }
            this.variables.add(variableSymbol);
            this.type = 2;
        }
    }

    void setExpression(ExpressionSymbol expressionSymbol) {
        this.expression = expressionSymbol;
        this.type = 4;
    }

    void setStatement(StatementSymbol statementSymbol) {
        this.statement = statementSymbol;
        if (this.variables == null) {
            this.type = 3;
        }
    }

    void doneParsing() {
        super.doneParsing();
        if (this.variables != null) {
            this.generateVariableArray();
        }
    }

    private void generateVariableArray() {
        int n = this.variables.size();
        this.variableArray = n > 0 ? this.variables.toArray(new VariableSymbol[n]) : VariableSymbol.EMPTY_ARRAY;
        CodeElement.freeArrayList(this.variables);
        this.variables = null;
    }
}

