/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1.symbol;

import oracle.javatools.parser.java.v1.symbol.ErrorReporter;
import oracle.javatools.parser.java.v1.symbol.ErrorSymbol;
import oracle.javatools.parser.java.v1.symbol.ExpressionSymbol;
import oracle.javatools.parser.java.v1.symbol.JavaSymbolFactory;
import oracle.javatools.parser.java.v1.symbol.OperatorExpression;
import oracle.javatools.parser.util.ExpressionStack;

class ExpressionWrapper
extends ExpressionSymbol
implements ErrorReporter {
    private ErrorSymbol[] errorArray;
    private ExpressionStack stack;

    public boolean hasErrors() {
        if (this.errorArray == null) {
            this.errorArray = ErrorSymbol.EMPTY_ARRAY;
        }
        return this.errorArray.length > 0;
    }

    public ErrorSymbol[] getErrors() {
        if (this.errorArray == null) {
            this.errorArray = ErrorSymbol.EMPTY_ARRAY;
        }
        return this.errorArray;
    }

    public final void setErrorArray(ErrorSymbol[] errorSymbolArray) {
        this.errorArray = errorSymbolArray;
    }

    void $init$() {
        this.errorArray = null;
    }

    ExpressionWrapper(int n, int n2) {
        super(n, n2);
        this.$init$();
    }

    void addOperand(ExpressionSymbol expressionSymbol) {
        if (this.firstOperand == null) {
            this.firstOperand = expressionSymbol;
        } else {
            if (this.stack == null) {
                this.stack = new ExpressionStack();
                this.stack.add(this.firstOperand);
            }
            this.stack.add(expressionSymbol);
        }
    }

    void process(JavaSymbolFactory javaSymbolFactory) {
        if (this.stack != null) {
            this.stack.setClosingArgument(javaSymbolFactory);
            this.firstOperand = (ExpressionSymbol)this.stack.process();
            this.stack = null;
            if (ExpressionWrapper.isBinaryPlus(this.firstOperand)) {
                this.firstOperand = ExpressionWrapper.rebalance(this.firstOperand);
            }
        }
    }

    private static boolean isBinaryPlus(ExpressionSymbol expressionSymbol) {
        return expressionSymbol.getExactCode() == 67 && expressionSymbol.getCategory() == 3;
    }

    private static ExpressionSymbol rotate(ExpressionSymbol expressionSymbol) {
        ExpressionSymbol expressionSymbol2 = expressionSymbol.firstOperand;
        OperatorExpression operatorExpression = (OperatorExpression)expressionSymbol2.firstOperand;
        ExpressionSymbol expressionSymbol3 = operatorExpression.secondOperand;
        expressionSymbol.firstOperand = operatorExpression;
        operatorExpression.secondOperand = expressionSymbol2;
        expressionSymbol2.firstOperand = expressionSymbol3;
        return operatorExpression;
    }

    private static ExpressionSymbol rebalance(ExpressionSymbol expressionSymbol) {
        ExpressionSymbol expressionSymbol2 = expressionSymbol;
        int n = 0;
        while (ExpressionWrapper.isBinaryPlus(expressionSymbol2)) {
            expressionSymbol2 = expressionSymbol2.firstOperand;
            ++n;
        }
        while (n > 4) {
            expressionSymbol2 = expressionSymbol;
            while (ExpressionWrapper.isBinaryPlus(expressionSymbol2.firstOperand) && ExpressionWrapper.isBinaryPlus(expressionSymbol2.firstOperand.firstOperand)) {
                expressionSymbol2 = ExpressionWrapper.rotate(expressionSymbol2);
            }
            n /= 2;
        }
        return expressionSymbol;
    }
}

