/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1.symbol;

import java.util.ArrayList;
import oracle.javatools.parser.java.v1.symbol.CodeElement;
import oracle.javatools.parser.java.v1.symbol.ControlStatement;
import oracle.javatools.parser.java.v1.symbol.ExpressionSymbol;
import oracle.javatools.parser.java.v1.symbol.VariableSymbol;

public class ForStatement
extends ControlStatement {
    private CodeElement[] initArray;
    private ExpressionSymbol conditional;
    private ExpressionSymbol[] updateArray;
    private ArrayList inits;
    private ArrayList updates;

    public CodeElement[] getInits() {
        return this.initArray;
    }

    public ExpressionSymbol getConditional() {
        return this.conditional;
    }

    public ExpressionSymbol[] getUpdates() {
        return this.updateArray;
    }

    public VariableSymbol findVariable(String string) {
        CodeElement[] codeElementArray = this.getInits();
        int n = codeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            CodeElement codeElement = codeElementArray[n2];
            if (codeElement != null) {
                VariableSymbol[] variableSymbolArray = codeElement.getVariables();
                if (variableSymbolArray == null) {
                    return null;
                }
                int n3 = variableSymbolArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    VariableSymbol variableSymbol = variableSymbolArray[n4];
                    if (variableSymbol != null && ForStatement.matches(variableSymbol, string)) {
                        return variableSymbol;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    void $init$() {
        this.initArray = null;
        this.conditional = null;
        this.updateArray = null;
        this.inits = ForStatement.allocArrayList();
        this.updates = ForStatement.allocArrayList();
    }

    ForStatement() {
        super(532);
        this.$init$();
    }

    void addInit(CodeElement codeElement) {
        this.inits.add(codeElement);
    }

    void setConditional(ExpressionSymbol expressionSymbol) {
        this.conditional = expressionSymbol;
    }

    void addUpdate(ExpressionSymbol expressionSymbol) {
        this.updates.add(expressionSymbol);
    }

    void doneParsing() {
        super.doneParsing();
        this.generateInitArray();
        this.generateUpdateArray();
    }

    private void generateInitArray() {
        int n = this.inits.size();
        this.initArray = n > 0 ? this.inits.toArray(new CodeElement[n]) : CodeElement.EMPTY_ARRAY;
        ForStatement.freeArrayList(this.inits);
        this.inits = null;
    }

    private void generateUpdateArray() {
        int n = this.updates.size();
        this.updateArray = n > 0 ? this.updates.toArray(new ExpressionSymbol[n]) : ExpressionSymbol.EMPTY_ARRAY;
        ForStatement.freeArrayList(this.updates);
        this.updates = null;
    }
}

