/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1.symbol;

import oracle.javatools.parser.java.v1.JavaSyntaxCodes;
import oracle.javatools.parser.java.v1.JavaSyntaxRecognizer;
import oracle.javatools.parser.java.v1.symbol.CommonRoot;
import oracle.javatools.parser.java.v1.symbol.ErrorSymbol;
import oracle.javatools.parser.java.v1.symbol.NameSymbol;
import oracle.javatools.parser.java.v1.symbol.Nameable;
import oracle.javatools.parser.util.ArrayListHeap;

public class JavaSymbol
extends ArrayListHeap
implements JavaSyntaxCodes {
    static final int SYNTAX_ROOT = 10;
    JavaSymbol parent;
    int code;
    int startOffset;
    int endOffset;
    int dataValue;
    static final String ERR_READONLY_AFTER_PARSE = "Parse structure is read-only after parse is finished";

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getCode() {
        return this.code;
    }

    void $init$() {
        this.startOffset = -1;
        this.endOffset = -1;
    }

    JavaSymbol(int n) {
        this.$init$();
        this.code = n;
    }

    public JavaSymbol getParent() {
        return this.parent;
    }

    void doneParsing() {
    }

    void reportSyntaxError(String string) {
        JavaSymbol javaSymbol = this.parent;
        while (javaSymbol.parent != null) {
            javaSymbol = javaSymbol.parent;
        }
        CommonRoot commonRoot = (CommonRoot)javaSymbol;
        ErrorSymbol errorSymbol = new ErrorSymbol(string);
        errorSymbol.startOffset = this.startOffset;
        errorSymbol.endOffset = this.endOffset;
        commonRoot.addError(errorSymbol);
    }

    static boolean matches(Nameable nameable, String string) {
        if (nameable == null) {
            return false;
        }
        return JavaSymbol.matches(nameable.getName(), string);
    }

    static boolean matches(NameSymbol nameSymbol, String string) {
        if (nameSymbol == null) {
            return false;
        }
        String string2 = nameSymbol.getValue();
        return string2 != null && string.equals(string2);
    }

    void error(String string) {
        String string2 = JavaSyntaxRecognizer.codeToString(this.code);
        String string3 = "JavaSymbol error: (" + string2 + ") - " + string;
        System.err.println(string3);
        throw new RuntimeException(string3);
    }

    void internalError(String string) {
        String string2 = JavaSyntaxRecognizer.codeToString(this.code);
        String string3 = "JavaSymbol internal error: (" + string2 + ") - " + string;
        System.err.println(string3);
        throw new RuntimeException(string3);
    }
}

