/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1.symbol;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.SyntaxToken;
import oracle.javatools.parser.java.v1.JavaDocLexer;
import oracle.javatools.parser.java.v1.JavaSyntaxCodes;
import oracle.javatools.parser.java.v1.JavaSyntaxRecognizer;
import oracle.javatools.parser.java.v1.symbol.CatchClause;
import oracle.javatools.parser.java.v1.symbol.ClassBodySymbol;
import oracle.javatools.parser.java.v1.symbol.ClassListSymbol;
import oracle.javatools.parser.java.v1.symbol.ClassSymbol;
import oracle.javatools.parser.java.v1.symbol.CodeBlockSymbol;
import oracle.javatools.parser.java.v1.symbol.CodeElement;
import oracle.javatools.parser.java.v1.symbol.CommentSymbol;
import oracle.javatools.parser.java.v1.symbol.Commentable;
import oracle.javatools.parser.java.v1.symbol.CommonRoot;
import oracle.javatools.parser.java.v1.symbol.ControlStatement;
import oracle.javatools.parser.java.v1.symbol.CreatorExpressionSymbol;
import oracle.javatools.parser.java.v1.symbol.ErrorReporter;
import oracle.javatools.parser.java.v1.symbol.ErrorSymbol;
import oracle.javatools.parser.java.v1.symbol.ExpressionList;
import oracle.javatools.parser.java.v1.symbol.ExpressionSymbol;
import oracle.javatools.parser.java.v1.symbol.ExpressionWrapper;
import oracle.javatools.parser.java.v1.symbol.FieldSymbol;
import oracle.javatools.parser.java.v1.symbol.ForStatement;
import oracle.javatools.parser.java.v1.symbol.HasModifiers;
import oracle.javatools.parser.java.v1.symbol.ImportSymbol;
import oracle.javatools.parser.java.v1.symbol.InnerClassSymbol;
import oracle.javatools.parser.java.v1.symbol.JavaSymbol;
import oracle.javatools.parser.java.v1.symbol.MemberSymbol;
import oracle.javatools.parser.java.v1.symbol.MethodSymbol;
import oracle.javatools.parser.java.v1.symbol.NameSymbol;
import oracle.javatools.parser.java.v1.symbol.Nameable;
import oracle.javatools.parser.java.v1.symbol.OperatorExpression;
import oracle.javatools.parser.java.v1.symbol.PackageSymbol;
import oracle.javatools.parser.java.v1.symbol.ParameterSymbol;
import oracle.javatools.parser.java.v1.symbol.RootSymbol;
import oracle.javatools.parser.java.v1.symbol.Scope;
import oracle.javatools.parser.java.v1.symbol.SqlStatement;
import oracle.javatools.parser.java.v1.symbol.StatementSymbol;
import oracle.javatools.parser.java.v1.symbol.SwitchCaseLabel;
import oracle.javatools.parser.java.v1.symbol.TryStatement;
import oracle.javatools.parser.java.v1.symbol.TypeSymbol;
import oracle.javatools.parser.java.v1.symbol.VariableSymbol;

public class JavaSymbolFactory
implements JavaSyntaxCodes {
    static final int SYNTAX_ROOT = 10;
    private Scope currentScope;
    private ReadTextBuffer buffer;
    private Map nameMap;
    private int classCount;
    private int variableCount;
    private int expressionCount;

    void $init$() {
        this.currentScope = null;
        this.classCount = 0;
        this.variableCount = 0;
        this.expressionCount = 0;
    }

    public JavaSymbolFactory(ReadTextBuffer readTextBuffer, Scope scope) {
        this.$init$();
        this.buffer = readTextBuffer;
        this.currentScope = scope;
        this.nameMap = new HashMap();
    }

    TypeSymbol newTypeSymbol() {
        return new TypeSymbol(this.currentScope);
    }

    ReadTextBuffer getReadTextBuffer() {
        return this.buffer;
    }

    Map getNameMap() {
        return this.nameMap;
    }

    private JavaSymbol pushScope(Scope scope) {
        scope.setEnclosingScope(this.currentScope);
        this.currentScope = scope;
        return (JavaSymbol)((Object)scope);
    }

    private void popScope() {
        this.currentScope = this.currentScope.getEnclosingScope();
    }

    public JavaSymbol createAndFinishErrorSymbol(SyntaxToken syntaxToken, CommonRoot commonRoot) {
        ErrorSymbol errorSymbol = new ErrorSymbol(syntaxToken.getContextString());
        errorSymbol.startOffset = syntaxToken.getStartOffset();
        errorSymbol.endOffset = syntaxToken.getEndOffset();
        errorSymbol.dataValue = syntaxToken.getDataValue();
        commonRoot.addError(errorSymbol);
        return errorSymbol;
    }

    public JavaSymbol createSymbol(SyntaxToken syntaxToken, JavaSymbol javaSymbol) {
        return this.createSymbol(syntaxToken.getCode(), syntaxToken.getStartOffset(), syntaxToken.getEndOffset(), javaSymbol);
    }

    public JavaSymbol createSymbol(int n, int n2, int n3, JavaSymbol javaSymbol) {
        JavaSymbol javaSymbol2;
        JavaSymbol javaSymbol3 = null;
        switch (n) {
            case 10: {
                javaSymbol2 = new CommonRoot();
                break;
            }
            case 25: {
                RootSymbol rootSymbol;
                javaSymbol3 = rootSymbol = new RootSymbol();
                javaSymbol2 = this.pushScope(rootSymbol);
                break;
            }
            case 40: {
                javaSymbol2 = new PackageSymbol();
                break;
            }
            case 50: {
                javaSymbol2 = new ImportSymbol();
                break;
            }
            case 60: {
                javaSymbol2 = new ClassSymbol(n, -1);
                break;
            }
            case 99: {
                javaSymbol2 = new NameSymbol(n);
                break;
            }
            case 200: 
            case 400: {
                javaSymbol2 = new ClassSymbol(n, this.classCount++);
                break;
            }
            case 65: {
                javaSymbol2 = new ClassBodySymbol();
                this.pushScope((ClassSymbol)javaSymbol);
                break;
            }
            case 280: {
                javaSymbol2 = new MemberSymbol(n);
                break;
            }
            case 212: {
                javaSymbol2 = new ClassListSymbol(n);
                break;
            }
            case 300: {
                javaSymbol2 = this.pushScope(new FieldSymbol());
                break;
            }
            case 260: {
                javaSymbol2 = this.pushScope(new MemberSymbol(n));
                break;
            }
            case 340: 
            case 370: {
                javaSymbol2 = this.pushScope(new MethodSymbol(n));
                break;
            }
            case 500: {
                CodeBlockSymbol codeBlockSymbol = new CodeBlockSymbol(n);
                javaSymbol3 = codeBlockSymbol;
                javaSymbol2 = this.pushScope(codeBlockSymbol);
                break;
            }
            case 501: 
            case 509: {
                javaSymbol2 = this.pushScope(new CodeBlockSymbol(n));
                break;
            }
            case 510: {
                javaSymbol2 = new CodeElement(n);
                break;
            }
            case 591: {
                javaSymbol2 = new SwitchCaseLabel(n);
                break;
            }
            case 520: {
                javaSymbol2 = this.pushScope(new StatementSymbol(n));
                break;
            }
            case 522: {
                javaSymbol2 = this.pushScope(new SqlStatement());
                break;
            }
            case 532: {
                javaSymbol2 = this.pushScope(new ForStatement());
                break;
            }
            case 531: 
            case 533: 
            case 534: 
            case 536: 
            case 537: {
                javaSymbol2 = this.pushScope(new ControlStatement(n));
                break;
            }
            case 535: {
                javaSymbol2 = this.pushScope(new TryStatement());
                break;
            }
            case 542: {
                javaSymbol2 = this.pushScope(new CatchClause());
                break;
            }
            case 541: 
            case 543: {
                javaSymbol2 = new ControlStatement(n);
                break;
            }
            case 570: 
            case 571: 
            case 580: {
                javaSymbol2 = new JavaSymbol(n);
                break;
            }
            case 560: 
            case 581: {
                javaSymbol2 = new CodeElement(n);
                break;
            }
            case 582: 
            case 583: {
                javaSymbol2 = new ExpressionSymbol(n, this.expressionCount++);
                break;
            }
            case 609: 
            case 619: {
                javaSymbol2 = new NameSymbol(n);
                break;
            }
            case 321: 
            case 611: 
            case 772: {
                javaSymbol2 = new ExpressionList(n, this.expressionCount++);
                break;
            }
            case 640: {
                ExpressionWrapper expressionWrapper = new ExpressionWrapper(n, this.expressionCount++);
                javaSymbol3 = expressionWrapper;
                javaSymbol2 = expressionWrapper;
                break;
            }
            case 641: 
            case 642: 
            case 643: 
            case 644: 
            case 645: {
                javaSymbol2 = new OperatorExpression(n, this.expressionCount++);
                break;
            }
            case 320: 
            case 600: 
            case 605: 
            case 610: 
            case 700: 
            case 701: 
            case 723: 
            case 770: 
            case 771: {
                javaSymbol2 = new ExpressionSymbol(n, this.expressionCount++);
                break;
            }
            case 760: {
                javaSymbol2 = new ClassSymbol(n, this.classCount++);
                break;
            }
            case 750: 
            case 751: {
                javaSymbol2 = new CreatorExpressionSymbol(n, this.expressionCount++, this.newTypeSymbol());
                break;
            }
            case 352: {
                javaSymbol2 = new ClassListSymbol(n);
                break;
            }
            case 311: {
                javaSymbol2 = new VariableSymbol(this.variableCount++);
                if (javaSymbol.code != 560) break;
                this.popScope();
                break;
            }
            case 100: {
                javaSymbol2 = this.newTypeSymbol();
                break;
            }
            case 359: {
                javaSymbol2 = new ParameterSymbol();
                break;
            }
            case 351: {
                javaSymbol2 = new JavaSymbol(n);
                break;
            }
            case 151: 
            case 152: 
            case 155: 
            case 721: 
            case 722: {
                javaSymbol2 = new NameSymbol(n);
                break;
            }
            case 143: {
                javaSymbol2 = new CommentSymbol(n);
                break;
            }
            case 111: 
            case 159: 
            case 170: {
                javaSymbol2 = new JavaSymbol(n);
                break;
            }
            default: {
                System.err.println("JavaSymbolFactory - create: Unknown syntax code " + n);
                javaSymbol2 = new JavaSymbol(n);
            }
        }
        if (javaSymbol3 != null && javaSymbol.code == 10) {
            ((CommonRoot)javaSymbol).setRoot((ErrorReporter)((Object)javaSymbol3));
        }
        javaSymbol2.parent = javaSymbol;
        javaSymbol2.startOffset = n2;
        javaSymbol2.endOffset = n3;
        return javaSymbol2;
    }

    public void finishSymbol(JavaSymbol javaSymbol, SyntaxToken syntaxToken) {
        javaSymbol.endOffset = syntaxToken.getEndOffset();
        javaSymbol.dataValue = syntaxToken.getDataValue();
        this.finishSymbol(javaSymbol);
    }

    public boolean forceFinishSymbol(JavaSymbol javaSymbol, int n) {
        try {
            javaSymbol.endOffset = n;
            this.finishSymbol(javaSymbol);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finishSymbol(JavaSymbol javaSymbol) {
        try {
            JavaSymbol javaSymbol2 = javaSymbol.parent;
            block3 : switch (javaSymbol.code) {
                case 25: {
                    this.popScope();
                }
                case 10: 
                case 40: 
                case 50: 
                case 60: {
                    break;
                }
                case 99: {
                    NameSymbol nameSymbol = (NameSymbol)javaSymbol;
                    nameSymbol.recordName(this.buffer);
                    ((RootSymbol)javaSymbol2).setSqlContext(nameSymbol);
                    break;
                }
                case 200: 
                case 400: {
                    this.popScope();
                }
                case 65: 
                case 280: {
                    break;
                }
                case 212: {
                    ((ClassSymbol)javaSymbol2).setBaseInterfaces((ClassListSymbol)javaSymbol);
                    break;
                }
                case 260: 
                case 300: 
                case 340: 
                case 370: {
                    this.popScope();
                    break;
                }
                case 500: 
                case 501: 
                case 509: {
                    this.popScope();
                    CodeBlockSymbol codeBlockSymbol = (CodeBlockSymbol)javaSymbol;
                    if (javaSymbol2 instanceof CodeBlockSymbol) break;
                    if (javaSymbol2 instanceof MemberSymbol) {
                        ((MemberSymbol)javaSymbol2).setBlock(codeBlockSymbol);
                        break;
                    }
                    if (javaSymbol.code == 509 || javaSymbol2.code == 10) break;
                    ((StatementSymbol)javaSymbol2).setBlock(codeBlockSymbol);
                    break;
                }
                case 510: {
                    if (!(javaSymbol2 instanceof CodeBlockSymbol)) break;
                    ((CodeBlockSymbol)javaSymbol2).addCodeElement((CodeElement)javaSymbol);
                    break;
                }
                case 522: {
                    ((SqlStatement)javaSymbol).recordStatement(this.buffer);
                }
                case 520: {
                    this.popScope();
                }
                case 591: {
                    StatementSymbol statementSymbol;
                    StatementSymbol statementSymbol2 = (StatementSymbol)javaSymbol;
                    StatementSymbol statementSymbol3 = statementSymbol2.getChild();
                    StatementSymbol statementSymbol4 = statementSymbol = statementSymbol3 != null ? statementSymbol3 : statementSymbol2;
                    if (javaSymbol2 instanceof CodeElement) {
                        ((CodeElement)javaSymbol2).setStatement(statementSymbol);
                        break;
                    }
                    if (javaSymbol2 instanceof ControlStatement) {
                        ((ControlStatement)javaSymbol2).setPrimaryClause(statementSymbol);
                        break;
                    }
                    ((StatementSymbol)javaSymbol2).setChild(statementSymbol);
                    break;
                }
                case 531: 
                case 532: 
                case 533: 
                case 534: 
                case 535: 
                case 536: 
                case 537: {
                    this.popScope();
                    ((StatementSymbol)javaSymbol2).setChild((StatementSymbol)javaSymbol);
                    break;
                }
                case 541: 
                case 543: {
                    ControlStatement controlStatement = (ControlStatement)javaSymbol;
                    ((ControlStatement)javaSymbol2).setEndClause(controlStatement.getPrimaryClause());
                    break;
                }
                case 542: {
                    this.popScope();
                    ((TryStatement)javaSymbol2).addCatchClause((CatchClause)javaSymbol);
                    break;
                }
                case 570: 
                case 571: 
                case 580: {
                    break;
                }
                case 560: {
                    if (!(javaSymbol2 instanceof StatementSymbol)) break;
                    ((StatementSymbol)javaSymbol2).setExpression(((CodeElement)javaSymbol).getExpression());
                    break;
                }
                case 581: {
                    ((ForStatement)javaSymbol2.parent).addInit((CodeElement)javaSymbol);
                    break;
                }
                case 582: {
                    ExpressionSymbol expressionSymbol = (ExpressionSymbol)javaSymbol;
                    expressionSymbol.setCategory(1);
                    ((ForStatement)javaSymbol2.parent).setConditional(expressionSymbol);
                    break;
                }
                case 583: {
                    ExpressionSymbol expressionSymbol = (ExpressionSymbol)javaSymbol;
                    expressionSymbol.setCategory(1);
                    ((ForStatement)javaSymbol2.parent).addUpdate((ExpressionSymbol)javaSymbol);
                    break;
                }
                case 611: 
                case 772: {
                    ExpressionSymbol expressionSymbol = (ExpressionSymbol)javaSymbol;
                    expressionSymbol.setCategory(9);
                    break;
                }
                case 321: {
                    ((ExpressionSymbol)javaSymbol).setCategory(34);
                    break;
                }
                case 609: 
                case 619: {
                    if (javaSymbol2.code != 320) break;
                    ExpressionSymbol expressionSymbol = (ExpressionSymbol)javaSymbol2;
                    expressionSymbol.setCategory(-1);
                    expressionSymbol.setName((NameSymbol)javaSymbol);
                    break;
                }
                case 605: {
                    if (javaSymbol2.code == 772) {
                        while (true) {
                            if (javaSymbol2 instanceof CreatorExpressionSymbol) {
                                CreatorExpressionSymbol creatorExpressionSymbol = (CreatorExpressionSymbol)javaSymbol2;
                                creatorExpressionSymbol.getClassType().incrementArrayDimension(1);
                                break;
                            }
                            javaSymbol2 = javaSymbol2.parent;
                        }
                    }
                }
                case 610: {
                    ExpressionSymbol expressionSymbol = (ExpressionSymbol)javaSymbol;
                    expressionSymbol.setCategory(40);
                    break;
                }
                case 640: {
                    ((ExpressionWrapper)javaSymbol).process(this);
                    break;
                }
                case 600: 
                case 641: 
                case 642: 
                case 643: 
                case 644: 
                case 645: {
                    break;
                }
                case 700: 
                case 701: {
                    ExpressionSymbol expressionSymbol = (ExpressionSymbol)javaSymbol;
                    if (JavaSyntaxRecognizer.isLiteral(expressionSymbol.getExactCode())) {
                        ((ExpressionSymbol)javaSymbol).setCategory(33);
                        break;
                    }
                    ((ExpressionSymbol)javaSymbol).setCategory(17);
                    break;
                }
                case 750: 
                case 751: {
                    break;
                }
                case 723: {
                    ((ExpressionSymbol)javaSymbol).setCategory(19);
                    break;
                }
                case 760: {
                    this.popScope();
                }
                case 770: 
                case 771: {
                    break;
                }
                case 352: {
                    ((MethodSymbol)javaSymbol2).setThrows((ClassListSymbol)javaSymbol);
                    break;
                }
                case 320: {
                    ExpressionSymbol expressionSymbol = (ExpressionSymbol)javaSymbol;
                    if (javaSymbol2 instanceof VariableSymbol) {
                        ((VariableSymbol)javaSymbol2).setInitializer(expressionSymbol);
                    }
                    if (expressionSymbol.getCategory() != -1) break;
                    expressionSymbol.dataValue = -1;
                    break;
                }
                case 311: {
                    VariableSymbol variableSymbol = (VariableSymbol)javaSymbol;
                    if (javaSymbol2 instanceof FieldSymbol) {
                        FieldSymbol fieldSymbol = (FieldSymbol)javaSymbol2;
                        MemberSymbol memberSymbol = (MemberSymbol)fieldSymbol.parent;
                        variableSymbol.useType(memberSymbol.getType(), this);
                        variableSymbol.setModifiers(memberSymbol.getModifiers());
                        fieldSymbol.addVariable(variableSymbol);
                        break;
                    }
                    if (javaSymbol2 instanceof ParameterSymbol) {
                        ParameterSymbol parameterSymbol = (ParameterSymbol)javaSymbol2;
                        MethodSymbol methodSymbol = (MethodSymbol)parameterSymbol.parent.parent;
                        variableSymbol.useType(parameterSymbol.getType(), this);
                        variableSymbol.setModifiers(parameterSymbol.getModifiers());
                        methodSymbol.addParameter(variableSymbol);
                        break;
                    }
                    if (javaSymbol2.code == 571) {
                        CatchClause catchClause = (CatchClause)javaSymbol2.parent;
                        variableSymbol.useType(catchClause.getThrowableType(), this);
                        catchClause.setThrowable(variableSymbol);
                        break;
                    }
                    CodeElement codeElement = (CodeElement)javaSymbol2;
                    variableSymbol.setModifiers(codeElement.getModifiers());
                    try {
                        TypeSymbol typeSymbol = this.newTypeSymbol();
                        typeSymbol.useExpression(codeElement.getExpression(), this.buffer, this.nameMap);
                        variableSymbol.useType(typeSymbol, this);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (javaSymbol2.parent.code == 520) {
                        this.pushScope((StatementSymbol)javaSymbol2.parent);
                    }
                    codeElement.addVariable(variableSymbol);
                    break;
                }
                case 100: {
                    TypeSymbol typeSymbol = (TypeSymbol)javaSymbol;
                    if (javaSymbol2.code == 280) {
                        ((MemberSymbol)javaSymbol2).setType(typeSymbol);
                        break;
                    }
                    if (javaSymbol2.code == 359) {
                        ((ParameterSymbol)javaSymbol2).setType(typeSymbol);
                        break;
                    }
                    ((CatchClause)javaSymbol2.parent).setThrowableType(typeSymbol);
                    break;
                }
                case 351: 
                case 359: {
                    break;
                }
                case 152: {
                    NameSymbol nameSymbol = (NameSymbol)javaSymbol;
                    if (javaSymbol2.code == 200) {
                        TypeSymbol typeSymbol = this.newTypeSymbol();
                        typeSymbol.setName(nameSymbol);
                        typeSymbol.startOffset = nameSymbol.startOffset;
                        typeSymbol.endOffset = nameSymbol.endOffset;
                        ((ClassSymbol)javaSymbol2).setBaseClass(typeSymbol);
                    } else if (javaSymbol2 instanceof ClassListSymbol) {
                        TypeSymbol typeSymbol = this.newTypeSymbol();
                        typeSymbol.setName(nameSymbol);
                        typeSymbol.startOffset = nameSymbol.startOffset;
                        typeSymbol.endOffset = nameSymbol.endOffset;
                        ((ClassListSymbol)javaSymbol2).addClass(typeSymbol);
                    } else {
                        ((Nameable)((Object)javaSymbol2)).setName(nameSymbol);
                    }
                    nameSymbol.recordName(this.buffer);
                    nameSymbol.uniquefy(this.nameMap);
                    break;
                }
                case 151: {
                    NameSymbol nameSymbol = (NameSymbol)javaSymbol;
                    if (javaSymbol2 instanceof StatementSymbol) {
                        ((StatementSymbol)javaSymbol2).addLabel(nameSymbol);
                    } else {
                        ((Nameable)((Object)javaSymbol2)).setName(nameSymbol);
                    }
                    nameSymbol.recordName(this.buffer);
                    nameSymbol.uniquefy(this.nameMap);
                    break;
                }
                case 159: {
                    break;
                }
                case 721: {
                    ((Nameable)((Object)javaSymbol2)).setName((NameSymbol)javaSymbol);
                    NameSymbol nameSymbol = (NameSymbol)javaSymbol;
                    nameSymbol.recordName(this.buffer, javaSymbol.dataValue);
                    nameSymbol.uniquefy(this.nameMap);
                    break;
                }
                case 155: 
                case 722: {
                    ((Nameable)((Object)javaSymbol2)).setName((NameSymbol)javaSymbol);
                    NameSymbol nameSymbol = (NameSymbol)javaSymbol;
                    nameSymbol.recordName(this.buffer, javaSymbol.dataValue);
                    nameSymbol.uniquefy(this.nameMap);
                    break;
                }
                case 143: {
                    CommentSymbol commentSymbol = (CommentSymbol)javaSymbol;
                    ((Commentable)((Object)javaSymbol2)).setComment(commentSymbol);
                    commentSymbol.recordName(this.buffer);
                    break;
                }
                case 170: {
                    if (javaSymbol2.code == 571) {
                        ((CatchClause)javaSymbol2.parent).setModifiers(javaSymbol.dataValue);
                        break;
                    }
                    if (!(javaSymbol2 instanceof HasModifiers)) break;
                    ((HasModifiers)javaSymbol2).setModifiers(javaSymbol.dataValue);
                    break;
                }
                case 111: {
                    if (javaSymbol2 instanceof TypeSymbol) {
                        TypeSymbol typeSymbol = (TypeSymbol)javaSymbol2;
                        typeSymbol.incrementArrayDimension(javaSymbol.dataValue);
                        break;
                    }
                    if (javaSymbol2 instanceof MethodSymbol) {
                        MethodSymbol methodSymbol = (MethodSymbol)javaSymbol2;
                        methodSymbol.getType().incrementArrayDimension(javaSymbol.dataValue);
                        break;
                    }
                    if (javaSymbol2 instanceof VariableSymbol) {
                        VariableSymbol variableSymbol = (VariableSymbol)javaSymbol2;
                        variableSymbol.incrementArrayDimension(javaSymbol.dataValue);
                        break;
                    }
                    if (javaSymbol2 instanceof ParameterSymbol) {
                        ParameterSymbol parameterSymbol = (ParameterSymbol)javaSymbol2;
                        parameterSymbol.getType().incrementArrayDimension(javaSymbol.dataValue);
                        break;
                    }
                    while (true) {
                        if (javaSymbol2 instanceof CreatorExpressionSymbol) {
                            CreatorExpressionSymbol creatorExpressionSymbol = (CreatorExpressionSymbol)javaSymbol2;
                            creatorExpressionSymbol.getClassType().incrementArrayDimension(javaSymbol.dataValue);
                            break block3;
                        }
                        javaSymbol2 = javaSymbol2.parent;
                    }
                }
                default: {
                    System.err.println("JavaSymbolFactory, finish: Unknown syntax code " + javaSymbol.code);
                }
            }
            javaSymbol.doneParsing();
            return;
        }
        catch (ClassCastException classCastException) {
            try {
                javaSymbol.parent.internalError("I'm the parent");
            }
            catch (Exception exception) {
                // empty catch block
            }
            javaSymbol.internalError("Class cast exception during finishSymbol");
            classCastException.printStackTrace();
            return;
        }
        catch (NullPointerException nullPointerException) {
            javaSymbol.reportSyntaxError(JavaSyntaxRecognizer.SYNTAXERR_SKIPPING);
            return;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static void postProcess(RootSymbol rootSymbol) {
        JavaSymbolFactory.processJavadoc(rootSymbol);
    }

    public static void processJavadoc(RootSymbol rootSymbol) {
        JavaDocLexer javaDocLexer = new JavaDocLexer();
        LexerToken lexerToken = javaDocLexer.createLexerToken();
        ClassSymbol[] classSymbolArray = rootSymbol.getClasses();
        if (classSymbolArray != null) {
            int n = classSymbolArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClassSymbol classSymbol = classSymbolArray[n2];
                if (classSymbol != null) {
                    JavaSymbolFactory.processOneJavadoc(classSymbol, javaDocLexer, lexerToken);
                    JavaSymbolFactory.processJavadoc(classSymbol, javaDocLexer, lexerToken);
                }
                ++n2;
            }
        }
    }

    private static void processJavadoc(ClassSymbol classSymbol, JavaDocLexer javaDocLexer, LexerToken lexerToken) {
        MemberSymbol[] memberSymbolArray = classSymbol.getMembers();
        int n = memberSymbolArray.length;
        int n2 = 0;
        while (n2 < n) {
            MemberSymbol memberSymbol = memberSymbolArray[n2];
            if (memberSymbol != null) {
                JavaSymbolFactory.processOneJavadoc(memberSymbol, javaDocLexer, lexerToken);
                if (memberSymbol.whatAmI() == 289) {
                    InnerClassSymbol innerClassSymbol = (InnerClassSymbol)memberSymbol;
                    ClassSymbol classSymbol2 = innerClassSymbol.getClassDefinition();
                    JavaSymbolFactory.processJavadoc(classSymbol2, javaDocLexer, lexerToken);
                }
            }
            ++n2;
        }
    }

    private static void processOneJavadoc(Commentable commentable, JavaDocLexer javaDocLexer, LexerToken lexerToken) {
        CommentSymbol commentSymbol = commentable.getComment();
        if (commentSymbol != null) {
            commentSymbol.processFlags(javaDocLexer, lexerToken);
        }
    }
}

