/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1.symbol;

import java.util.ArrayList;
import oracle.javatools.parser.java.v1.symbol.CatchClause;
import oracle.javatools.parser.java.v1.symbol.ClassBodySymbol;
import oracle.javatools.parser.java.v1.symbol.ClassSymbol;
import oracle.javatools.parser.java.v1.symbol.CodeBlockSymbol;
import oracle.javatools.parser.java.v1.symbol.CommentSymbol;
import oracle.javatools.parser.java.v1.symbol.Commentable;
import oracle.javatools.parser.java.v1.symbol.HasModifiers;
import oracle.javatools.parser.java.v1.symbol.NameSymbol;
import oracle.javatools.parser.java.v1.symbol.Scope;
import oracle.javatools.parser.java.v1.symbol.TypeSymbol;
import oracle.javatools.parser.java.v1.symbol.VariableSymbol;

public class MemberSymbol
extends HasModifiers
implements Commentable,
Scope {
    public static final MemberSymbol[] EMPTY_ARRAY = new MemberSymbol[0];
    public static final int METHOD = 340;
    public static final int CONSTRUCTOR = 370;
    public static final int FIELD = 300;
    public static final int INNER_CLASS = 289;
    public static final int INITIALIZER = 260;
    private CommentSymbol comment;
    private TypeSymbol type;
    private MemberSymbol child;
    private CodeBlockSymbol block;
    private ClassSymbol[] localClassArray;
    private ArrayList localClasses;
    private Scope scope;

    public int whatAmI() {
        return this.code;
    }

    public CodeBlockSymbol getBlock() {
        return this.block;
    }

    public ClassSymbol[] getLocalClasses() {
        if (this.localClassArray == null) {
            this.generateLocalClassArray();
        }
        return this.localClassArray;
    }

    public boolean isDeprecated() {
        if (this.whatAmI() == 260) {
            return false;
        }
        if (this.comment != null) {
            return this.comment.isDeprecated();
        }
        return false;
    }

    public boolean isHidden() {
        if (this.whatAmI() == 260) {
            return false;
        }
        if (this.comment != null) {
            return this.comment.isHidden();
        }
        return false;
    }

    public int getScopeType() {
        return 2;
    }

    public Scope getEnclosingScope() {
        return this.scope;
    }

    public void setEnclosingScope(Scope scope) {
        this.scope = scope;
    }

    public boolean findLabel(String string) {
        return false;
    }

    public VariableSymbol findVariable(String string) {
        return null;
    }

    public ClassSymbol findType(String string) {
        return null;
    }

    public NameSymbol[] getLabels() {
        return NameSymbol.EMPTY_ARRAY;
    }

    public VariableSymbol[] getVariables() {
        return VariableSymbol.EMPTY_ARRAY;
    }

    public ClassSymbol[] getClasses() {
        return ClassSymbol.EMPTY_ARRAY;
    }

    public CatchClause[] getCatchClauses() {
        return CatchClause.EMPTY_ARRAY;
    }

    void $init$() {
        this.comment = null;
        this.type = null;
        this.child = null;
        this.block = null;
        this.localClassArray = null;
        this.localClasses = null;
    }

    MemberSymbol(int n) {
        super(n);
        this.$init$();
    }

    void addLocalClass(ClassSymbol classSymbol) {
        if (this.localClasses == null) {
            this.localClasses = MemberSymbol.allocArrayList();
        }
        this.localClasses.add(classSymbol);
    }

    TypeSymbol getType() {
        return this.type;
    }

    void setType(TypeSymbol typeSymbol) {
        this.type = typeSymbol;
    }

    void setChild(MemberSymbol memberSymbol) {
        this.child = memberSymbol;
    }

    void setBlock(CodeBlockSymbol codeBlockSymbol) {
        this.block = codeBlockSymbol;
    }

    MemberSymbol getChild() {
        return this.child;
    }

    void addToClass(ClassBodySymbol classBodySymbol) {
    }

    void doneParsing() {
        super.doneParsing();
        if (this.whatAmI() == 260) {
            ClassBodySymbol classBodySymbol = (ClassBodySymbol)this.parent;
            classBodySymbol.addInitializer(this);
        } else if (this.parent.code == 280) {
            MemberSymbol memberSymbol = (MemberSymbol)this.parent;
            memberSymbol.setChild(this);
            this.setType(memberSymbol.getType());
            this.setModifiers(memberSymbol.getModifiers());
            this.setComment(memberSymbol.getComment());
            if (memberSymbol.getEnclosingScope() != null) {
                this.internalError("Outer member should not have a scope ptr!");
            }
        } else if (this.child != null) {
            ClassBodySymbol classBodySymbol = (ClassBodySymbol)this.parent;
            this.child.addToClass(classBodySymbol);
        }
        this.generateLocalClassArray();
    }

    private void generateLocalClassArray() {
        if (this.localClasses == null) {
            this.localClassArray = ClassSymbol.EMPTY_ARRAY;
        } else {
            int n = this.localClasses.size();
            this.localClassArray = this.localClasses.toArray(new ClassSymbol[n]);
            MemberSymbol.freeArrayList(this.localClasses);
            this.localClasses = null;
        }
    }

    public CommentSymbol getComment() {
        return this.comment;
    }

    public void setComment(CommentSymbol commentSymbol) {
        this.comment = commentSymbol;
    }
}

