/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1.symbol;

import java.util.ArrayList;
import oracle.javatools.parser.java.v1.symbol.ClassBodySymbol;
import oracle.javatools.parser.java.v1.symbol.ClassListSymbol;
import oracle.javatools.parser.java.v1.symbol.MemberSymbol;
import oracle.javatools.parser.java.v1.symbol.NameSymbol;
import oracle.javatools.parser.java.v1.symbol.Nameable;
import oracle.javatools.parser.java.v1.symbol.TypeSymbol;
import oracle.javatools.parser.java.v1.symbol.VariableSymbol;

public class MethodSymbol
extends MemberSymbol
implements Nameable {
    private NameSymbol name;
    private ArrayList parameters;
    private VariableSymbol[] parameterArray;
    private ClassListSymbol thrownClasses;
    static final MethodSymbol[] EMPTY_ARRAY = new MethodSymbol[0];

    public boolean isConstructor() {
        return this.code == 370;
    }

    public VariableSymbol[] getParameters() {
        return this.parameterArray;
    }

    public NameSymbol[] getThrows() {
        return this.thrownClasses != null ? this.thrownClasses.listClasses() : NameSymbol.EMPTY_ARRAY;
    }

    public TypeSymbol[] getThrownTypes() {
        return this.thrownClasses != null ? this.thrownClasses.listClassTypes() : TypeSymbol.EMPTY_ARRAY;
    }

    public TypeSymbol getReturnType() {
        return this.getType();
    }

    public int getScopeType() {
        return 3;
    }

    public VariableSymbol findVariable(String string) {
        VariableSymbol[] variableSymbolArray = this.getParameters();
        int n = variableSymbolArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableSymbol variableSymbol = variableSymbolArray[n2];
            if (variableSymbol != null && MethodSymbol.matches(variableSymbol, string)) {
                return variableSymbol;
            }
            ++n2;
        }
        return null;
    }

    public VariableSymbol[] getVariables() {
        return this.getParameters();
    }

    void $init$() {
        this.name = null;
        this.parameters = MethodSymbol.allocArrayList();
        this.parameterArray = null;
    }

    MethodSymbol(int n) {
        super(n);
        this.$init$();
        if (n != 340 && n != 370) {
            this.internalError("Wrong code for a MethodSymbol");
        }
    }

    TypeSymbol getType() {
        TypeSymbol typeSymbol = super.getType();
        if (typeSymbol == null && this.parent.code == 280) {
            return ((MemberSymbol)this.parent).getType();
        }
        return typeSymbol;
    }

    void addParameter(VariableSymbol variableSymbol) {
        this.parameters.add(variableSymbol);
    }

    void setThrows(ClassListSymbol classListSymbol) {
        this.thrownClasses = classListSymbol;
    }

    void addToClass(ClassBodySymbol classBodySymbol) {
        if (this.isConstructor()) {
            classBodySymbol.addConstructor(this);
        } else {
            classBodySymbol.addMethod(this);
        }
    }

    void doneParsing() {
        super.doneParsing();
        this.generateParameterArray();
    }

    private void generateParameterArray() {
        int n = this.parameters.size();
        this.parameterArray = n > 0 ? this.parameters.toArray(new VariableSymbol[n]) : VariableSymbol.EMPTY_ARRAY;
        MethodSymbol.freeArrayList(this.parameters);
        this.parameters = null;
    }

    public NameSymbol getName() {
        return this.name;
    }

    public void setName(NameSymbol nameSymbol) {
        this.name = nameSymbol;
    }
}

