/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1.symbol;

import java.util.ArrayList;
import oracle.javatools.parser.java.v1.symbol.CatchClause;
import oracle.javatools.parser.java.v1.symbol.ClassSymbol;
import oracle.javatools.parser.java.v1.symbol.ErrorReporter;
import oracle.javatools.parser.java.v1.symbol.ErrorSymbol;
import oracle.javatools.parser.java.v1.symbol.ImportSymbol;
import oracle.javatools.parser.java.v1.symbol.JavaSymbol;
import oracle.javatools.parser.java.v1.symbol.NameSymbol;
import oracle.javatools.parser.java.v1.symbol.PackageSymbol;
import oracle.javatools.parser.java.v1.symbol.Scope;
import oracle.javatools.parser.java.v1.symbol.VariableSymbol;

public class RootSymbol
extends JavaSymbol
implements Scope,
ErrorReporter {
    private PackageSymbol p;
    private NameSymbol sqlContext;
    private ImportSymbol[] importArray;
    private ClassSymbol[] classArray;
    private ErrorSymbol[] errorArray;
    private ArrayList imports;
    private ArrayList classes;

    public PackageSymbol getPackage() {
        return this.p;
    }

    public ImportSymbol[] getImports() {
        if (this.importArray == null) {
            this.generateImportArray();
        }
        return this.importArray;
    }

    public ClassSymbol[] getClasses() {
        if (this.classArray == null) {
            this.generateClassArray();
        }
        return this.classArray;
    }

    public NameSymbol getSqlContext() {
        return this.sqlContext;
    }

    public boolean hasErrors() {
        if (this.errorArray == null) {
            this.errorArray = ErrorSymbol.EMPTY_ARRAY;
        }
        return this.errorArray.length > 0;
    }

    public ErrorSymbol[] getErrors() {
        if (this.errorArray == null) {
            this.errorArray = ErrorSymbol.EMPTY_ARRAY;
        }
        return this.errorArray;
    }

    public final void setErrorArray(ErrorSymbol[] errorSymbolArray) {
        this.errorArray = errorSymbolArray;
    }

    public int getScopeType() {
        return 0;
    }

    public Scope getEnclosingScope() {
        return null;
    }

    public void setEnclosingScope(Scope scope) {
    }

    public int getModifiers() {
        return 0;
    }

    public boolean findLabel(String string) {
        return false;
    }

    public VariableSymbol findVariable(String string) {
        return null;
    }

    public ClassSymbol findType(String string) {
        ClassSymbol[] classSymbolArray = this.getClasses();
        int n = classSymbolArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassSymbol classSymbol = classSymbolArray[n2];
            if (RootSymbol.matches(classSymbol, string)) {
                return classSymbol;
            }
            ++n2;
        }
        return null;
    }

    public NameSymbol[] getLabels() {
        return NameSymbol.EMPTY_ARRAY;
    }

    public VariableSymbol[] getVariables() {
        return VariableSymbol.EMPTY_ARRAY;
    }

    public CatchClause[] getCatchClauses() {
        return CatchClause.EMPTY_ARRAY;
    }

    void $init$() {
        this.importArray = null;
        this.classArray = null;
        this.errorArray = null;
        this.imports = RootSymbol.allocArrayList();
        this.classes = RootSymbol.allocArrayList();
    }

    RootSymbol() {
        super(25);
        this.$init$();
    }

    private void generateImportArray() {
        int n = this.imports.size();
        this.importArray = n > 0 ? this.imports.toArray(new ImportSymbol[n]) : ImportSymbol.EMPTY_ARRAY;
        RootSymbol.freeArrayList(this.imports);
        this.imports = null;
    }

    private void generateClassArray() {
        int n = this.classes.size();
        this.classArray = n > 0 ? this.classes.toArray(new ClassSymbol[n]) : ClassSymbol.EMPTY_ARRAY;
        RootSymbol.freeArrayList(this.classes);
        this.classes = null;
    }

    final void setPackage(PackageSymbol packageSymbol) {
        this.p = packageSymbol;
    }

    final void addImport(ImportSymbol importSymbol) {
        this.imports.add(importSymbol);
    }

    final void addClass(ClassSymbol classSymbol) {
        this.classes.add(classSymbol);
    }

    final void setSqlContext(NameSymbol nameSymbol) {
        this.sqlContext = nameSymbol;
    }

    void doneParsing() {
        super.doneParsing();
        this.generateImportArray();
        this.generateClassArray();
    }
}

