/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1.symbol;

import oracle.javatools.parser.java.v1.symbol.ExpressionSymbol;
import oracle.javatools.parser.java.v1.symbol.HasModifiers;
import oracle.javatools.parser.java.v1.symbol.JavaSymbolFactory;
import oracle.javatools.parser.java.v1.symbol.NameSymbol;
import oracle.javatools.parser.java.v1.symbol.Nameable;
import oracle.javatools.parser.java.v1.symbol.TypeSymbol;

public class VariableSymbol
extends HasModifiers
implements Nameable {
    private NameSymbol name;
    private TypeSymbol type;
    private ExpressionSymbol initializer;
    private int arrayDimension;
    private int index;
    static final VariableSymbol[] EMPTY_ARRAY = new VariableSymbol[0];

    public TypeSymbol getType() {
        return this.type;
    }

    public ExpressionSymbol getInitializer() {
        return this.initializer;
    }

    public int getIndex() {
        return this.index;
    }

    void $init$() {
        this.name = null;
        this.type = null;
    }

    VariableSymbol(int n) {
        super(311);
        this.$init$();
        this.index = n;
    }

    void setInitializer(ExpressionSymbol expressionSymbol) {
        this.initializer = expressionSymbol;
    }

    void incrementArrayDimension(int n) {
        this.arrayDimension += n;
        if (this.type != null) {
            this.type.incrementArrayDimension(n);
        }
    }

    void useType(TypeSymbol typeSymbol, JavaSymbolFactory javaSymbolFactory) {
        TypeSymbol typeSymbol2 = javaSymbolFactory.newTypeSymbol();
        typeSymbol2.parent = this;
        typeSymbol2.startOffset = typeSymbol.startOffset;
        typeSymbol2.endOffset = typeSymbol.endOffset;
        typeSymbol2.setName(typeSymbol.getName());
        typeSymbol2.incrementArrayDimension(typeSymbol.getArrayDimension() + this.arrayDimension);
        this.type = typeSymbol2;
        if (typeSymbol.startOffset < this.startOffset) {
            this.startOffset = typeSymbol.startOffset;
        }
    }

    public NameSymbol getName() {
        return this.name;
    }

    public void setName(NameSymbol nameSymbol) {
        this.name = nameSymbol;
    }
}

