/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.classfile;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.classfile.ClParser;
import oracle.javatools.parser.java.v2.classfile.ClassFile;
import oracle.javatools.parser.java.v2.classfile.NameType;
import oracle.javatools.parser.java.v2.common.AbstractAnnotation;
import oracle.javatools.parser.java.v2.common.AbstractClass;
import oracle.javatools.parser.java.v2.common.AbstractField;
import oracle.javatools.parser.java.v2.common.AbstractMethod;
import oracle.javatools.parser.java.v2.common.AbstractType;
import oracle.javatools.parser.java.v2.common.AbstractVariable;
import oracle.javatools.parser.java.v2.common.AnnotationComponents;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasAnnotations;
import oracle.javatools.parser.java.v2.model.JavaIsGeneric;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceHasModifiers;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.UnresolvedType;

public class ClClass
extends AbstractClass {
    private static final List kEmptyList = Collections.EMPTY_LIST;
    private final JavaProvider provider;
    private final ClassFile classFile;
    protected Collection annotations;
    protected Collection typeParameters;
    protected ClType superclass;
    protected Collection interfaceTypes;
    private Collection interfaces;
    private Collection methods;
    private Collection constructors;
    private ClMethod clinitMethod;
    private Collection fields;
    private Collection classes;
    private SourceClass sourceClass;

    void $init$() {
        this.typeParameters = JavaConstants.kEmptyCollection;
        this.superclass = null;
        this.interfaceTypes = null;
        this.sourceClass = null;
    }

    public ClClass(ClassFile classFile, JavaProvider javaProvider) {
        this.$init$();
        this.classFile = classFile;
        this.provider = javaProvider;
        String string = classFile.getSignature();
        if (string != null) {
            this.parseSignature(string);
            if (this.interfaceTypes == null) {
                this.interfaces = JavaConstants.kEmptyCollection;
            }
        } else {
            NameType nameType = classFile.getBaseClass();
            if (nameType != null) {
                this.superclass = new ClType('L', nameType.toString());
            }
        }
    }

    private void parseSignature(String string) {
        ClParser clParser = new ClParser(string, this);
        clParser.parseClassSignature0(this);
    }

    public JavaProvider getProvider() {
        return this.provider;
    }

    public String getName() {
        String string = this.getQualifiedName();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public String getSignature() {
        String string = this.classFile.getSignature();
        if (string != null) {
            return string;
        }
        return super.getSignature();
    }

    public boolean isInterface() {
        return (this.classFile.getModifiers() & 0x200) != 0;
    }

    public String getQualifiedName() {
        String string = this.getVMName();
        int n = string.indexOf(36);
        JavaClass javaClass = this.getOwningClass();
        if (n != -1 && javaClass != null) {
            String string2 = javaClass.getQualifiedName();
            int n2 = string2.length();
            return string2 + '.' + string.substring(n2 + 1);
        }
        return string.replace('/', '.');
    }

    public String getVMName() {
        return this.classFile.getFullClassName();
    }

    public JavaPackage getPackage() {
        return this.provider.getPackage(this.getPackageName());
    }

    public String getPackageName() {
        JavaClass javaClass = this.getOwningClass();
        if (javaClass != null) {
            return javaClass.getPackageName();
        }
        String string = this.getQualifiedName();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            return string.substring(0, n);
        }
        return "";
    }

    public boolean hasTypeParameters() {
        return this.typeParameters.isEmpty() ^ true;
    }

    public Collection getTypeParameters() {
        return this.typeParameters;
    }

    public JavaType getSuperclass() {
        if (this.superclass != null) {
            return ClType.mav$getResolvedType(this.superclass);
        }
        return null;
    }

    public Collection getInterfaces() {
        if (this.interfaces == null) {
            if (this.interfaceTypes != null) {
                ArrayList<JavaType> arrayList = new ArrayList<JavaType>();
                for (ClType clType : this.interfaceTypes) {
                    JavaType javaType = ClType.mav$getResolvedType(clType);
                    if (javaType == null) continue;
                    arrayList.add(javaType);
                }
                this.interfaces = arrayList;
                this.interfaceTypes = null;
            } else {
                NameType[] nameTypeArray = this.classFile.getBaseInterfaces();
                int n = nameTypeArray.length;
                if (n == 0) {
                    this.interfaces = JavaConstants.kEmptyCollection;
                } else {
                    ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>();
                    int n2 = 0;
                    while (n2 < n) {
                        JavaClass javaClass = this.provider.getClassByVMName(nameTypeArray[n2].toString());
                        if (javaClass != null) {
                            arrayList.add(javaClass);
                        }
                        ++n2;
                    }
                    this.interfaces = arrayList;
                }
            }
            if (this.interfaces.isEmpty()) {
                this.interfaces = JavaConstants.kEmptyCollection;
            }
        }
        return this.interfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getDeclaredFields() {
        if (this.fields == null) {
            ClClass clClass = this;
            synchronized (clClass) {
                if (this.fields == null) {
                    ClassFile.ClassField[] classFieldArray = this.classFile.getDeclaredFields();
                    int n = classFieldArray.length;
                    if (n == 0) {
                        this.fields = JavaConstants.kEmptyCollection;
                    } else {
                        ArrayList<ClField> arrayList = new ArrayList<ClField>();
                        int n2 = 0;
                        while (n2 < n) {
                            ClassFile.ClassField classField = classFieldArray[n2];
                            if ((classField.getModifiers() & 0x1000) == 0) {
                                arrayList.add(new ClField(classField, null));
                            }
                            ++n2;
                        }
                        this.fields = arrayList;
                    }
                }
            }
        }
        return this.fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getDeclaredMethods() {
        if (this.methods == null) {
            ClClass clClass = this;
            synchronized (clClass) {
                if (this.methods == null) {
                    ClassFile.ClassMethod[] classMethodArray = this.classFile.getDeclaredMethods();
                    int n = classMethodArray.length;
                    if (n == 0) {
                        this.methods = JavaConstants.kEmptyCollection;
                    } else {
                        ArrayList<ClMethod> arrayList = new ArrayList<ClMethod>();
                        int n2 = 0;
                        while (n2 < n) {
                            ClassFile.ClassMethod classMethod = classMethodArray[n2];
                            if (!classMethod.getMethodName().startsWith("access$") && (classMethod.getModifiers() & 0x1000) == 0) {
                                arrayList.add(new ClMethod(classMethod, null));
                            }
                            ++n2;
                        }
                        this.methods = arrayList;
                    }
                    ClassFile.ClassMethod classMethod = this.classFile.getClinitMethod();
                    if (classMethod != null) {
                        this.clinitMethod = new ClMethod(classMethod, null);
                    }
                }
            }
        }
        return this.methods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getDeclaredConstructors() {
        if (this.constructors == null) {
            ClClass clClass = this;
            synchronized (clClass) {
                if (this.constructors == null) {
                    ClassFile.ClassMethod[] classMethodArray = this.classFile.getDeclaredConstructors();
                    int n = classMethodArray.length;
                    if (n == 0) {
                        this.constructors = JavaConstants.kEmptyCollection;
                    } else {
                        ArrayList<ClMethod> arrayList = new ArrayList<ClMethod>();
                        int n2 = 0;
                        while (n2 < n) {
                            arrayList.add(new ClMethod(classMethodArray[n2], null));
                            ++n2;
                        }
                        this.constructors = arrayList;
                    }
                }
            }
        }
        return this.constructors;
    }

    public JavaMethod getClinitMethod() {
        this.getDeclaredMethods();
        return this.clinitMethod;
    }

    public Collection getDeclaredClasses() {
        if (this.classes == null) {
            NameType[] nameTypeArray = this.classFile.getDeclaredInnerClasses();
            int n = nameTypeArray.length;
            if (n == 0) {
                this.classes = JavaConstants.kEmptyCollection;
            } else {
                ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>();
                int n2 = 0;
                while (n2 < n) {
                    JavaClass javaClass = this.getInnerClassByVMName(nameTypeArray[n2].toString());
                    if (javaClass != null) {
                        arrayList.add(javaClass);
                    }
                    ++n2;
                }
                this.classes = !arrayList.isEmpty() ? arrayList : JavaConstants.kEmptyCollection;
            }
        }
        return this.classes;
    }

    public JavaClass getOwningClass() {
        NameType nameType = this.classFile.getOuterClass();
        if (nameType != null) {
            return this.provider.getClassByVMName(nameType.toString());
        }
        return null;
    }

    public JavaElement getOwner() {
        JavaClass javaClass = this.getOwningClass();
        if (javaClass != null) {
            return javaClass;
        }
        return this.getPackage();
    }

    public boolean isDeprecated() {
        return this.classFile.isDeprecated();
    }

    public boolean isHidden() {
        return this.classFile.isHidden();
    }

    public int getModifiers() {
        return this.classFile.getModifiers();
    }

    public void setSourceElement(SourceElement sourceElement) {
        this.sourceClass = (SourceClass)sourceElement;
    }

    public SourceElement getSourceElement() {
        if (this.sourceClass != null) {
            return this.sourceClass;
        }
        return this.getSourceClass(this.classFile.getSourceFilename());
    }

    public URL getURL() {
        return this.classFile.getURL();
    }

    public Collection getDeclaredAnnotations() {
        if (this.annotations == null) {
            ClassFile.ClassAnnotation[] classAnnotationArray = this.classFile.getDeclaredAnnotations();
            this.annotations = this.createAnnotations(this, classAnnotationArray);
        }
        return this.annotations;
    }

    public void clearCompiledInfo() {
        super.clearCompiledInfo();
        this.interfaces = null;
        this.sourceClass = null;
        this.annotations = null;
        for (ClTypeParameter clTypeParameter : this.typeParameters) {
            clTypeParameter.clearCompiledInfo();
        }
        for (ClMethod clMethod : this.methods) {
            clMethod.clearCompiledInfo();
        }
        for (ClField clField : this.fields) {
            clField.clearCompiledInfo();
        }
        for (ClClass clClass : this.classes) {
            clClass.clearCompiledInfo();
        }
    }

    protected SourceClass getSourceClass(String string) {
        return this.provider.getSourceClass(this.getQualifiedName());
    }

    protected JavaClass getInnerClassByVMName(String string) {
        JavaClass javaClass = this.provider.getClassByVMName(string);
        return javaClass;
    }

    private Object readComponentValue(ClassFile.ComponentValue componentValue, JavaElement javaElement) {
        Object object = componentValue.getComponentValue();
        char c = componentValue.getComponentTag();
        switch (c) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': 
            case 's': {
                return object;
            }
            case 'c': {
                NameType nameType = (NameType)object;
                return ClType.mav$getResolvedType(new ClType(nameType));
            }
            case 'e': {
                ClassFile.EnumReference enumReference = (ClassFile.EnumReference)object;
                JavaType javaType = ClType.mav$getResolvedType(new ClType(enumReference.enumClassname));
                if (javaType != null) {
                    return javaType.getDeclaredField(enumReference.enumName.toString());
                }
                return null;
            }
            case '@': {
                ClassFile.ClassAnnotation classAnnotation = (ClassFile.ClassAnnotation)object;
                return new ClAnnotation(javaElement, classAnnotation);
            }
            case '[': {
                ClassFile.ComponentValue[] componentValueArray = (ClassFile.ComponentValue[])object;
                int n = componentValueArray.length;
                if (n == 0) {
                    return JavaConstants.EMPTY_OBJECT_ARRAY;
                }
                Object[] objectArray = new Object[n];
                int n2 = 0;
                while (n2 < n) {
                    objectArray[n2] = this.readComponentValue(componentValueArray[n2], javaElement);
                    ++n2;
                }
                return objectArray;
            }
        }
        CommonUtilities.panic("Unknown component tag: " + c);
        return null;
    }

    private Collection createAnnotations(JavaHasAnnotations javaHasAnnotations, ClassFile.ClassAnnotation[] classAnnotationArray) {
        int n = classAnnotationArray.length;
        if (n == 0) {
            return JavaConstants.kEmptyCollection;
        }
        JavaAnnotation[] javaAnnotationArray = new JavaAnnotation[n];
        int n2 = 0;
        while (n2 < n) {
            javaAnnotationArray[n2] = new ClAnnotation(javaHasAnnotations, classAnnotationArray[n2]);
            ++n2;
        }
        return Arrays.asList(javaAnnotationArray);
    }

    private static void errorMalformed(String string) {
        CommonUtilities.panic(string);
    }

    static Collection mav$createAnnotations(ClClass clClass, JavaHasAnnotations javaHasAnnotations, ClassFile.ClassAnnotation[] classAnnotationArray) {
        return clClass.createAnnotations(javaHasAnnotations, classAnnotationArray);
    }

    static Object mav$readComponentValue(ClClass clClass, ClassFile.ComponentValue componentValue, JavaElement javaElement) {
        return clClass.readComponentValue(componentValue, javaElement);
    }

    static JavaProvider ra$provider(ClClass clClass) {
        return clClass.provider;
    }

    static List ra$kEmptyList() {
        return kEmptyList;
    }

    static void wa$interfaces(ClClass clClass, Collection collection) {
        clClass.interfaces = collection;
    }

    private class ClField
    extends AbstractField {
        private ClassFile.ClassField thing;
        protected Collection annotations;
        private ClType type;

        private ClField(ClassFile.ClassField classField) {
            this.thing = classField;
            String string = classField.getSignature();
            this.type = string != null ? this.parseSignature(string) : this.parseSignature(classField.getDescriptor());
        }

        private ClType parseSignature(String string) {
            ClParser clParser = new ClParser(string, ClClass.this);
            return clParser.parseTypeSignature0();
        }

        public JavaType getResolvedType() {
            return ClType.mav$getResolvedType(this.type);
        }

        public UnresolvedType getUnresolvedType() {
            return this.type.getUnresolvedType();
        }

        public String getName() {
            return this.thing.getFieldName();
        }

        public JavaClass getOwningClass() {
            return ClClass.this;
        }

        public JavaElement getOwner() {
            return this.getOwningClass();
        }

        public String getDescriptor() {
            return this.thing.getDescriptor();
        }

        public String getSignature() {
            String string = this.thing.getSignature();
            if (string != null) {
                return string;
            }
            return this.getDescriptor();
        }

        public boolean isDeprecated() {
            return this.thing.isDeprecated();
        }

        public boolean isHidden() {
            return this.thing.isHidden();
        }

        public int getModifiers() {
            return this.thing.getModifiers();
        }

        public SourceElement getSourceElement() {
            SourceClass sourceClass = (SourceClass)ClClass.this.getSourceElement();
            return CommonUtilities.getSourceElement(this, sourceClass);
        }

        public Collection getDeclaredAnnotations() {
            if (this.annotations == null) {
                ClassFile.ClassAnnotation[] classAnnotationArray = this.thing.getDeclaredAnnotations();
                this.annotations = ClClass.mav$createAnnotations(ClClass.this, this, classAnnotationArray);
            }
            return this.annotations;
        }

        public Object getConstantValue() {
            if (this.isEnumConstant()) {
                return this;
            }
            return this.thing.getConstantValue();
        }

        public void clearCompiledInfo() {
            this.annotations = null;
        }

        ClField(ClassFile.ClassField classField, 1 var3_3) {
            this(classField);
        }

        public final class 1 {
        }
    }

    protected class ClMethod
    extends AbstractMethod {
        private final ClassFile.ClassMethod thing;
        protected Collection annotations;
        protected Collection typeParameters;
        protected ClType returnType;
        protected Collection formalParameters;
        protected Collection exceptionTypes;
        private Collection exceptions;
        private Object value;
        private SourceElement source;

        void $init$() {
            this.typeParameters = JavaConstants.kEmptyCollection;
            this.formalParameters = JavaConstants.kEmptyCollection;
            this.exceptionTypes = null;
            this.value = null;
            this.source = null;
        }

        private ClMethod(ClassFile.ClassMethod classMethod) {
            this.$init$();
            this.thing = classMethod;
            String string = classMethod.getSignature();
            if (string != null) {
                this.parseSignature(string);
            } else {
                String string2 = classMethod.getDescriptor();
                this.parseSignature(string2);
            }
        }

        private void parseSignature(String string) {
            ClParser clParser = new ClParser(string, ClClass.this, this);
            clParser.parseMethodTypeSignature0(this);
        }

        public boolean isConstructor() {
            return this.thing.isConstructor();
        }

        public JavaType getResolvedType() {
            return ClType.mav$getResolvedType(this.returnType);
        }

        public UnresolvedType getUnresolvedType() {
            return this.returnType.getUnresolvedType();
        }

        public String getName() {
            return this.thing.getMethodName();
        }

        public JavaClass getOwningClass() {
            return ClClass.this;
        }

        public JavaElement getOwner() {
            return this.getOwningClass();
        }

        public boolean hasTypeParameters() {
            return this.typeParameters.isEmpty() ^ true;
        }

        public Collection getTypeParameters() {
            return this.typeParameters;
        }

        public Collection getParameters() {
            return this.formalParameters;
        }

        public Collection getExceptions() {
            if (this.exceptions == null) {
                if (this.exceptionTypes != null) {
                    ArrayList<JavaType> arrayList = new ArrayList<JavaType>();
                    for (ClType clType : this.exceptionTypes) {
                        JavaType javaType = ClType.mav$getResolvedType(clType);
                        if (javaType == null) continue;
                        arrayList.add(javaType);
                    }
                    this.exceptions = arrayList;
                    this.exceptionTypes = null;
                } else {
                    NameType[] nameTypeArray = this.thing.getThrownExceptionTypes();
                    int n = nameTypeArray.length;
                    if (n == 0) {
                        this.exceptions = JavaConstants.kEmptyCollection;
                    } else {
                        ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>();
                        int n2 = 0;
                        while (n2 < n) {
                            JavaClass javaClass = ClClass.ra$provider(ClClass.this).getClassByVMName(nameTypeArray[n2].toString());
                            if (javaClass != null) {
                                arrayList.add(javaClass);
                            }
                            ++n2;
                        }
                        this.exceptions = arrayList;
                    }
                }
                if (this.exceptions.isEmpty()) {
                    this.exceptions = JavaConstants.kEmptyCollection;
                }
            }
            return this.exceptions;
        }

        public boolean isDeprecated() {
            return this.thing.isDeprecated();
        }

        public boolean isHidden() {
            return this.thing.isHidden();
        }

        public int getModifiers() {
            return this.thing.getModifiers();
        }

        public String getDescriptor() {
            return this.thing.getDescriptor();
        }

        public String getSignature() {
            String string = this.thing.getSignature();
            if (string != null) {
                return string;
            }
            return this.getDescriptor();
        }

        public SourceElement getSourceElement() {
            if (this.source == null) {
                SourceClass sourceClass = (SourceClass)ClClass.this.getSourceElement();
                this.source = CommonUtilities.getSourceElement(this, sourceClass);
            }
            return this.source;
        }

        public Object getDefaultValue() {
            ClassFile.ComponentValue componentValue;
            if (this.value == null && (componentValue = this.thing.getDefaultValue()) != null) {
                this.value = ClClass.mav$readComponentValue(ClClass.this, componentValue, this);
            }
            return this.value;
        }

        public void clearCompiledInfo() {
            this.exceptions = null;
            this.source = null;
            this.annotations = null;
            this.value = null;
        }

        public Collection getDeclaredAnnotations() {
            if (this.annotations == null) {
                ClassFile.ClassAnnotation[] classAnnotationArray = this.thing.getDeclaredAnnotations();
                this.annotations = ClClass.mav$createAnnotations(ClClass.this, this, classAnnotationArray);
            }
            return this.annotations;
        }

        ClMethod(ClassFile.ClassMethod classMethod, 1 var3_3) {
            this(classMethod);
        }

        protected class ClVariable
        extends AbstractVariable
        implements JavaLocalVariable {
            private final ClType type;
            private final int index;

            protected ClVariable(ClType clType, int n) {
                this.type = clType;
                this.index = n;
            }

            public int getElementKind() {
                return 7;
            }

            public JavaType getResolvedType() {
                return ClType.mav$getResolvedType(this.type);
            }

            public UnresolvedType getUnresolvedType() {
                return this.type.getUnresolvedType();
            }

            public String getName() {
                SourceVariable sourceVariable = (SourceVariable)this.getSourceElement();
                if (sourceVariable != null) {
                    return sourceVariable.getName();
                }
                return "";
            }

            public JavaElement getOwner() {
                return ClMethod.this;
            }

            public int getModifiers() {
                if (ClMethod.this.isVarargs() && this.index == ClMethod.this.formalParameters.size() - 1) {
                    return 128;
                }
                return 0;
            }

            public SourceElement getSourceElement() {
                SourceMethod sourceMethod = (SourceMethod)ClMethod.this.getSourceElement();
                if (sourceMethod == null) {
                    return null;
                }
                List list = sourceMethod.getSourceParameters();
                if (list.size() <= this.index) {
                    return null;
                }
                return (SourceElement)list.get(this.index);
            }
        }

        public final class 1 {
        }
    }

    protected class ClTypeParameter
    extends AbstractType
    implements JavaTypeVariable {
        private final JavaIsGeneric owner;
        private final String name;
        protected ClType superclassBound;
        protected List interfaceBounds;
        private JavaType[] resolvedInterfaces;
        private JavaType[] resolvedBounds;

        void $init$() {
            this.superclassBound = null;
            this.interfaceBounds = ClClass.ra$kEmptyList();
            this.resolvedInterfaces = null;
            this.resolvedBounds = null;
        }

        protected ClTypeParameter(JavaIsGeneric javaIsGeneric, String string) {
            this.$init$();
            this.owner = javaIsGeneric;
            this.name = string;
        }

        public String getTypeSignature() {
            return CommonUtilities.getTypeSignature(this);
        }

        public String getDescriptor() {
            return CommonUtilities.getDescriptor(this);
        }

        public String getUniqueIdentifier() {
            return CommonUtilities.getUniqueIdentifier(this);
        }

        public String getQualifiedName() {
            return this.getName();
        }

        public String getVMName() {
            return this.getName();
        }

        public int getElementKind() {
            return 10;
        }

        public String getName() {
            return this.name;
        }

        public JavaElement getOwner() {
            return this.owner;
        }

        public JavaMember getOwningMember() {
            return this.owner;
        }

        public JavaClass getTypeErasure() {
            return CommonUtilities.getTypeErasure(this);
        }

        public JavaType getSuperclass() {
            JavaType javaType;
            if (this.superclassBound != null && (javaType = ClType.mav$getResolvedType(this.superclassBound)) != null) {
                return javaType;
            }
            return ClClass.ra$provider(ClClass.this).getClassByVMName("java/lang/Object");
        }

        public Collection getInterfaces() {
            JavaType[] javaTypeArray = this.getResolvedInterfaces();
            if (javaTypeArray.length > 0) {
                return Arrays.asList(javaTypeArray);
            }
            return JavaConstants.kEmptyCollection;
        }

        public Collection getBounds() {
            JavaType[] javaTypeArray = this.getResolvedBounds();
            if (javaTypeArray.length > 0) {
                return Arrays.asList(javaTypeArray);
            }
            return JavaConstants.kEmptyCollection;
        }

        public void clearCompiledInfo() {
            super.clearCompiledInfo();
            ClClass.wa$interfaces(ClClass.this, null);
        }

        public JavaType[] getResolvedInterfaces() {
            if (this.resolvedInterfaces == null) {
                ArrayList<JavaType> arrayList = ClClass.ra$kEmptyList();
                if (this.interfaceBounds != null && !this.interfaceBounds.isEmpty()) {
                    arrayList = new ArrayList<JavaType>();
                    for (ClType clType : this.interfaceBounds) {
                        JavaType javaType = ClType.mav$getResolvedType(clType);
                        if (javaType == null) continue;
                        arrayList.add(javaType);
                    }
                }
                this.resolvedInterfaces = arrayList.isEmpty() ? JavaType.EMPTY_ARRAY : arrayList.toArray(new JavaType[arrayList.size()]);
            }
            return this.resolvedInterfaces;
        }

        public JavaType[] getResolvedBounds() {
            if (this.resolvedBounds == null) {
                JavaType javaType;
                JavaType[] javaTypeArray = this.getResolvedInterfaces();
                if (this.superclassBound != null && (javaType = ClType.mav$getResolvedType(this.superclassBound)) != null) {
                    int n = javaTypeArray.length;
                    JavaType[] javaTypeArray2 = new JavaType[n + 1];
                    javaTypeArray2[0] = javaType;
                    System.arraycopy(javaTypeArray, 0, javaTypeArray2, 1, n);
                    this.resolvedBounds = javaTypeArray2;
                }
                if (this.resolvedBounds == null) {
                    this.resolvedBounds = javaTypeArray;
                }
            }
            return this.resolvedBounds;
        }
    }

    protected class ClType
    implements UnresolvedType {
        private final byte ch;
        protected byte bound;
        private final JavaIsGeneric owningGeneric;
        private final String name;
        protected short array;
        protected Collection arguments;

        void $init$() {
            this.bound = 0;
            this.array = 0;
            this.arguments = JavaConstants.kEmptyCollection;
        }

        protected ClType(char c) {
            this.$init$();
            this.ch = (byte)c;
            this.name = null;
            this.owningGeneric = null;
        }

        protected ClType(char c, String string) {
            this.$init$();
            this.ch = (byte)c;
            this.name = string;
            this.owningGeneric = null;
        }

        protected ClType(String string, JavaIsGeneric javaIsGeneric) {
            this.$init$();
            this.ch = (byte)84;
            this.name = string;
            this.owningGeneric = javaIsGeneric;
        }

        protected ClType(NameType nameType) {
            this.$init$();
            this.ch = (byte)76;
            this.owningGeneric = null;
            String string = nameType.toString();
            this.name = string.substring(1, string.length() - 1);
        }

        private JavaType getResolvedType() {
            JavaType javaType;
            switch (this.ch) {
                case 84: {
                    javaType = this.resolveTypeVariable(this.name);
                    break;
                }
                case 42: {
                    javaType = CommonUtilities.createWildcardType((byte)3, null, ClClass.ra$provider(ClClass.this));
                    break;
                }
                default: {
                    javaType = this.name != null ? ClClass.ra$provider(ClClass.this).getClassByVMName(this.name) : PrimitiveType.PRIMITIVE_alpha[this.ch - 65];
                    if (this.arguments.isEmpty()) break;
                    int n = this.arguments.size();
                    JavaType[] javaTypeArray = new JavaType[n];
                    Iterator iterator = this.arguments.iterator();
                    int n2 = 0;
                    while (iterator.hasNext()) {
                        ClType clType = (ClType)iterator.next();
                        javaTypeArray[n2++] = clType.getResolvedType();
                    }
                    javaType = CommonUtilities.createParameterizedType(ClClass.ra$provider(ClClass.this), javaType, javaTypeArray);
                }
            }
            if (this.array > 0) {
                javaType = CommonUtilities.createArrayType(ClClass.ra$provider(ClClass.this), javaType, this.array);
            }
            if (this.bound == 0) {
                return javaType;
            }
            return CommonUtilities.createWildcardType(this.bound, javaType, ClClass.ra$provider(ClClass.this));
        }

        private JavaTypeVariable resolveTypeVariable(String string) {
            JavaIsGeneric javaIsGeneric = this.owningGeneric;
            while (javaIsGeneric != null) {
                JavaTypeVariable javaTypeVariable = javaIsGeneric.getTypeParameter(string);
                if (javaTypeVariable != null) {
                    return javaTypeVariable;
                }
                javaIsGeneric = javaIsGeneric.getOwningClass();
            }
            return null;
        }

        public UnresolvedType getUnresolvedType() {
            return this;
        }

        private String getUnresolvedName(boolean bl) {
            String string = null;
            switch (this.ch) {
                case 84: {
                    string = this.name;
                    break;
                }
                case 42: {
                    string = "java.lang.Object";
                    break;
                }
                default: {
                    if (this.name != null) {
                        if (bl) {
                            int n;
                            int n2 = this.name.lastIndexOf(47);
                            if (n2 <= (n = this.name.lastIndexOf(36))) {
                                string = this.name.substring(n + 1);
                                break;
                            }
                            string = this.name.substring(n2 + 1);
                            break;
                        }
                        string = this.name;
                        string = string.replace('/', '.');
                        string = string.replace('$', '.');
                        break;
                    }
                    PrimitiveType primitiveType = PrimitiveType.PRIMITIVE_alpha[this.ch - 65];
                    string = primitiveType.getName();
                }
            }
            int n = 0;
            while (n < this.array) {
                string = string + "[]";
                ++n;
            }
            return string;
        }

        public String getSimplifiedName() {
            return this.getUnresolvedName(true);
        }

        public String toString() {
            return this.getUnresolvedName(false);
        }

        static JavaType mav$getResolvedType(ClType clType) {
            return clType.getResolvedType();
        }
    }

    protected class ClAnnotation
    extends AbstractAnnotation
    implements JavaAnnotation {
        private final JavaElement owner;
        private final ClassFile.ClassAnnotation thing;
        private final ClType annotationType;
        private AnnotationComponents components;

        void $init$() {
            this.components = null;
        }

        protected ClAnnotation(JavaElement javaElement, ClassFile.ClassAnnotation classAnnotation) {
            this.$init$();
            this.owner = javaElement;
            this.thing = classAnnotation;
            this.annotationType = new ClType(classAnnotation.getAnnotationType());
        }

        public int getElementKind() {
            return 2;
        }

        public JavaElement getOwner() {
            return this.owner;
        }

        public SourceElement getSourceElement() {
            SourceElement sourceElement = this.owner.getSourceElement();
            if (sourceElement == null) {
                return null;
            }
            SourceHasModifiers sourceHasModifiers = (SourceHasModifiers)sourceElement;
            return CommonUtilities.getSourceElement(this, sourceHasModifiers);
        }

        public JavaType getResolvedType() {
            return ClType.mav$getResolvedType(this.annotationType);
        }

        public Map getComponents() {
            if (this.components == null) {
                try {
                    String[] stringArray;
                    int n;
                    AnnotationComponents annotationComponents = AnnotationComponents.createInstance(this.getResolvedType());
                    if (annotationComponents != null && (n = (stringArray = this.thing.getComponentNames()).length) > 0) {
                        ClassFile.ComponentValue[] componentValueArray = this.thing.getComponentValues();
                        int n2 = 0;
                        while (n2 < n) {
                            Object object = ClClass.mav$readComponentValue(ClClass.this, componentValueArray[n2], this);
                            if (object != null) {
                                annotationComponents.assignValue(stringArray[n2], object);
                            }
                            ++n2;
                        }
                    }
                    this.components = annotationComponents;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return this.components;
        }
    }
}

