/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.classfile;

import java.util.ArrayList;
import java.util.Collection;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.classfile.ClClass;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.model.JavaIsGeneric;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;

final class ClParser
implements JavaConstants {
    private final ClClass owningClass;
    private final JavaIsGeneric owningGeneric;
    private final ReadTextBuffer buffer;
    private final JavaLexer lexer;
    private int curToken;
    private String errorMessage;

    void $init$() {
        this.lexer = new JavaLexer(3);
        this.errorMessage = "Unknown error.";
    }

    ClParser(String string, ClClass clClass) {
        this(TextBufferFactory.createReadTextBuffer(string), clClass);
    }

    ClParser(ReadTextBuffer readTextBuffer, ClClass clClass) {
        this.$init$();
        this.owningClass = clClass;
        this.owningGeneric = clClass;
        this.buffer = readTextBuffer;
        this.lexer.setTextBuffer(readTextBuffer);
        this.lexer.setPosition(0);
        this.skipToken();
    }

    ClParser(String string, ClClass clClass, ClClass.ClMethod clMethod) {
        this(TextBufferFactory.createReadTextBuffer(string), clClass, clMethod);
    }

    ClParser(ReadTextBuffer readTextBuffer, ClClass clClass, ClClass.ClMethod clMethod) {
        this.$init$();
        this.owningClass = clClass;
        this.owningGeneric = clMethod;
        this.buffer = readTextBuffer;
        this.lexer.setTextBuffer(readTextBuffer);
        this.lexer.setPosition(0);
        this.skipToken();
    }

    protected final void nextToken(short s) {
        if (this.curToken == s) {
            this.skipToken();
        } else {
            this.error();
        }
    }

    protected final void nextToken(short s, short s2) {
        if (this.curToken == s || this.curToken == s2) {
            this.skipToken();
        } else {
            this.error();
        }
    }

    protected final boolean optionalToken(short s) {
        if (this.curToken != s) {
            return false;
        }
        this.skipToken();
        return true;
    }

    protected final boolean optionalToken(short s, short s2) {
        if (this.curToken != s && this.curToken != s2) {
            return false;
        }
        this.skipToken();
        return true;
    }

    protected final void skipToken() {
        this.curToken = this.lexer.lex();
    }

    protected Collection parseFormalTypeParameters0(JavaIsGeneric javaIsGeneric) {
        if (this.curToken != 58) {
            return null;
        }
        String string = this.errorMessage;
        try {
            this.errorMessage = "Invalid type parameter";
            this.skipToken();
            ArrayList<ClClass.ClTypeParameter> arrayList = new ArrayList<ClClass.ClTypeParameter>();
            while (this.curToken != 46) {
                if (this.curToken != 4) {
                    this.error();
                }
                int n = this.lexer.getStartOffset();
                int n2 = this.lexer.getEndOffset();
                String string2 = this.buffer.getString(n, n2 - n);
                this.skipToken();
                ClClass clClass = this.owningClass;
                clClass.getClass();
                ClClass.ClTypeParameter clTypeParameter = clClass.new ClClass.ClTypeParameter(javaIsGeneric, string2);
                this.nextToken((short)38);
                if (this.curToken != 38) {
                    clTypeParameter.superclassBound = this.parseTypeSignature0();
                }
                if (this.curToken == 38) {
                    ArrayList<ClClass.ClType> arrayList2 = new ArrayList<ClClass.ClType>();
                    this.skipToken();
                    do {
                        ClClass.ClType clType = this.parseTypeSignature0();
                        arrayList2.add(clType);
                    } while (this.optionalToken((short)38));
                    clTypeParameter.interfaceBounds = arrayList2;
                }
                arrayList.add(clTypeParameter);
            }
            this.nextToken((short)46);
            ArrayList<ClClass.ClTypeParameter> arrayList3 = arrayList;
            this.errorMessage = string;
            return arrayList3;
        }
        catch (Throwable throwable) {
            this.errorMessage = string;
            throw throwable;
        }
    }

    private ClClass.ClType parseTypeArgument0(ClClass.ClType clType) {
        int n = 0;
        switch (this.curToken) {
            case 63: {
                this.skipToken();
                ClClass clClass = this.owningClass;
                clClass.getClass();
                return clClass.new ClClass.ClType('*');
            }
            case 67: {
                n = 1;
                this.skipToken();
                break;
            }
            case 59: {
                n = 2;
                this.skipToken();
            }
        }
        ClClass.ClType clType2 = this.parseTypeSignature0();
        clType2.bound = (byte)n;
        return clType2;
    }

    private void parseTypeArguments_opt0(ClClass.ClType clType) {
        if (this.optionalToken((short)58)) {
            clType.arguments = new ArrayList();
            while (this.curToken != 46 && this.curToken != 0) {
                ClClass.ClType clType2 = this.parseTypeArgument0(clType);
                clType.arguments.add(clType2);
            }
            this.nextToken((short)46);
        }
    }

    protected ClClass.ClType parseTypeSignature0() {
        int n = this.lexer.getStartOffset();
        if (n == -1) {
            ClParser.panic("No token");
        }
        char c = this.buffer.getChar(n);
        String string = this.errorMessage;
        try {
            PrimitiveType primitiveType;
            this.lexer.setPosition(n + 1);
            this.skipToken();
            switch (c) {
                case 'L': {
                    int n2;
                    this.errorMessage = "Invalid class reference.";
                    int n3 = n + 1;
                    do {
                        if (this.curToken != 4) {
                            this.error();
                        }
                        n2 = this.lexer.getEndOffset();
                        this.skipToken();
                    } while (this.optionalToken((short)41));
                    String string2 = this.buffer.getString(n3, n2 - n3);
                    ClClass clClass = this.owningClass;
                    clClass.getClass();
                    ClClass.ClType clType = clClass.new ClClass.ClType(c, string2);
                    this.parseTypeArguments_opt0(clType);
                    while (this.optionalToken((short)43)) {
                        this.nextToken((short)4);
                        this.parseTypeArguments_opt0(clType);
                    }
                    this.nextToken((short)75);
                    ClClass.ClType clType2 = clType;
                    this.errorMessage = string;
                    return clType2;
                }
                case 'T': {
                    this.errorMessage = "Invalid type variable reference.";
                    int n4 = n + 1;
                    if (this.curToken != 4) {
                        this.error();
                    }
                    int n5 = this.lexer.getEndOffset();
                    String string3 = this.buffer.getString(n4, n5 - n4);
                    this.skipToken();
                    this.nextToken((short)75);
                    ClClass clClass = this.owningClass;
                    clClass.getClass();
                    ClClass.ClType clType = clClass.new ClClass.ClType(string3, this.owningGeneric);
                    this.errorMessage = string;
                    return clType;
                }
                case '[': {
                    ClClass.ClType clType = this.parseTypeSignature0();
                    clType.array = (short)(clType.array + 1);
                    ClClass.ClType clType3 = clType;
                    this.errorMessage = string;
                    return clType3;
                }
            }
            this.errorMessage = "Invalid class type signature.";
            if (c < 'A' || 'Z' < c) {
                this.error();
            }
            if ((primitiveType = PrimitiveType.PRIMITIVE_alpha[c - 65]) == null) {
                this.error();
            }
            ClClass clClass = this.owningClass;
            clClass.getClass();
            ClClass.ClType clType = clClass.new ClClass.ClType(c);
            this.errorMessage = string;
            return clType;
        }
        catch (Throwable throwable) {
            this.errorMessage = string;
            throw throwable;
        }
    }

    protected void parseClassSignature0(ClClass clClass) {
        if (this.curToken == 58) {
            clClass.typeParameters = this.parseFormalTypeParameters0(clClass);
        }
        if (this.curToken != 0) {
            clClass.superclass = this.parseTypeSignature0();
        }
        if (this.curToken != 0) {
            ArrayList<ClClass.ClType> arrayList = new ArrayList<ClClass.ClType>();
            do {
                ClClass.ClType clType = this.parseTypeSignature0();
                arrayList.add(clType);
            } while (this.curToken != 0);
            clClass.interfaceTypes = arrayList;
        }
    }

    protected void parseMethodTypeSignature0(ClClass.ClMethod clMethod) {
        if (this.curToken == 58) {
            clMethod.typeParameters = this.parseFormalTypeParameters0(clMethod);
        }
        String string = this.errorMessage;
        try {
            this.errorMessage = "Invalid method signature.";
            this.nextToken((short)55);
            if (this.curToken != 72) {
                ArrayList<ClClass.ClMethod.ClVariable> arrayList = new ArrayList<ClClass.ClMethod.ClVariable>();
                int n = 0;
                do {
                    ClClass.ClType clType = this.parseTypeSignature0();
                    ClClass.ClMethod clMethod2 = clMethod;
                    clMethod2.getClass();
                    arrayList.add(clMethod2.new ClClass.ClMethod.ClVariable(clType, n++));
                } while (this.curToken != 72);
                clMethod.formalParameters = arrayList;
            }
            this.nextToken((short)72);
            clMethod.returnType = this.parseTypeSignature0();
            if (this.curToken == 37) {
                this.skipToken();
                ArrayList<ClClass.ClType> arrayList = new ArrayList<ClClass.ClType>();
                do {
                    ClClass.ClType clType = this.parseTypeSignature0();
                    arrayList.add(clType);
                } while (this.optionalToken((short)37));
                clMethod.exceptionTypes = arrayList;
            }
        }
        finally {
            this.errorMessage = string;
        }
    }

    private void error(String string) {
        string = string + ": " + this.buffer.getString(0, this.buffer.getLength());
        CommonUtilities.panic(string);
    }

    private void error() {
        String string = this.buffer.getString(0, this.buffer.getLength());
        CommonUtilities.panic(string);
    }

    private static void panic(String string) {
        CommonUtilities.panic(string);
    }
}

