/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.classfile;

import java.io.PrintStream;
import java.net.URL;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.classfile.ClassConstants;
import oracle.javatools.parser.java.v2.classfile.Name;
import oracle.javatools.parser.java.v2.classfile.NamePool;
import oracle.javatools.parser.java.v2.classfile.NameType;
import oracle.javatools.parser.java.v2.common.CommonUtilities;

public final class ClassFile
implements ClassConstants {
    private static final ClassField[] EMPTY_FIELD_ARRAY = new ClassField[0];
    private static final ClassMethod[] EMPTY_METHOD_ARRAY = new ClassMethod[0];
    private static final ClassAnnotation[] EMPTY_ANNOTATION_ARRAY = new ClassAnnotation[0];
    private static final ComponentValue[] EMPTY_VALUE_ARRAY = new ComponentValue[0];
    private static final int PROCESSED = Integer.MIN_VALUE;
    private static final int DEPRECATED = 65536;
    private static final int HIDDEN_ATTR = 0x20000000;
    private static final Name[] ATTRIBUTE_names;
    private static final byte[] ATTRIBUTE_indices;
    private static final Name kInitS;
    private static final Name kClinitS;
    private static final Name kJavaLangObjectS;
    private byte[] buffer;
    private int bp;
    private int[] poolIdx;
    private Object[] poolObj;
    private int implBp;
    private int fieldBp;
    private int methodBp;
    private int attrBp;
    private URL url;
    private int modifiers;
    private Name thisClassName;
    private Name sourceFilename;
    private Name classSignature;
    private NameType baseClass;
    private NameType[] baseInterfaces;
    private ClassField[] fields;
    private ClassMethod clinit;
    private ClassMethod[] methods;
    private ClassMethod[] constructors;
    private NameType outerClass;
    private NameType[] innerClasses;
    private ClassAnnotation[] classAnnotations;
    public static int ___constant_pool;
    public static final int ___inner_classes = 0;
    private static final int kMember_AttrPos = 6;

    static {
        int n = 18;
        ATTRIBUTE_names = new Name[18];
        int n2 = 0;
        int n3 = 0;
        while (n3 < 18) {
            Name name = NamePool.global.fromString(ClassConstants.ATTRIBUTE_words[n3]);
            if (n2 < name.index) {
                n2 = name.index;
            }
            ClassFile.ATTRIBUTE_names[n3] = name;
            ++n3;
        }
        ATTRIBUTE_indices = new byte[n2 + 1];
        int n4 = 0;
        while (n4 < 18) {
            Name name = ATTRIBUTE_names[n4];
            ClassFile.ATTRIBUTE_indices[name.index] = (byte)(n4 + 1);
            ++n4;
        }
        kInitS = NamePool.global.fromString("<init>");
        kClinitS = NamePool.global.fromString("<clinit>");
        kJavaLangObjectS = NamePool.global.fromString("java/lang/Object");
        ___constant_pool = 0;
    }

    private static final byte name2attribute(Name name) {
        int n = name.index;
        if (0 <= n && n < ATTRIBUTE_indices.length) {
            return ATTRIBUTE_indices[n];
        }
        return 0;
    }

    void $init$() {
        this.implBp = 0;
        this.fieldBp = 0;
        this.methodBp = 0;
        this.attrBp = 0;
        this.sourceFilename = null;
        this.classSignature = null;
        this.baseClass = null;
        this.baseInterfaces = null;
        this.fields = null;
        this.clinit = null;
        this.methods = null;
        this.constructors = null;
        this.outerClass = null;
        this.innerClasses = null;
        this.classAnnotations = null;
    }

    public ClassFile(byte[] byArray, URL uRL) {
        this(byArray);
        this.url = uRL;
    }

    public ClassFile(byte[] byArray) {
        this.$init$();
        this.buffer = byArray;
        this.readHeader();
        this.indexFields();
        this.indexMethods();
        this.readClassAttributes();
    }

    public boolean isInterface() {
        return (this.modifiers & 0x200) != 0;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getSignature() {
        if (this.classSignature != null) {
            return this.classSignature.toString();
        }
        return null;
    }

    public boolean isDeprecated() {
        this.readClassAttributes();
        return (this.modifiers & 0x10000) != 0;
    }

    public boolean isHidden() {
        this.readClassAttributes();
        return (this.modifiers & 0x20000000) != 0;
    }

    public String getFullClassName() {
        return this.thisClassName.toString();
    }

    public NameType getBaseClass() {
        return this.baseClass;
    }

    public NameType[] getBaseInterfaces() {
        if (this.baseInterfaces == null) {
            this.readBaseInterfaces();
        }
        return this.baseInterfaces;
    }

    public NameType getOuterClass() {
        if (this.outerClass == null) {
            this.readClassAttributes();
        }
        return this.outerClass;
    }

    public ClassField[] getDeclaredFields() {
        if (this.fields == null) {
            this.readFields();
        }
        return this.fields;
    }

    public ClassMethod[] getDeclaredMethods() {
        if (this.methods == null) {
            this.readMethods();
        }
        return this.methods;
    }

    public ClassMethod[] getDeclaredConstructors() {
        if (this.constructors == null) {
            this.readMethods();
        }
        return this.constructors;
    }

    public ClassMethod getClinitMethod() {
        if (this.methods == null) {
            this.readMethods();
        }
        return this.clinit;
    }

    public NameType[] getDeclaredInnerClasses() {
        if (this.innerClasses == null) {
            this.readClassAttributes();
        }
        return this.innerClasses;
    }

    public ClassAnnotation[] getDeclaredAnnotations() {
        if (this.classAnnotations == null) {
            this.readClassAttributes();
        }
        return this.classAnnotations;
    }

    public String getSourceFilename() {
        if (this.sourceFilename == null) {
            return null;
        }
        return this.sourceFilename.toString();
    }

    public URL getURL() {
        return this.url;
    }

    private void readHeader() {
        int n = this.nextInt();
        if (n != -889275714) {
            this.fileError("Bad magic number");
        }
        char c = this.nextChar();
        char c2 = this.nextChar();
        if (c2 * 100 + c < 4503) {
            this.fileError("Wrong version");
        }
        this.indexConstantPool();
        this.modifiers = this.nextChar();
        this.thisClassName = (Name)this.readPoolObject(this.nextChar());
        this.baseClass = this.readPoolClass(this.nextChar());
        this.implBp = this.bp;
        char c3 = this.nextChar();
        this.bp += 2 * c3;
        this.fieldBp = this.bp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexFields() {
        ClassFile classFile = this;
        synchronized (classFile) {
            int n = this.nextChar();
            Object[] objectArray = new Object[n];
            int n2 = 0;
            while (n2 < n) {
                this.skipFieldOrMethod();
                ++n2;
            }
            this.methodBp = this.bp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexMethods() {
        ClassFile classFile = this;
        synchronized (classFile) {
            if (this.methodBp == 0) {
                this.indexFields();
            }
            this.bp = this.methodBp;
            int n = this.nextChar();
            int n2 = 0;
            while (n2 < n) {
                this.skipFieldOrMethod();
                ++n2;
            }
            this.attrBp = this.bp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBaseInterfaces() {
        ClassFile classFile = this;
        synchronized (classFile) {
            int n = this.bp;
            this.bp = this.implBp;
            int n2 = this.nextChar();
            this.baseInterfaces = new NameType[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.baseInterfaces[n3] = this.readPoolClass(this.nextChar());
                ++n3;
            }
            this.bp = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFields() {
        ClassFile classFile = this;
        synchronized (classFile) {
            int n = this.bp;
            this.bp = this.fieldBp;
            int n2 = this.nextChar();
            this.fields = ClassFile.createFieldArray(n2);
            int n3 = 0;
            while (n3 < n2) {
                this.fields[n3] = new ClassField(null);
                ++n3;
            }
            if (this.methodBp == 0) {
                this.methodBp = this.bp;
            } else {
                this.bp = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMethods() {
        ClassFile classFile = this;
        synchronized (classFile) {
            int n = this.bp;
            if (this.methodBp == 0) {
                this.indexFields();
            }
            this.bp = this.methodBp;
            int n2 = this.nextChar();
            if (n2 == 0) {
                this.methods = EMPTY_METHOD_ARRAY;
                this.constructors = EMPTY_METHOD_ARRAY;
                this.clinit = null;
            } else {
                ClassMethod[] classMethodArray = new ClassMethod[n2];
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                while (n5 < n2) {
                    ClassMethod classMethod;
                    classMethodArray[n5] = classMethod = new ClassMethod(null);
                    if (classMethod.isConstructor()) {
                        ++n3;
                    } else if (classMethod.isClinit()) {
                        ++n4;
                    }
                    ++n5;
                }
                this.methods = ClassFile.createMethodArray(n2 - n3 - n4);
                this.constructors = ClassFile.createMethodArray(n3);
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                while (n8 < n2) {
                    ClassMethod classMethod = classMethodArray[n8];
                    if (classMethod.isConstructor()) {
                        this.constructors[n7++] = classMethod;
                    } else if (classMethod.isClinit()) {
                        if (this.clinit != null) {
                            // empty if block
                        }
                        this.clinit = classMethod;
                    } else {
                        this.methods[n6++] = classMethod;
                    }
                    ++n8;
                }
            }
            if (this.attrBp == 0) {
                this.attrBp = this.bp;
            } else {
                this.bp = n;
            }
        }
    }

    private void readInnerClasses() {
        int n = this.nextChar();
        NameType[] nameTypeArray = new NameType[n];
        int n2 = 0;
        while (n-- > 0) {
            NameType nameType = this.readPoolClass(this.nextChar());
            NameType nameType2 = this.readPoolClass(this.nextChar());
            this.bp += 2;
            char c = this.nextChar();
            if (nameType2 != null && nameType2.name.index == this.thisClassName.index) {
                nameTypeArray[n2++] = nameType;
                continue;
            }
            if (nameType == null || nameType.name.index != this.thisClassName.index) continue;
            int n3 = this.modifiers & 0xFFFFFFFE;
            this.outerClass = nameType2;
            this.modifiers = n3 | c & 0xF;
        }
        if (n2 == 0) {
            this.innerClasses = NameType.EMPTY_ARRAY;
        } else {
            this.innerClasses = new NameType[n2];
            System.arraycopy(nameTypeArray, 0, this.innerClasses, 0, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readClassAttributes() {
        if ((this.modifiers & Integer.MIN_VALUE) != 0) {
            return;
        }
        int n = this.bp;
        ClassFile classFile = this;
        synchronized (classFile) {
            if (this.attrBp == 0) {
                this.indexMethods();
            }
            try {
                this.bp = this.attrBp;
                int n2 = this.nextChar();
                int n3 = 0;
                while (n3 < n2) {
                    char c = this.nextChar();
                    int n4 = this.nextInt();
                    int n5 = this.bp;
                    Name name = this.readPoolName(c);
                    byte by = ClassFile.name2attribute(name);
                    switch (by) {
                        case 4: {
                            this.modifiers |= 0x10000;
                            break;
                        }
                        case 18: {
                            this.modifiers |= 0x20000000;
                            break;
                        }
                        case 15: {
                            this.classSignature = this.readPoolExternal(this.nextChar());
                            break;
                        }
                        case 17: {
                            this.modifiers |= 0x1000;
                            break;
                        }
                        case 11: 
                        case 13: {
                            this.classAnnotations = this.readAnnotations(this.classAnnotations);
                            int n6 = n5 + n4;
                            if (this.bp != n6) {
                                this.fileError("Invalid annotations length");
                            }
                            this.bp = n6;
                            break;
                        }
                        case 16: {
                            this.sourceFilename = this.readPoolName(this.nextChar());
                            break;
                        }
                        case 7: {
                            this.readInnerClasses();
                            break;
                        }
                        default: {
                            this.bp += n4;
                        }
                    }
                    ++n3;
                }
                if (this.innerClasses == null) {
                    this.innerClasses = NameType.EMPTY_ARRAY;
                }
                if (this.classAnnotations == null) {
                    this.classAnnotations = EMPTY_ANNOTATION_ARRAY;
                }
                this.modifiers |= Integer.MIN_VALUE;
            }
            finally {
                this.bp = n;
            }
        }
    }

    private void indexConstantPool() {
        int n = this.nextChar();
        this.poolIdx = new int[n];
        this.poolObj = new Object[n];
        int n2 = 1;
        while (n2 < n) {
            this.poolIdx[n2++] = this.bp;
            byte by = this.buffer[this.bp++];
            switch (by) {
                case 1: 
                case 2: {
                    char c = this.nextChar();
                    this.bp += c;
                    break;
                }
                case 7: 
                case 8: {
                    this.bp += 2;
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.bp += 4;
                    break;
                }
                case 5: 
                case 6: {
                    this.bp += 8;
                    ++n2;
                    break;
                }
                default: {
                    this.fileError("Bad constant pool tag: " + by);
                }
            }
        }
    }

    private Object readPoolObject(int n) {
        Object object;
        if (n < 0 || this.poolObj.length <= n) {
            this.fileError("Invalid pool index");
        }
        if (this.poolObj[n] != null) {
            return this.poolObj[n];
        }
        int n2 = this.poolIdx[n];
        if (n2 == 0) {
            return null;
        }
        this.poolObj[n] = object = this.readPoolObjectImpl(n2);
        return object;
    }

    private Object readPoolObjectImpl(int n) {
        byte by = this.buffer[n];
        switch (by) {
            case 1: {
                return NamePool.global.fromUTF(this.buffer, n + 3, this.getChar(n + 1));
            }
            case 7: {
                return this.readPoolExternal(this.getChar(n + 1));
            }
            case 2: {
                this.fileError("Can't read unicode");
                break;
            }
            case 8: {
                Name name = (Name)this.readPoolObject(this.getChar(n + 1));
                return name.toString();
            }
            case 3: {
                int n2 = this.getInt(n + 1);
                return new Integer(n2);
            }
            case 4: {
                float f = Float.intBitsToFloat(this.getInt(n + 1));
                return new Float(f);
            }
            case 5: {
                long l = this.getLong(n + 1);
                return new Long(l);
            }
            case 6: {
                double d = Double.longBitsToDouble(this.getLong(n + 1));
                return new Double(d);
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.fileError("Shouldn't be handling these attributes: " + by);
                break;
            }
            default: {
                this.fileError("Bad constant pool tag: " + by);
            }
        }
        return null;
    }

    private Object readPoolConstant(int n, char c) {
        switch (c) {
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 's': {
                return this.readPoolObject(n);
            }
            case 'c': {
                Name name = this.readPoolName(n);
                return NameType.getTypeFor(name);
            }
            case '@': 
            case '[': 
            case 'e': {
                CommonUtilities.panic("May not read a '" + c + "' directly from the pool.");
                return null;
            }
        }
        Integer n2 = (Integer)this.readPoolObject(n);
        switch (c) {
            case 'S': {
                return new Short((short)n2.intValue());
            }
            case 'C': {
                return new Character((char)n2.intValue());
            }
            case 'B': {
                return new Byte((byte)n2.intValue());
            }
            case 'Z': {
                if (n2 == 0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        }
        this.fileError("Invalid type for a ConstantValue attribute");
        return null;
    }

    private Name readPoolName(int n) {
        return (Name)this.readPoolObject(n);
    }

    private Name readPoolExternal(int n) {
        if (this.poolObj[n] == null) {
            int n2 = this.poolIdx[n];
            if (this.buffer[n2] == 1) {
                this.poolObj[n] = NamePool.global.fromUTF(this.buffer, n2 + 3, this.getChar(n2 + 1));
            } else {
                ClassFile.internalError("readExternal");
            }
        }
        return (Name)this.poolObj[n];
    }

    private NameType readPoolClass(int n) {
        Name name;
        if (n == 0) {
            return null;
        }
        int n2 = this.poolIdx[n];
        if (this.buffer[n2] != 7) {
            this.fileError("readClassAtIndex");
        }
        if ((name = (Name)this.readPoolObject(n)) != null) {
            return NameType.getTypeFor(name);
        }
        return null;
    }

    private byte nextByte() {
        return this.buffer[this.bp++];
    }

    private char nextChar() {
        int n = this.bp;
        char c = (char)((this.buffer[n] & 0xFF) << 8 | this.buffer[n + 1] & 0xFF);
        this.bp += 2;
        return c;
    }

    private int nextInt() {
        int n = this.bp;
        int n2 = (this.buffer[n] & 0xFF) << 24 | (this.buffer[n + 1] & 0xFF) << 16 | (this.buffer[n + 2] & 0xFF) << 8 | this.buffer[n + 3] & 0xFF;
        this.bp += 4;
        return n2;
    }

    private char getChar(int n) {
        return (char)((this.buffer[n] & 0xFF) << 8 | this.buffer[n + 1] & 0xFF);
    }

    private int getInt(int n) {
        return (this.buffer[n] & 0xFF) << 24 | (this.buffer[n + 1] & 0xFF) << 16 | (this.buffer[n + 2] & 0xFF) << 8 | this.buffer[n + 3] & 0xFF;
    }

    private long getLong(int n) {
        long l = this.getInt(n);
        long l2 = this.getInt(n + 4);
        return l << 32 | l2;
    }

    public final void dump(PrintStream printStream) {
        int n = this.getModifiers();
        ClassFile.dumpModifiers(printStream, n, true, false);
        if ((n & 0x2000) != 0) {
            printStream.print("@interface ");
        } else if ((n & 0x200) != 0) {
            printStream.print("interface ");
        } else if ((n & 0x4000) != 0) {
            printStream.print("enum ");
        } else {
            printStream.print("class ");
        }
        printStream.println(this.getFullClassName());
        printStream.println("  extends " + this.getBaseClass().toString());
        NameType[] nameTypeArray = this.getBaseInterfaces();
        int n2 = 0;
        while (n2 < nameTypeArray.length) {
            printStream.println("  implements " + nameTypeArray[n2].toString());
            ++n2;
        }
        String string = this.getSignature();
        if (string != null) {
            printStream.println("  signature: " + string);
        }
        printStream.println("SourceFile: " + this.getSourceFilename().toString());
        ClassFile.dumpAnnotations(printStream, this.getDeclaredAnnotations());
        printStream.println();
        this.dumpConstantPool(printStream);
        printStream.println("Fields:");
        ClassField[] classFieldArray = this.getDeclaredFields();
        int n3 = 0;
        while (n3 < classFieldArray.length) {
            classFieldArray[n3].dump(printStream);
            ++n3;
        }
        printStream.println();
        printStream.println("Constructors:");
        ClassMethod[] classMethodArray = this.getDeclaredConstructors();
        int n4 = 0;
        while (n4 < classMethodArray.length) {
            classMethodArray[n4].dump(printStream);
            ++n4;
        }
        printStream.println();
        printStream.println("Methods:");
        ClassMethod[] classMethodArray2 = this.getDeclaredMethods();
        int n5 = 0;
        while (n5 < classMethodArray2.length) {
            classMethodArray2[n5].dump(printStream);
            ++n5;
        }
        printStream.println();
    }

    private void dumpConstantPool(PrintStream printStream) {
        printStream.println("Constant pool:");
        int n = 1;
        while (n < this.poolIdx.length) {
            printStream.print(n + "\t");
            this.dumpPoolObject(printStream, n);
            printStream.println();
            int n2 = this.poolIdx[n];
            byte by = this.buffer[n2];
            if (by == 5 || by == 6) {
                ++n;
            }
            ++n;
        }
        printStream.println();
    }

    private void dumpPoolObject(PrintStream printStream, int n) {
        int n2 = this.poolIdx[n];
        byte by = this.buffer[n2];
        switch (by) {
            case 1: {
                printStream.print("(Utf8) ");
                break;
            }
            case 7: {
                char c = this.getChar(n2 + 1);
                printStream.print("(Class) #" + c + ": ");
                break;
            }
            case 2: {
                printStream.print("(Unicode) ??");
                return;
            }
            case 8: {
                char c = this.getChar(n2 + 1);
                printStream.print("(String) #" + c + ": ");
                break;
            }
            case 3: {
                printStream.print("(Integer) ");
                break;
            }
            case 4: {
                printStream.print("(Float) ");
                break;
            }
            case 5: {
                printStream.print("(Long) ");
                break;
            }
            case 6: {
                printStream.print("(Double) ");
                break;
            }
            case 12: {
                char c = this.getChar(n2 + 1);
                char c2 = this.getChar(n2 + 3);
                printStream.print("(NameandTypeRef) ");
                printStream.print("#" + c + " #" + c2 + ": ");
                break;
            }
            case 9: {
                printStream.print("(Fieldref) ");
                char c = this.getChar(n2 + 1);
                char c3 = this.getChar(n2 + 3);
                printStream.print("#" + c + " #" + c3 + ": ");
                break;
            }
            case 10: {
                printStream.print("(Methodref) ");
                char c = this.getChar(n2 + 1);
                char c4 = this.getChar(n2 + 3);
                printStream.print("#" + c + " #" + c4 + ": ");
                break;
            }
            case 11: {
                printStream.print("(InterfaceMethodref) ");
                char c = this.getChar(n2 + 1);
                char c5 = this.getChar(n2 + 3);
                printStream.print("#" + c + " #" + c5 + ": ");
                break;
            }
            default: {
                this.fileError("Bad constant pool tag: " + by);
            }
        }
        this.dumpPoolObjectImpl(printStream, n);
    }

    private void dumpPoolObjectImpl(PrintStream printStream, int n) {
        int n2 = this.poolIdx[n];
        byte by = this.buffer[n2];
        switch (by) {
            case 7: {
                char c = this.getChar(n2 + 1);
                this.dumpPoolObjectImpl(printStream, c);
                return;
            }
            case 8: {
                char c = this.getChar(n2 + 1);
                this.dumpPoolObjectImpl(printStream, c);
                return;
            }
            case 12: {
                char c = this.getChar(n2 + 1);
                char c2 = this.getChar(n2 + 3);
                this.dumpPoolObjectImpl(printStream, c);
                printStream.print(", ");
                this.dumpPoolObjectImpl(printStream, c2);
                return;
            }
            case 9: 
            case 10: 
            case 11: {
                char c = this.getChar(n2 + 1);
                char c3 = this.getChar(n2 + 3);
                this.dumpPoolObjectImpl(printStream, c);
                printStream.print(".");
                this.dumpPoolObjectImpl(printStream, c3);
                return;
            }
        }
        Object object = this.readPoolObject(n);
        if (object != null) {
            printStream.print(object);
        }
    }

    private static void dumpModifiers(PrintStream printStream, int n, boolean bl, boolean bl2) {
        if ((n & 1) != 0) {
            printStream.print("public ");
        }
        if ((n & 2) != 0) {
            printStream.print("private ");
        }
        if ((n & 4) != 0) {
            printStream.print("protected ");
        }
        if ((n & 8) != 0) {
            printStream.print("static ");
        }
        if ((n & 0x10) != 0) {
            printStream.print("final ");
        }
        if (!bl && (n & 0x20) != 0) {
            printStream.print("synchronized ");
        }
        if (bl2) {
            if ((n & 0x40) != 0) {
                printStream.print("volatile ");
            }
            if ((n & 0x80) != 0) {
                printStream.print("transient ");
            }
        }
        if ((n & 0x100) != 0) {
            printStream.print("native ");
        }
        if ((n & 0x400) != 0) {
            printStream.print("abstract ");
        }
        if ((n & 0x800) != 0) {
            printStream.print("strictfp ");
        }
        if ((n & 0x1000) != 0) {
            printStream.print("(synthetic) ");
        }
        if ((n & 0x2000) != 0) {
            printStream.print("(annotation) ");
        }
        if ((n & 0x4000) != 0) {
            printStream.print("(enum) ");
        }
        if ((n & 0x10000) != 0) {
            printStream.print("@deprecated ");
        }
        if ((n & 0x20000000) != 0) {
            printStream.print("@hidden ");
        }
    }

    private static void dumpAnnotations(PrintStream printStream, ClassAnnotation[] classAnnotationArray) {
        if (classAnnotationArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < classAnnotationArray.length) {
            classAnnotationArray[n].dump(printStream);
            ++n;
        }
    }

    private static ClassField[] createFieldArray(int n) {
        if (n == 0) {
            return EMPTY_FIELD_ARRAY;
        }
        return new ClassField[n];
    }

    private static ClassMethod[] createMethodArray(int n) {
        if (n == 0) {
            return EMPTY_METHOD_ARRAY;
        }
        return new ClassMethod[n];
    }

    private void skipFieldOrMethod() {
        this.bp += 6;
        int n = this.nextChar();
        int n2 = 0;
        while (n2 < n) {
            this.bp += 2;
            int n3 = this.nextInt();
            this.bp += n3;
            ++n2;
        }
    }

    private void skipAnnotation() {
        this.bp += 2;
        int n = this.nextChar();
        int n2 = 0;
        while (n2 < n) {
            this.skipComponent();
            ++n2;
        }
    }

    private void skipComponent() {
        this.bp += 2;
        this.skipComponentValue();
    }

    private void skipComponentValue() {
        byte by = this.nextByte();
        this.skipValue(by);
    }

    private void skipValue(byte by) {
        switch (by) {
            case 64: {
                this.skipAnnotation();
                break;
            }
            case 91: {
                int n = this.nextChar();
                int n2 = 0;
                while (n2 < n) {
                    this.skipComponentValue();
                    ++n2;
                }
                break;
            }
            case 101: {
                this.bp += 4;
                break;
            }
            default: {
                this.bp += 2;
            }
        }
    }

    private ClassAnnotation[] readAnnotations(ClassAnnotation[] classAnnotationArray) {
        if (classAnnotationArray == null) {
            classAnnotationArray = EMPTY_ANNOTATION_ARRAY;
        }
        int n = classAnnotationArray.length;
        int n2 = n + this.nextChar();
        ClassAnnotation[] classAnnotationArray2 = new ClassAnnotation[n2];
        if (n > 0) {
            System.arraycopy(classAnnotationArray, 0, classAnnotationArray2, 0, n);
        }
        int n3 = n;
        while (n3 < n2) {
            classAnnotationArray2[n3] = new ClassAnnotation(null);
            ++n3;
        }
        return classAnnotationArray2;
    }

    private void fileError(String string) {
        throw new RuntimeException(string);
    }

    static void internalError(String string) {
        CommonUtilities.panic(string);
    }

    static void maS$dumpAnnotations(PrintStream printStream, ClassAnnotation[] classAnnotationArray) {
        ClassFile.dumpAnnotations(printStream, classAnnotationArray);
    }

    static void maS$dumpModifiers(PrintStream printStream, int n, boolean bl, boolean bl2) {
        ClassFile.dumpModifiers(printStream, n, bl, bl2);
    }

    static void mav$dumpPoolObject(ClassFile classFile, PrintStream printStream, int n) {
        classFile.dumpPoolObject(printStream, n);
    }

    static int ra$bp(ClassFile classFile) {
        return classFile.bp;
    }

    static void wa$bp(ClassFile classFile, int n) {
        classFile.bp = n;
    }

    static char mav$nextChar(ClassFile classFile) {
        return classFile.nextChar();
    }

    static Name mav$readPoolName(ClassFile classFile, int n) {
        return classFile.readPoolName(n);
    }

    static int mav$nextInt(ClassFile classFile) {
        return classFile.nextInt();
    }

    static byte maS$name2attribute(Name name) {
        return ClassFile.name2attribute(name);
    }

    static Name mav$readPoolExternal(ClassFile classFile, int n) {
        return classFile.readPoolExternal(n);
    }

    static ClassAnnotation[] mav$readAnnotations(ClassFile classFile, ClassAnnotation[] classAnnotationArray) {
        return classFile.readAnnotations(classAnnotationArray);
    }

    static void mav$fileError(ClassFile classFile, String string) {
        classFile.fileError(string);
    }

    static ClassAnnotation[] ra$EMPTY_ANNOTATION_ARRAY() {
        return EMPTY_ANNOTATION_ARRAY;
    }

    static Object mav$readPoolConstant(ClassFile classFile, int n, char c) {
        return classFile.readPoolConstant(n, c);
    }

    static void mav$skipFieldOrMethod(ClassFile classFile) {
        classFile.skipFieldOrMethod();
    }

    static NameType mav$readPoolClass(ClassFile classFile, int n) {
        return classFile.readPoolClass(n);
    }

    static Name ra$kInitS() {
        return kInitS;
    }

    static Name ra$kClinitS() {
        return kClinitS;
    }

    static ComponentValue[] ra$EMPTY_VALUE_ARRAY() {
        return EMPTY_VALUE_ARRAY;
    }

    static void mav$skipComponent(ClassFile classFile) {
        classFile.skipComponent();
    }

    static char mav$getChar(ClassFile classFile, int n) {
        return classFile.getChar(n);
    }

    static byte mav$nextByte(ClassFile classFile) {
        return classFile.nextByte();
    }

    static void mav$skipValue(ClassFile classFile, byte by) {
        classFile.skipValue(by);
    }

    public final class ClassField {
        private int thisBp;
        private int modifiers;
        private String name;
        private String fieldDescriptor;
        private String fieldSignature;
        private int constantValueIndex;
        private ClassAnnotation[] fieldAnnotations;

        void $init$() {
            this.constantValueIndex = 0;
            this.fieldAnnotations = null;
        }

        private ClassField() {
            this.$init$();
            this.thisBp = ClassFile.ra$bp(ClassFile.this);
            this.modifiers = ClassFile.mav$nextChar(ClassFile.this);
            this.name = ClassFile.mav$readPoolName(ClassFile.this, ClassFile.mav$nextChar(ClassFile.this)).toString();
            this.fieldDescriptor = ClassFile.mav$readPoolExternal(ClassFile.this, ClassFile.mav$nextChar(ClassFile.this)).toString();
            ClassFile.wa$bp(ClassFile.this, this.thisBp);
            ClassFile.mav$skipFieldOrMethod(ClassFile.this);
        }

        public final int getModifiers() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readFieldAttributes();
            }
            return this.modifiers;
        }

        public final String getFieldName() {
            return this.name;
        }

        public final String getDescriptor() {
            return this.fieldDescriptor;
        }

        public final String getSignature() {
            return this.fieldSignature;
        }

        public final boolean isDeprecated() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readFieldAttributes();
            }
            return (this.modifiers & 0x10000) != 0;
        }

        public final boolean isHidden() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readFieldAttributes();
            }
            return (this.modifiers & 0x20000000) != 0;
        }

        public final Object getConstantValue() {
            int n;
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readFieldAttributes();
            }
            if ((n = this.fieldDescriptor.charAt(0)) == 76 && this.fieldDescriptor.equals("Ljava/lang/String;")) {
                n = 115;
            }
            return ClassFile.mav$readPoolConstant(ClassFile.this, this.constantValueIndex, (char)n);
        }

        public ClassAnnotation[] getDeclaredAnnotations() {
            if (this.fieldAnnotations == null) {
                this.readFieldAttributes();
            }
            return this.fieldAnnotations;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readFieldAttributes() {
            ClassFile classFile = ClassFile.this;
            synchronized (classFile) {
                int n = ClassFile.ra$bp(ClassFile.this);
                ClassFile.wa$bp(ClassFile.this, this.thisBp + 6);
                int n2 = ClassFile.mav$nextChar(ClassFile.this);
                int n3 = 0;
                while (n3 < n2) {
                    Name name = ClassFile.mav$readPoolName(ClassFile.this, ClassFile.mav$nextChar(ClassFile.this));
                    int n4 = ClassFile.mav$nextInt(ClassFile.this);
                    int n5 = ClassFile.ra$bp(ClassFile.this);
                    byte by = ClassFile.maS$name2attribute(name);
                    switch (by) {
                        case 4: {
                            this.modifiers |= 0x10000;
                            break;
                        }
                        case 18: {
                            this.modifiers |= 0x20000000;
                            break;
                        }
                        case 15: {
                            this.fieldSignature = ClassFile.mav$readPoolExternal(ClassFile.this, ClassFile.mav$nextChar(ClassFile.this)).toString();
                            break;
                        }
                        case 17: {
                            this.modifiers |= 0x1000;
                            break;
                        }
                        case 11: 
                        case 13: {
                            this.fieldAnnotations = ClassFile.mav$readAnnotations(ClassFile.this, this.fieldAnnotations);
                            int n6 = n5 + n4;
                            if (ClassFile.ra$bp(ClassFile.this) != n6) {
                                ClassFile.mav$fileError(ClassFile.this, "Invalid annotations length");
                            }
                            ClassFile.wa$bp(ClassFile.this, n6);
                            break;
                        }
                        case 3: {
                            this.constantValueIndex = ClassFile.mav$nextChar(ClassFile.this);
                            break;
                        }
                        default: {
                            ClassFile classFile2 = ClassFile.this;
                            ClassFile.wa$bp(classFile2, ClassFile.ra$bp(classFile2) + n4);
                        }
                    }
                    ++n3;
                }
                if (this.fieldAnnotations == null) {
                    this.fieldAnnotations = ClassFile.ra$EMPTY_ANNOTATION_ARRAY();
                }
                if (ClassFile.this.isDeprecated()) {
                    this.modifiers |= 0x10000;
                }
                if (ClassFile.this.isHidden()) {
                    this.modifiers |= 0x20000000;
                }
                this.modifiers |= Integer.MIN_VALUE;
                ClassFile.wa$bp(ClassFile.this, n);
            }
        }

        public final void dump(PrintStream printStream) {
            ClassFile.maS$dumpAnnotations(printStream, this.getDeclaredAnnotations());
            ClassFile.maS$dumpModifiers(printStream, this.getModifiers(), false, true);
            printStream.println(this.getFieldName() + ' ' + this.getDescriptor());
            String string = this.getSignature();
            if (string != null) {
                printStream.println("  signature: " + string);
            }
            if (this.constantValueIndex > 0) {
                printStream.print("  constant value: " + this.constantValueIndex + ", ");
                ClassFile.mav$dumpPoolObject(ClassFile.this, printStream, this.constantValueIndex);
                printStream.println();
            }
            printStream.println();
        }

        ClassField(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    public final class ClassMethod {
        private int thisBp;
        private int modifiers;
        private Name name;
        private String methodDescriptor;
        private String methodSignature;
        private NameType[] exceptions;
        private ClassAnnotation[] methodAnnotations;
        private ComponentValue defaultValue;

        void $init$() {
            this.exceptions = null;
            this.methodAnnotations = null;
            this.defaultValue = null;
        }

        private ClassMethod() {
            this.$init$();
            this.thisBp = ClassFile.ra$bp(ClassFile.this);
            this.modifiers = ClassFile.mav$nextChar(ClassFile.this);
            this.name = ClassFile.mav$readPoolName(ClassFile.this, ClassFile.mav$nextChar(ClassFile.this));
            this.methodDescriptor = ClassFile.mav$readPoolExternal(ClassFile.this, ClassFile.mav$nextChar(ClassFile.this)).toString();
            ClassFile.wa$bp(ClassFile.this, this.thisBp);
            ClassFile.mav$skipFieldOrMethod(ClassFile.this);
        }

        public final int getModifiers() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readMethodAttributes();
            }
            return this.modifiers;
        }

        public final String getDescriptor() {
            return this.methodDescriptor;
        }

        public final String getSignature() {
            return this.methodSignature;
        }

        public final boolean isClinit() {
            return this.name.index == ClassFile.ra$kClinitS().index;
        }

        public final boolean isConstructor() {
            return this.name.index == ClassFile.ra$kInitS().index;
        }

        public final String getMethodName() {
            return this.name.toString();
        }

        public final boolean isDeprecated() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readMethodAttributes();
            }
            return (this.modifiers & 0x10000) != 0;
        }

        public final boolean isHidden() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readMethodAttributes();
            }
            return (this.modifiers & 0x20000000) != 0;
        }

        public final NameType[] getThrownExceptionTypes() {
            if (this.exceptions == null) {
                this.readMethodAttributes();
            }
            return this.exceptions;
        }

        public ClassAnnotation[] getDeclaredAnnotations() {
            if (this.methodAnnotations == null) {
                this.readMethodAttributes();
            }
            return this.methodAnnotations;
        }

        public ComponentValue getDefaultValue() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readMethodAttributes();
            }
            return this.defaultValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readMethodAttributes() {
            ClassFile classFile = ClassFile.this;
            synchronized (classFile) {
                int n = ClassFile.ra$bp(ClassFile.this);
                try {
                    ClassFile.wa$bp(ClassFile.this, this.thisBp + 6);
                    int n2 = ClassFile.mav$nextChar(ClassFile.this);
                    int n3 = 0;
                    while (n3 < n2) {
                        Name name = ClassFile.mav$readPoolName(ClassFile.this, ClassFile.mav$nextChar(ClassFile.this));
                        int n4 = ClassFile.mav$nextInt(ClassFile.this);
                        int n5 = ClassFile.ra$bp(ClassFile.this);
                        byte by = ClassFile.maS$name2attribute(name);
                        switch (by) {
                            case 4: {
                                this.modifiers |= 0x10000;
                                break;
                            }
                            case 18: {
                                this.modifiers |= 0x20000000;
                                break;
                            }
                            case 15: {
                                this.methodSignature = ClassFile.mav$readPoolExternal(ClassFile.this, ClassFile.mav$nextChar(ClassFile.this)).toString();
                                break;
                            }
                            case 17: {
                                this.modifiers |= 0x1000;
                                break;
                            }
                            case 1: {
                                this.defaultValue = new ComponentValue(null);
                                break;
                            }
                            case 6: {
                                int n6 = ClassFile.mav$nextChar(ClassFile.this);
                                this.exceptions = new NameType[n6];
                                int n7 = 0;
                                while (n7 < n6) {
                                    this.exceptions[n7] = ClassFile.mav$readPoolClass(ClassFile.this, ClassFile.mav$nextChar(ClassFile.this));
                                    ++n7;
                                }
                                break;
                            }
                            case 11: 
                            case 13: {
                                this.methodAnnotations = ClassFile.mav$readAnnotations(ClassFile.this, this.methodAnnotations);
                                int n8 = n5 + n4;
                                if (ClassFile.ra$bp(ClassFile.this) != n8) {
                                    ClassFile.mav$fileError(ClassFile.this, "Invalid annotations length");
                                }
                                ClassFile.wa$bp(ClassFile.this, n8);
                                break;
                            }
                            default: {
                                ClassFile classFile2 = ClassFile.this;
                                ClassFile.wa$bp(classFile2, ClassFile.ra$bp(classFile2) + n4);
                            }
                        }
                        ++n3;
                    }
                    if (this.exceptions == null) {
                        this.exceptions = NameType.EMPTY_ARRAY;
                    }
                    if (this.methodAnnotations == null) {
                        this.methodAnnotations = ClassFile.ra$EMPTY_ANNOTATION_ARRAY();
                    }
                    if (ClassFile.this.isDeprecated()) {
                        this.modifiers |= 0x10000;
                    }
                    if (ClassFile.this.isHidden()) {
                        this.modifiers |= 0x20000000;
                    }
                    this.modifiers |= Integer.MIN_VALUE;
                }
                finally {
                    ClassFile.wa$bp(ClassFile.this, n);
                }
            }
        }

        public final void dump(PrintStream printStream) {
            ClassFile.maS$dumpAnnotations(printStream, this.getDeclaredAnnotations());
            ClassFile.maS$dumpModifiers(printStream, this.getModifiers(), false, true);
            printStream.println(this.getMethodName() + ' ' + this.getDescriptor());
            String string = this.getSignature();
            if (string != null) {
                printStream.println("  signature: " + string);
            }
            NameType[] nameTypeArray = this.getThrownExceptionTypes();
            int n = 0;
            while (n < nameTypeArray.length) {
                printStream.println("  throws " + nameTypeArray[n].toString());
                ++n;
            }
            ClassFile.maS$dumpAnnotations(printStream, this.getDeclaredAnnotations());
            printStream.println();
        }

        ClassMethod(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    public final class ClassAnnotation {
        private final NameType annotationType;
        private final int compBp;
        private String[] componentNames;
        private ComponentValue[] componentValues;

        void $init$() {
            this.componentNames = null;
            this.componentValues = null;
        }

        private ClassAnnotation() {
            this.$init$();
            this.annotationType = (NameType)ClassFile.mav$readPoolConstant(ClassFile.this, ClassFile.mav$nextChar(ClassFile.this), 'c');
            this.compBp = ClassFile.ra$bp(ClassFile.this);
            int n = ClassFile.mav$nextChar(ClassFile.this);
            int n2 = 0;
            while (n2 < n) {
                ClassFile.mav$skipComponent(ClassFile.this);
                ++n2;
            }
        }

        public final NameType getAnnotationType() {
            return this.annotationType;
        }

        public final String[] getComponentNames() {
            if (this.componentNames == null) {
                this.readComponents();
            }
            return this.componentNames;
        }

        public final ComponentValue[] getComponentValues() {
            if (this.componentValues == null) {
                this.readComponents();
            }
            return this.componentValues;
        }

        public final void dump(PrintStream printStream) {
            String string = this.annotationType.toString();
            String string2 = string.substring(1, string.length() - 1);
            printStream.print('@' + string2);
            printStream.print('(');
            this.readComponents();
            int n = this.componentNames.length;
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                if (bl) {
                    printStream.print(", ");
                }
                printStream.print(this.componentNames[n2] + " = ");
                ComponentValue.mav$dump(this.componentValues[n2], printStream);
                bl = true;
                ++n2;
            }
            printStream.println(')');
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readComponents() {
            ClassFile classFile = ClassFile.this;
            synchronized (classFile) {
                if (this.componentNames != null) {
                    return;
                }
                int n = ClassFile.ra$bp(ClassFile.this);
                try {
                    ClassFile.wa$bp(ClassFile.this, this.compBp);
                    int n2 = ClassFile.mav$nextChar(ClassFile.this);
                    if (n2 == 0) {
                        this.componentNames = JavaConstants.EMPTY_STRING_ARRAY;
                        this.componentValues = ClassFile.ra$EMPTY_VALUE_ARRAY();
                    } else {
                        this.componentNames = new String[n2];
                        this.componentValues = new ComponentValue[n2];
                        int n3 = 0;
                        while (n3 < n2) {
                            this.componentNames[n3] = ClassFile.mav$readPoolName(ClassFile.this, ClassFile.mav$nextChar(ClassFile.this)).toString();
                            this.componentValues[n3] = new ComponentValue(null);
                            ++n3;
                        }
                    }
                }
                finally {
                    ClassFile.wa$bp(ClassFile.this, n);
                }
            }
        }

        ClassAnnotation(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    public final class ComponentValue {
        private final byte tag;
        private final int valueBp;
        private Object value;

        void $init$() {
            this.value = null;
        }

        private ComponentValue() {
            this.$init$();
            this.tag = ClassFile.mav$nextByte(ClassFile.this);
            this.valueBp = ClassFile.ra$bp(ClassFile.this);
            ClassFile.mav$skipValue(ClassFile.this, this.tag);
        }

        public final char getComponentTag() {
            return (char)(this.tag & 0xFF);
        }

        public final Object getComponentValue() {
            if (this.value == null) {
                this.value = this.readValue();
            }
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object readValue() {
            switch (this.tag) {
                case 101: {
                    char c = ClassFile.mav$getChar(ClassFile.this, this.valueBp);
                    char c2 = ClassFile.mav$getChar(ClassFile.this, this.valueBp + 2);
                    return new EnumReference(c, c2);
                }
                case 91: {
                    int n = ClassFile.mav$getChar(ClassFile.this, this.valueBp);
                    if (n == 0) {
                        return ClassFile.ra$EMPTY_VALUE_ARRAY();
                    }
                    ComponentValue[] componentValueArray = new ComponentValue[n];
                    ClassFile classFile = ClassFile.this;
                    synchronized (classFile) {
                        int n2 = ClassFile.ra$bp(ClassFile.this);
                        try {
                            ClassFile.wa$bp(ClassFile.this, this.valueBp + 2);
                            int n3 = 0;
                            while (n3 < n) {
                                componentValueArray[n3] = new ComponentValue();
                                ++n3;
                            }
                            ComponentValue[] componentValueArray2 = componentValueArray;
                            ClassFile.wa$bp(ClassFile.this, n2);
                            return componentValueArray2;
                        }
                        catch (Throwable throwable) {
                            ClassFile.wa$bp(ClassFile.this, n2);
                            throw throwable;
                        }
                    }
                }
                case 64: {
                    ClassFile classFile = ClassFile.this;
                    synchronized (classFile) {
                        int n = ClassFile.ra$bp(ClassFile.this);
                        try {
                            ClassFile.wa$bp(ClassFile.this, this.valueBp);
                            ClassAnnotation classAnnotation = new ClassAnnotation(null);
                            ClassFile.wa$bp(ClassFile.this, n);
                            return classAnnotation;
                        }
                        catch (Throwable throwable) {
                            ClassFile.wa$bp(ClassFile.this, n);
                            throw throwable;
                        }
                    }
                }
            }
            char c = ClassFile.mav$getChar(ClassFile.this, this.valueBp);
            return ClassFile.mav$readPoolConstant(ClassFile.this, c, this.getComponentTag());
        }

        private void dump(PrintStream printStream) {
            Object object = this.getComponentValue();
            switch (this.tag) {
                case 66: 
                case 67: 
                case 68: 
                case 73: 
                case 74: 
                case 83: 
                case 90: {
                    printStream.print(object);
                    break;
                }
                case 115: {
                    printStream.print('\"' + object.toString() + '\"');
                    break;
                }
                case 64: {
                    ClassAnnotation classAnnotation = (ClassAnnotation)object;
                    classAnnotation.dump(printStream);
                    break;
                }
                case 99: {
                    printStream.print("(Class) " + object.toString());
                    break;
                }
                case 101: {
                    EnumReference enumReference = (EnumReference)object;
                    EnumReference.mav$dump(enumReference, printStream);
                    break;
                }
                case 91: {
                    CommonUtilities.notImplementedYet();
                }
                default: {
                    CommonUtilities.panic("Unknown component tag: " + this.tag);
                }
            }
        }

        ComponentValue(1 var2_2) {
            this();
        }

        static void mav$dump(ComponentValue componentValue, PrintStream printStream) {
            componentValue.dump(printStream);
        }

        public final class 1 {
        }
    }

    public final class EnumReference {
        final NameType enumClassname;
        final Name enumName;

        EnumReference(int n, int n2) {
            this.enumClassname = (NameType)ClassFile.mav$readPoolConstant(ClassFile.this, n, 'c');
            this.enumName = ClassFile.mav$readPoolName(ClassFile.this, n2);
        }

        private void dump(PrintStream printStream) {
            printStream.print("(Enum) " + this.enumClassname.toString() + '.' + this.enumName);
        }

        static void mav$dump(EnumReference enumReference, PrintStream printStream) {
            enumReference.dump(printStream);
        }
    }
}

