/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.classfile;

import oracle.javatools.parser.java.v2.classfile.Convert;
import oracle.javatools.parser.java.v2.classfile.Name;

public final class NamePool {
    public static final NamePool global = new NamePool();
    private static final int NAME_MAX_COUNT = 65536;
    private static final int HASH_SIZE = 16384;
    private static final int HASH_MASK = 16383;
    public byte[] data;
    private int byteCount;
    private final Name[] hashtable;
    public int count;

    void $init$() {
        this.data = new byte[65536];
        this.byteCount = 0;
        this.hashtable = new Name[16384];
        this.count = 0;
    }

    private static int hashValue(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 = n3 * 1664525 + byArray[n + n4];
            ++n4;
        }
        return n3;
    }

    synchronized int hashValue(Name name) {
        return NamePool.hashValue(this.data, name.index, name.length);
    }

    private boolean equals(int n, byte[] byArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            if (this.data[n + n4] != byArray[n2 + n4]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public static boolean equals(Name name, Name name2) {
        if (name == null || name2 == null) {
            return false;
        }
        if (name.owningPool == name2.owningPool) {
            return name.index == name2.index;
        }
        if (name.length != name2.length) {
            return false;
        }
        return name.owningPool.equals(name.index, name.length, name2.owningPool, name2.index);
    }

    private synchronized boolean equals(int n, int n2, NamePool namePool, int n3) {
        int n4 = 0;
        while (n4 < n2) {
            if (this.data[n + n4] != namePool.data[n3 + n4]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public synchronized Name fromUTF(byte[] byArray, int n, int n2) {
        int n3 = NamePool.hashValue(byArray, n, n2) & 0x3FFF;
        Name name = this.hashtable[n3];
        while (!(name == null || name.length == n2 && this.equals(name.index, byArray, n, n2))) {
            name = name.next;
        }
        if (name == null) {
            name = new Name(this, this.byteCount, n2);
            name.next = this.hashtable[n3];
            this.hashtable[n3] = name;
            int n4 = 0;
            while (n4 < n2) {
                if (this.byteCount == this.data.length) {
                    byte[] byArray2 = new byte[this.data.length * 2];
                    System.arraycopy(this.data, 0, byArray2, 0, this.data.length);
                    this.data = byArray2;
                }
                this.data[this.byteCount++] = byArray[n + n4];
                ++n4;
            }
            if (n2 == 0) {
                ++this.byteCount;
            }
        }
        return name;
    }

    public Name fromUTF(byte[] byArray) {
        return this.fromUTF(byArray, 0, byArray.length);
    }

    public Name fromSource(byte[] byArray, int n, int n2) {
        int n3 = Convert.source2ascii_inplace(byArray, n, n2);
        return this.fromUTF(Convert.ascii, 0, n3);
    }

    public Name fromString(String string) {
        byte[] byArray = Convert.string2source(string);
        Name name = this.fromSource(byArray, 0, byArray.length);
        name.string = string;
        return name;
    }

    synchronized byte[] toUTF(Name name) {
        byte[] byArray = new byte[name.length];
        System.arraycopy(this.data, name.index, byArray, 0, name.length);
        return byArray;
    }

    synchronized byte[] toSource(Name name) {
        return Convert.string2source(this.toString(name));
    }

    synchronized String toString(Name name) {
        return Convert.ascii2string(this.data, name.index, name.length);
    }

    public NamePool() {
        this.$init$();
    }
}

