/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.Collection;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.QuickUnresolvedType;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasAnnotations;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.UnresolvedType;

public abstract class AbstractElement
implements JavaConstants,
JavaElement {
    public abstract int getElementKind();

    public abstract JavaElement getOwner();

    public abstract int getModifiers();

    public boolean isSourceElement() {
        return false;
    }

    public SourceElement getSourceElement() {
        return null;
    }

    public SourceElement getSourceSymbol() {
        return this.getSourceElement();
    }

    public boolean isPublic() {
        return (this.getModifiers() & 1) != 0;
    }

    public boolean isProtected() {
        return (this.getModifiers() & 4) != 0;
    }

    public boolean isPrivate() {
        return (this.getModifiers() & 2) != 0;
    }

    public boolean isPackagePrivate() {
        return (this.getModifiers() & 7) == 0;
    }

    public boolean isStatic() {
        return (this.getModifiers() & 8) != 0;
    }

    public boolean isFinal() {
        return (this.getModifiers() & 0x10) != 0;
    }

    public boolean isVarargs() {
        return (this.getModifiers() & 0x80) != 0;
    }

    public boolean isAbstract() {
        return (this.getModifiers() & 0x400) != 0;
    }

    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public UnresolvedType getUnresolvedType() {
        return QuickUnresolvedType.EMPTY_UNRESOLVED_TYPE;
    }

    public Collection getDeclaredAnnotations() {
        return JavaConstants.kEmptyCollection;
    }

    public Collection getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    public JavaAnnotation getDeclaredAnnotation(JavaType javaType) {
        return CommonUtilities.getDeclaredAnnotation((JavaHasAnnotations)((Object)this), javaType);
    }

    public JavaAnnotation getAnnotation(JavaType javaType) {
        return this.getDeclaredAnnotation(javaType);
    }

    public boolean hasTypeParameters() {
        return this.getTypeParameters().isEmpty() ^ true;
    }

    public Collection getTypeParameters() {
        return JavaConstants.kEmptyCollection;
    }

    public boolean hasActualTypeArguments() {
        return this.getActualTypeArguments().isEmpty() ^ true;
    }

    public Collection getActualTypeArguments() {
        return JavaConstants.kEmptyCollection;
    }

    public void clearCompiledInfo() {
    }

    public String printCompiledInfo() {
        return "";
    }
}

