/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.lang.ref.WeakReference;
import java.util.Collection;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.common.AbstractElement;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.MethodHierarchy;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.util.Conversions;

public abstract class AbstractMethod
extends AbstractElement
implements JavaMethod {
    private WeakReference hierarchyRef;

    public abstract int getModifiers();

    public abstract JavaClass getOwningClass();

    public abstract String getName();

    public abstract JavaType getResolvedType();

    public JavaTypeVariable getTypeParameter(String string) {
        return CommonUtilities.getTypeParameter(this, string);
    }

    public JavaMethod getMethodErasure() {
        return this;
    }

    public int getElementKind() {
        return 8;
    }

    public boolean isConstructor() {
        return false;
    }

    public JavaElement getOwner() {
        return this.getOwningClass();
    }

    public JavaType getReturnType() {
        return this.getResolvedType();
    }

    public Collection getParameters() {
        return JavaConstants.kEmptyCollection;
    }

    public JavaType[] getParameterTypes() {
        return CommonUtilities.getParameterTypes(this);
    }

    public Collection getExceptions() {
        return JavaConstants.kEmptyCollection;
    }

    public Object getDefaultValue() {
        return null;
    }

    public String getDescriptor() {
        return CommonUtilities.getDescriptor(this);
    }

    public String getTypeSignature() {
        return CommonUtilities.getTypeSignature(this);
    }

    public String getSignature() {
        return CommonUtilities.getSignature(this);
    }

    public String getUniqueIdentifier() {
        return CommonUtilities.getUniqueIdentifier(this);
    }

    public String printCompiledInfo() {
        return this.getUniqueIdentifier();
    }

    public boolean hasSubsignatureOf(JavaMethod javaMethod) {
        return Conversions.hasSubsignatureOf(this, javaMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getOverriddenMethods() {
        AbstractMethod abstractMethod = this;
        synchronized (abstractMethod) {
            Object t;
            if (this.hierarchyRef != null && (t = this.hierarchyRef.get()) != null) {
                Collection collection = (Collection)t;
                return collection;
            }
            MethodHierarchy methodHierarchy = new MethodHierarchy(this);
            this.hierarchyRef = new WeakReference<MethodHierarchy>(methodHierarchy);
            MethodHierarchy methodHierarchy2 = methodHierarchy;
            return methodHierarchy2;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof JavaMethod) {
            return CommonUtilities.equals(this, (JavaMethod)object);
        }
        return false;
    }

    public int hashCode() {
        return CommonUtilities.hashCode(this);
    }

    void $init$() {
        this.hierarchyRef = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCompiledInfo() {
        super.clearCompiledInfo();
        AbstractMethod abstractMethod = this;
        synchronized (abstractMethod) {
            this.hierarchyRef = null;
        }
    }

    public AbstractMethod() {
        this.$init$();
    }
}

