/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.common.AbstractElement;
import oracle.javatools.parser.java.v2.common.ClassHierarchy;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.QuickUnresolvedType;
import oracle.javatools.parser.java.v2.common.Value;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.javatools.parser.java.v2.model.expression.CompiledTmpVariable;
import oracle.javatools.parser.java.v2.util.Conversions;

public abstract class AbstractType
extends AbstractElement
implements JavaType {
    private WeakReference hierarchyRef;
    private WeakReference thisValueRef;

    public abstract int getElementKind();

    public abstract String getName();

    public abstract String getQualifiedName();

    public abstract String getVMName();

    public abstract String getDescriptor();

    public abstract String getUniqueIdentifier();

    public abstract JavaClass getTypeErasure();

    public JavaType getResolvedType() {
        return this;
    }

    public UnresolvedType getUnresolvedType() {
        return QuickUnresolvedType.createUnresolvedType(this);
    }

    public int getModifiers() {
        return 0;
    }

    public JavaElement getOwner() {
        return null;
    }

    public JavaClass getOwningClass() {
        return null;
    }

    public JavaMethod getOwningMethod() {
        return null;
    }

    public boolean isExported() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isAnnotation() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public boolean isMemberClass() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public JavaType getComponentType() {
        return null;
    }

    public int getArrayDimensions() {
        return 0;
    }

    public JavaType getBaseComponentType() {
        return null;
    }

    public JavaTypeVariable getTypeParameter(String string) {
        return CommonUtilities.getTypeParameter(this, string);
    }

    public String getRawName() {
        return this.getQualifiedName();
    }

    public String getSourceName() {
        return this.getQualifiedName();
    }

    public String getSignature() {
        return this.getDescriptor();
    }

    public String printCompiledInfo() {
        return this.getUniqueIdentifier();
    }

    public URL getURL() {
        return null;
    }

    public JavaClass getClosestClass() {
        return this.getTypeErasure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompiledTmpVariable getThisValue() {
        AbstractType abstractType = this;
        synchronized (abstractType) {
            Object t;
            if (this.thisValueRef != null && (t = this.thisValueRef.get()) != null) {
                CompiledTmpVariable compiledTmpVariable = (CompiledTmpVariable)t;
                return compiledTmpVariable;
            }
            Value value = Value.createValue(this);
            this.thisValueRef = new WeakReference<Value>(value);
            Value value2 = value;
            return value2;
        }
    }

    public JavaPackage getPackage() {
        return null;
    }

    public String getPackageName() {
        return "";
    }

    public JavaType getSuperclass() {
        return null;
    }

    public Collection getInterfaces() {
        return JavaConstants.kEmptyCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getHierarchy() {
        AbstractType abstractType = this;
        synchronized (abstractType) {
            Object t;
            if (this.hierarchyRef != null && (t = this.hierarchyRef.get()) != null) {
                Set set = (Set)t;
                return set;
            }
            ClassHierarchy classHierarchy = new ClassHierarchy(this);
            this.hierarchyRef = new WeakReference<ClassHierarchy>(classHierarchy);
            ClassHierarchy classHierarchy2 = classHierarchy;
            return classHierarchy2;
        }
    }

    public boolean isAssignableFrom(JavaType javaType) {
        return Conversions.applyAssignmentConversion(javaType, this, false, null);
    }

    public boolean isSubtypeOf(JavaType javaType) {
        return Conversions.isSubtypeOf(this, javaType);
    }

    public Collection getDeclaredFields() {
        return JavaConstants.kEmptyCollection;
    }

    public JavaField getDeclaredField(String string) {
        return CommonUtilities.getDeclaredField(this, string);
    }

    public Collection getDeclaredMethods() {
        return JavaConstants.kEmptyCollection;
    }

    public Collection getDeclaredMethods(String string) {
        return CommonUtilities.getDeclaredMethods(this, string);
    }

    public JavaMethod getDeclaredMethod(String string, JavaType[] javaTypeArray) {
        return CommonUtilities.getDeclaredMethod(this, string, javaTypeArray);
    }

    public Collection getDeclaredConstructors() {
        return JavaConstants.kEmptyCollection;
    }

    public JavaMethod getDeclaredConstructor(JavaType[] javaTypeArray) {
        return CommonUtilities.getDeclaredConstructor(this, javaTypeArray);
    }

    public JavaMethod getClinitMethod() {
        return null;
    }

    public Collection getDeclaredClasses() {
        return JavaConstants.kEmptyCollection;
    }

    public JavaClass getDeclaredClass(String string) {
        return CommonUtilities.getDeclaredClass(this, string);
    }

    public Collection getFields() {
        return CommonUtilities.getFields(this);
    }

    public JavaField getField(String string) {
        return CommonUtilities.getField(this, string);
    }

    public Collection getMethods() {
        return CommonUtilities.getMethods(this);
    }

    public Collection getMethods(String string) {
        return CommonUtilities.getMethods(this, string);
    }

    public JavaMethod getMethod(String string, JavaType[] javaTypeArray) {
        return CommonUtilities.getMethod(this, string, javaTypeArray);
    }

    public Collection getClasses() {
        return CommonUtilities.getClasses(this);
    }

    public JavaClass getClass(String string) {
        return CommonUtilities.getClass(this, string);
    }

    public Collection getAnnotations() {
        return CommonUtilities.getAnnotations(this);
    }

    public JavaAnnotation getAnnotation(JavaType javaType) {
        return CommonUtilities.getAnnotation(this, javaType);
    }

    public boolean equals(Object object) {
        if (object instanceof JavaType) {
            return CommonUtilities.equals(this, (JavaType)object);
        }
        return false;
    }

    public int hashCode() {
        return CommonUtilities.hashCode(this);
    }

    void $init$() {
        this.hierarchyRef = null;
        this.thisValueRef = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCompiledInfo() {
        super.clearCompiledInfo();
        AbstractType abstractType = this;
        synchronized (abstractType) {
            this.hierarchyRef = null;
        }
    }

    public AbstractType() {
        this.$init$();
    }
}

