/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.AbstractClass;
import oracle.javatools.parser.java.v2.common.AbstractField;
import oracle.javatools.parser.java.v2.common.AbstractMethod;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.QuickUnresolvedType;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.UnresolvedType;

final class ArrayType
extends AbstractClass
implements JavaConstants {
    private final JavaProvider provider;
    private final JavaType arrayComponent;
    private JavaField[] arrayFields;
    private JavaMethod[] arrayMethods;
    private Collection arrayInterfaces;

    void $init$() {
        this.arrayFields = null;
        this.arrayMethods = null;
        this.arrayInterfaces = null;
    }

    public ArrayType(JavaProvider javaProvider, JavaType javaType) {
        this.$init$();
        this.provider = javaProvider;
        this.arrayComponent = javaType;
    }

    public boolean isArray() {
        return true;
    }

    public JavaType getComponentType() {
        return this.arrayComponent;
    }

    public int getArrayDimensions() {
        JavaType javaType = this.arrayComponent;
        if (javaType == null) {
            return 1;
        }
        int n = 1;
        JavaType javaType2 = javaType.getComponentType();
        while (javaType2 != null && javaType2 != javaType) {
            if (++n > 255) {
                return 255;
            }
            javaType = javaType2;
            javaType2 = javaType.getComponentType();
        }
        return n;
    }

    public JavaType getBaseComponentType() {
        JavaType javaType = this.arrayComponent;
        if (javaType == null) {
            return null;
        }
        int n = 1;
        JavaType javaType2 = javaType.getComponentType();
        while (javaType2 != null) {
            if (javaType2 == javaType) {
                return null;
            }
            if (++n > 255) {
                return null;
            }
            javaType = javaType2;
            javaType2 = javaType.getComponentType();
        }
        return javaType;
    }

    public JavaClass getTypeErasure() {
        if (this.arrayComponent == null) {
            return null;
        }
        JavaClass javaClass = this.arrayComponent.getTypeErasure();
        if (javaClass == this.arrayComponent) {
            return this;
        }
        return new ArrayType(this.provider, javaClass);
    }

    public String getName() {
        if (this.arrayComponent != null) {
            return this.arrayComponent.getName() + "[]";
        }
        return "Object[]";
    }

    public String getQualifiedName() {
        if (this.arrayComponent != null) {
            return this.arrayComponent.getQualifiedName() + "[]";
        }
        return "java.lang.Object[]";
    }

    public String getVMName() {
        if (this.arrayComponent != null) {
            return this.arrayComponent.getVMName() + "[]";
        }
        return "java/lang/Object[]";
    }

    public String getDescriptor() {
        if (this.arrayComponent != null) {
            return '[' + this.arrayComponent.getDescriptor();
        }
        return "[Ljava/lang/Object;";
    }

    public String getTypeSignature() {
        if (this.arrayComponent != null) {
            return '[' + this.arrayComponent.getTypeSignature();
        }
        return this.getDescriptor();
    }

    public String getSignature() {
        if (this.arrayComponent != null) {
            return '[' + this.arrayComponent.getSignature();
        }
        return this.getDescriptor();
    }

    public JavaType getSuperclass() {
        return this.provider.getClassByVMName("java/lang/Object");
    }

    public Collection getInterfaces() {
        if (this.arrayInterfaces == null) {
            ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>();
            int n = JavaConstants.ARRAY_implements.length;
            int n2 = 0;
            while (n2 < n) {
                JavaClass javaClass = this.provider.getClassByVMName(JavaConstants.ARRAY_implements[n2]);
                if (javaClass != null) {
                    arrayList.add(javaClass);
                }
                ++n2;
            }
            this.arrayInterfaces = !arrayList.isEmpty() ? arrayList : JavaConstants.kEmptyCollection;
        }
        return this.arrayInterfaces;
    }

    public Collection getDeclaredFields() {
        if (this.arrayFields == null) {
            JavaField[] javaFieldArray = new JavaField[]{new ArrayLength(null)};
            this.arrayFields = javaFieldArray;
        }
        return Arrays.asList(this.arrayFields);
    }

    public Collection getDeclaredMethods() {
        if (this.arrayMethods == null) {
            JavaMethod[] javaMethodArray = new JavaMethod[]{new ArrayClone(null)};
            this.arrayMethods = javaMethodArray;
        }
        return Arrays.asList(this.arrayMethods);
    }

    static JavaProvider ra$provider(ArrayType arrayType) {
        return arrayType.provider;
    }

    private class ArrayLength
    extends AbstractField {
        public JavaClass getOwningClass() {
            return ArrayType.this;
        }

        public JavaType getResolvedType() {
            return PrimitiveType.PRIMITIVE_objects[4];
        }

        public UnresolvedType getUnresolvedType() {
            return this.getResolvedType().getUnresolvedType();
        }

        public String getName() {
            return "length";
        }

        public int getModifiers() {
            return 17;
        }

        private ArrayLength() {
        }

        ArrayLength(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ArrayClone
    extends AbstractMethod {
        public JavaClass getOwningClass() {
            return ArrayType.this;
        }

        public JavaType getResolvedType() {
            return ArrayType.ra$provider(ArrayType.this).getClassByVMName("java/lang/Object");
        }

        public UnresolvedType getUnresolvedType() {
            JavaType javaType = this.getResolvedType();
            if (javaType != null) {
                return javaType.getUnresolvedType();
            }
            return QuickUnresolvedType.EMPTY_UNRESOLVED_TYPE;
        }

        public String getName() {
            return "clone";
        }

        public String getDescriptor() {
            return "()Ljava/lang/Object;";
        }

        public int getModifiers() {
            return 17;
        }

        private ArrayClone() {
        }

        ArrayClone(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

