/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaType;

public class ClassHierarchy
extends AbstractSet
implements JavaConstants {
    private JavaType[] classHierarchy;
    private JavaType target;

    public Iterator iterator() {
        if (this.classHierarchy != null) {
            return Arrays.asList(this.classHierarchy).iterator();
        }
        return new ClassHierarchyIterator(null);
    }

    public int size() {
        this.calculateHierarchy();
        return this.classHierarchy.length;
    }

    public boolean isEmpty() {
        if (this.classHierarchy != null) {
            return this.classHierarchy.length == 0;
        }
        return new ClassHierarchyIterator(null).hasNext() ^ true;
    }

    public Object[] toArray() {
        this.calculateHierarchy();
        return this.classHierarchy;
    }

    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    public ClassHierarchy(JavaType javaType) {
        this.target = javaType;
        if (javaType == null) {
            this.classHierarchy = JavaType.EMPTY_ARRAY;
        }
    }

    private void calculateHierarchy() {
        if (this.classHierarchy != null) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.calculateHierarchyImpl(this.target, arrayList, arrayList2);
        arrayList2.remove(this.target);
        int n = arrayList2.size();
        this.classHierarchy = n == 0 ? JavaType.EMPTY_ARRAY : arrayList2.toArray(new JavaType[n]);
    }

    private void calculateHierarchyImpl(JavaType javaType, ArrayList arrayList, ArrayList arrayList2) {
        JavaType javaType2;
        if (javaType == null) {
            return;
        }
        if (CommonUtilities.classProcessed(arrayList, javaType)) {
            return;
        }
        if (javaType.getElementKind() == 3) {
            arrayList2.add(javaType);
        }
        if ((javaType2 = javaType.getSuperclass()) != null) {
            this.calculateHierarchyImpl(javaType2, arrayList, arrayList2);
        }
        for (JavaType javaType3 : javaType.getInterfaces()) {
            this.calculateHierarchyImpl(javaType3, arrayList, arrayList2);
        }
    }

    static JavaType[] ra$classHierarchy(ClassHierarchy classHierarchy) {
        return classHierarchy.classHierarchy;
    }

    static void wa$classHierarchy(ClassHierarchy classHierarchy, JavaType[] javaTypeArray) {
        classHierarchy.classHierarchy = javaTypeArray;
    }

    static JavaType ra$target(ClassHierarchy classHierarchy) {
        return classHierarchy.target;
    }

    private class ClassHierarchyIterator
    implements Iterator {
        final ArrayList processed;
        final ArrayList output;
        final LinkedList frontier;
        JavaType current;

        void $init$() {
            this.processed = new ArrayList();
            this.output = new ArrayList();
            this.frontier = new LinkedList();
            this.current = null;
        }

        private ClassHierarchyIterator() {
            this.$init$();
            this.frontier.add(ClassHierarchy.ra$target(ClassHierarchy.this));
            this.next();
            this.output.clear();
        }

        public boolean hasNext() {
            if (this.current == null) {
                this.advance();
            }
            if (this.current != null) {
                return true;
            }
            if (ClassHierarchy.ra$classHierarchy(ClassHierarchy.this) == null) {
                int n = this.output.size();
                if (n == 0) {
                    ClassHierarchy.wa$classHierarchy(ClassHierarchy.this, JavaType.EMPTY_ARRAY);
                } else {
                    ClassHierarchy.wa$classHierarchy(ClassHierarchy.this, this.output.toArray(new JavaType[n]));
                }
            }
            return false;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            JavaType javaType = this.current;
            this.output.add(javaType);
            this.current = null;
            return javaType;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advance() {
            while (this.current == null && !this.frontier.isEmpty()) {
                JavaType javaType = (JavaType)this.frontier.removeFirst();
                if (CommonUtilities.classProcessed(this.processed, javaType)) continue;
                this.current = javaType;
                JavaType javaType2 = javaType.getSuperclass();
                if (javaType2 != null) {
                    this.frontier.addLast(javaType2);
                }
                for (JavaType javaType3 : javaType.getInterfaces()) {
                    this.frontier.addLast(javaType3);
                }
            }
        }

        ClassHierarchyIterator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

