/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.ArrayType;
import oracle.javatools.parser.java.v2.common.ParameterizedClass;
import oracle.javatools.parser.java.v2.common.ParameterizedMethod;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.WildcardType;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaHasAnnotations;
import oracle.javatools.parser.java.v2.model.JavaIsGeneric;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasModifiers;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.util.Conversions;

public class CommonUtilities
extends Conversions
implements JavaConstants {
    private static WeakReference textBufferRef = null;
    private static byte OPTYPE_ASSIGNMENT = 0;
    private static byte OPTYPE_RELATIONAL = 1;
    private static byte OPTYPE_SHIFT = (byte)2;
    private static byte OPTYPE_INFIX = (byte)3;
    private static byte OPTYPE_PREFIX = (byte)4;
    private static byte OPTYPE_POSTFIX = (byte)5;
    private static byte OPTYPE_max = (byte)6;
    private static byte[][] op2optTable = new byte[OPTYPE_max][49];

    public static int provider2jdkVersion(JavaProvider javaProvider) {
        JavaClass javaClass = javaProvider.getClassByVMName("java/lang/Iterable");
        if (javaProvider.getClassByVMName("java/lang/Enum") == null || javaProvider.getClassByVMName("java/lang/annotation/Annotation") == null) {
            return 2;
        }
        return 3;
    }

    static {
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)33, (byte)6);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)68, (byte)2);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)60, (byte)32);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)64, (byte)36);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)42, (byte)18);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)62, (byte)34);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)32, (byte)8);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)66, (byte)11);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)78, (byte)13);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)57, (byte)29);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)74, (byte)52);
        CommonUtilities.set_op2opt(OPTYPE_ASSIGNMENT, (short)77, (byte)57);
        CommonUtilities.set_op2opt(OPTYPE_RELATIONAL, (short)58, (byte)30);
        CommonUtilities.set_op2opt(OPTYPE_RELATIONAL, (short)51, (byte)25);
        CommonUtilities.set_op2opt(OPTYPE_RELATIONAL, (short)46, (byte)22);
        CommonUtilities.set_op2opt(OPTYPE_RELATIONAL, (short)45, (byte)21);
        CommonUtilities.set_op2opt(OPTYPE_RELATIONAL, (short)44, (byte)20);
        CommonUtilities.set_op2opt(OPTYPE_RELATIONAL, (short)65, (byte)42);
        CommonUtilities.set_op2opt(OPTYPE_SHIFT, (short)56, (byte)28);
        CommonUtilities.set_op2opt(OPTYPE_SHIFT, (short)73, (byte)51);
        CommonUtilities.set_op2opt(OPTYPE_SHIFT, (short)76, (byte)56);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)67, (byte)1);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)59, (byte)31);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)63, (byte)35);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)41, (byte)17);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)61, (byte)33);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)52, (byte)3);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)54, (byte)43);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)34, (byte)7);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)36, (byte)10);
        CommonUtilities.set_op2opt(OPTYPE_INFIX, (short)37, (byte)12);
        short s = 32;
        while (s < 81) {
            byte by = 0;
            if (by == 0) {
                by = CommonUtilities.asg_op(s);
            }
            if (by == 0) {
                by = CommonUtilities.rel_op(s);
            }
            if (by == 0) {
                by = CommonUtilities.shift_op(s);
            }
            if (by != 0) {
                CommonUtilities.set_op2opt(OPTYPE_INFIX, s, by);
            }
            s = (short)(s + 1);
        }
        CommonUtilities.set_op2opt(OPTYPE_PREFIX, (short)48, (byte)48);
        CommonUtilities.set_op2opt(OPTYPE_PREFIX, (short)40, (byte)47);
        CommonUtilities.set_op2opt(OPTYPE_PREFIX, (short)53, (byte)41);
        CommonUtilities.set_op2opt(OPTYPE_PREFIX, (short)35, (byte)9);
        CommonUtilities.set_op2opt(OPTYPE_PREFIX, (short)67, (byte)44);
        CommonUtilities.set_op2opt(OPTYPE_PREFIX, (short)59, (byte)37);
        CommonUtilities.set_op2opt(OPTYPE_POSTFIX, (short)48, (byte)46);
        CommonUtilities.set_op2opt(OPTYPE_POSTFIX, (short)40, (byte)45);
    }

    protected static synchronized TextBuffer acquireTextBuffer() {
        TextBuffer textBuffer = null;
        if (textBufferRef != null && (textBuffer = (TextBuffer)textBufferRef.get()) != null) {
            textBuffer.remove(0, textBuffer.getLength());
        }
        if (textBuffer == null) {
            textBuffer = TextBufferFactory.createGapTextBuffer();
        } else {
            textBuffer.remove(0, textBuffer.getLength());
        }
        textBufferRef = null;
        return textBuffer;
    }

    protected static synchronized void releaseTextBuffer(TextBuffer textBuffer) {
        textBufferRef = new WeakReference<TextBuffer>(textBuffer);
    }

    public static PrimitiveType getPrimitiveType(String string) {
        return PrimitiveType.lookupPrimitive(string);
    }

    public static JavaType createArrayType(JavaProvider javaProvider, JavaType javaType, int n) {
        if (n == 0) {
            return javaType;
        }
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        ArrayType arrayType = new ArrayType(javaProvider, javaType);
        int n2 = n - 1;
        while (n2 > 0) {
            arrayType = new ArrayType(javaProvider, arrayType);
            --n2;
        }
        return arrayType;
    }

    public static JavaType createParameterizedType(JavaType javaType, JavaType[] javaTypeArray) {
        return CommonUtilities.createParameterizedType(null, javaType, javaTypeArray);
    }

    public static JavaType createParameterizedType(JavaProvider javaProvider, JavaType javaType, JavaType[] javaTypeArray) {
        if (javaType.isArray()) {
            throw new IllegalArgumentException("Cannot bind an array type");
        }
        Collection collection = javaType.getTypeParameters();
        int n = collection.size();
        if (n == 0) {
            throw new IllegalArgumentException("Not a generic type");
        }
        int n2 = javaTypeArray.length;
        if (n != n2) {
            throw new IllegalArgumentException("Arguments mismatch");
        }
        try {
            JavaClass javaClass = (JavaClass)javaType;
            ParameterizedClass parameterizedClass = new ParameterizedClass(javaProvider, javaClass, javaTypeArray);
            return parameterizedClass;
        }
        catch (ClassCastException classCastException) {
            JavaType javaType2 = javaType;
            return javaType2;
        }
    }

    public static JavaMethod createParameterizedMethod(JavaProvider javaProvider, JavaMethod javaMethod, JavaType[] javaTypeArray) {
        Collection collection = javaMethod.getTypeParameters();
        int n = collection.size();
        if (n == 0) {
            throw new IllegalArgumentException("Not a generic type");
        }
        int n2 = javaTypeArray.length;
        if (n != n2) {
            throw new IllegalArgumentException("Arguments mismatch");
        }
        return new ParameterizedMethod(javaProvider, javaMethod, javaTypeArray);
    }

    public static JavaType createWildcardType(byte by, JavaType javaType, JavaProvider javaProvider) {
        switch (by) {
            case 0: {
                return javaType;
            }
            case 2: {
                if (javaType != null) {
                    return new WildcardType(null, javaType, javaProvider);
                }
                throw new IllegalArgumentException();
            }
            case 1: {
                return new WildcardType(javaType, null, javaProvider);
            }
            case 3: {
                if (javaType != null) break;
                return new WildcardType(null, null, javaProvider);
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean matchMethod(JavaMethod javaMethod, JavaType[] javaTypeArray) {
        Collection collection = javaMethod.getParameters();
        if (javaTypeArray.length != collection.size()) {
            return false;
        }
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            JavaType javaType = javaTypeArray[n++];
            JavaVariable javaVariable = (JavaVariable)iterator.next();
            if (javaType == null) continue;
            JavaType javaType2 = javaVariable.getResolvedType();
            if (javaType2 == null) {
                return false;
            }
            if (javaType.equals(javaType2)) continue;
            return false;
        }
        return true;
    }

    protected static boolean isInheritedAnnotation(JavaAnnotation javaAnnotation) {
        if (javaAnnotation == null) {
            return false;
        }
        JavaType javaType = javaAnnotation.getResolvedType();
        return CommonUtilities.isInheritedAnnotation(javaType);
    }

    protected static boolean isInheritedAnnotation(JavaType javaType) {
        if (javaType == null) {
            return false;
        }
        for (JavaAnnotation javaAnnotation : javaType.getDeclaredAnnotations()) {
            JavaType javaType2 = javaAnnotation.getAnnotationType();
            if (javaType2 == null || !"java/lang/annotation/Inherited".equals(javaType2.getVMName())) continue;
            return true;
        }
        return false;
    }

    protected static boolean classProcessed(ArrayList arrayList, JavaType javaType) {
        if (arrayList == null) {
            return false;
        }
        String string = javaType.getTypeSignature();
        if (arrayList.contains(string)) {
            return true;
        }
        arrayList.add(string);
        return false;
    }

    private static void set_op2opt(byte by, short s, byte by2) {
        CommonUtilities.op2optTable[by][s - 32] = by2;
    }

    protected static byte asg_op(int n) {
        if (32 <= n && n < 81) {
            return op2optTable[OPTYPE_ASSIGNMENT][n - 32];
        }
        return 0;
    }

    protected static byte rel_op(int n) {
        if (32 <= n && n < 81) {
            return op2optTable[OPTYPE_RELATIONAL][n - 32];
        }
        return 0;
    }

    protected static byte shift_op(int n) {
        if (32 <= n && n < 81) {
            return op2optTable[OPTYPE_SHIFT][n - 32];
        }
        return 0;
    }

    protected static byte infix_op(int n) {
        if (32 <= n && n < 81) {
            return op2optTable[OPTYPE_INFIX][n - 32];
        }
        return 0;
    }

    protected static byte prefix_op(int n) {
        if (32 <= n && n < 81) {
            return op2optTable[OPTYPE_PREFIX][n - 32];
        }
        return 0;
    }

    protected static byte postfix_op(int n) {
        if (32 <= n && n < 81) {
            return op2optTable[OPTYPE_POSTFIX][n - 32];
        }
        return 0;
    }

    public static String getDescriptor(JavaMethod javaMethod) {
        StringBuffer stringBuffer = new StringBuffer();
        Collection collection = javaMethod.getParameters();
        if (collection.isEmpty()) {
            stringBuffer.append("()");
        } else {
            stringBuffer.append('(');
            for (JavaVariable javaVariable : collection) {
                JavaType javaType = javaVariable.getResolvedType();
                if (javaType != null) {
                    stringBuffer.append(javaType.getDescriptor());
                    continue;
                }
                stringBuffer.append('V');
            }
            stringBuffer.append(')');
        }
        JavaType javaType = javaMethod.getReturnType();
        if (javaType != null) {
            stringBuffer.append(javaType.getDescriptor());
        } else {
            stringBuffer.append('V');
        }
        return stringBuffer.toString();
    }

    public static String getTypeSignature(JavaMethod javaMethod) {
        Collection collection;
        StringBuffer stringBuffer = new StringBuffer();
        if (javaMethod.hasActualTypeArguments()) {
            stringBuffer.append('<');
            for (JavaType javaType : javaMethod.getActualTypeArguments()) {
                stringBuffer.append(javaType.getTypeSignature());
            }
            stringBuffer.append('>');
        }
        if ((collection = javaMethod.getParameters()).isEmpty()) {
            stringBuffer.append("()");
        } else {
            stringBuffer.append('(');
            for (JavaVariable javaVariable : collection) {
                JavaType javaType = javaVariable.getResolvedType();
                if (javaType != null) {
                    stringBuffer.append(javaType.getTypeSignature());
                    continue;
                }
                stringBuffer.append('V');
            }
            stringBuffer.append(')');
        }
        JavaType javaType = javaMethod.getReturnType();
        if (javaType != null) {
            stringBuffer.append(javaType.getTypeSignature());
        } else {
            stringBuffer.append('V');
        }
        return stringBuffer.toString();
    }

    public static String getSignature(JavaMethod javaMethod) {
        Collection collection;
        StringBuffer stringBuffer = new StringBuffer();
        if (javaMethod.hasTypeParameters()) {
            stringBuffer.append('<');
            for (JavaTypeVariable javaTypeVariable : javaMethod.getTypeParameters()) {
                stringBuffer.append(javaTypeVariable.getSignature());
            }
            stringBuffer.append('>');
        }
        if ((collection = javaMethod.getParameters()).isEmpty()) {
            stringBuffer.append("()");
        } else {
            stringBuffer.append('(');
            for (JavaVariable javaVariable : collection) {
                JavaType javaType = javaVariable.getResolvedType();
                if (javaType != null) {
                    stringBuffer.append(javaType.getTypeSignature());
                    continue;
                }
                stringBuffer.append('V');
            }
            stringBuffer.append(')');
        }
        JavaType javaType = javaMethod.getReturnType();
        if (javaType != null) {
            stringBuffer.append(javaType.getTypeSignature());
        } else {
            stringBuffer.append('V');
        }
        for (JavaType javaType2 : javaMethod.getExceptions()) {
            stringBuffer.append('^');
            stringBuffer.append(javaType2.getTypeSignature());
        }
        return stringBuffer.toString();
    }

    public static String getDescriptor(JavaField javaField) {
        JavaType javaType = javaField.getResolvedType();
        if (javaType == null) {
            return "java/lang/Object";
        }
        return javaType.getDescriptor();
    }

    public static String getSignature(JavaField javaField) {
        JavaType javaType = javaField.getResolvedType();
        if (javaType == null) {
            return "java/lang/Object";
        }
        return javaType.getTypeSignature();
    }

    public static String getDescriptor(JavaClass javaClass) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('L');
        stringBuffer.append(javaClass.getVMName());
        stringBuffer.append(';');
        return stringBuffer.toString();
    }

    public static String getTypeSignature(JavaClass javaClass) {
        StringBuffer stringBuffer = new StringBuffer();
        if (javaClass.isMemberClass() && !javaClass.isStatic()) {
            String string;
            JavaClass javaClass2 = javaClass.getOwningClass();
            String string2 = javaClass2.getDescriptor();
            if (!string2.equals(string = javaClass2.getTypeSignature())) {
                stringBuffer.append(string);
                stringBuffer.setLength(stringBuffer.length() - 1);
                stringBuffer.append('.');
                stringBuffer.append(javaClass.getName());
            } else {
                stringBuffer.append('L');
                stringBuffer.append(javaClass.getVMName());
            }
        } else {
            stringBuffer.append('L');
            stringBuffer.append(javaClass.getVMName());
        }
        if (javaClass.hasActualTypeArguments()) {
            stringBuffer.append('<');
            for (JavaType javaType : javaClass.getActualTypeArguments()) {
                stringBuffer.append(javaType.getTypeSignature());
            }
            stringBuffer.append('>');
        }
        stringBuffer.append(';');
        return stringBuffer.toString();
    }

    public static String getSignature(JavaClass javaClass) {
        JavaType javaType;
        StringBuffer stringBuffer = new StringBuffer();
        if (javaClass.hasTypeParameters()) {
            stringBuffer.append('<');
            for (JavaTypeVariable javaTypeVariable : javaClass.getTypeParameters()) {
                stringBuffer.append(javaTypeVariable.getSignature());
            }
            stringBuffer.append('>');
        }
        if ((javaType = javaClass.getSuperclass()) != null) {
            stringBuffer.append(javaType.getDescriptor());
        }
        for (JavaType javaType2 : javaClass.getInterfaces()) {
            stringBuffer.append(javaType2.getDescriptor());
        }
        return stringBuffer.toString();
    }

    public static String getDescriptor(JavaTypeVariable javaTypeVariable) {
        JavaClass javaClass = javaTypeVariable.getTypeErasure();
        if (javaClass != null) {
            return javaClass.getDescriptor();
        }
        return "Ljava/lang/Object;";
    }

    public static String getTypeSignature(JavaTypeVariable javaTypeVariable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('T');
        stringBuffer.append(javaTypeVariable.getName());
        stringBuffer.append(';');
        return stringBuffer.toString();
    }

    public static String getSignature(JavaTypeVariable javaTypeVariable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(javaTypeVariable.getName());
        for (JavaType javaType : javaTypeVariable.getBounds()) {
            stringBuffer.append(':');
            stringBuffer.append(javaType.getTypeSignature());
        }
        return stringBuffer.toString();
    }

    public static String getUniqueIdentifier(JavaPackage javaPackage) {
        return 'P' + javaPackage.getQualifiedName().replace('.', '/');
    }

    public static String getUniqueIdentifier(JavaClass javaClass) {
        return javaClass.getTypeSignature();
    }

    public static String getUniqueIdentifier(JavaTypeVariable javaTypeVariable) {
        JavaIsGeneric javaIsGeneric = (JavaIsGeneric)javaTypeVariable.getOwningMember();
        String string = javaIsGeneric != null ? javaIsGeneric.getUniqueIdentifier() : "<unknown>";
        return string + ':' + javaTypeVariable.getTypeSignature();
    }

    public static String getUniqueIdentifier(JavaWildcardType javaWildcardType) {
        return javaWildcardType.getTypeSignature();
    }

    public static String getUniqueIdentifier(JavaField javaField) {
        JavaClass javaClass = javaField.getOwningClass();
        String string = javaClass != null ? javaClass.getUniqueIdentifier() : "class-unknown";
        return 'F' + string + '.' + javaField.getName() + CommonUtilities.getSignature(javaField);
    }

    public static String getUniqueIdentifier(JavaMethod javaMethod) {
        JavaClass javaClass = javaMethod.getOwningClass();
        String string = javaClass != null ? javaClass.getUniqueIdentifier() : "class-unknown";
        String string2 = javaMethod.getTypeSignature();
        int n = string2.indexOf(94);
        String string3 = n >= 0 ? string2.substring(0, n) : string2;
        return 'M' + string + '.' + javaMethod.getName() + string3;
    }

    public static boolean equals(JavaPackage javaPackage, JavaPackage javaPackage2) {
        if (javaPackage == javaPackage2) {
            return true;
        }
        return javaPackage.getQualifiedName().equals(javaPackage2.getQualifiedName());
    }

    public static boolean equals(JavaMember javaMember, JavaMember javaMember2) {
        if (javaMember == javaMember2) {
            return true;
        }
        return javaMember.getUniqueIdentifier().equals(javaMember2.getUniqueIdentifier());
    }

    public static int hashCode(JavaPackage javaPackage) {
        if (javaPackage == null) {
            return 0;
        }
        return javaPackage.getQualifiedName().hashCode();
    }

    public static int hashCode(JavaMember javaMember) {
        if (javaMember == null) {
            return 0;
        }
        return javaMember.getUniqueIdentifier().hashCode();
    }

    public static JavaField getDeclaredField(JavaType javaType, String string) {
        for (JavaField javaField : javaType.getDeclaredFields()) {
            if (!string.equals(javaField.getName())) continue;
            return javaField;
        }
        return null;
    }

    public static Collection getDeclaredMethods(JavaType javaType, String string) {
        ArrayList<JavaMethod> arrayList = new ArrayList<JavaMethod>();
        for (JavaMethod javaMethod : javaType.getDeclaredMethods()) {
            if (!string.equals(javaMethod.getName())) continue;
            arrayList.add(javaMethod);
        }
        return arrayList;
    }

    public static JavaMethod getDeclaredMethod(JavaType javaType, String string, JavaType[] javaTypeArray) {
        if (javaTypeArray == null) {
            javaTypeArray = JavaType.EMPTY_ARRAY;
        }
        for (JavaMethod javaMethod : javaType.getDeclaredMethods()) {
            if (!string.equals(javaMethod.getName()) || !CommonUtilities.matchMethod(javaMethod, javaTypeArray)) continue;
            return javaMethod;
        }
        return null;
    }

    public static JavaMethod getDeclaredConstructor(JavaType javaType, JavaType[] javaTypeArray) {
        if (javaTypeArray == null) {
            javaTypeArray = JavaType.EMPTY_ARRAY;
        }
        for (JavaMethod javaMethod : javaType.getDeclaredConstructors()) {
            if (!CommonUtilities.matchMethod(javaMethod, javaTypeArray)) continue;
            return javaMethod;
        }
        return null;
    }

    public static JavaClass getDeclaredClass(JavaType javaType, String string) {
        for (JavaClass javaClass : javaType.getDeclaredClasses()) {
            String string2 = javaClass.getName();
            if (!string.equals(javaClass.getName())) continue;
            return javaClass;
        }
        return null;
    }

    public static JavaTypeVariable getTypeParameter(JavaIsGeneric javaIsGeneric, String string) {
        if (!javaIsGeneric.hasTypeParameters()) {
            return null;
        }
        for (JavaTypeVariable javaTypeVariable : javaIsGeneric.getTypeParameters()) {
            if (!string.equals(javaTypeVariable.getName())) continue;
            return javaTypeVariable;
        }
        return null;
    }

    public static JavaAnnotation getDeclaredAnnotation(JavaHasAnnotations javaHasAnnotations, JavaType javaType) {
        if (javaType == null) {
            return null;
        }
        for (JavaAnnotation javaAnnotation : javaHasAnnotations.getDeclaredAnnotations()) {
            JavaType javaType2 = javaAnnotation.getResolvedType();
            if (javaType2 == null || !javaType2.equals(javaType)) continue;
            return javaAnnotation;
        }
        return null;
    }

    public static Collection getFields(JavaType javaType) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(javaType.getDeclaredFields());
        for (JavaType javaType2 : javaType.getHierarchy()) {
            arrayList.addAll(javaType2.getDeclaredFields());
        }
        return arrayList;
    }

    public static JavaField getField(JavaType javaType, String string) {
        for (JavaField javaField : javaType.getFields()) {
            if (!string.equals(javaField.getName())) continue;
            return javaField;
        }
        return null;
    }

    public static Collection getMethods(JavaType javaType) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(javaType.getDeclaredMethods());
        for (JavaType javaType2 : javaType.getHierarchy()) {
            arrayList.addAll(javaType2.getDeclaredMethods());
        }
        return arrayList;
    }

    public static Collection getMethods(JavaType javaType, String string) {
        ArrayList<JavaMethod> arrayList = new ArrayList<JavaMethod>();
        for (JavaMethod javaMethod : javaType.getMethods()) {
            if (!string.equals(javaMethod.getName())) continue;
            arrayList.add(javaMethod);
        }
        return arrayList;
    }

    public static JavaMethod getMethod(JavaType javaType, String string, JavaType[] javaTypeArray) {
        if (javaTypeArray == null) {
            javaTypeArray = JavaType.EMPTY_ARRAY;
        }
        for (JavaMethod javaMethod : javaType.getMethods()) {
            if (!string.equals(javaMethod.getName()) || !CommonUtilities.matchMethod(javaMethod, javaTypeArray)) continue;
            return javaMethod;
        }
        return null;
    }

    public static Collection getClasses(JavaType javaType) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(javaType.getDeclaredClasses());
        for (JavaType javaType2 : javaType.getHierarchy()) {
            arrayList.addAll(javaType2.getDeclaredClasses());
        }
        return arrayList;
    }

    public static JavaClass getClass(JavaType javaType, String string) {
        for (JavaClass javaClass : javaType.getClasses()) {
            if (!string.equals(javaClass.getName())) continue;
            return javaClass;
        }
        return null;
    }

    public static JavaClass getClass(JavaFile javaFile, String string) {
        for (JavaClass javaClass : javaFile.getClasses()) {
            if (!string.equals(javaClass.getName())) continue;
            return javaClass;
        }
        return null;
    }

    public static Collection getAnnotations(JavaType javaType) {
        ArrayList<JavaAnnotation> arrayList = new ArrayList<JavaAnnotation>();
        arrayList.addAll(javaType.getDeclaredAnnotations());
        for (JavaType javaType2 : javaType.getHierarchy()) {
            for (JavaAnnotation javaAnnotation : javaType2.getDeclaredAnnotations()) {
                if (!javaAnnotation.isInherited()) continue;
                arrayList.add(javaAnnotation);
            }
        }
        return arrayList;
    }

    public static JavaAnnotation getAnnotation(JavaType javaType, JavaType javaType2) {
        if (javaType2 == null) {
            return null;
        }
        for (JavaAnnotation javaAnnotation : javaType.getAnnotations()) {
            JavaType javaType3 = javaAnnotation.getResolvedType();
            if (javaType3 == null || !javaType3.equals(javaType2)) continue;
            return javaAnnotation;
        }
        return null;
    }

    public static JavaType[] getParameterTypes(JavaMethod javaMethod) {
        Collection collection = javaMethod.getParameters();
        int n = collection.size();
        if (n == 0) {
            return JavaType.EMPTY_ARRAY;
        }
        JavaType[] javaTypeArray = new JavaType[n];
        Iterator iterator = collection.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            JavaVariable javaVariable = (JavaVariable)iterator.next();
            javaTypeArray[n2++] = javaVariable.getResolvedType();
        }
        return javaTypeArray;
    }

    public static SourceElement getSourceElement(JavaElement javaElement, SourceFile sourceFile) {
        if (sourceFile == null) {
            return null;
        }
        if (javaElement == null) {
            throw new NullPointerException();
        }
        switch (javaElement.getElementKind()) {
            case 3: {
                JavaClass javaClass = (JavaClass)javaElement;
                SourceClass sourceClass = CommonUtilities.getSourceElement(javaClass, sourceFile);
                if (sourceClass != null) {
                    return sourceClass;
                }
                JavaClass javaClass2 = javaClass.getOwningClass();
                SourceClass sourceClass2 = CommonUtilities.getSourceElement(javaClass2, sourceFile);
                return CommonUtilities.getSourceElement(javaClass, sourceClass2);
            }
            case 5: {
                JavaField javaField = (JavaField)javaElement;
                JavaClass javaClass = javaField.getOwningClass();
                SourceClass sourceClass = CommonUtilities.getSourceElement(javaClass, sourceFile);
                return CommonUtilities.getSourceElement(javaField, sourceClass);
            }
            case 4: 
            case 8: {
                JavaMethod javaMethod = (JavaMethod)javaElement;
                JavaClass javaClass = javaMethod.getOwningClass();
                SourceClass sourceClass = CommonUtilities.getSourceElement(javaClass, sourceFile);
                return CommonUtilities.getSourceElement(javaMethod, sourceClass);
            }
        }
        return null;
    }

    public static SourceClass getSourceElement(JavaClass javaClass, SourceFile sourceFile) {
        SourceFile sourceFile2 = sourceFile;
        if (sourceFile2 == null) {
            return null;
        }
        String string = javaClass.getDescriptor();
        for (SourceClass sourceClass : sourceFile2.getSourceClasses()) {
            if (!string.equals(sourceClass.getDescriptor())) continue;
            return sourceClass;
        }
        return null;
    }

    public static SourceClass getSourceElement(JavaClass javaClass, SourceClass sourceClass) {
        SourceClass sourceClass2 = sourceClass;
        if (sourceClass2 == null) {
            return null;
        }
        String string = javaClass.getName();
        for (SourceClass sourceClass3 : sourceClass2.getSourceClasses()) {
            if (!string.equals(sourceClass3.getName())) continue;
            return sourceClass3;
        }
        return null;
    }

    public static SourceMemberVariable getSourceElement(JavaField javaField, SourceClass sourceClass) {
        SourceClass sourceClass2 = sourceClass;
        if (sourceClass2 == null) {
            return null;
        }
        String string = javaField.getName();
        for (SourceMemberVariable sourceMemberVariable : sourceClass2.getSourceMemberVariables()) {
            if (!string.equals(sourceMemberVariable.getName())) continue;
            return sourceMemberVariable;
        }
        return null;
    }

    public static SourceMethod getSourceElement(JavaMethod javaMethod, SourceClass sourceClass) {
        SourceClass sourceClass2 = sourceClass;
        if (sourceClass == null) {
            return null;
        }
        boolean bl = javaMethod.isConstructor();
        String string = javaMethod.getName();
        Iterator iterator = bl ? sourceClass2.getSourceConstructors().iterator() : sourceClass2.getSourceMethods().iterator();
        boolean bl2 = javaMethod.isVarargs();
        String string2 = javaMethod.getDescriptor();
        while (iterator.hasNext()) {
            SourceMethod sourceMethod = (SourceMethod)iterator.next();
            if (!bl && (!string.equals(sourceMethod.getName()) || bl2 != sourceMethod.isVarargs()) || !string2.equals(sourceMethod.getDescriptor())) continue;
            return sourceMethod;
        }
        return null;
    }

    public static SourceAnnotation getSourceElement(JavaAnnotation javaAnnotation, SourceHasModifiers sourceHasModifiers) {
        if (sourceHasModifiers == null) {
            return null;
        }
        JavaType javaType = javaAnnotation.getResolvedType();
        if (javaType == null) {
            return null;
        }
        for (SourceAnnotation sourceAnnotation : sourceHasModifiers.getSourceAnnotations()) {
            JavaType javaType2;
            JavaAnnotation javaAnnotation2 = (JavaAnnotation)sourceAnnotation.getCompiledObject();
            if (javaAnnotation2 == null || (javaType2 = javaAnnotation2.getResolvedType()) == null || !javaType.equals(javaType2)) continue;
            return sourceAnnotation;
        }
        return null;
    }

    public static boolean isValidImportName(String string) {
        return CommonUtilities.isValidName(string, true, true);
    }

    public static boolean isValidQualifiedName(String string) {
        return CommonUtilities.isValidName(string, true, false);
    }

    public static boolean isValidSimpleName(String string) {
        return CommonUtilities.isValidName(string, false, false);
    }

    private static boolean isValidName(String string, boolean bl, boolean bl2) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (!Character.isJavaIdentifierStart(c)) {
            return false;
        }
        int n2 = 1;
        while (n2 < n) {
            char c2 = string.charAt(n2);
            if (!(Character.isJavaIdentifierPart(c2) || c2 == '.' && bl || c2 == '*' && bl2 && n2 == n - 1)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static JavaClass getTypeErasure(JavaTypeVariable javaTypeVariable) {
        Collection collection = javaTypeVariable.getBounds();
        if (!collection.isEmpty()) {
            JavaType javaType = (JavaType)collection.iterator().next();
            return javaType.getTypeErasure();
        }
        JavaType javaType = javaTypeVariable.getSuperclass();
        if (javaType != null) {
            return javaType.getTypeErasure();
        }
        Collection collection2 = javaTypeVariable.getInterfaces();
        if (collection2.isEmpty()) {
            return null;
        }
        JavaType javaType2 = (JavaType)collection2.iterator().next();
        return javaType2.getTypeErasure();
    }

    public static List immutableCopy(Collection collection) {
        Object[] objectArray = collection.toArray();
        return Arrays.asList(objectArray);
    }

    public static ArrayList mutableCopy(Collection collection) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(collection);
        return arrayList;
    }

    public static String format(String string, String string2) {
        int n;
        if (string2 != null && (n = string.indexOf("{0}")) >= 0) {
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 3);
            string = string3 + string2 + string4;
        }
        return string;
    }

    public static String format(String string, String string2, String string3) {
        int n;
        int n2;
        if (string2 != null && (n2 = string.indexOf("{0}")) >= 0) {
            String string4 = string.substring(0, n2);
            String string5 = string.substring(n2 + 3);
            string = string4 + string2 + string5;
        }
        if (string3 != null && (n = string.indexOf("{1}")) >= 0) {
            String string6 = string.substring(0, n);
            String string7 = string.substring(n + 3);
            string = string6 + string3 + string7;
        }
        return string;
    }

    public static void panic(String string) {
        throw new IllegalStateException(string);
    }

    public static void panic() {
        throw new IllegalStateException();
    }

    public static void unsupported(String string) {
        throw new UnsupportedOperationException(string);
    }

    public static void unsupported() {
        throw new UnsupportedOperationException();
    }

    public static void notImplementedYet() {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

