/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.util.Conversions;

public class MethodHierarchy
extends AbstractCollection
implements JavaConstants {
    private JavaMethod[] methodHierarchy;
    private JavaMethod target;

    public Iterator iterator() {
        if (this.methodHierarchy != null) {
            return Arrays.asList(this.methodHierarchy).iterator();
        }
        if (this.target.isConstructor()) {
            this.methodHierarchy = JavaMethod.EMPTY_ARRAY;
            return Arrays.asList(this.methodHierarchy).iterator();
        }
        return new MethodHierarchyIterator(null);
    }

    public int size() {
        this.calculateHierarchy();
        return this.methodHierarchy.length;
    }

    public boolean isEmpty() {
        if (this.methodHierarchy != null) {
            return this.methodHierarchy.length == 0;
        }
        return new MethodHierarchyIterator(null).hasNext() ^ true;
    }

    public Object[] toArray() {
        this.calculateHierarchy();
        return this.methodHierarchy;
    }

    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    public MethodHierarchy(JavaMethod javaMethod) {
        this.target = javaMethod;
    }

    private void calculateHierarchy() {
        if (this.methodHierarchy != null) {
            return;
        }
        if (this.target.isConstructor()) {
            this.methodHierarchy = JavaMethod.EMPTY_ARRAY;
            return;
        }
        JavaClass javaClass = this.target.getOwningClass();
        if (javaClass == null) {
            this.methodHierarchy = JavaMethod.EMPTY_ARRAY;
            return;
        }
        Iterator iterator = javaClass.getHierarchy().iterator();
        ArrayList<JavaMethod> arrayList = new ArrayList<JavaMethod>();
        while (iterator.hasNext()) {
            JavaType javaType = (JavaType)iterator.next();
            for (JavaMethod javaMethod : javaType.getDeclaredMethods()) {
                if (!Conversions.hasSubsignatureOf(this.target, javaMethod)) continue;
                arrayList.add(javaMethod);
            }
        }
        int n = arrayList.size();
        this.methodHierarchy = n == 0 ? JavaMethod.EMPTY_ARRAY : arrayList.toArray(new JavaMethod[n]);
    }

    static JavaMethod ra$target(MethodHierarchy methodHierarchy) {
        return methodHierarchy.target;
    }

    static JavaMethod[] ra$methodHierarchy(MethodHierarchy methodHierarchy) {
        return methodHierarchy.methodHierarchy;
    }

    static void wa$methodHierarchy(MethodHierarchy methodHierarchy, JavaMethod[] javaMethodArray) {
        methodHierarchy.methodHierarchy = javaMethodArray;
    }

    private class MethodHierarchyIterator
    implements Iterator {
        final ArrayList processed;
        final LinkedList frontier;
        final Iterator classHierarchy;
        JavaMethod current;

        void $init$() {
            this.processed = new ArrayList();
            this.frontier = new LinkedList();
            this.current = null;
        }

        private MethodHierarchyIterator() {
            this.$init$();
            JavaClass javaClass = MethodHierarchy.ra$target(MethodHierarchy.this).getOwningClass();
            this.classHierarchy = javaClass == null ? JavaConstants.kEmptyCollection.iterator() : javaClass.getHierarchy().iterator();
        }

        public boolean hasNext() {
            this.advance();
            if (this.current != null) {
                return true;
            }
            if (MethodHierarchy.ra$methodHierarchy(MethodHierarchy.this) == null) {
                int n = this.processed.size();
                if (n == 0) {
                    MethodHierarchy.wa$methodHierarchy(MethodHierarchy.this, JavaMethod.EMPTY_ARRAY);
                } else {
                    MethodHierarchy.wa$methodHierarchy(MethodHierarchy.this, this.processed.toArray(new JavaMethod[n]));
                }
            }
            return false;
        }

        public Object next() {
            this.advance();
            JavaMethod javaMethod = this.current;
            this.processed.add(javaMethod);
            this.current = null;
            return javaMethod;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advance() {
            while (this.current == null) {
                if (!this.frontier.isEmpty()) {
                    this.current = (JavaMethod)this.frontier.removeFirst();
                    continue;
                }
                if (!this.classHierarchy.hasNext()) {
                    return;
                }
                JavaType javaType = (JavaType)this.classHierarchy.next();
                for (JavaMethod javaMethod : javaType.getDeclaredMethods()) {
                    if (!Conversions.hasSubsignatureOf(MethodHierarchy.ra$target(MethodHierarchy.this), javaMethod)) continue;
                    this.frontier.add(javaMethod);
                }
            }
        }

        MethodHierarchyIterator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

