/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.ParameterizedClass;
import oracle.javatools.parser.java.v2.common.WildcardType;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaIsGeneric;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;

final class Parameterization
implements JavaConstants {
    private static final LinkedHashMap kEmptyMap = new LinkedHashMap();
    final JavaProvider provider;
    final JavaIsGeneric baseObject;
    final JavaType[] boundArguments;
    private final LinkedHashMap argumentMap;

    Parameterization(JavaProvider javaProvider, JavaIsGeneric javaIsGeneric, JavaType[] javaTypeArray) {
        JavaClass javaClass;
        this.provider = javaProvider;
        this.baseObject = javaIsGeneric;
        this.boundArguments = javaTypeArray;
        LinkedHashMap linkedHashMap = null;
        if (javaTypeArray.length > 0) {
            linkedHashMap = new LinkedHashMap();
            Iterator iterator = javaIsGeneric.getTypeParameters().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                linkedHashMap.put(iterator.next(), javaTypeArray[n++]);
            }
        }
        if ((javaClass = javaIsGeneric.getOwningClass()) instanceof ParameterizedClass) {
            ParameterizedClass parameterizedClass = (ParameterizedClass)javaClass;
            if (!parameterizedClass.params.argumentMap.isEmpty()) {
                if (linkedHashMap == null) {
                    linkedHashMap = new LinkedHashMap();
                }
                linkedHashMap.putAll(parameterizedClass.params.argumentMap);
            }
        }
        this.argumentMap = linkedHashMap == null ? kEmptyMap : linkedHashMap;
    }

    Parameterization(JavaIsGeneric javaIsGeneric, Parameterization parameterization) {
        this.provider = parameterization.provider;
        this.baseObject = javaIsGeneric;
        this.boundArguments = JavaType.EMPTY_ARRAY;
        this.argumentMap = parameterization.argumentMap;
    }

    final JavaType bind(JavaType javaType) {
        JavaType[] javaTypeArray;
        int n;
        JavaClass javaClass;
        JavaType javaType2;
        if (javaType == null) {
            return null;
        }
        if (javaType.isPrimitive()) {
            return javaType;
        }
        if (javaType.isArray()) {
            JavaType javaType3 = this.bind(javaType.getComponentType());
            if (javaType3 == javaType) {
                return javaType;
            }
            return CommonUtilities.createArrayType(this.provider, javaType3, 1);
        }
        switch (javaType.getElementKind()) {
            case 11: {
                Collection collection;
                JavaWildcardType javaWildcardType = (JavaWildcardType)javaType;
                JavaType javaType4 = null;
                JavaType javaType5 = null;
                Collection collection2 = javaWildcardType.getUpperBounds();
                if (!collection2.isEmpty()) {
                    javaType4 = (JavaType)collection2.iterator().next();
                }
                if (!(collection = javaWildcardType.getLowerBounds()).isEmpty()) {
                    javaType5 = (JavaType)collection.iterator().next();
                }
                JavaType javaType6 = this.bind(javaType4);
                JavaType javaType7 = this.bind(javaType5);
                if (javaType4 == javaType6 && javaType5 == javaType7) {
                    return javaType;
                }
                return new WildcardType(javaType6, javaType7, this.provider);
            }
            case 10: {
                JavaType javaType8 = (JavaType)this.argumentMap.get(javaType);
                if (javaType8 == null) {
                    return javaType;
                }
                return javaType8;
            }
        }
        if (javaType.isMemberClass() && (javaType2 = this.bind(javaClass = javaType.getOwningClass())) != javaClass && (javaType = javaType2.getDeclaredClass(javaType.getName())) == null) {
            return null;
        }
        if (!javaType.hasActualTypeArguments()) {
            return javaType;
        }
        Collection collection = javaType.getActualTypeArguments();
        JavaType[] javaTypeArray2 = collection.toArray(new JavaType[n = collection.size()]);
        if (javaTypeArray2 == (javaTypeArray = this.bindImpl(javaTypeArray2))) {
            return javaType;
        }
        ParameterizedClass parameterizedClass = (ParameterizedClass)javaType;
        try {
            ParameterizedClass parameterizedClass2 = new ParameterizedClass(this.provider, parameterizedClass.thing, javaTypeArray);
            return parameterizedClass2;
        }
        catch (ClassCastException classCastException) {
            JavaType javaType9 = javaType;
            return javaType9;
        }
    }

    final Collection bind(Collection collection) {
        JavaType[] javaTypeArray;
        if (collection.isEmpty()) {
            return JavaConstants.kEmptyCollection;
        }
        int n = collection.size();
        JavaType[] javaTypeArray2 = collection.toArray(new JavaType[n]);
        if (javaTypeArray2 == (javaTypeArray = this.bindImpl(javaTypeArray2))) {
            return collection;
        }
        return Arrays.asList(javaTypeArray);
    }

    private JavaType[] bindImpl(JavaType[] javaTypeArray) {
        int n = javaTypeArray.length;
        if (n == 0) {
            return javaTypeArray;
        }
        JavaType[] javaTypeArray2 = new JavaType[n];
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            JavaType javaType;
            JavaType javaType2 = javaTypeArray[n2];
            javaTypeArray2[n2] = javaType = this.bind(javaType2);
            if (javaType2 != javaType) {
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            return javaTypeArray;
        }
        return javaTypeArray2;
    }
}

