/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.Parameterization;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.WrapperClass;
import oracle.javatools.parser.java.v2.common.WrapperField;
import oracle.javatools.parser.java.v2.common.WrapperLocalVariable;
import oracle.javatools.parser.java.v2.common.WrapperMethod;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.UnresolvedType;

final class ParameterizedClass
extends WrapperClass {
    private final JavaClass owningClass;
    final Parameterization params;
    private JavaType boundSuperclass;
    private Collection boundInterfaces;
    private Collection fields;
    private Collection methods;
    private Collection constructors;
    private Collection classes;

    void $init$() {
        this.boundSuperclass = null;
        this.boundInterfaces = null;
        this.fields = null;
        this.methods = null;
        this.constructors = null;
        this.classes = null;
    }

    ParameterizedClass(JavaProvider javaProvider, JavaClass javaClass, JavaType[] javaTypeArray) {
        super(javaClass);
        this.$init$();
        this.params = new Parameterization(javaProvider, javaClass, javaTypeArray);
        this.owningClass = null;
    }

    private ParameterizedClass(JavaClass javaClass, Parameterization parameterization) {
        super((JavaClass)parameterization.baseObject);
        this.$init$();
        this.params = parameterization;
        this.owningClass = javaClass;
    }

    public JavaClass getOwningClass() {
        if (this.owningClass == null) {
            return super.getOwningClass();
        }
        return this.owningClass;
    }

    public boolean hasActualTypeArguments() {
        return this.params.boundArguments.length > 0;
    }

    public Collection getActualTypeArguments() {
        if (this.params.boundArguments.length == 0) {
            return JavaConstants.kEmptyCollection;
        }
        return Arrays.asList(this.params.boundArguments);
    }

    public JavaClass getTypeErasure() {
        return super.getTypeErasure();
    }

    public String getQualifiedName() {
        JavaClass javaClass = this.getOwningClass();
        String string = javaClass == null ? this.thing.getQualifiedName() : javaClass.getQualifiedName() + '.' + this.getName();
        if (string.length() == 0) {
            return "";
        }
        int n = this.params.boundArguments.length;
        if (n == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('<');
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            JavaType javaType;
            if (bl) {
                stringBuffer.append(',');
            }
            if ((javaType = this.params.boundArguments[n2]) != null) {
                stringBuffer.append(javaType.getQualifiedName());
            } else {
                stringBuffer.append('N');
            }
            bl = true;
            ++n2;
        }
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    public String getDescriptor() {
        JavaClass javaClass = this.getTypeErasure();
        if (javaClass != null) {
            return javaClass.getDescriptor();
        }
        return super.getDescriptor();
    }

    public JavaType getSuperclass() {
        if (this.boundSuperclass == null) {
            JavaType javaType = super.getSuperclass();
            if (javaType == null) {
                return null;
            }
            this.boundSuperclass = this.params.bind(javaType);
        }
        return this.boundSuperclass;
    }

    public Collection getInterfaces() {
        if (this.boundInterfaces == null) {
            this.boundInterfaces = this.params.bind(super.getInterfaces());
        }
        return this.boundInterfaces;
    }

    public Collection getDeclaredFields() {
        if (this.fields == null) {
            Collection collection = super.getDeclaredFields();
            if (collection.isEmpty()) {
                this.fields = collection;
            } else {
                BoundMemberField[] boundMemberFieldArray = new BoundMemberField[collection.size()];
                Iterator iterator = collection.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    JavaField javaField = (JavaField)iterator.next();
                    boundMemberFieldArray[n++] = new BoundMemberField(javaField, null);
                }
                this.fields = Arrays.asList(boundMemberFieldArray);
            }
        }
        return this.fields;
    }

    public Collection getDeclaredMethods() {
        if (this.methods == null) {
            Collection collection = super.getDeclaredMethods();
            if (collection.isEmpty()) {
                this.methods = collection;
            } else {
                BoundMemberMethod[] boundMemberMethodArray = new BoundMemberMethod[collection.size()];
                Iterator iterator = collection.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    JavaMethod javaMethod = (JavaMethod)iterator.next();
                    boundMemberMethodArray[n++] = new BoundMemberMethod(javaMethod, null);
                }
                this.methods = Arrays.asList(boundMemberMethodArray);
            }
        }
        return this.methods;
    }

    public Collection getDeclaredConstructors() {
        if (this.constructors == null) {
            Collection collection = super.getDeclaredConstructors();
            if (collection.isEmpty()) {
                this.constructors = collection;
            } else {
                BoundMemberMethod[] boundMemberMethodArray = new BoundMemberMethod[collection.size()];
                Iterator iterator = collection.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    JavaMethod javaMethod = (JavaMethod)iterator.next();
                    boundMemberMethodArray[n++] = new BoundMemberMethod(javaMethod, null);
                }
                this.constructors = Arrays.asList(boundMemberMethodArray);
            }
        }
        return this.constructors;
    }

    public Collection getDeclaredClasses() {
        if (this.classes == null) {
            Collection collection = super.getDeclaredClasses();
            if (collection.isEmpty()) {
                this.classes = collection;
            } else {
                ParameterizedClass[] parameterizedClassArray = new ParameterizedClass[collection.size()];
                Iterator iterator = collection.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    JavaClass javaClass = (JavaClass)iterator.next();
                    Parameterization parameterization = new Parameterization(javaClass, this.params);
                    parameterizedClassArray[n++] = new ParameterizedClass(this, parameterization);
                }
                this.classes = Arrays.asList(parameterizedClassArray);
            }
        }
        return this.classes;
    }

    private class BoundMemberField
    extends WrapperField {
        private JavaType type;

        void $init$() {
            this.type = null;
        }

        private BoundMemberField(JavaField javaField) {
            super(javaField);
            this.$init$();
        }

        public JavaType getResolvedType() {
            if (this.type == null) {
                this.type = ParameterizedClass.this.params.bind(this.thing.getResolvedType());
            }
            return this.type;
        }

        public JavaClass getOwningClass() {
            return ParameterizedClass.this;
        }

        BoundMemberField(JavaField javaField, 1 var3_3) {
            this(javaField);
        }

        public final class 1 {
        }
    }

    private class BoundMemberMethod
    extends WrapperMethod {
        private JavaType type;
        private Collection parameters;
        private Collection exceptions;

        void $init$() {
            this.type = null;
            this.parameters = null;
            this.exceptions = null;
        }

        private BoundMemberMethod(JavaMethod javaMethod) {
            super(javaMethod);
            this.$init$();
        }

        public JavaType getResolvedType() {
            if (this.type == null) {
                this.type = ParameterizedClass.this.params.bind(this.thing.getResolvedType());
                if (this.type == null) {
                    this.type = PrimitiveType.PRIMITIVE_objects[9];
                }
            }
            return this.type;
        }

        public Collection getParameters() {
            if (this.parameters == null) {
                Collection collection = this.thing.getParameters();
                if (collection.isEmpty()) {
                    this.parameters = collection;
                } else {
                    BoundParameter[] boundParameterArray = new BoundParameter[collection.size()];
                    Iterator iterator = collection.iterator();
                    int n = 0;
                    while (iterator.hasNext()) {
                        JavaLocalVariable javaLocalVariable = (JavaLocalVariable)iterator.next();
                        boundParameterArray[n++] = new BoundParameter(javaLocalVariable, null);
                    }
                    this.parameters = Arrays.asList(boundParameterArray);
                }
            }
            return this.parameters;
        }

        public Collection getExceptions() {
            if (this.exceptions == null) {
                this.exceptions = ParameterizedClass.this.params.bind(this.thing.getExceptions());
            }
            return this.exceptions;
        }

        public JavaClass getOwningClass() {
            return ParameterizedClass.this;
        }

        BoundMemberMethod(JavaMethod javaMethod, 1 var3_3) {
            this(javaMethod);
        }

        private class BoundParameter
        extends WrapperLocalVariable {
            private JavaType type;

            void $init$() {
                this.type = null;
            }

            private BoundParameter(JavaLocalVariable javaLocalVariable) {
                super(javaLocalVariable);
                this.$init$();
            }

            public JavaType getResolvedType() {
                if (this.type == null) {
                    this.type = ParameterizedClass.this.params.bind(this.thing.getResolvedType());
                }
                return this.type;
            }

            public UnresolvedType getUnresolvedType() {
                return this.thing.getUnresolvedType();
            }

            public JavaElement getOwner() {
                return BoundMemberMethod.this;
            }

            BoundParameter(JavaLocalVariable javaLocalVariable, 1 var3_3) {
                this(javaLocalVariable);
            }

            public final class 1 {
            }
        }

        public final class 1 {
        }
    }
}

