/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.HashMap;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaTokens;
import oracle.javatools.parser.java.v2.common.AbstractClass;
import oracle.javatools.parser.java.v2.model.JavaType;

public final class PrimitiveType
extends AbstractClass
implements JavaConstants {
    public static final PrimitiveType[] PRIMITIVE_objects = new PrimitiveType[10];
    public static final PrimitiveType[] PRIMITIVE_lookup = new PrimitiveType[50];
    public static final PrimitiveType[] PRIMITIVE_alpha = new PrimitiveType[26];
    private static final HashMap PRIMITIVE_hashtable;
    private static final HashMap PRIMITIVE_unboxing;
    private static final int NARROWING_BIT = 16;
    private static final int WIDENING_BIT = 8;
    private static final int MASK_ID = 15;
    private static final int FL_INTEGER = 16;
    private static final int FL_NUMERIC = 32;
    private static int[] PRIMITIVE_flags;
    public final byte primCode;

    static {
        byte by = 0;
        while (by < 10) {
            String string;
            char c;
            PrimitiveType primitiveType;
            PrimitiveType.PRIMITIVE_objects[by] = primitiveType = new PrimitiveType(by);
            short s = JavaConstants.PRIMITIVE_tokens[by];
            if (96 <= s && s < 146) {
                PrimitiveType.PRIMITIVE_lookup[s - 96] = primitiveType;
            }
            if ('A' <= (c = (string = JavaConstants.PRIMITIVE_descriptors[by]).charAt(0)) && c <= 'Z') {
                PrimitiveType.PRIMITIVE_alpha[c - 65] = primitiveType;
            }
            by = (byte)(by + 1);
        }
        PRIMITIVE_hashtable = new HashMap();
        int n = 0;
        while (n < 10) {
            short s = JavaConstants.PRIMITIVE_tokens[n];
            if (96 <= s && s < 146) {
                String string = JavaTokens.KW_words[s - 96];
                PRIMITIVE_hashtable.put(string, PRIMITIVE_objects[n]);
            }
            n = (byte)(n + 1);
        }
        PRIMITIVE_unboxing = new HashMap();
        int n2 = 0;
        while (n2 < 10) {
            String string = JavaConstants.PRIMITIVE_autoboxes[n2];
            if (string != null) {
                PRIMITIVE_unboxing.put(string, PRIMITIVE_objects[n2]);
            }
            n2 = (byte)(n2 + 1);
        }
        PRIMITIVE_flags = new int[]{0, 64049, 717874, 456755, 978996, 2023477, 4112422, 8290343, 0, 0};
    }

    public static PrimitiveType lookupPrimitive(String string) {
        Object v = PRIMITIVE_hashtable.get(string);
        if (v == null) {
            return null;
        }
        return (PrimitiveType)v;
    }

    public static PrimitiveType applyUnboxingConversion(JavaType javaType) {
        String string = javaType.getVMName();
        if (!string.startsWith("java/lang/")) {
            return null;
        }
        return (PrimitiveType)PRIMITIVE_unboxing.get(string);
    }

    public static boolean isNumeric(PrimitiveType primitiveType) {
        int n = PRIMITIVE_flags[primitiveType.primCode];
        return (n & 0x20) != 0;
    }

    public static boolean applyWideningConversion(PrimitiveType primitiveType, PrimitiveType primitiveType2) {
        if (primitiveType == null) {
            return false;
        }
        if (primitiveType.primCode == primitiveType2.primCode) {
            return true;
        }
        if (!PrimitiveType.isNumeric(primitiveType) || !PrimitiveType.isNumeric(primitiveType2)) {
            return false;
        }
        int n = PRIMITIVE_flags[primitiveType.primCode];
        int n2 = 1 << 8 + primitiveType2.primCode;
        return (n & n2) != 0;
    }

    public static boolean applyNarrowingConversion(PrimitiveType primitiveType, PrimitiveType primitiveType2) {
        if (primitiveType == null) {
            return false;
        }
        if (primitiveType.primCode == primitiveType2.primCode) {
            return true;
        }
        if (!PrimitiveType.isNumeric(primitiveType) || !PrimitiveType.isNumeric(primitiveType2)) {
            return false;
        }
        int n = PRIMITIVE_flags[primitiveType.primCode];
        int n2 = 1 << 16 + primitiveType2.primCode;
        return (n & n2) != 0;
    }

    public boolean isNumeric() {
        return 1 <= this.primCode && this.primCode <= 7;
    }

    public boolean isIntegral() {
        return 1 <= this.primCode && this.primCode <= 5;
    }

    public boolean isFloatingPoint() {
        return this.primCode == 6 || this.primCode == 7;
    }

    public String getQualifiedName() {
        return this.getName();
    }

    public String getVMName() {
        return this.getName();
    }

    public String getName() {
        short s = JavaConstants.PRIMITIVE_tokens[this.primCode];
        if (s != 15) {
            return JavaTokens.KW_words[s - 96];
        }
        return "null";
    }

    public String getDescriptor() {
        return JavaConstants.PRIMITIVE_descriptors[this.primCode];
    }

    public String getTypeSignature() {
        return this.getDescriptor();
    }

    public String getSignature() {
        return this.getDescriptor();
    }

    public int getModifiers() {
        return 17;
    }

    public boolean isPrimitive() {
        return true;
    }

    protected PrimitiveType(byte by) {
        this.primCode = by;
    }
}

