/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.Collection;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.common.AbstractMethod;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.QuickLocalVariable;
import oracle.javatools.parser.java.v2.common.QuickUnresolvedType;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.UnresolvedType;

public final class QuickMethod
extends AbstractMethod {
    private final JavaClass methodOwning;
    private final char methodAccess;
    private final JavaType methodReturnType;
    private final String methodName;
    private final Collection methodParameters;
    private final Collection methodExceptions;

    public static QuickMethod createMethod(JavaClass javaClass, char c, JavaType javaType, String string, Collection collection, Collection collection2) {
        return new QuickMethod(javaClass, c, javaType, string, collection, collection2);
    }

    public int getModifiers() {
        return this.methodAccess;
    }

    public JavaType getResolvedType() {
        return this.methodReturnType;
    }

    public UnresolvedType getUnresolvedType() {
        if (this.methodReturnType != null) {
            return this.methodReturnType.getUnresolvedType();
        }
        return QuickUnresolvedType.EMPTY_UNRESOLVED_TYPE;
    }

    public String getName() {
        return this.methodName;
    }

    public Collection getParameters() {
        return this.methodParameters;
    }

    public Collection getExceptions() {
        return this.methodExceptions;
    }

    public JavaClass getOwningClass() {
        return this.methodOwning;
    }

    public boolean isConstructor() {
        return "<init>".equals(this.methodName);
    }

    private QuickMethod(JavaClass javaClass, char c, JavaType javaType, String string, Collection collection, Collection collection2) {
        if (javaType == null) {
            javaType = PrimitiveType.PRIMITIVE_objects[9];
        }
        if (collection == null) {
            collection = JavaConstants.kEmptyCollection;
        }
        if (collection2 == null) {
            collection2 = JavaConstants.kEmptyCollection;
        }
        this.methodOwning = javaClass;
        this.methodAccess = c;
        this.methodReturnType = javaType;
        this.methodName = string;
        this.methodParameters = collection;
        this.methodExceptions = collection2;
        if (!collection.isEmpty()) {
            for (Object e : collection) {
                if (!(e instanceof QuickLocalVariable)) continue;
                QuickLocalVariable quickLocalVariable = (QuickLocalVariable)e;
                quickLocalVariable.setOwner(this);
            }
        }
    }
}

