/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.Arrays;
import java.util.Collection;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.AbstractType;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;

final class WildcardType
extends AbstractType
implements JavaWildcardType {
    public final JavaType wildcardUpper;
    public final JavaType wildcardLower;
    public final JavaProvider provider;

    WildcardType(JavaType javaType, JavaType javaType2, JavaProvider javaProvider) {
        this.wildcardUpper = javaType;
        this.wildcardLower = javaType2;
        this.provider = javaProvider;
    }

    public int getElementKind() {
        return 11;
    }

    public boolean isInterface() {
        return false;
    }

    public String getName() {
        return "?";
    }

    public String getQualifiedName() {
        if (this.wildcardUpper != null) {
            return "? extends " + this.wildcardUpper.getQualifiedName();
        }
        if (this.wildcardLower != null) {
            return "? super " + this.wildcardLower.getQualifiedName();
        }
        return this.getName();
    }

    public String getVMName() {
        if (this.wildcardUpper != null) {
            return "? extends " + this.wildcardUpper.getVMName();
        }
        if (this.wildcardLower != null) {
            return "? super " + this.wildcardLower.getVMName();
        }
        return this.getName();
    }

    public String getDescriptor() {
        JavaClass javaClass = this.getTypeErasure();
        if (javaClass != null) {
            return javaClass.getDescriptor();
        }
        return "Ljava/lang/Object;";
    }

    public String getTypeSignature() {
        if (this.wildcardUpper != null) {
            return '+' + this.wildcardUpper.getTypeSignature();
        }
        if (this.wildcardLower != null) {
            return '-' + this.wildcardLower.getTypeSignature();
        }
        return "*";
    }

    public String getSignature() {
        return this.getTypeSignature();
    }

    public String getUniqueIdentifier() {
        return CommonUtilities.getUniqueIdentifier(this);
    }

    public JavaClass getTypeErasure() {
        if (this.wildcardLower != null) {
            return this.wildcardLower.getTypeErasure();
        }
        return this.provider.getClassByVMName("java/lang/Object");
    }

    public JavaType getSuperclass() {
        if (this.wildcardLower == null) {
            return this.provider.getClassByVMName("java/lang/Object");
        }
        if (this.wildcardLower.isInterface()) {
            return this.wildcardLower.getSuperclass();
        }
        return this.wildcardLower.getTypeErasure();
    }

    public Collection getInterfaces() {
        if (this.wildcardLower != null && this.wildcardLower.isInterface()) {
            return Arrays.asList((JavaClass)this.wildcardLower);
        }
        return JavaConstants.kEmptyCollection;
    }

    public JavaType getUpperBound() {
        return this.wildcardUpper;
    }

    public JavaType getLowerBound() {
        return this.wildcardLower;
    }

    public Collection getUpperBounds() {
        JavaType javaType = this.getUpperBound();
        if (javaType != null) {
            return Arrays.asList(javaType);
        }
        return JavaConstants.kEmptyCollection;
    }

    public Collection getLowerBounds() {
        JavaType javaType = this.getLowerBound();
        if (javaType != null) {
            return Arrays.asList(javaType);
        }
        return JavaConstants.kEmptyCollection;
    }
}

