/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal;

import oracle.javatools.editor.resource.BundleHelper;
import oracle.javatools.parser.java.v2.JavaErrors;
import oracle.javatools.parser.java.v2.JavaTokens;
import oracle.javatools.parser.java.v2.JavadocTokens;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.InternalConstants;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaType;

public abstract class InternalUtilities
extends CommonUtilities
implements InternalConstants {
    protected static final BundleHelper resources = new BundleHelper("oracle.javatools.parser.resource.ParserBundle");
    protected static final String[] ERROR_loaded = new String[JavaErrors.ERROR_words.length];

    public static boolean isCommentToken(int n) {
        switch (n) {
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    public static boolean srcIsStmt(int n) {
        return 29 <= n && n < 47;
    }

    public static boolean srcIsExpr(int n) {
        return 47 <= n && n < 63;
    }

    public static boolean srcIsLexical(int n) {
        return 70 <= n && n < 73;
    }

    public static String op2text(short s) {
        return JavaTokens.OP_words[s - 32];
    }

    public static String kw2text(short s) {
        return JavaTokens.KW_words[s - 96];
    }

    public static char ty2access(byte by) {
        switch (by) {
            case 0: {
                return '\u0000';
            }
            case 1: {
                return '\u0200';
            }
            case 2: {
                return '\u4000';
            }
            case 3: {
                return '\u2200';
            }
        }
        throw new IllegalArgumentException("Unknown tykind: " + by);
    }

    public static byte access2ty(char c) {
        if ((c & 0x2000) != 0) {
            return 3;
        }
        if ((c & 0x4000) != 0) {
            return 2;
        }
        if ((c & 0x200) != 0) {
            return 1;
        }
        return 0;
    }

    public static String tag2name(short s) {
        if (202 <= s && s < 222) {
            return JavadocTokens.TAG_words[s - 202];
        }
        return "@unknown";
    }

    public static int error2severity(int n) {
        if (n == 2) {
            return 4;
        }
        int n2 = JavaErrors.ERROR_warnings.length;
        int n3 = 0;
        while (n3 < n2) {
            if (n == JavaErrors.ERROR_warnings[n3]) {
                return 2;
            }
            ++n3;
        }
        return 3;
    }

    public static int error2category(int n) {
        if (4 <= n && n < 8) {
            return 1;
        }
        if (8 <= n && n < 33) {
            return 2;
        }
        if (33 <= n && n < 74) {
            return 4;
        }
        return 0;
    }

    private static String loadErrorMessage(int n) {
        if (resources != null) {
            String string = JavaErrors.ERROR_keys[n];
            String string2 = resources.getString(string);
            if (string2 != null) {
                return string2;
            }
            return "Missing resource '" + string + "'";
        }
        return JavaErrors.ERROR_words[n];
    }

    public static String error2message(int n) {
        if (1 <= n && n < 74) {
            String string;
            int n2 = n - 1;
            String string2 = ERROR_loaded[n2];
            if (string2 != null) {
                return string2;
            }
            InternalUtilities.ERROR_loaded[n2] = string = InternalUtilities.loadErrorMessage(n2);
            return string;
        }
        return "Error";
    }

    public static JavaType getOuterClassOfNonstaticInner(ClassSym classSym) {
        Sym sym = classSym.getParentSym();
        if (sym == null) {
            return null;
        }
        switch (sym.symKind) {
            case 74: {
                return null;
            }
            case 4: {
                if (classSym.isStatic()) {
                    return null;
                }
                return classSym.getOwningClassSym();
            }
        }
        Sym sym2 = sym;
        while (sym2 != null) {
            switch (sym2.symKind) {
                case 4: {
                    return sym2.getOwningClassSym();
                }
            }
            if (sym2.isStatic()) {
                return null;
            }
            sym2 = sym2.symParent;
        }
        return null;
    }

    protected static JavaType getOuterClassOfNonstaticInner(JavaType javaType) {
        if (javaType == null) {
            return null;
        }
        if (javaType instanceof ClassSym) {
            return InternalUtilities.getOuterClassOfNonstaticInner((ClassSym)javaType);
        }
        if (javaType.isExported()) {
            if (javaType.isStatic()) {
                return null;
            }
        } else {
            boolean bl;
            JavaField javaField = javaType.getDeclaredField("this$0");
            boolean bl2 = bl = javaField != null && javaField.isSynthetic();
            if (!bl) {
                return null;
            }
        }
        JavaClass javaClass = javaType.getOwningClass();
        return javaClass;
    }
}

