/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.internal.compiler.CallerContextImpl;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerLayer1;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.ImportSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.TypeArgumentSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ClassCreatorExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;

abstract class CompilerLayer2
extends CompilerLayer1 {
    protected abstract JavaType processInnerCreatorType(Expr var1, String var2);

    public final JavaType resolve(TypeSym typeSym) {
        JavaType javaType;
        this.checkCancel();
        if (typeSym == null) {
            return null;
        }
        typeSym.setProcessed();
        CompilerContext compilerContext = this.context;
        short s = typeSym.typeToken;
        if (96 <= s && s < 146) {
            javaType = PrimitiveType.PRIMITIVE_lookup[s - 96];
            if (javaType == null) {
                this.error(typeSym, (short)69, typeSym.getName());
            }
        } else {
            String string = typeSym.getName();
            if (string.length() == 0) {
                return (JavaType)this.error(typeSym, (short)50);
            }
            try {
                this.context = this.newContext(typeSym);
                TypeSym typeSym2 = typeSym.getTypeSym();
                JavaType javaType2 = null;
                if (typeSym2 != null && (javaType2 = typeSym2.getResolvedType()) == null) {
                    JavaType javaType3 = null;
                    this.context = compilerContext;
                    return javaType3;
                }
                javaType = this.processType(javaType2, string);
                if (javaType == null) {
                    JavaType javaType4 = (JavaType)this.error(typeSym, (short)69, string);
                    this.context = compilerContext;
                    return javaType4;
                }
                if (!this.context.allowAccess(javaType)) {
                    JavaType javaType5 = (JavaType)this.error(typeSym, (short)57, javaType);
                    this.context = compilerContext;
                    return javaType5;
                }
                this.recordUsage(typeSym, javaType);
            }
            finally {
                this.context = compilerContext;
            }
        }
        javaType = this.processTypeFilters(typeSym, javaType);
        List list = typeSym.getTypeArguments();
        if (!list.isEmpty()) {
            try {
                this.context = this.newContext(typeSym);
                javaType = this.processTypeArguments1(javaType, list);
            }
            finally {
                this.context = compilerContext;
            }
        }
        if (javaType == null) {
            return null;
        }
        int n = typeSym.getArrayDimension();
        return this.provider.getArrayType(javaType, n);
    }

    public final void compile(TypeSym typeSym) {
        this.checkCancel();
        if (typeSym == null) {
            return;
        }
        JavaType javaType = typeSym.getResolvedType();
        if (javaType == null) {
            return;
        }
        CompilerContext compilerContext = this.context;
        List list = typeSym.getTypeArguments();
        if (!list.isEmpty()) {
            try {
                this.context = this.newContext(typeSym);
                this.processTypeArguments2(javaType);
            }
            finally {
                this.context = compilerContext;
            }
        }
    }

    public final JavaType resolve(TypeArgumentSym typeArgumentSym) {
        JavaType javaType;
        TypeSym typeSym;
        byte by = typeArgumentSym.argBound;
        if (by != 3 && (typeSym = typeArgumentSym.getTypeSym()) != null && (javaType = typeSym.getResolvedType()) != null) {
            return CommonUtilities.createWildcardType(by, javaType, this.provider);
        }
        return CommonUtilities.createWildcardType((byte)3, null, this.provider);
    }

    public final JavaType resolveType(Sym sym, String string) {
        if (string.indexOf(91) >= 0 || string.indexOf(60) >= 0) {
            if (sym == null) {
                return null;
            }
            SymFactory symFactory = sym.symFile.getSymFactory();
            TypeSym typeSym = (TypeSym)symFactory.createTypeFromText(string);
            if (typeSym == null) {
                return null;
            }
            CallerContextImpl callerContextImpl = (CallerContextImpl)CallerContext.createContext(sym, false);
            return callerContextImpl.compiler.resolve(typeSym);
        }
        PrimitiveType primitiveType = PrimitiveType.lookupPrimitive(string);
        if (primitiveType != null) {
            return primitiveType;
        }
        CompilerContext compilerContext = this.context;
        try {
            this.context = this.newContext(sym);
            JavaType javaType = this.processType(null, string);
            this.context = compilerContext;
            return javaType;
        }
        catch (Throwable throwable) {
            this.context = compilerContext;
            throw throwable;
        }
    }

    protected final JavaType resolveType(Sym sym, JavaType javaType, String string) {
        if (javaType == null) {
            return null;
        }
        CompilerContext compilerContext = this.context;
        try {
            this.context = this.newContext(sym);
            if (!this.context.allowAccess(javaType)) {
                JavaType javaType2 = (JavaType)this.error(this.context.symCookie, (short)57, javaType);
                this.context = compilerContext;
                return javaType2;
            }
            JavaClass javaClass = this.context.findMemberType(javaType, string);
            this.context = compilerContext;
            return javaClass;
        }
        catch (Throwable throwable) {
            this.context = compilerContext;
            throw throwable;
        }
    }

    private JavaType processType(JavaType javaType, String string) {
        if (javaType == null) {
            int n = string.indexOf(46);
            JavaType javaType2 = n == -1 ? this.processSimpleType(string) : this.processQualifiedType(string);
            return javaType2;
        }
        return this.processMemberType(javaType, string);
    }

    private JavaType processTypeArguments1(JavaType javaType, Collection collection) {
        Collection collection2 = javaType.getTypeParameters();
        int n = collection2.size();
        if (n == 0) {
            this.error(null, (short)60, javaType);
            return javaType;
        }
        int n2 = collection.size();
        if (n != n2) {
            this.error(null, (short)67, javaType);
            return javaType;
        }
        JavaType[] javaTypeArray = new JavaType[n2];
        Iterator iterator = collection.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            TypeArgumentSym typeArgumentSym = (TypeArgumentSym)iterator.next();
            javaTypeArray[n3++] = typeArgumentSym.getResolvedType();
        }
        return CommonUtilities.createParameterizedType(this.provider, javaType, javaTypeArray);
    }

    private void processTypeArguments2(JavaType javaType) {
        if (javaType != null && javaType.isArray()) {
            javaType = javaType.getBaseComponentType();
        }
        if (javaType == null) {
            return;
        }
        Collection collection = javaType.getActualTypeArguments();
        if (collection == null || collection.isEmpty()) {
            return;
        }
        Collection collection2 = javaType.getTypeParameters();
        if (collection2 == null || collection2.isEmpty()) {
            return;
        }
        try {
            boolean bl = true;
            Iterator iterator = collection2.iterator();
            Iterator iterator2 = collection.iterator();
            while (iterator.hasNext() && bl) {
                JavaType javaType2 = (JavaType)iterator.next();
                JavaType javaType3 = (JavaType)iterator2.next();
                if (javaType2 != null && javaType3 != null && javaType2.isAssignableFrom(javaType3)) continue;
                bl = false;
            }
            if (bl) {
                return;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.error(null, (short)67, javaType.getTypeErasure());
    }

    private JavaType processTypeFilters(TypeSym typeSym, JavaType javaType) {
        Sym sym = typeSym.getParentSym();
        if (sym == null) {
            return javaType;
        }
        if (javaType.isPrimitive() || javaType.isArray()) {
            switch (sym.symKind) {
                case 25: {
                    this.error(typeSym, (short)61, javaType);
                    break;
                }
                case 15: 
                case 23: {
                    this.error(typeSym, (short)52, javaType);
                }
            }
        } else {
            switch (sym.symKind) {
                case 25: {
                    JavaClass javaClass = this.getPreloadedClass((byte)7);
                    if (javaType.isSubtypeOf(javaClass)) break;
                    return (JavaType)this.error(typeSym, (short)61, javaType);
                }
                case 23: {
                    if (javaType.isInterface()) {
                        return (JavaType)this.error(typeSym, (short)40, javaType);
                    }
                    if (javaType.isEnum()) {
                        return (JavaType)this.error(typeSym, (short)38, javaType);
                    }
                    if (!Modifier.isFinal(javaType.getModifiers())) break;
                    return (JavaType)this.error(typeSym, (short)39, javaType);
                }
                case 15: {
                    if (javaType.isInterface()) break;
                    return (JavaType)this.error(typeSym, (short)41, javaType);
                }
            }
        }
        return javaType;
    }

    private JavaType processSimpleType(String string) {
        ClassCreatorExpr classCreatorExpr;
        Expr expr;
        Sym sym = this.context.symCookie;
        Sym sym2 = sym.getParentSym();
        if (sym2 != null && sym2.symKind == 56 && (expr = (classCreatorExpr = (ClassCreatorExpr)sym2).getLhsOperandSym()) != null) {
            return this.processInnerCreatorType(expr, string);
        }
        Sym sym3 = this.context.cleanScope();
        boolean bl = true;
        while (sym3 != null) {
            switch (sym3.symKind) {
                case 3: {
                    ClassSym classSym = (ClassSym)sym3;
                    if (bl && this.context.findVisibleType(classSym, string)) {
                        return this.context.findMemberType(classSym, string);
                    }
                    JavaType javaType = this.context.findType(sym3, string);
                    if (javaType != null) {
                        return javaType;
                    }
                    bl = true;
                    break;
                }
                case 15: 
                case 23: {
                    bl = false;
                }
                default: {
                    JavaType javaType = this.context.findType(sym3, string);
                    if (javaType == null) break;
                    return javaType;
                }
            }
            sym3 = this.context.nextScope();
        }
        this.context.cleanScope();
        return this.findImportedType(string);
    }

    private JavaType processQualifiedType(String string) {
        int n = string.indexOf(46);
        String string2 = string.substring(0, n);
        JavaType javaType = this.processSimpleType(string2);
        if (javaType == null) {
            return this.provider.getClass(string);
        }
        return this.processMemberType(javaType, string.substring(n + 1));
    }

    private JavaType processMemberType(JavaType javaType, String string) {
        JavaType javaType2 = javaType;
        int n = -1;
        while (javaType2 != null) {
            this.recordUsage(this.context.symCookie, javaType2);
            if (!this.context.allowAccess(javaType2)) {
                return (JavaType)this.error(this.context.symCookie, (short)57, javaType2);
            }
            int n2 = string.indexOf(46, n + 1);
            String string2 = n2 == -1 ? string.substring(n + 1) : string.substring(n + 1, n2);
            javaType2 = this.context.findMemberType(javaType2, string2);
            if (n2 == -1) break;
            n = n2;
        }
        return javaType2;
    }

    protected final JavaType findImportedType(String string) {
        JavaClass javaClass;
        FileSym fileSym = this.context.symCookie.symFile;
        List list = fileSym.getSourceImports();
        for (ImportSym importSym : list) {
            ArrayList arrayList;
            String string2;
            int n;
            String string3;
            if (!importSym.isNarrow() || !(string3 = (n = (string2 = importSym.getName()).lastIndexOf(46)) == -1 ? string2 : string2.substring(n + 1)).equals(string)) continue;
            importSym.setUsed();
            if (importSym.isInvalid()) {
                return null;
            }
            importSym.resolve();
            if (!importSym.isStatic()) {
                return (JavaType)importSym.getImportedElementAt(0);
            }
            JavaClass javaClass2 = this.provider.getClass(string2);
            if (javaClass2 != null && (arrayList = importSym.getImportObj().importList) != null && !arrayList.contains(javaClass2)) {
                arrayList.add(javaClass2);
            }
            return javaClass2;
        }
        String string4 = fileSym.getPackageName();
        if (string4.length() > 0) {
            JavaClass javaClass3 = this.provider.getClass(string4, string);
            if (javaClass3 != null) {
                return javaClass3;
            }
        } else {
            JavaClass javaClass4 = this.provider.getClass(string);
            if (javaClass4 != null) {
                return javaClass4;
            }
        }
        ImportSym importSym = null;
        JavaClass javaClass5 = null;
        boolean bl = false;
        ArrayList arrayList = CompilerLayer2.allocArrayList();
        try {
            for (ImportSym importSym2 : list) {
                if (importSym2.isNarrow() || importSym2.isInvalid()) continue;
                String string5 = importSym2.getName();
                if ("java.lang.*".equals(string5)) {
                    bl = true;
                }
                if (arrayList.contains(string5)) continue;
                arrayList.add(string5);
                String string6 = string5.substring(0, string5.length() - 2);
                JavaClass javaClass6 = this.provider.getClass(string6, string);
                if (javaClass6 == null) continue;
                if (javaClass5 != null) {
                    this.error(importSym2, (short)34, string);
                }
                javaClass5 = javaClass6;
                importSym = importSym2;
            }
        }
        finally {
            CompilerLayer2.freeArrayList(arrayList);
        }
        if (!bl && (javaClass = this.provider.getClass("java.lang", string)) != null) {
            if (javaClass5 == null) {
                javaClass5 = javaClass;
            } else {
                this.error(importSym, (short)34, string);
            }
        }
        if (importSym != null) {
            importSym.setUsed();
            ArrayList arrayList2 = importSym.getImportObj().importList;
            if (arrayList2 != null && !arrayList2.contains(javaClass5)) {
                arrayList2.add(javaClass5);
            }
        }
        return javaClass5;
    }

    CompilerLayer2() {
    }
}

