/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerLayer2;
import oracle.javatools.parser.java.v2.internal.compiler.InputImpl;
import oracle.javatools.parser.java.v2.internal.compiler.OutputImpl;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ClassCreatorExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.MethodCallExpr;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.SwitchStmt;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;

abstract class CompilerLayer3a
extends CompilerLayer2
implements CallerContext.Constants {
    protected final JavaHasType resolveName(TreeSym treeSym, JavaHasType javaHasType, boolean bl) {
        String string = treeSym.getName();
        if (string.length() == 0) {
            return null;
        }
        return this.resolveName(treeSym, javaHasType, string, bl);
    }

    protected final JavaHasType resolveName(Sym sym, JavaHasType javaHasType, String string, boolean bl) {
        CompilerContext compilerContext = this.context;
        try {
            JavaHasType javaHasType2;
            this.context = this.newContext(sym);
            if (javaHasType == null) {
                JavaHasType javaHasType3 = this.processSimpleName(string, bl, true);
                if (javaHasType3 == null && !sym.testSymFlag((byte)64)) {
                    this.error(sym, (short)56, string);
                    if (this.flag_forgiving) {
                        javaHasType3 = this.processSimpleName(string, bl, false);
                    }
                }
                javaHasType2 = javaHasType3;
            } else {
                JavaType javaType = this.processLhs(javaHasType);
                javaHasType2 = this.processSimpleSelector(string, javaType, bl);
                if (javaHasType2 == null && !sym.testSymFlag((byte)64)) {
                    this.error(sym, (short)53, string, javaType);
                }
            }
            if (javaHasType2 == null) {
                JavaHasType javaHasType4 = null;
                this.context = compilerContext;
                return javaHasType4;
            }
            this.recordUsage(sym, javaHasType2);
            if (javaHasType != null) {
                this.context.cleanScope();
                if (javaHasType instanceof JavaType) {
                    this.context.flag_instance = false;
                }
            }
            if (this.flag_forgiving || this.context.allowAccess(javaHasType2)) {
                JavaHasType javaHasType5 = javaHasType2;
                this.context = compilerContext;
                return javaHasType5;
            }
            JavaType javaType = (JavaType)this.error(sym, (short)57, javaHasType2);
            this.context = compilerContext;
            return javaType;
        }
        catch (Throwable throwable) {
            this.context = compilerContext;
            throw throwable;
        }
    }

    protected final JavaMethod resolveMethodCall(MethodCallExpr methodCallExpr, JavaHasType javaHasType, JavaType[] javaTypeArray, boolean bl) {
        String string = bl ? "<init>" : methodCallExpr.getName();
        if (string.length() == 0) {
            return (JavaMethod)this.error(methodCallExpr, (short)50);
        }
        NameSym nameSym = methodCallExpr.getNameSym();
        Sym sym = methodCallExpr;
        if (nameSym != null) {
            sym = nameSym;
        }
        return this.resolveMethodCall(sym, string, javaHasType, javaTypeArray);
    }

    protected final JavaMethod resolveMethodCall(ClassCreatorExpr classCreatorExpr, JavaHasType javaHasType, JavaType[] javaTypeArray) {
        TypeSym typeSym = classCreatorExpr.getTypeSym();
        TreeSym treeSym = classCreatorExpr;
        if (typeSym != null) {
            treeSym = typeSym;
        }
        return this.resolveMethodCall(treeSym, "<init>", javaHasType, javaTypeArray);
    }

    protected final JavaMethod resolveMethodCall(Sym sym, String string, JavaHasType javaHasType, JavaType[] javaTypeArray) {
        CompilerContext compilerContext = this.context;
        try {
            JavaMethod javaMethod;
            this.context = this.newContext(sym);
            boolean bl = false;
            int n = javaTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (javaTypeArray[n2] == null) {
                    bl = true;
                }
                ++n2;
            }
            if (bl) {
                this.context.suppressErrors = true;
            }
            if ((javaMethod = javaHasType == null ? this.processSimpleMethodCall(string, javaTypeArray, true) : this.processSelectorMethodCall(string, javaHasType, javaTypeArray, true)) != null) {
                this.recordUsage(sym, javaMethod);
                JavaMethod javaMethod2 = javaMethod;
                this.context = compilerContext;
                return javaMethod2;
            }
            JavaType javaType = javaHasType != null ? this.processLhs(javaHasType) : sym.getOwningClassSym();
            this.error(sym, (short)54, string, javaTypeArray, javaType);
            if (!this.flag_forgiving) {
                JavaMethod javaMethod3 = null;
                this.context = compilerContext;
                return javaMethod3;
            }
            javaMethod = javaHasType == null ? this.processSimpleMethodCall(string, javaTypeArray, false) : this.processSelectorMethodCall(string, javaHasType, javaTypeArray, false);
            JavaMethod javaMethod4 = javaMethod;
            this.context = compilerContext;
            return javaMethod4;
        }
        catch (Throwable throwable) {
            this.context = compilerContext;
            throw throwable;
        }
    }

    protected final void resolveExceptions(Expr expr, JavaMethod javaMethod) {
        CompilerContext compilerContext = this.context;
        NameSym nameSym = expr.getNameSym();
        Sym sym = expr;
        if (nameSym != null) {
            sym = nameSym;
        }
        try {
            this.context = this.newContext(sym);
            this.processExceptions(expr, javaMethod);
        }
        finally {
            this.context = compilerContext;
        }
    }

    protected final void checkException(Sym sym, JavaType javaType) {
        if (javaType == null) {
            return;
        }
        JavaClass javaClass = this.getPreloadedClass((byte)7);
        if (javaType.isSubtypeOf(javaClass)) {
            CompilerContext compilerContext = this.context;
            try {
                this.context = this.newContext(sym);
                this.processException(javaType);
            }
            finally {
                this.context = compilerContext;
            }
        } else {
            this.error(sym, (short)61, javaType);
        }
    }

    protected final ClassSym resolveEnclosingScope(Sym sym, JavaType javaType) {
        boolean bl = true;
        CompilerContext compilerContext = this.newContext(sym);
        Sym sym2 = compilerContext.cleanScope();
        while (sym2 != null) {
            ClassSym classSym;
            if (sym2.symKind == 3 && (classSym = (ClassSym)sym2).isSubtypeOf(javaType)) {
                return classSym;
            }
            if (sym2.isStatic()) break;
            sym2 = compilerContext.nextScope();
        }
        return null;
    }

    protected final void listNames(Sym sym, JavaHasType javaHasType, InputImpl inputImpl, OutputImpl outputImpl) {
        if (inputImpl.input == 0) {
            throw new IllegalArgumentException("Empty set");
        }
        if (javaHasType == null && ("this".equals(inputImpl.name) || "super".equals(inputImpl.name))) {
            JavaHasType javaHasType2 = this.resolveName(sym, null, inputImpl.name, true);
            if (javaHasType2 == null) {
                return;
            }
            javaHasType = javaHasType2;
            inputImpl.name = "<init>";
        }
        CompilerContext compilerContext = this.context;
        try {
            this.context = this.newContext(sym);
            if (javaHasType == null) {
                this.processAllPrimaries(inputImpl, outputImpl);
            } else {
                this.processAllSelectors(javaHasType, inputImpl, outputImpl);
            }
        }
        finally {
            this.context = compilerContext;
        }
        if (javaHasType == null && !inputImpl.squash((byte)2) && inputImpl.input((byte)2)) {
            inputImpl.input = (byte)2;
            JavaPackage javaPackage = this.provider.getPackage("");
            this.listNames(sym, javaPackage, inputImpl, outputImpl);
        }
    }

    protected final void listNames(Sym sym, JavaPackage javaPackage, InputImpl inputImpl, OutputImpl outputImpl) {
        if (javaPackage == null) {
            if (inputImpl.squash((byte)2)) {
                inputImpl.input = (byte)(inputImpl.input & 0xFFFFFFFD);
            }
            javaPackage = this.provider.getPackage("");
        }
        if (inputImpl.input == 0) {
            return;
        }
        CompilerContext compilerContext = this.context;
        try {
            this.context = this.newContext(sym);
            this.context.listNames(javaPackage, inputImpl, outputImpl);
        }
        finally {
            this.context = compilerContext;
        }
    }

    private JavaHasType processSimpleName(String string, boolean bl, boolean bl2) {
        boolean bl3 = "this".equals(string);
        boolean bl4 = "super".equals(string);
        Object var6_6 = null;
        Sym sym = this.context.cleanScope();
        while (sym != null) {
            switch (sym.symKind) {
                case 3: {
                    ClassSym classSym = (ClassSym)sym;
                    if (bl3) {
                        JavaVariable javaVariable = classSym.getThisVariable();
                        if (!this.context.flag_instance) {
                            this.error(this.context.symCookie, (short)62, string);
                        }
                        return javaVariable;
                    }
                    if (bl4) {
                        if (this.context.flag_instance) {
                            return classSym.getSuperVariable();
                        }
                        return classSym.getSuperclass();
                    }
                    if (this.context.findVisibleVariable(classSym, string)) {
                        return this.context.findMemberVariable(classSym, string);
                    }
                    if (!bl) break;
                    if (this.context.findVisibleType(classSym, string)) {
                        return this.context.findMemberType(classSym, string);
                    }
                    JavaType javaType = this.context.findType(classSym, string);
                    if (javaType == null) break;
                    return javaType;
                }
                case 42: {
                    JavaType javaType;
                    SwitchStmt switchStmt = (SwitchStmt)sym;
                    Expr expr = switchStmt.getExpressionSym();
                    if (expr != null && (javaType = expr.getResolvedType()) != null && javaType.isEnum()) {
                        if (this.context.findVisibleVariable(javaType, string)) {
                            return this.context.findMemberVariable(javaType, string);
                        }
                        return null;
                    }
                }
                default: {
                    JavaType javaType;
                    JavaVariable javaVariable = this.context.findVariable(sym, string, bl2);
                    if (javaVariable != null) {
                        return javaVariable;
                    }
                    if (!bl || (javaType = this.context.findType(sym, string)) == null) break;
                    return javaType;
                }
            }
            sym = this.context.nextScope();
        }
        this.context.cleanScope();
        return this.findImportedName(string, bl);
    }

    private JavaHasType processSimpleSelector(String string, JavaType javaType, boolean bl) {
        if (javaType == null) {
            return null;
        }
        if (this.context.findVisibleVariable(javaType, string)) {
            return this.context.findMemberVariable(javaType, string);
        }
        if (bl && this.context.findVisibleType(javaType, string)) {
            return this.context.findMemberType(javaType, string);
        }
        return null;
    }

    private JavaMethod processSimpleMethodCall(String string, JavaType[] javaTypeArray, boolean bl) {
        boolean bl2 = "this".equals(string);
        boolean bl3 = "super".equals(string);
        Sym sym = this.context.cleanScope();
        while (sym != null) {
            int n = sym.getSymbolKind();
            if (n == 3) {
                ClassSym classSym = (ClassSym)sym;
                if (bl2 || bl3) {
                    if (!this.context.flag_instance) {
                        return (JavaMethod)this.error(this.context.symCookie, (short)62, string);
                    }
                    JavaType javaType = classSym;
                    if (bl3) {
                        javaType = classSym.getSuperclass();
                    }
                    if (javaType == null) {
                        return null;
                    }
                    return this.context.findMethod(javaType, "<init>", javaTypeArray);
                }
                if (bl) {
                    boolean bl4 = this.context.findVisibleMethod(classSym, string);
                    if (bl4) {
                        return this.context.findMethod(classSym, string, javaTypeArray);
                    }
                } else {
                    JavaMethod javaMethod = this.context.findSingleMethod(classSym, string);
                    if (javaMethod != null) {
                        return javaMethod;
                    }
                }
            }
            sym = this.context.nextScope();
        }
        if (bl) {
            return this.findImportedMethod(string, javaTypeArray);
        }
        return null;
    }

    private JavaMethod processSelectorMethodCall(String string, JavaHasType javaHasType, JavaType[] javaTypeArray, boolean bl) {
        JavaMethod javaMethod;
        JavaType javaType = this.processLhs(javaHasType);
        if (javaType == null) {
            return null;
        }
        if (bl) {
            if (javaHasType instanceof JavaType && !"<init>".equals(string)) {
                this.context.flag_instance = false;
            }
            return this.context.findMethod(javaType, string, javaTypeArray);
        }
        if (!"<init>".equals(string) && (javaMethod = this.context.findMethod(javaType, string, javaTypeArray)) != null) {
            return javaMethod;
        }
        return this.context.findSingleMethod(javaType, string);
    }

    private void processAllPrimaries(InputImpl inputImpl, OutputImpl outputImpl) {
        ClassSym classSym;
        Sym sym;
        if (inputImpl.squash((byte)64) && inputImpl.input((byte)4) && (sym = this.context.symCookie) != null && (classSym = sym.getOwningClassSym()) != null) {
            outputImpl.keys().add(classSym.getName());
        }
        Sym sym2 = this.context.cleanScope();
        while (sym2 != null) {
            if (inputImpl.input == 0) {
                return;
            }
            if (sym2.symKind == 3) {
                ClassSym classSym2 = (ClassSym)sym2;
                this.context.listMembers(classSym2, inputImpl, outputImpl);
            } else {
                this.context.listNames(sym2, inputImpl, outputImpl);
            }
            sym2 = this.context.nextScope();
        }
    }

    private void processAllSelectors(JavaHasType javaHasType, InputImpl inputImpl, OutputImpl outputImpl) {
        JavaType javaType = this.processLhs(javaHasType);
        if (javaType == null) {
            return;
        }
        this.context.listMembers(javaType, inputImpl, outputImpl);
    }

    private JavaType processLhs(JavaHasType javaHasType) {
        if (javaHasType == null) {
            return null;
        }
        JavaType javaType = javaHasType.getResolvedType();
        if (javaType == null) {
            return null;
        }
        if (javaType.isPrimitive()) {
            return (JavaType)this.error(null, (short)51, javaType);
        }
        if (javaHasType instanceof JavaType) {
            this.context.flag_instance = false;
        } else {
            this.context.flag_static = false;
        }
        return javaType;
    }

    private void processExceptions(Expr expr, JavaMethod javaMethod) {
        if (javaMethod == null) {
            return;
        }
        for (JavaType javaType : javaMethod.getExceptions()) {
            JavaClass javaClass;
            JavaType javaType2;
            if ("clone".equals(javaMethod.getName()) && "java/lang/CloneNotSupportedException".equals(javaType.getVMName()) && ((javaType2 = this.processLhs(expr.getResolvedLhs())) == null || (javaClass = this.provider.getClassByVMName("java/lang/Cloneable")) != null && javaType2.isSubtypeOf(javaClass))) continue;
            this.processException(javaType);
        }
    }

    private final void processException(JavaType javaType) {
        JavaClass javaClass = this.getPreloadedClass((byte)5);
        if (javaType.isSubtypeOf(javaClass)) {
            return;
        }
        JavaClass javaClass2 = this.getPreloadedClass((byte)2);
        if (javaType.isSubtypeOf(javaClass2)) {
            return;
        }
        Sym sym = this.context.cleanScope();
        while (sym != null) {
            if (this.context.checkException(sym, javaType)) break;
            sym = this.context.nextScope();
        }
    }

    private JavaMethod findImportedMethod(String string, JavaType[] javaTypeArray) {
        this.context.cleanScope();
        return this.context.findImportedMethod(string, javaTypeArray);
    }

    private JavaHasType findImportedName(String string, boolean bl) {
        this.context.cleanScope();
        JavaVariable javaVariable = this.context.findImportedVariable(string);
        if (javaVariable != null) {
            return javaVariable;
        }
        if (bl) {
            return this.findImportedType(string);
        }
        return null;
    }

    protected final JavaHasType processExpression(Expr expr) {
        JavaElement javaElement = expr.resolve((CompilerDriver)this);
        if (javaElement != null) {
            return (JavaHasType)javaElement;
        }
        return null;
    }

    protected final JavaType processExpressionType(Expr expr, boolean bl) {
        JavaHasType javaHasType = this.processExpression(expr);
        if (javaHasType == null) {
            return null;
        }
        if (javaHasType instanceof JavaType) {
            JavaType javaType = (JavaType)javaHasType;
            if (!bl) {
                this.error(expr, (short)68, javaType);
            }
            return (JavaType)javaHasType;
        }
        return javaHasType.getResolvedType();
    }

    CompilerLayer3a() {
    }
}

