/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerLayer3a;
import oracle.javatools.parser.java.v2.internal.compiler.ObjConstants;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ClassCreatorExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.DotExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.MethodCallExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.SimpleNameExpr;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.expression.CompiledTmpVariable;

abstract class CompilerLayer3b
extends CompilerLayer3a {
    public final JavaHasType resolve(Expr expr) {
        CompilerLayer3b.panic(expr);
        return null;
    }

    public final JavaHasType resolve(SimpleNameExpr simpleNameExpr) {
        boolean bl = simpleNameExpr.flag_lvalue() ^ true;
        return this.resolveName(simpleNameExpr, null, bl);
    }

    public final JavaHasType resolve(DotExpr dotExpr) {
        Expr expr;
        boolean bl = dotExpr.flag_lvalue() ^ true;
        JavaHasType javaHasType = this.processLhsOperand(dotExpr);
        if (javaHasType == ObjConstants.kEmptyResult && bl && (expr = dotExpr.getLhsOperandSym()) != null && expr.flag_maybePackage()) {
            String string = dotExpr.getQualifiedName();
            JavaType javaType = this.resolveType(dotExpr, string);
            if (javaType != null) {
                this.recordUsage(dotExpr, javaType);
                return javaType;
            }
            if (!dotExpr.flag_maybePackage()) {
                this.error(dotExpr, (short)56, string);
            }
            return null;
        }
        return this.resolveName(dotExpr, javaHasType, bl);
    }

    public final JavaHasType resolve(MethodCallExpr methodCallExpr) {
        JavaMethod javaMethod;
        JavaHasType javaHasType = this.processLhsOperand(methodCallExpr);
        String string = methodCallExpr.getName();
        if (string.length() == 0) {
            return (JavaMethod)this.error(methodCallExpr, (short)50);
        }
        if ("this".equals(string) || "super".equals(string)) {
            javaMethod = this.resolveExplicitConstructor(methodCallExpr, javaHasType, string);
        } else {
            JavaType[] javaTypeArray = this.processArguments(methodCallExpr);
            javaMethod = this.resolveMethodCall(methodCallExpr, javaHasType, javaTypeArray, false);
        }
        if (javaMethod == null) {
            return null;
        }
        this.resolveExceptions(methodCallExpr, javaMethod);
        return javaMethod;
    }

    public final JavaHasType resolve(ClassCreatorExpr classCreatorExpr) {
        ClassSym classSym;
        JavaType javaType;
        JavaHasType javaHasType = this.processLhsOperand(classCreatorExpr);
        TypeSym typeSym = classCreatorExpr.getTypeSym();
        if (typeSym == null) {
            return null;
        }
        if (javaHasType == null) {
            javaType = (JavaType)typeSym.resolve((CompilerDriver)this);
            if (javaType == null) {
                return null;
            }
            JavaType javaType2 = CompilerLayer3b.getOuterClassOfNonstaticInner(javaType);
            if (javaType2 != null && (javaHasType = this.resolveEnclosingScope(classCreatorExpr, javaType2)) == null) {
                this.error(classCreatorExpr, (short)66, javaType2);
                return javaType.getThisValue();
            }
        } else {
            String string = typeSym.getName();
            if (string.length() == 0) {
                return (JavaHasType)this.error(classCreatorExpr, (short)50);
            }
            if (javaHasType == ObjConstants.kEmptyResult) {
                return null;
            }
            CompilerContext compilerContext = this.context;
            try {
                this.context = this.newContext(classCreatorExpr);
                javaType = this.processInnerCreatorType(classCreatorExpr, javaHasType, string);
            }
            finally {
                this.context = compilerContext;
            }
            if (javaType == null) {
                return null;
            }
        }
        JavaType javaType3 = null;
        if (javaHasType != null) {
            javaType3 = javaHasType.getResolvedType();
        }
        if ((classSym = classCreatorExpr.getClassSym()) != null && javaType.isInterface() && classCreatorExpr.getArgumentCount() == 0) {
            return javaType.getThisValue();
        }
        JavaType[] javaTypeArray = this.processArguments(classCreatorExpr, javaType3);
        CompilerContext compilerContext = this.context;
        try {
            JavaMethod javaMethod;
            if (classSym != null) {
                this.context = this.newContext(classSym.getBodySym());
            }
            if ((javaMethod = this.resolveMethodCall(classCreatorExpr, javaType, javaTypeArray)) != null) {
                this.resolveExceptions(classCreatorExpr, javaMethod);
            }
            classCreatorExpr.creatorMethod = javaMethod;
            this.resolveExceptions(classCreatorExpr, javaMethod);
            if (classSym != null) {
                CompiledTmpVariable compiledTmpVariable = classSym.getThisValue();
                this.context = compilerContext;
                return compiledTmpVariable;
            }
            if (javaType.isAbstract()) {
                this.error(classCreatorExpr, (short)33);
            }
            CompiledTmpVariable compiledTmpVariable = javaType.getThisValue();
            this.context = compilerContext;
            return compiledTmpVariable;
        }
        catch (Throwable throwable) {
            this.context = compilerContext;
            throw throwable;
        }
    }

    private JavaMethod resolveExplicitConstructor(MethodCallExpr methodCallExpr, JavaHasType javaHasType, String string) {
        CompilerContext compilerContext = this.context;
        try {
            this.context = this.newContext(methodCallExpr);
            JavaMethod javaMethod = this.processExplicitConstructor(methodCallExpr, javaHasType, string);
            this.context = compilerContext;
            return javaMethod;
        }
        catch (Throwable throwable) {
            this.context = compilerContext;
            throw throwable;
        }
    }

    private JavaHasType processLhsOperand(Expr expr) {
        Expr expr2 = (Expr)expr.getLhsOperand();
        if (expr2 == null) {
            return null;
        }
        JavaHasType javaHasType = (JavaHasType)expr2.resolve((CompilerDriver)this);
        if (javaHasType != null) {
            return javaHasType;
        }
        return ObjConstants.kEmptyResult;
    }

    private JavaType[] processArguments(Expr expr) {
        return this.processArguments(expr, null);
    }

    private JavaType[] processArguments(Expr expr, JavaType javaType) {
        Expr expr2 = (Expr)expr.getChild((byte)52);
        int n = expr2.getOperandCount();
        if (n == 0) {
            if (javaType == null) {
                return JavaType.EMPTY_ARRAY;
            }
            JavaType[] javaTypeArray = new JavaType[]{javaType};
            return javaTypeArray;
        }
        if (javaType != null) {
            ++n;
        }
        JavaType[] javaTypeArray = new JavaType[n];
        int n2 = 0;
        if (javaType != null) {
            javaTypeArray[0] = javaType;
            ++n2;
        }
        for (Expr expr3 : expr2.getOperands()) {
            javaTypeArray[n2++] = this.processExpressionType(expr3, false);
        }
        return javaTypeArray;
    }

    private JavaMethod processExplicitConstructor(MethodCallExpr methodCallExpr, JavaHasType javaHasType, String string) {
        JavaType javaType;
        JavaHasType javaHasType2 = this.resolveName(methodCallExpr, javaHasType, string, true);
        if (javaHasType2 == null) {
            return (JavaMethod)this.error(methodCallExpr, (short)54, string, JavaType.EMPTY_ARRAY);
        }
        JavaType javaType2 = javaHasType2.getResolvedType();
        if (javaType2 == null) {
            return (JavaMethod)this.error(methodCallExpr, (short)54, string, JavaType.EMPTY_ARRAY);
        }
        if (javaHasType == null && (javaType = CompilerLayer3b.getOuterClassOfNonstaticInner(javaType2)) != null) {
            ClassSym classSym = methodCallExpr.getOwningClassSym();
            if (classSym != null) {
                javaHasType = this.resolveEnclosingScope(classSym, javaType);
            }
            if (javaHasType == null) {
                this.error(methodCallExpr, (short)66, javaType);
                return null;
            }
        }
        JavaType javaType3 = null;
        if (javaHasType != null) {
            javaType3 = javaHasType.getResolvedType();
        }
        JavaType[] javaTypeArray = this.processArguments(methodCallExpr, javaType3);
        JavaMethod javaMethod = this.resolveMethodCall(methodCallExpr, javaType2, javaTypeArray, true);
        this.resolveExceptions(methodCallExpr, javaMethod);
        return javaMethod;
    }

    protected final JavaType processInnerCreatorType(Expr expr, String string) {
        JavaHasType javaHasType = this.processExpression(expr);
        if (javaHasType == null) {
            return null;
        }
        return this.processInnerCreatorType(expr, javaHasType, string);
    }

    protected final JavaType processInnerCreatorType(Sym sym, JavaHasType javaHasType, String string) {
        if (javaHasType instanceof JavaType) {
            this.error(sym, (short)65, javaHasType);
            return null;
        }
        JavaType javaType = javaHasType.getResolvedType();
        if (javaType == null) {
            return null;
        }
        return this.context.findMemberType(javaType, string);
    }

    CompilerLayer3b() {
    }
}

