/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerLayer3b;
import oracle.javatools.parser.java.v2.internal.symbol.AnnotateSym;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.AnnotateExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ArrayAccessExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ArrayCreatorExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.AssignExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.InfixExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ListExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.LiteralExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.QuestionExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.TypeExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.TypecastExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.UnaryExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.WrapperExpr;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.expression.CompiledTmpVariable;
import oracle.javatools.parser.java.v2.scanner.LexerLiteral;

abstract class CompilerLayer3c
extends CompilerLayer3b {
    private static final byte PRIMOP_ADD = 0;
    private static final byte PRIMOP_ARITHMETIC = 1;
    private static final byte PRIMOP_BITWISE = 2;
    private static final byte PRIMOP_LOGICAL = 3;
    private static final byte BINOP_ASSIGNMENT = 0;
    private static final byte BINOP_COMPARISON = 1;
    private static final byte BINOP_EQUALITY = 2;
    private static final byte BINOP_SHIFT = 3;

    public final JavaHasType resolve(LiteralExpr literalExpr) {
        JavaClass javaClass;
        LexerLiteral lexerLiteral = literalExpr.literal;
        if (lexerLiteral == null) {
            return null;
        }
        switch (lexerLiteral.literalToken) {
            case 8: {
                javaClass = PrimitiveType.PRIMITIVE_objects[4];
                break;
            }
            case 9: {
                javaClass = PrimitiveType.PRIMITIVE_objects[5];
                break;
            }
            case 10: {
                javaClass = PrimitiveType.PRIMITIVE_objects[6];
                break;
            }
            case 11: {
                javaClass = PrimitiveType.PRIMITIVE_objects[7];
                break;
            }
            case 12: {
                javaClass = PrimitiveType.PRIMITIVE_objects[0];
                break;
            }
            case 13: {
                javaClass = PrimitiveType.PRIMITIVE_objects[2];
                break;
            }
            case 15: {
                javaClass = PrimitiveType.PRIMITIVE_objects[8];
                break;
            }
            case 14: {
                javaClass = this.getPreloadedClass((byte)6);
                break;
            }
            default: {
                CompilerLayer3c.panic(literalExpr);
                return null;
            }
        }
        if (javaClass != null) {
            return javaClass.getThisValue();
        }
        return null;
    }

    public final JavaHasType resolve(AnnotateExpr annotateExpr) {
        AnnotateSym annotateSym = annotateExpr.getAnnotateSym();
        if (annotateSym == null) {
            return null;
        }
        return (JavaAnnotation)annotateSym.resolve((CompilerDriver)this);
    }

    public final JavaHasType resolve(TypeExpr typeExpr) {
        TypeSym typeSym = typeExpr.getTypeSym();
        if (typeSym == null) {
            return null;
        }
        return (JavaType)typeSym.resolve((CompilerDriver)this);
    }

    public final JavaHasType resolve(WrapperExpr wrapperExpr) {
        return this.processNthOperand(wrapperExpr, 0);
    }

    public final JavaHasType resolve(ListExpr listExpr) {
        if (listExpr.exprOptcode != 5) {
            return null;
        }
        PrimitiveType primitiveType = PrimitiveType.PRIMITIVE_objects[8];
        return this.provider.getArrayType(primitiveType, 1).getThisValue();
    }

    public final JavaHasType resolve(QuestionExpr questionExpr) {
        return this.handleQuestion(questionExpr);
    }

    public final JavaHasType resolve(TypecastExpr typecastExpr) {
        return this.handleTypecast(typecastExpr);
    }

    public final JavaHasType resolve(ArrayAccessExpr arrayAccessExpr) {
        return this.handleArrayDereference(arrayAccessExpr);
    }

    public final JavaHasType resolve(ArrayCreatorExpr arrayCreatorExpr) {
        int n;
        TypeSym typeSym = arrayCreatorExpr.getTypeSym();
        JavaType javaType = typeSym.getResolvedType();
        if (javaType == null) {
            return null;
        }
        Expr expr = arrayCreatorExpr.getNthOperandSym(0);
        if (expr.getExpressionCode() == 26 && (n = expr.getOperandCount()) > 0) {
            javaType = CompilerLayer3c.createArrayType(this.provider, javaType, expr.getOperandCount());
        }
        return javaType.getThisValue();
    }

    public final JavaHasType resolve(AssignExpr assignExpr) {
        return this.processInfix(assignExpr);
    }

    public final JavaHasType resolve(InfixExpr infixExpr) {
        return this.processInfix(infixExpr);
    }

    public final JavaHasType resolve(UnaryExpr unaryExpr) {
        JavaType javaType;
        int n = unaryExpr.getOperatorCode();
        switch (n) {
            case 37: 
            case 44: {
                javaType = this.handlePrimitiveOperator(unaryExpr, (byte)1);
                break;
            }
            case 41: {
                javaType = this.handlePrimitiveOperator(unaryExpr, (byte)3);
                break;
            }
            case 45: 
            case 46: {
                return this.processNthOperand(unaryExpr, 0);
            }
            case 47: 
            case 48: {
                javaType = this.handlePreincPredec(unaryExpr);
                break;
            }
            case 9: {
                javaType = this.handlePrimitiveOperator(unaryExpr, (byte)2);
                break;
            }
            case 50: {
                return this.handleQualifiedThis(unaryExpr);
            }
            case 49: {
                return this.handleQualifiedSuper(unaryExpr);
            }
            case 14: {
                javaType = this.handleClassLiteral(unaryExpr);
                break;
            }
            default: {
                CompilerLayer3c.panic(unaryExpr);
                return null;
            }
        }
        if (javaType != null) {
            return javaType.getThisValue();
        }
        return null;
    }

    private JavaHasType processNthOperand(Expr expr, int n) {
        Expr expr2 = (Expr)expr.getNthChild((byte)84, n);
        if (expr2 == null) {
            return null;
        }
        if (expr.flag_lvalue()) {
            // empty if block
        }
        return this.processExpression(expr2);
    }

    private JavaType processNthOperandType(Expr expr, int n) {
        JavaHasType javaHasType = this.processNthOperand(expr, n);
        return this.processHasType(javaHasType);
    }

    private JavaType processHasType(JavaHasType javaHasType) {
        if (javaHasType != null) {
            return javaHasType.getResolvedType();
        }
        return null;
    }

    public final JavaHasType processInfix(Expr expr) {
        JavaType javaType;
        int n = expr.getOperatorCode();
        switch (n) {
            case 6: {
                javaType = this.handleBinaryOperator(expr, (byte)0);
                break;
            }
            case 1: 
            case 2: {
                javaType = this.handlePrimitiveOperator(expr, (byte)0);
                break;
            }
            case 17: 
            case 18: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                javaType = this.handlePrimitiveOperator(expr, (byte)1);
                break;
            }
            case 3: 
            case 43: {
                javaType = this.handlePrimitiveOperator(expr, (byte)3);
                break;
            }
            case 20: 
            case 42: {
                javaType = this.handleBinaryOperator(expr, (byte)2);
                break;
            }
            case 21: 
            case 22: 
            case 25: 
            case 30: {
                javaType = this.handleBinaryOperator(expr, (byte)1);
                break;
            }
            case 23: {
                return this.handleInstanceof(expr);
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                javaType = this.handlePrimitiveOperator(expr, (byte)2);
                break;
            }
            case 28: 
            case 29: 
            case 51: 
            case 52: 
            case 56: 
            case 57: {
                javaType = this.handleBinaryOperator(expr, (byte)3);
                break;
            }
            default: {
                CompilerLayer3c.panic(expr);
                return null;
            }
        }
        if (javaType != null) {
            return javaType.getThisValue();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private JavaType handlePrimitiveOperator(Expr var1_1, byte var2_2) {
        switch (var2_2) {
            case 3: {
                var3_3 = PrimitiveType.PRIMITIVE_objects[0];
                if (!this.flag_forgiving) break;
                return var3_3;
            }
            default: {
                var3_3 = PrimitiveType.PRIMITIVE_objects[4];
            }
        }
        var4_4 = var1_1.getOperandCount();
        if (var4_4 == 0) {
            return var3_3;
        }
        var5_5 = this.processNthOperandType(var1_1, 0);
        var6_6 = false;
        var7_7 = null;
        if (var5_5 != null && !CompilerLayer3c.isVoidType(var5_5)) {
            switch (var2_2) {
                case 0: {
                    var7_7 = var5_5;
                    var6_6 = "java.lang.String".equals(var7_7.getQualifiedName());
                    break;
                }
                case 1: {
                    if (!CompilerLayer3c.isNumericType(var5_5)) break;
                    var7_7 = var5_5;
                    break;
                }
                case 2: {
                    if (!CompilerLayer3c.isIntegralOrBooleanType(var5_5)) break;
                    var7_7 = var5_5;
                    break;
                }
                case 3: {
                    if (!CompilerLayer3c.isBooleanType(var5_5)) break;
                    var7_7 = var5_5;
                }
            }
            if (var7_7 == null) {
                this.error(var1_1.getNthOperandSym(0), (short)51, var5_5);
            }
        }
        if (var7_7 == null) {
            var7_7 = var3_3;
        }
        if (var4_4 == 1) {
            var8_8 = CompilerLayer3c.applyUnaryPromotion(var7_7);
            if (var8_8 != null) {
                return var8_8;
            }
            this.error(var1_1.getNthOperandSym(0), (short)51, var7_7);
            return null;
        }
        var9_9 = 1;
        while (var9_9 < var4_4) {
            var10_10 = this.processNthOperandType(var1_1, var9_9);
            if (var10_10 == null) {
                var10_10 = var3_3;
            } else if (CompilerLayer3c.isVoidType(var10_10)) {
                this.error(var1_1.getNthOperandSym(var9_9), (short)51, var10_10);
                var10_10 = var3_3;
            }
            switch (var2_2) {
                case 0: {
                    if (var6_6) break;
                    if (var10_10 != null && "java.lang.String".equals(var10_10.getQualifiedName())) {
                        var6_6 = true;
                        var7_7 = var10_10;
                        break;
                    }
                    if (var9_9 == 1) {
                        var11_11 = var7_7;
                        var7_7 = null;
                        if (CompilerLayer3c.isNumericType(var11_11)) {
                            var7_7 = var11_11;
                        }
                        if (var7_7 == null) {
                            this.error(var1_1.getNthOperandSym(0), (short)51, var11_11);
                            var7_7 = var3_3;
                        }
                    }
                }
                case 1: {
                    var12_12 = CompilerLayer3c.applyBinaryPromotion(var7_7, var10_10);
                    if (var12_12 != null) {
                        var7_7 = var12_12;
                        break;
                    }
                    ** GOTO lbl81
                }
                case 2: {
                    if (CompilerLayer3c.isIntegralOrBooleanType(var5_5) && (var7_7 = CompilerLayer3c.applyBinaryPromotion(var7_7, var10_10)) != null) break;
                    var7_7 = CompilerLayer3c.applyBinaryPromotion(var7_7, var7_7);
                    ** GOTO lbl81
                }
                case 3: {
                    if (CompilerLayer3c.isBooleanType(var10_10)) break;
                }
lbl81:
                // 4 sources

                default: {
                    this.error(var1_1.getNthOperandSym(var9_9), (short)51, var10_10);
                }
            }
            ++var9_9;
        }
        return var7_7;
    }

    private JavaType handleBinaryOperator(Expr expr, byte by) {
        PrimitiveType primitiveType;
        switch (by) {
            case 0: {
                primitiveType = null;
                break;
            }
            case 1: 
            case 2: {
                primitiveType = PrimitiveType.PRIMITIVE_objects[0];
                if (!this.flag_forgiving) break;
                return primitiveType;
            }
            default: {
                primitiveType = PrimitiveType.PRIMITIVE_objects[4];
            }
        }
        int n = expr.getOperandCount();
        if (n == 0) {
            return primitiveType;
        }
        JavaType javaType = this.processNthOperandType(expr, 0);
        if (n == 1) {
            switch (by) {
                case 0: {
                    return javaType;
                }
                case 3: {
                    if (javaType != null) {
                        javaType = CompilerLayer3c.applyUnaryPromotion(javaType);
                        break;
                    }
                    javaType = primitiveType;
                    break;
                }
                default: {
                    return primitiveType;
                }
            }
        }
        if (n > 2) {
            // empty if block
        }
        JavaType javaType2 = this.processNthOperandType(expr, 1);
        switch (by) {
            case 0: {
                JavaType javaType3;
                JavaHasType javaHasType;
                if (this.flag_forgiving) {
                    return javaType;
                }
                JavaHasType javaHasType2 = this.processNthOperand(expr, 0);
                if (javaHasType2 != null && javaHasType2 instanceof JavaType) {
                    this.error(expr.getNthOperandSym(0), (short)59, javaHasType2);
                }
                if ((javaHasType = this.processNthOperand(expr, 1)) != null && javaHasType instanceof JavaType) {
                    this.error(expr.getNthOperandSym(1), (short)68, javaHasType);
                }
                if (CompilerLayer3c.applyAssignmentConversion(javaType2, javaType, false, this.provider)) break;
                boolean bl = true;
                if (CompilerLayer3c.applyAssignmentConversion(javaType2, javaType, true, this.provider) || javaType.isArray() && CompilerLayer3c.isComponentAssignment(expr) && CompilerLayer3c.applyAssignmentConversion(javaType2, javaType3 = javaType.getComponentType(), true, this.provider)) break;
                this.error(expr.getNthOperandSym(1), (short)37, javaType2, javaType);
                break;
            }
            case 1: {
                PrimitiveType primitiveType2;
                if (javaType2 == null) {
                    return primitiveType;
                }
                PrimitiveType primitiveType3 = CompilerLayer3c.applyUnboxingConversion(javaType);
                if (primitiveType3 == null || !primitiveType3.isNumeric()) {
                    this.error(expr.getNthOperandSym(0), (short)51, javaType);
                }
                if ((primitiveType2 = CompilerLayer3c.applyUnboxingConversion(javaType2)) == null || !primitiveType2.isNumeric()) {
                    this.error(expr.getNthOperandSym(0), (short)51, javaType2);
                }
                JavaType javaType4 = CompilerLayer3c.applyBinaryPromotion(primitiveType3, primitiveType2);
                return primitiveType;
            }
            case 2: {
                return primitiveType;
            }
            case 3: {
                JavaType javaType5;
                JavaType javaType6 = CompilerLayer3c.applyUnaryPromotion(javaType);
                if (!CompilerLayer3c.isNumericType(javaType6)) {
                    this.error(expr.getNthOperandSym(0), (short)51, javaType);
                }
                if (CompilerLayer3c.isNumericType(javaType5 = CompilerLayer3c.applyUnaryPromotion(javaType2))) break;
                this.error(expr.getNthOperandSym(0), (short)51, javaType2);
                break;
            }
            default: {
                CompilerLayer3c.panic(expr);
                return null;
            }
        }
        return javaType;
    }

    private JavaHasType handleArrayDereference(Expr expr) {
        JavaType javaType = this.processNthOperandType(expr, 0);
        JavaType javaType2 = null;
        Expr expr2 = expr.getNthOperandSym(1);
        int n = expr2.getOperandCount();
        int n2 = 0;
        while (n2 < n) {
            if (javaType == null) {
                return null;
            }
            javaType2 = javaType.getComponentType();
            if (javaType2 == null) {
                return (JavaHasType)this.error(expr.getNthOperandSym(0), (short)63, javaType);
            }
            JavaType javaType3 = this.processNthOperandType(expr2, n2);
            if (javaType3 == null || this.flag_forgiving) {
                return javaType2.getThisValue();
            }
            if ((javaType3 = CompilerLayer3c.applyUnaryPromotion(javaType3)) != null && !CompilerLayer3c.isIntegralType(javaType3)) {
                this.error(expr.getNthOperandSym(1), (short)51, javaType3);
            }
            javaType = javaType2;
            ++n2;
        }
        if (javaType2 == null) {
            return null;
        }
        return javaType2.getThisValue();
    }

    private JavaType handleClassLiteral(UnaryExpr unaryExpr) {
        JavaClass javaClass = this.getPreloadedClass((byte)0);
        if (javaClass == null) {
            return null;
        }
        if (!javaClass.hasTypeParameters()) {
            return javaClass;
        }
        JavaType javaType = this.processNthOperandType(unaryExpr, 0);
        if (javaType != null) {
            try {
                JavaType[] javaTypeArray = new JavaType[]{javaType};
                JavaType javaType2 = CompilerLayer3c.createParameterizedType(this.provider, javaClass, javaTypeArray);
                return javaType2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return javaClass;
    }

    private JavaHasType handleInstanceof(Expr expr) {
        PrimitiveType primitiveType = PrimitiveType.PRIMITIVE_objects[0];
        CompiledTmpVariable compiledTmpVariable = primitiveType.getThisValue();
        if (this.flag_forgiving) {
            return compiledTmpVariable;
        }
        JavaType javaType = this.processNthOperandType(expr, 1);
        if (javaType == null) {
            return compiledTmpVariable;
        }
        JavaType javaType2 = this.processNthOperandType(expr, 0);
        if (javaType2 == null) {
            return compiledTmpVariable;
        }
        if (javaType2.isPrimitive()) {
            return compiledTmpVariable;
        }
        return compiledTmpVariable;
    }

    private JavaType handlePreincPredec(Expr expr) {
        PrimitiveType primitiveType = PrimitiveType.PRIMITIVE_objects[4];
        int n = expr.getOperandCount();
        if (n == 0) {
            return primitiveType;
        }
        JavaType javaType = this.processNthOperandType(expr, 0);
        if (javaType == null) {
            return primitiveType;
        }
        if (this.flag_forgiving) {
            return javaType;
        }
        JavaType javaType2 = CompilerLayer3c.applyBinaryPromotion(javaType, primitiveType);
        if (javaType2 == null) {
            this.error(expr.getNthOperandSym(0), (short)51, javaType);
        }
        return javaType;
    }

    private JavaHasType handleQualifiedThis(Expr expr) {
        JavaType javaType = this.processNthOperandType(expr, 0);
        if (javaType == null) {
            return null;
        }
        if (this.flag_forgiving) {
            return javaType.getThisValue();
        }
        ClassSym classSym = this.resolveEnclosingScope(expr, javaType);
        if (classSym != null) {
            return classSym.getThisVariable();
        }
        return null;
    }

    private JavaHasType handleQualifiedSuper(Expr expr) {
        JavaHasType javaHasType = this.handleQualifiedThis(expr);
        JavaType javaType = this.processHasType(javaHasType);
        if (javaType == null) {
            return null;
        }
        JavaType javaType2 = javaType.getSuperclass();
        if (javaType2 != null) {
            return javaType2.getThisValue();
        }
        return null;
    }

    private JavaHasType handleQuestion(Expr expr) {
        JavaType javaType = this.processNthOperandType(expr, 0);
        if (javaType != null && !CompilerLayer3c.isBooleanType(javaType)) {
            this.error(expr.getNthOperandSym(0), (short)51, javaType);
        }
        JavaHasType javaHasType = this.processNthOperand(expr, 1);
        JavaHasType javaHasType2 = this.processNthOperand(expr, 2);
        if (javaHasType == null) {
            return javaHasType2;
        }
        if (javaHasType2 == null) {
            return javaHasType;
        }
        JavaType javaType2 = javaHasType.getResolvedType();
        if (javaType2 == null) {
            return javaHasType2;
        }
        JavaType javaType3 = javaHasType2.getResolvedType();
        if (javaType3 == null) {
            return javaHasType;
        }
        JavaType javaType4 = this.handleQuestion(javaType2, javaType3);
        if (javaType4 == javaType2) {
            return javaHasType;
        }
        if (javaType4 == javaType3) {
            return javaHasType2;
        }
        if (javaType4 == null) {
            this.error(expr.getNthOperandSym(2), (short)37, javaType3, javaType2);
            return javaHasType;
        }
        return javaType4.getThisValue();
    }

    private JavaHasType handleTypecast(Expr expr) {
        JavaType javaType = this.processNthOperandType(expr, 0);
        if (javaType == null) {
            JavaClass javaClass = this.getPreloadedClass((byte)4);
            if (javaClass != null) {
                return javaClass.getThisValue();
            }
            return null;
        }
        if (this.flag_forgiving) {
            return javaType.getThisValue();
        }
        JavaType javaType2 = this.processNthOperandType(expr, 1);
        if (javaType2 != null && !CompilerLayer3c.applyCastingConversion(javaType2, javaType, this.provider)) {
            this.error(expr, (short)42, javaType2, javaType);
        }
        return javaType.getThisValue();
    }

    private JavaType handleQuestion(JavaType javaType, JavaType javaType2) {
        if (javaType.equals(javaType2)) {
            return javaType;
        }
        boolean bl = javaType.isPrimitive();
        boolean bl2 = javaType2.isPrimitive();
        if (!bl && !bl2) {
            return this.handleQuestionImpl(javaType, javaType2);
        }
        if (bl && bl2) {
            return this.handleQuestionImpl((PrimitiveType)javaType, (PrimitiveType)javaType2);
        }
        if (bl) {
            return this.handleQuestionImpl((PrimitiveType)javaType, javaType2);
        }
        return this.handleQuestionImpl((PrimitiveType)javaType2, javaType);
    }

    private JavaType handleQuestionImpl(JavaType javaType, JavaType javaType2) {
        if (javaType.isSubtypeOf(javaType2)) {
            return javaType2;
        }
        if (javaType2.isSubtypeOf(javaType)) {
            return javaType;
        }
        return null;
    }

    private JavaType handleQuestionImpl(PrimitiveType primitiveType, JavaType javaType) {
        if ("null".equals(primitiveType.getName())) {
            return javaType;
        }
        PrimitiveType primitiveType2 = CompilerLayer3c.applyUnboxingConversion(javaType);
        if (primitiveType2 != null) {
            return this.handleQuestionImpl(primitiveType, primitiveType2);
        }
        return null;
    }

    private JavaType handleQuestionImpl(PrimitiveType primitiveType, PrimitiveType primitiveType2) {
        if (primitiveType.isSubtypeOf(primitiveType2)) {
            return primitiveType2;
        }
        if (primitiveType2.isSubtypeOf(primitiveType)) {
            return primitiveType;
        }
        JavaType javaType = CompilerLayer3c.applyBinaryPromotion(primitiveType, primitiveType2);
        if (javaType != null) {
            return javaType;
        }
        if ("null".equals(primitiveType.getName())) {
            return CompilerLayer3c.applyBoxingConversion(primitiveType2, this.provider);
        }
        if ("null".equals(primitiveType2.getName())) {
            return CompilerLayer3c.applyBoxingConversion(primitiveType, this.provider);
        }
        return null;
    }

    CompilerLayer3c() {
    }
}

