/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.Collection;
import java.util.HashMap;
import oracle.javatools.parser.java.v2.common.AnnotationComponents;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.QuickComponent;
import oracle.javatools.parser.java.v2.internal.compiler.AnnotateObj;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerLayer3;
import oracle.javatools.parser.java.v2.internal.symbol.AnnotateSym;
import oracle.javatools.parser.java.v2.internal.symbol.BlockSym;
import oracle.javatools.parser.java.v2.internal.symbol.MemberSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.VariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ListExpr;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ExpressionStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ForStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ReturnStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.SynchStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ThrowStmt;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;

abstract class CompilerLayer4
extends CompilerLayer3 {
    public final JavaAnnotation resolve(AnnotateSym annotateSym) {
        JavaType javaType;
        AnnotateObj annotateObj = annotateSym.getObj();
        if (annotateObj.flag_resolved) {
            return annotateObj;
        }
        String string = annotateSym.getName();
        if (string.length() == 0) {
            return (JavaAnnotation)this.error(annotateSym, (short)50);
        }
        Sym sym = annotateSym;
        NameSym nameSym = annotateSym.getNameSym();
        if (nameSym != null) {
            sym = nameSym;
        }
        if ((javaType = this.resolveType(sym, string)) == null) {
            return (JavaAnnotation)this.error(sym, (short)69, string);
        }
        if (!javaType.isAnnotation()) {
            return (JavaAnnotation)this.error(sym, (short)58, javaType);
        }
        this.recordUsage(annotateSym, javaType);
        annotateObj.annotateType = javaType;
        annotateObj.flag_resolved = true;
        annotateObj.annotateComponents = AnnotationComponents.createInstance(javaType);
        if (annotateObj.annotateComponents == null) {
            CompilerLayer4.panic("Creating the component map failed!");
        }
        return annotateObj;
    }

    public final JavaAnnotation compile(AnnotateSym annotateSym) {
        this.resolve(annotateSym);
        AnnotateObj annotateObj = annotateSym.getObj();
        if (annotateObj.flag_compiled) {
            return annotateObj;
        }
        if (annotateObj.annotateType == null) {
            return annotateObj;
        }
        ListExpr listExpr = annotateSym.getArgumentListSym();
        CompilerContext compilerContext = this.context;
        try {
            this.context = this.newContext(annotateSym);
            this.processComponents(annotateObj, listExpr);
        }
        finally {
            this.context = compilerContext;
        }
        annotateObj.flag_compiled = true;
        return annotateObj;
    }

    public final JavaElement resolve(BlockSym blockSym) {
        if (blockSym.getChild((byte)18) != null) {
            this.processDuplicates(blockSym.getLocalVariables());
        }
        return null;
    }

    public final JavaVariable resolve(VariableSym variableSym) {
        String string = variableSym.getName();
        if (string != null && string.length() > 0) {
            this.recordDefine(variableSym);
            CompilerContext compilerContext = this.context;
            try {
                this.context = this.newContext(variableSym);
                JavaVariable javaVariable = this.lookupExclusiveLocal(variableSym, string);
                if (javaVariable != null) {
                    this.error(variableSym, (short)46, string, javaVariable);
                }
            }
            finally {
                this.context = compilerContext;
            }
        }
        return this.process(variableSym);
    }

    public final JavaElement resolve(ExpressionStmt expressionStmt) {
        this.processExpressionStatement(expressionStmt.getExpressionSym());
        return null;
    }

    public final JavaElement resolve(ForStmt forStmt) {
        this.processExpressionStatements(forStmt.getInitializationsSym());
        this.processExpressionStatements(forStmt.getUpdatesSym());
        return null;
    }

    public final JavaElement resolve(ReturnStmt returnStmt) {
        MethodSym methodSym;
        JavaType javaType = null;
        MemberSym memberSym = returnStmt.getOwningMemberSym();
        if (memberSym != null && memberSym.symKind == 19 && (javaType = (methodSym = (MethodSym)memberSym).getReturnType()) != null && CompilerLayer4.isVoidType(javaType)) {
            javaType = null;
        }
        Expr expr = returnStmt.getExpressionSym();
        if (javaType != null) {
            if (expr != null) {
                JavaType javaType2;
                JavaHasType javaHasType = expr.getResolvedObject();
                if (javaHasType != null && javaHasType instanceof JavaType) {
                    this.error(expr, (short)68, javaHasType);
                }
                if ((javaType2 = expr.getResolvedType()) != null) {
                    this.processAssignment(javaType, expr);
                }
            } else {
                PrimitiveType primitiveType = PrimitiveType.PRIMITIVE_objects[9];
                this.error(returnStmt, (short)37, primitiveType, javaType);
            }
        } else if (expr != null) {
            this.error(expr, (short)70);
        }
        return null;
    }

    public final JavaElement resolve(SynchStmt synchStmt) {
        Expr expr = synchStmt.getExpressionSym();
        if (expr == null) {
            return null;
        }
        JavaHasType javaHasType = this.processExpression(expr);
        if (javaHasType == null) {
            return null;
        }
        if (javaHasType instanceof JavaType) {
            this.error(expr, (short)65, javaHasType);
        }
        return null;
    }

    public final JavaElement resolve(ThrowStmt throwStmt) {
        Expr expr = throwStmt.getExpressionSym();
        if (expr == null) {
            return null;
        }
        JavaType javaType = expr.getResolvedType();
        if (javaType == null) {
            return null;
        }
        this.checkException(throwStmt, javaType);
        return null;
    }

    private void processComponents(AnnotateObj annotateObj, ListExpr listExpr) {
        Expr expr;
        if (listExpr == null) {
            return;
        }
        int n = listExpr.getOperandCount();
        if (n == 0) {
            return;
        }
        if (n == 1 && (expr = listExpr.getNthOperandSym(0)) != null && expr.exprOptcode != 6) {
            this.processSingleComponent(annotateObj, expr);
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            Expr expr2 = listExpr.getNthOperandSym(n2);
            this.processNormalComponent(annotateObj, expr2);
            ++n2;
        }
    }

    private void processSingleComponent(AnnotateObj annotateObj, Expr expr) {
        JavaType javaType;
        Object object;
        JavaType javaType2 = annotateObj.annotateType;
        Collection collection = javaType2.getDeclaredMethods();
        if (collection.size() != 1) {
            this.error(null, (short)55);
            return;
        }
        JavaMethod javaMethod = (JavaMethod)collection.iterator().next();
        if (javaMethod != null) {
            this.recordUsage(this.context.symCookie, javaMethod);
        }
        if ((object = this.processComponentValue(javaType = javaMethod.getResolvedType(), expr)) != null) {
            annotateObj.annotateComponents.assignValue(javaMethod.getName(), object);
        }
    }

    private void processNormalComponent(AnnotateObj annotateObj, Expr expr) {
        JavaType javaType;
        Object object;
        if (expr.exprOptcode != 6) {
            return;
        }
        Expr expr2 = expr.getNthOperandSym(0);
        JavaHasType javaHasType = expr2.getResolvedObject();
        if (javaHasType == null) {
            return;
        }
        if (javaHasType.getElementKind() != 4) {
            return;
        }
        Expr expr3 = expr.getNthOperandSym(1);
        QuickComponent quickComponent = (QuickComponent)javaHasType;
        JavaMethod javaMethod = quickComponent.getMethod();
        if (javaMethod != null) {
            this.recordUsage(this.context.symCookie, javaMethod);
        }
        if ((object = this.processComponentValue(javaType = quickComponent.getResolvedType(), expr3)) != null) {
            annotateObj.annotateComponents.assignValue(quickComponent.getName(), object);
        }
    }

    private Object processComponentValue(JavaType javaType, Expr expr) {
        JavaType javaType2;
        Object object = expr.getConstantValue();
        if (object == null) {
            return null;
        }
        JavaType javaType3 = expr.getResolvedType();
        if (javaType3 == null) {
            return null;
        }
        if (javaType == null || javaType.isAssignableFrom(javaType3)) {
            return object;
        }
        if (javaType.isArray() && ((javaType2 = javaType.getComponentType()) == null || javaType2.isAssignableFrom(javaType3))) {
            return new Object[]{object};
        }
        return null;
    }

    public final JavaVariable process(VariableSym variableSym) {
        Expr expr = variableSym.getExpressionSym();
        if (expr != null) {
            JavaType javaType = variableSym.getResolvedType();
            this.processAssignment(javaType, expr);
        }
        return variableSym;
    }

    /*
     * Unable to fully structure code
     */
    private JavaVariable lookupExclusiveLocal(VariableSym var1_1, String var2_2) {
        var3_3 = this.context.cleanScope();
        if (var3_3 != null) ** GOTO lbl8
        return null;
        while (var3_3.symKind != 3) {
            if (var3_3.symKind != 18 && (var4_4 = this.context.findVariable(var3_3, var2_2, true)) != null && var4_4 != var1_1) {
                return var4_4;
            }
            var3_3 = this.context.nextScope();
lbl8:
            // 2 sources

            if (var3_3 != null) continue;
        }
        return null;
    }

    protected final void processDuplicates(Collection collection) {
        HashMap<String, VariableSym> hashMap = null;
        for (VariableSym variableSym : collection) {
            VariableSym variableSym2;
            String string = variableSym.getName();
            if (hashMap == null) {
                hashMap = new HashMap<String, VariableSym>();
            }
            if ((variableSym2 = (VariableSym)hashMap.get(string)) != null) {
                Sym sym = variableSym;
                NameSym nameSym = variableSym.getNameSym();
                if (nameSym != null) {
                    sym = nameSym;
                }
                this.error(sym, (short)46, string, variableSym2);
            }
            hashMap.put(string, variableSym);
        }
    }

    private void processAssignment(JavaType javaType, Expr expr) {
        if (expr == null || javaType == null) {
            return;
        }
        JavaType javaType2 = expr.getResolvedType();
        if (javaType2 == null) {
            return;
        }
        JavaHasType javaHasType = expr.getResolvedObject();
        if (javaHasType != null && javaHasType instanceof JavaType) {
            this.error(expr, (short)68, javaHasType);
        }
        if (CompilerLayer4.applyAssignmentConversion(javaType2, javaType, false, this.provider)) {
            return;
        }
        boolean bl = true;
        if (CompilerLayer4.applyAssignmentConversion(javaType2, javaType, true, this.provider)) {
            return;
        }
        this.error(expr, (short)37, javaType2, javaType);
    }

    public final void processExpressionStatements(ListExpr listExpr) {
        if (listExpr == null) {
            return;
        }
        for (Expr expr : listExpr.getOperands()) {
            this.processExpressionStatement(expr);
        }
    }

    public final void processExpressionStatement(Expr expr) {
        if (expr == null) {
            return;
        }
        switch (expr.symKind) {
            case 49: 
            case 54: 
            case 56: {
                return;
            }
            case 61: {
                boolean bl = false;
                switch (expr.exprOptcode) {
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: {
                        return;
                    }
                }
            }
        }
        this.error(expr, (short)49);
    }

    CompilerLayer4() {
    }
}

