/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.QuickMethod;
import oracle.javatools.parser.java.v2.internal.compiler.ClassObj;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerLayer5j;
import oracle.javatools.parser.java.v2.internal.compiler.ImportObj;
import oracle.javatools.parser.java.v2.internal.compiler.TypeVariableObj;
import oracle.javatools.parser.java.v2.internal.symbol.ClassBodySym;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.FieldSym;
import oracle.javatools.parser.java.v2.internal.symbol.FormalsSym;
import oracle.javatools.parser.java.v2.internal.symbol.ImportSym;
import oracle.javatools.parser.java.v2.internal.symbol.InitializerSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.RootSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;

abstract class CompilerLayer5
extends CompilerLayer5j {
    public final void resolve(RootSym rootSym) {
        if (this.inUsageMode()) {
            return;
        }
        ArrayList arrayList = CompilerLayer5.allocArrayList();
        arrayList.add("java.lang.*");
        List list = rootSym.getSourceImports();
        HashMap<String, ImportSym> hashMap = new HashMap<String, ImportSym>(list.size());
        for (ImportSym importSym : list) {
            String string = importSym.getName();
            if (arrayList.contains(string)) {
                importSym.setInvalid();
            }
            arrayList.add(string);
            if (!importSym.isNarrow()) continue;
            int n = string.lastIndexOf(46);
            String string2 = string.substring(n + 1);
            ImportSym importSym2 = (ImportSym)hashMap.get(string2);
            if (importSym2 != null) {
                if (!importSym2.isInvalid()) {
                    importSym2.setInvalid();
                    this.error(importSym2, (short)34, string);
                }
                importSym.setInvalid();
                this.error(importSym, (short)34, string);
            }
            hashMap.put(string2, importSym2);
        }
        CompilerLayer5.freeArrayList(arrayList);
    }

    public final void compile(RootSym rootSym) {
        if (this.inUsageMode()) {
            return;
        }
        List list = rootSym.getSourceImports();
        for (ImportSym importSym : list) {
            if (importSym.isInvalid()) continue;
            ImportObj importObj = importSym.getImportObj();
            if (importSym.isUsed()) {
                int n;
                if (importObj.importList == null) continue;
                if (importObj.importResults != null) {
                    CompilerLayer5.panic(importSym);
                }
                importObj.importResults = (n = importObj.importList.size()) == 0 ? JavaHasType.EMPTY_ARRAY : importObj.importList.toArray(new JavaHasType[n]);
                importObj.importList = null;
                continue;
            }
            this.error(importSym, (short)71);
        }
    }

    public final void resolve(ImportSym importSym) {
        boolean bl;
        ImportObj importObj = importSym.getImportObj();
        if (importObj.flag_resolved) {
            return;
        }
        if (importSym.isInvalid()) {
            return;
        }
        String string = importSym.getName();
        if (string.length() == 0) {
            return;
        }
        if (importSym.isStatic()) {
            String string2;
            JavaClass javaClass;
            bl = true;
            int n = string.lastIndexOf(46);
            if (n != -1 && (javaClass = this.provider.getClass(string2 = string.substring(0, n))) != null) {
                importObj.importQualifyingType = javaClass;
                bl = false;
            }
        } else {
            bl = false;
            if (importSym.isNarrow()) {
                JavaClass javaClass = this.provider.getClass(string);
                if (javaClass != null) {
                    this.recordUsage(importSym, javaClass);
                    importObj.importResults = new JavaHasType[]{javaClass};
                } else {
                    bl = true;
                }
            }
        }
        if (bl) {
            importSym.setInvalid();
            importObj.importResults = JavaHasType.EMPTY_ARRAY;
            this.error(importSym, (short)48, string);
        }
        if (!importSym.isInvalid() && importObj.importResults == null) {
            importObj.importList.clear();
        } else {
            importObj.importList = null;
        }
        importObj.flag_resolved = true;
    }

    public final JavaClass resolve(ClassSym classSym) {
        ClassObj classObj = classSym.getClassObj();
        if (classObj.flag_resolved) {
            return classSym;
        }
        JavaType javaType = null;
        TypeSym typeSym = classSym.tySuper;
        if (typeSym != null) {
            typeSym.resolve((CompilerDriver)this);
            JavaType javaType2 = typeSym.getResolvedType();
            if (javaType2 != null) {
                JavaClass javaClass;
                if (javaType2.getElementKind() != 3) {
                    this.error(typeSym, (short)45);
                }
                if ((javaClass = javaType2.getTypeErasure()) != null && !javaClass.isInterface()) {
                    javaType = javaClass;
                }
            }
        }
        if (javaType == null) {
            javaType = this.resolveSuperclass(classSym);
        }
        classObj.typeSuperclass = javaType;
        for (TypeSym typeSym2 : classSym.getSourceInterfaces()) {
            typeSym2.resolve((CompilerDriver)this);
        }
        if (this.needsClinitMethod(classSym)) {
            classObj.classClinit = QuickMethod.createMethod(classSym, '\b', null, "<clinit>", null, null);
        }
        classObj.typeHierarchy = null;
        classObj.flag_resolved = true;
        return classSym;
    }

    public final void compile(ClassSym classSym) {
        this.recordDefine(classSym);
    }

    public final JavaTypeVariable resolve(TypeParameterSym typeParameterSym) {
        TypeVariableObj typeVariableObj = typeParameterSym.getTypeVariableObj();
        if (typeVariableObj.flag_resolved) {
            return typeParameterSym;
        }
        this.resolveBounds(typeParameterSym);
        typeVariableObj.typeHierarchy = null;
        this.recordDefine(typeParameterSym);
        typeParameterSym.setProcessed();
        typeVariableObj.flag_resolved = true;
        return typeParameterSym;
    }

    public final JavaTypeVariable compile(TypeParameterSym typeParameterSym) {
        TypeVariableObj typeVariableObj = typeParameterSym.getTypeVariableObj();
        if (!typeVariableObj.flag_resolved) {
            this.resolve(typeParameterSym);
        }
        if (typeVariableObj.flag_compiled) {
            return typeParameterSym;
        }
        typeVariableObj.flag_compiled = true;
        return typeParameterSym;
    }

    public final JavaElement resolve(FormalsSym formalsSym) {
        if (!this.inUsageMode() && formalsSym.getChild((byte)13) != null) {
            this.processDuplicates(formalsSym.getChildren((byte)13));
        }
        return null;
    }

    public final JavaElement resolve(ClassBodySym classBodySym) {
        if (!this.inUsageMode()) {
            this.processDuplicates(classBodySym.getSourceFieldVariables());
        }
        return null;
    }

    public final JavaMethod resolve(MethodSym methodSym) {
        if (!methodSym.isProcessed()) {
            this.recordDefine(methodSym);
        }
        methodSym.setProcessed();
        return methodSym;
    }

    private JavaType resolveSuperclass(ClassSym classSym) {
        if ("java.lang.Object".equals(classSym.getQualifiedName())) {
            return null;
        }
        JavaType javaType = null;
        switch (classSym.getTypeKind()) {
            case 2: {
                JavaType[] javaTypeArray;
                JavaClass javaClass = this.provider.getClassByVMName("java/lang/Enum");
                if (javaClass == null || (javaType = CommonUtilities.createParameterizedType(this.provider, javaClass, javaTypeArray = new JavaType[]{classSym})) != null) break;
                javaType = javaClass;
                break;
            }
            case 1: {
                javaType = this.getPreloadedClass((byte)4);
                break;
            }
            case 3: {
                javaType = this.getSystemClass("java/lang/annotation/Annotation");
            }
        }
        if (javaType == null) {
            Sym sym;
            JavaType javaType2;
            TypeSym typeSym = (TypeSym)classSym.getSourceSuperclass();
            if (typeSym != null && (javaType2 = (JavaType)typeSym.resolve((CompilerDriver)this)) != null) {
                return javaType2;
            }
            if (classSym.isAnonymous() && (sym = classSym.getParentSym()) != null && sym.symKind == 7) {
                javaType = classSym.getOwningClassSym();
            }
            if (javaType == null) {
                javaType = this.getPreloadedClass((byte)4);
            }
        }
        if (javaType != null) {
            this.recordUsage(classSym, javaType);
        }
        return javaType;
    }

    private void resolveBounds(TypeParameterSym typeParameterSym) {
        TypeVariableObj typeVariableObj = typeParameterSym.getTypeVariableObj();
        typeVariableObj.typeSuperclass = null;
        typeVariableObj.typeInterfaces = JavaConstants.kEmptyCollection;
        TypeSym typeSym = typeParameterSym.getFirstBoundSym();
        if (typeSym != null) {
            List list = typeParameterSym.getSourceBounds();
            if (list.size() == 1) {
                JavaType javaType = typeSym.getResolvedType();
                if (javaType != null) {
                    if (!javaType.isInterface()) {
                        typeVariableObj.typeSuperclass = javaType;
                    } else {
                        typeVariableObj.typeInterfaces = Arrays.asList(javaType);
                    }
                }
            } else {
                JavaType javaType;
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(typeParameterSym.getObjects((byte)28));
                if (!arrayList.isEmpty() && !(javaType = (JavaType)arrayList.get(0)).isInterface()) {
                    typeVariableObj.typeSuperclass = javaType;
                    arrayList.remove(0);
                }
                typeVariableObj.typeInterfaces = arrayList;
            }
        }
        if (typeVariableObj.typeSuperclass == null) {
            typeVariableObj.typeSuperclass = this.getPreloadedClass((byte)4);
        }
    }

    private boolean needsClinitMethod(ClassSym classSym) {
        if (!classSym.getSourceEnumConstants().isEmpty()) {
            return true;
        }
        for (FieldSym fieldSym : classSym.getSourceFieldVariables()) {
            if (!fieldSym.isStatic() || fieldSym.getInitializer() == null) continue;
            return true;
        }
        for (InitializerSym initializerSym : classSym.getSourceInitializers()) {
            if (!initializerSym.isStatic()) continue;
            return true;
        }
        return false;
    }

    CompilerLayer5() {
    }
}

