/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.List;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerLayer4;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.FormalParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.MemberSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocReferenceSym;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;

abstract class CompilerLayer5j
extends CompilerLayer4 {
    public JavaElement resolve(DocReferenceSym docReferenceSym) {
        if (docReferenceSym.refParameterName != null) {
            return this.resolveParameterReference(docReferenceSym);
        }
        return this.resolveMemberReference(docReferenceSym);
    }

    private JavaElement resolveParameterReference(DocReferenceSym docReferenceSym) {
        block4: {
            int n;
            String string = docReferenceSym.refParameterName;
            if (string == null || string.length() == 0) {
                return null;
            }
            if (string.charAt(0) == '<' && string.charAt((n = string.length()) - 1) == '>') {
                String string2 = string.substring(1, n - 1);
                JavaType javaType = this.resolveType(docReferenceSym, string2);
                if (javaType != null && javaType.getElementKind() == 10) {
                    this.recordUsage(docReferenceSym, javaType);
                    return javaType;
                }
                this.error(docReferenceSym, (short)72, string);
                return null;
            }
            MemberSym memberSym = docReferenceSym.getOwningMemberSym();
            if (memberSym.symKind != 6 && memberSym.symKind != 19) break block4;
            MethodSym methodSym = (MethodSym)memberSym;
            for (FormalParameterSym formalParameterSym : methodSym.getSourceParameters()) {
                if (!string.equals(formalParameterSym.getName())) continue;
                this.recordUsage(docReferenceSym, formalParameterSym);
                return formalParameterSym;
            }
            this.error(docReferenceSym, (short)72, string);
        }
        return null;
    }

    private JavaElement resolveMemberReference(DocReferenceSym docReferenceSym) {
        CompilerContext compilerContext = this.context;
        try {
            JavaElement javaElement;
            this.context = this.newContext(docReferenceSym);
            this.context.suppressErrors = true;
            String string = docReferenceSym.refClassName;
            String string2 = docReferenceSym.refMemberName;
            JavaType javaType = null;
            if (string != null) {
                javaType = this.resolveType(docReferenceSym, string);
                if (javaType == null) {
                    JavaElement javaElement2 = this.error(docReferenceSym, (short)72, string);
                    this.context = compilerContext;
                    return javaElement2;
                }
                this.recordUsage(docReferenceSym, javaType);
                if (string2 == null) {
                    JavaType javaType2 = javaType;
                    this.context = compilerContext;
                    return javaType2;
                }
            } else if (string2 == null) {
                JavaElement javaElement3 = this.error(docReferenceSym, (short)50);
                this.context = compilerContext;
                return javaElement3;
            }
            if (string2.length() == 0) {
                JavaElement javaElement4 = this.error(docReferenceSym, (short)50);
                this.context = compilerContext;
                return javaElement4;
            }
            List list = docReferenceSym.refMethodParameters;
            JavaType[] javaTypeArray = null;
            if (list != null) {
                int n = list.size();
                javaTypeArray = n > 0 ? new JavaType[n] : JavaType.EMPTY_ARRAY;
                int n2 = 0;
                while (n2 < n) {
                    JavaType javaType3 = this.resolveType(this.context.symCookie, (String)list.get(n2));
                    if (javaType3 != null) {
                        this.recordUsage(docReferenceSym, javaType3);
                        javaTypeArray[n2] = javaType3;
                    }
                    ++n2;
                }
            }
            if ((javaElement = javaType != null ? this.processQualifiedReference(javaType, string2, javaTypeArray) : this.processUnqualifiedReference(string2, javaTypeArray)) == null) {
                this.error(docReferenceSym, (short)72, string2);
            } else {
                this.recordUsage(docReferenceSym, javaElement);
            }
            JavaElement javaElement5 = javaElement;
            this.context = compilerContext;
            return javaElement5;
        }
        catch (Throwable throwable) {
            this.context = compilerContext;
            throw throwable;
        }
    }

    private JavaElement processUnqualifiedReference(String string, JavaType[] javaTypeArray) {
        Sym sym = this.context.cleanScope();
        while (sym != null) {
            if (sym.symKind == 3) {
                ClassSym classSym = (ClassSym)sym;
                if (javaTypeArray == null && this.context.findVisibleVariable(classSym, string)) {
                    return this.context.findMemberVariable(classSym, string);
                }
                boolean bl = string.equals(classSym.getName());
                String string2 = string;
                if (bl) {
                    string2 = "<init>";
                }
                if (bl || this.context.findVisibleMethod(classSym, string2)) {
                    if (javaTypeArray != null) {
                        return this.context.findMethod(classSym, string2, javaTypeArray);
                    }
                    return this.context.findSingleMethod(classSym, string2);
                }
            }
            sym = this.context.nextScope();
        }
        return null;
    }

    private JavaElement processQualifiedReference(JavaType javaType, String string, JavaType[] javaTypeArray) {
        if (javaType != null) {
            JavaVariable javaVariable;
            if (javaTypeArray == null && (javaVariable = this.context.findMemberVariable(javaType, string)) != null) {
                return javaVariable;
            }
            boolean bl = string.equals(javaType.getName());
            String string2 = string;
            if (bl) {
                string2 = "<init>";
            }
            if (javaTypeArray != null) {
                return this.context.findMethod(javaType, string2, javaTypeArray);
            }
            return this.context.findSingleMethod(javaType, string2);
        }
        return null;
    }

    CompilerLayer5j() {
    }
}

