/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.Collection;
import java.util.Iterator;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.internal.InternalUtilities;
import oracle.javatools.parser.java.v2.internal.compiler.FileObj;
import oracle.javatools.parser.java.v2.internal.compiler.ObjConstants;
import oracle.javatools.parser.java.v2.internal.symbol.ErrorSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;

abstract class CompilerUtilities
extends InternalUtilities
implements ObjConstants {
    protected static final String kJavaLang = "java.lang";
    protected static final String kJavaLangStar = "java.lang.*";
    protected static final String kJavaLangObject = "java.lang.Object";
    protected static final String kJavaLangString = "java.lang.String";
    static final String kThis = "this";
    static final String kSuper = "super";
    static final String kInit = "<init>";

    protected static boolean isComponentAssignment(Sym sym) {
        Sym sym2;
        Sym sym3 = sym.getParentSym();
        return sym3 != null && sym3.symKind == 52 && (sym2 = sym3.getParentSym()) != null && sym2.symKind == 1;
    }

    protected static boolean isMoreSpecific(JavaMethod javaMethod, JavaMethod javaMethod2) {
        Collection collection = javaMethod.getParameters();
        Collection collection2 = javaMethod2.getParameters();
        if (collection.size() != collection2.size()) {
            return false;
        }
        Iterator iterator = collection.iterator();
        Iterator iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            JavaVariable javaVariable = (JavaVariable)iterator.next();
            JavaVariable javaVariable2 = (JavaVariable)iterator2.next();
            JavaType javaType = javaVariable.getResolvedType();
            JavaType javaType2 = javaVariable2.getResolvedType();
            if (javaType == null && javaType2 == null) continue;
            if (javaType == null || javaType2 == null) {
                return false;
            }
            if (CompilerUtilities.applyMethodConversion(javaType, javaType2, false, null)) continue;
            return false;
        }
        return true;
    }

    protected static final boolean isBooleanType(JavaType javaType) {
        if (javaType == null) {
            return false;
        }
        if (!javaType.isPrimitive()) {
            javaType = CompilerUtilities.applyUnboxingConversion(javaType);
        }
        if (javaType == null) {
            return false;
        }
        PrimitiveType primitiveType = (PrimitiveType)javaType;
        return primitiveType.primCode == 0;
    }

    protected static final boolean isVoidType(JavaType javaType) {
        if (javaType == null) {
            return false;
        }
        if (!javaType.isPrimitive()) {
            return false;
        }
        PrimitiveType primitiveType = (PrimitiveType)javaType;
        return primitiveType.primCode == 9;
    }

    protected static final boolean isNumericType(JavaType javaType) {
        if (javaType == null) {
            return false;
        }
        if (!javaType.isPrimitive()) {
            javaType = CompilerUtilities.applyUnboxingConversion(javaType);
        }
        if (javaType == null) {
            return false;
        }
        PrimitiveType primitiveType = (PrimitiveType)javaType;
        return primitiveType.isNumeric();
    }

    protected static final boolean isIntegralType(JavaType javaType) {
        if (javaType == null) {
            return false;
        }
        if (!javaType.isPrimitive()) {
            javaType = CompilerUtilities.applyUnboxingConversion(javaType);
        }
        if (javaType == null) {
            return false;
        }
        PrimitiveType primitiveType = (PrimitiveType)javaType;
        return primitiveType.isIntegral();
    }

    protected static final boolean isIntegralOrBooleanType(JavaType javaType) {
        if (javaType == null) {
            return false;
        }
        if (!javaType.isPrimitive()) {
            javaType = CompilerUtilities.applyUnboxingConversion(javaType);
        }
        if (javaType == null) {
            return false;
        }
        PrimitiveType primitiveType = (PrimitiveType)javaType;
        return primitiveType.isIntegral() || primitiveType.primCode == 0;
    }

    public final ErrorSym generateError(FileSym fileSym, Sym sym, short s) {
        return this.generateErrorImpl(fileSym, sym, s, JavaConstants.EMPTY_OBJECT_ARRAY);
    }

    public final ErrorSym generateError(FileSym fileSym, Sym sym, short s, Object object) {
        if (object != null) {
            return this.generateErrorImpl(fileSym, sym, s, new Object[]{object});
        }
        return this.generateError(fileSym, sym, s);
    }

    public final ErrorSym generateError(FileSym fileSym, Sym sym, short s, Object object, Object object2) {
        if (object2 != null) {
            return this.generateErrorImpl(fileSym, sym, s, new Object[]{object, object2});
        }
        return this.generateError(fileSym, sym, s, object);
    }

    public final ErrorSym generateErrorImpl(FileSym fileSym, Sym sym, short s, Object[] objectArray) {
        boolean bl;
        if (sym.is((byte)86)) {
            return null;
        }
        boolean bl2 = bl = 33 <= s && s < 74;
        if (!bl) {
            CompilerUtilities.panic(sym);
        }
        FileObj fileObj = fileSym.getFileObj();
        ErrorSym errorSym = (ErrorSym)SymFactory.createNode(fileSym, 8);
        errorSym.symFile = fileSym;
        if (sym != null) {
            errorSym.symStart = sym.symStart;
            errorSym.symEnd = sym.symEnd;
            errorSym.errorSymbol = sym;
        } else {
            errorSym.symStart = 0;
            errorSym.symEnd = 0;
        }
        errorSym.errorCode = s;
        errorSym.errorRefData = objectArray;
        String string = CompilerUtilities.error2message(s);
        switch (s) {
            case 46: 
            case 48: 
            case 56: 
            case 62: 
            case 69: 
            case 72: {
                String string2 = (String)errorSym.getErrorRefData(0);
                string = CompilerUtilities.format(string, string2);
                break;
            }
            case 43: 
            case 51: 
            case 52: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 66: 
            case 67: {
                JavaElement javaElement = (JavaElement)errorSym.getErrorRefData(0);
                string = CompilerUtilities.format(string, CompilerUtilities.elementToDisplayText(javaElement));
                break;
            }
            case 53: {
                String string3 = (String)errorSym.getErrorRefData(0);
                JavaElement javaElement = (JavaElement)errorSym.getErrorRefData(1);
                string = CompilerUtilities.format(string, string3, CompilerUtilities.elementToDisplayText(javaElement));
                break;
            }
            case 37: 
            case 42: {
                JavaType javaType = (JavaType)errorSym.getErrorRefData(0);
                JavaType javaType2 = (JavaType)errorSym.getErrorRefData(1);
                string = CompilerUtilities.format(string, CompilerUtilities.elementToDisplayText(javaType), CompilerUtilities.elementToDisplayText(javaType2));
                break;
            }
            case 54: {
                String string4;
                String string5 = (String)errorSym.getErrorRefData(0);
                JavaType[] javaTypeArray = (JavaType[])errorSym.getErrorRefData(1);
                if (javaTypeArray != null) {
                    StringBuffer stringBuffer = new StringBuffer(string5);
                    int n = javaTypeArray.length;
                    stringBuffer.append('(');
                    if (n > 0) {
                        boolean bl3 = false;
                        int n2 = 0;
                        while (n2 < n) {
                            if (bl3) {
                                stringBuffer.append(',');
                            }
                            stringBuffer.append(CompilerUtilities.elementToDisplayText(javaTypeArray[n2]));
                            bl3 = true;
                            ++n2;
                        }
                    }
                    stringBuffer.append(')');
                    string4 = stringBuffer.toString();
                } else {
                    string4 = string5;
                }
                JavaType javaType = (JavaType)errorSym.getErrorRefData(2);
                String string6 = javaType != null ? CompilerUtilities.elementToDisplayText(javaType) : "<unknown>";
                string = CompilerUtilities.format(string, string4, string6);
            }
        }
        errorSym.errorMessage = string;
        errorSym.symParent = fileSym.compileErrors;
        errorSym.buildSelf();
        if (fileObj.errorData != null) {
            fileObj.errorData.addKid(errorSym);
        }
        return errorSym;
    }

    protected static String elementToDisplayText(JavaType javaType) {
        if (javaType != null) {
            return javaType.getQualifiedName();
        }
        return "<unknown>";
    }

    protected static String elementToDisplayText(JavaMethod javaMethod) {
        if (javaMethod == null) {
            return "<unknown>";
        }
        String string = javaMethod.isConstructor() ? kInit : javaMethod.getName();
        StringBuffer stringBuffer = new StringBuffer(javaMethod.getName());
        stringBuffer.append('(');
        Collection collection = javaMethod.getParameters();
        if (!collection.isEmpty()) {
            Iterator iterator = collection.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(',');
                }
                JavaVariable javaVariable = (JavaVariable)iterator.next();
                stringBuffer.append(CompilerUtilities.elementToDisplayText(javaVariable.getResolvedType()));
                bl = true;
            }
        }
        stringBuffer.append(')');
        String string2 = stringBuffer.toString();
        JavaClass javaClass = javaMethod.getOwningClass();
        if (javaClass != null) {
            return javaClass.getQualifiedName() + '.' + string2;
        }
        return string2;
    }

    protected static String elementToDisplayText(JavaField javaField) {
        if (javaField == null) {
            return "<unknown>";
        }
        String string = javaField.getName();
        JavaClass javaClass = javaField.getOwningClass();
        if (javaClass != null) {
            return javaClass.getQualifiedName() + '.' + string;
        }
        return string;
    }

    protected static String elementToDisplayText(JavaPackage javaPackage) {
        if (javaPackage == null) {
            return "<unknown>";
        }
        return javaPackage.getQualifiedName();
    }

    public static String elementToDisplayText(JavaElement javaElement) {
        if (javaElement != null) {
            if (javaElement instanceof JavaType) {
                return CompilerUtilities.elementToDisplayText((JavaType)javaElement);
            }
            if (javaElement instanceof JavaField) {
                return CompilerUtilities.elementToDisplayText((JavaField)javaElement);
            }
            if (javaElement instanceof JavaMethod) {
                return CompilerUtilities.elementToDisplayText((JavaMethod)javaElement);
            }
            if (javaElement instanceof JavaPackage) {
                return CompilerUtilities.elementToDisplayText((JavaPackage)javaElement);
            }
        }
        return "<unknown>";
    }

    protected static final void panic(Sym sym) {
        System.out.println(sym.toString());
        CompilerUtilities.panic();
    }

    CompilerUtilities() {
    }
}

