/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.lang.reflect.Modifier;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerUtilities;
import oracle.javatools.parser.java.v2.internal.compiler.ObjConstants;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceVariable;

abstract class ContextImageA
extends CompilerUtilities
implements ObjConstants {
    protected boolean flag_instance;
    protected boolean flag_static;
    protected boolean flag_nonfinal;
    protected boolean suppressErrors;
    protected final CompilerDriver compiler;
    protected final JavaClass callerClass;
    protected final Sym symCookie;
    private Sym symScope;

    void $init$() {
        this.flag_instance = true;
        this.flag_static = true;
        this.flag_nonfinal = true;
        this.suppressErrors = false;
    }

    ContextImageA(CompilerDriver compilerDriver, JavaClass javaClass) {
        this.$init$();
        this.compiler = compilerDriver;
        this.callerClass = javaClass;
        this.symCookie = null;
    }

    ContextImageA(CompilerDriver compilerDriver, Sym sym) {
        this.$init$();
        this.compiler = compilerDriver;
        this.callerClass = null;
        this.symCookie = sym;
    }

    ContextImageA(CompilerContext compilerContext) {
        this.$init$();
        this.compiler = compilerContext.compiler;
        this.callerClass = compilerContext.callerClass;
        this.symCookie = compilerContext.symCookie;
        this.flag_instance = compilerContext.flag_instance;
        this.flag_static = compilerContext.flag_static;
        this.flag_nonfinal = compilerContext.flag_nonfinal;
    }

    protected final Sym cleanScope() {
        this.flag_instance = true;
        this.flag_static = true;
        this.flag_nonfinal = true;
        this.symScope = this.symCookie.getScope();
        return this.symScope;
    }

    protected final Sym nextScope() {
        Sym sym;
        if (this.symScope == null) {
            return null;
        }
        if (this.symScope.isStatic()) {
            this.flag_instance = false;
        }
        if ((sym = this.symScope.getScope()) != null && this.symScope.symKind == 3 && sym.symKind != 4) {
            this.flag_nonfinal = false;
        }
        this.symScope = sym;
        return sym;
    }

    protected final boolean allowAccess(JavaElement javaElement) {
        if (javaElement == null) {
            return true;
        }
        return this.processAccess(javaElement);
    }

    protected final JavaElement error(short s) {
        return this.error(s, null, null);
    }

    protected final JavaElement error(short s, Object object) {
        return this.error(s, object, null);
    }

    protected final JavaElement error(short s, Object object, Object object2) {
        if (this.suppressErrors) {
            return null;
        }
        if (this.symCookie == null) {
            return null;
        }
        FileSym fileSym = this.symCookie.symFile;
        if (fileSym == null) {
            return null;
        }
        this.generateError(fileSym, this.symCookie, s, object, object2);
        return null;
    }

    private boolean processAccess(JavaElement javaElement) {
        int n;
        boolean bl;
        if (javaElement instanceof JavaPackage) {
            return true;
        }
        switch (javaElement.getElementKind()) {
            case 9: {
                return true;
            }
            case 7: {
                if (!this.flag_nonfinal && !javaElement.isFinal()) {
                    return false;
                }
                SourceVariable sourceVariable = (SourceVariable)javaElement.getSourceElement();
                if (sourceVariable != null) {
                    return this.processAccessImpl(sourceVariable);
                }
                return true;
            }
            case 14: 
            case 16: {
                return true;
            }
            case 10: {
                return true;
            }
        }
        boolean bl2 = javaElement instanceof JavaClass;
        if (!bl2 || !this.flag_static) {
            // empty if block
        }
        if (!(bl = this.processAccessImpl(n = javaElement.getModifiers(), javaElement))) {
            return false;
        }
        if (!bl2 && !this.flag_instance) {
            JavaMethod javaMethod;
            if (javaElement.getElementKind() == 8 && (javaMethod = (JavaMethod)javaElement).isConstructor()) {
                return true;
            }
            if (!Modifier.isStatic(n)) {
                return false;
            }
        }
        return true;
    }

    private boolean processAccessImpl(SourceVariable sourceVariable) {
        Sym sym = (Sym)((Object)sourceVariable);
        int n = this.symCookie.getEndOffset();
        if (n < 0) {
            n = this.symCookie.getStartOffset();
        }
        if (n < 0) {
            return true;
        }
        int n2 = sym.getEndOffset();
        if (n2 == -1) {
            return true;
        }
        if (n <= n2) {
            return false;
        }
        Sym sym2 = sym.getParentSym();
        if (sym2 != null && sym2.symKind == 18) {
            int n3 = sym.getEndIndex();
            int n4 = sym.symFile.tokens.tokenStarts[n3 + 1];
            return n4 < n;
        }
        return true;
    }

    private boolean processAccessImpl(int n, JavaElement javaElement) {
        if (Modifier.isPublic(n)) {
            return true;
        }
        JavaClass javaClass = null;
        if (javaElement instanceof JavaMember) {
            javaClass = ((JavaMember)javaElement).getOwningClass();
        }
        if (javaClass == null) {
            if (javaElement instanceof JavaType) {
                return ContextImageA.checkPackageAccess(this.getCallingPackage(), (JavaType)javaElement);
            }
            return false;
        }
        if (javaClass.isPrimitive() || javaClass.isArray()) {
            ContextImageA.panic();
        }
        if (Modifier.isPrivate(n)) {
            return ContextImageA.checkPrivateAccess(this.getCallingClass(), javaClass);
        }
        if (ContextImageA.checkPackageAccess(this.getCallingPackage(), javaClass)) {
            return true;
        }
        if (!Modifier.isProtected(n)) {
            return false;
        }
        return this.checkProtectedAccess(this.symCookie.getScope(), javaClass, javaElement, this.flag_instance);
    }

    protected final boolean processVisible(JavaMember javaMember) {
        int n = javaMember.getModifiers();
        if (Modifier.isPublic(n)) {
            return true;
        }
        JavaClass javaClass = javaMember.getOwningClass();
        if (javaClass == null) {
            if (javaMember instanceof JavaType) {
                return ContextImageA.checkPackageAccess(this.getCallingPackage(), (JavaType)javaMember);
            }
            return false;
        }
        if (javaClass.isArray()) {
            return false;
        }
        if (Modifier.isPrivate(n)) {
            return ContextImageA.checkPrivateAccess(this.getCallingClass(), javaClass);
        }
        if (Modifier.isProtected(n)) {
            return true;
        }
        return ContextImageA.checkPackageAccess(this.getCallingPackage(), javaClass);
    }

    private static boolean checkPrivateAccess(JavaClass javaClass, JavaType javaType) {
        JavaClass javaClass2 = ContextImageA.getOutermost(javaClass);
        JavaClass javaClass3 = ContextImageA.getOutermost(javaType);
        if (javaClass2 == null && javaClass3 == null) {
            return false;
        }
        if (javaClass2 != null) {
            javaClass2 = javaClass2.getTypeErasure();
        }
        if (javaClass3 != null) {
            javaClass3 = javaClass3.getTypeErasure();
        }
        if (javaClass2 == null && javaClass3 == null) {
            return false;
        }
        if (javaClass2 == null || javaClass3 == null) {
            return true;
        }
        return javaClass2.equals(javaClass3);
    }

    private static boolean checkPackageAccess(String string, JavaType javaType) {
        String string2 = javaType.getPackageName();
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    private boolean checkProtectedAccess(Sym sym, JavaType javaType, JavaElement javaElement, boolean bl) {
        boolean bl2 = false;
        while (sym != null) {
            switch (sym.symKind) {
                case 3: {
                    if (bl2) {
                        bl2 = false;
                        break;
                    }
                    JavaClass javaClass = (JavaClass)((Object)sym);
                    if (!javaClass.isSubtypeOf(javaType)) break;
                    int n = javaElement.getElementKind();
                    if (n == 3) {
                        return true;
                    }
                    if (Modifier.isStatic(javaElement.getModifiers())) {
                        return true;
                    }
                    if (bl) {
                        return true;
                    }
                    this.error((short)62);
                    return false;
                }
                case 15: 
                case 23: {
                    bl2 = true;
                }
            }
            if (Modifier.isStatic(sym.getModifiers())) {
                bl = false;
            }
            sym = sym.getScope();
        }
        return false;
    }

    private JavaClass getCallingClass() {
        if (this.callerClass != null) {
            return this.callerClass;
        }
        return this.symCookie.getOwningClassSym();
    }

    private String getCallingPackage() {
        return this.symCookie.getOwningFile().getPackageName();
    }

    protected static JavaClass getOutermost(JavaType javaType) {
        if (javaType == null) {
            return null;
        }
        JavaMember javaMember = null;
        if (javaType.getElementKind() == 3) {
            javaMember = (JavaClass)javaType;
        }
        JavaClass javaClass = javaMember.getOwningClass();
        while (javaClass != null) {
            javaMember = javaClass;
            javaClass = javaMember.getOwningClass();
        }
        return javaMember;
    }
}

