/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.ContextImageA;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.FormalParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.ImportSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.CatchStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.TryStmt;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.SourceMethod;

abstract class ContextImageB
extends ContextImageA {
    private static final int PASS_1 = 1;
    private static final int PASS_2 = 2;
    private static final int PASS_3 = 3;

    ContextImageB(CompilerDriver compilerDriver, JavaClass javaClass) {
        super(compilerDriver, javaClass);
    }

    ContextImageB(CompilerDriver compilerDriver, Sym sym) {
        super(compilerDriver, sym);
    }

    ContextImageB(CompilerContext compilerContext) {
        super(compilerContext);
    }

    protected final boolean findVisibleMethod(JavaType javaType, String string) {
        if (javaType == null) {
            return false;
        }
        if ("<init>".equals(string)) {
            ContextImageB.panic(this.symCookie);
        }
        for (JavaMethod javaMethod : javaType.getDeclaredMethods()) {
            if (!string.equals(javaMethod.getName())) continue;
            return true;
        }
        for (JavaClass javaClass : javaType.getHierarchy()) {
            for (JavaMethod javaMethod : javaClass.getDeclaredMethods()) {
                if (!string.equals(javaMethod.getName()) || !this.processVisible(javaMethod)) continue;
                return true;
            }
        }
        return false;
    }

    protected final JavaMethod findSingleMethod(JavaType javaType, String string) {
        if (javaType == null) {
            return null;
        }
        ArrayList arrayList = ContextImageB.allocArrayList();
        if ("<init>".equals(string)) {
            arrayList.addAll(javaType.getDeclaredConstructors());
        } else {
            for (JavaMethod javaMethod : javaType.getDeclaredMethods()) {
                if (!string.equals(javaMethod.getName())) continue;
                arrayList.add(javaMethod);
            }
            for (JavaClass javaClass : javaType.getHierarchy()) {
                for (JavaMethod javaMethod : javaClass.getDeclaredMethods()) {
                    if (!string.equals(javaMethod.getName()) || !this.processVisible(javaMethod)) continue;
                    arrayList.add(javaMethod);
                }
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        this.findMostSpecificMethod(arrayList);
        if (arrayList.isEmpty()) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (JavaMethod)arrayList.get(0);
        }
        return this.chooseMostSpecificMethod(arrayList);
    }

    protected final JavaMethod findMethod(JavaType javaType, String string, JavaType[] javaTypeArray) {
        return this.findMethod(javaType, string, null, javaTypeArray);
    }

    protected final JavaMethod findMethod(JavaType javaType, String string, JavaType[] javaTypeArray, JavaType[] javaTypeArray2) {
        ArrayList arrayList = ContextImageB.allocArrayList();
        this.findPotentiallyApplicable(javaType, string, javaTypeArray, javaTypeArray2, arrayList);
        return this.processMethods(arrayList, javaTypeArray, javaTypeArray2);
    }

    protected final JavaMethod findImportedMethod(String string, JavaType[] javaTypeArray) {
        this.flag_instance = false;
        JavaType[] javaTypeArray2 = JavaType.EMPTY_ARRAY;
        ArrayList arrayList = ContextImageB.allocArrayList();
        this.processImportedMethods(string, javaTypeArray2, javaTypeArray, arrayList);
        return this.processMethods(arrayList, javaTypeArray2, javaTypeArray);
    }

    protected final boolean checkException(Sym sym, JavaType javaType) {
        byte by = sym.symKind;
        switch (by) {
            case 6: 
            case 19: {
                SourceMethod sourceMethod = (SourceMethod)((Object)sym);
                for (JavaType javaType2 : sourceMethod.getExceptions()) {
                    if (!javaType.isSubtypeOf(javaType2)) continue;
                    return true;
                }
                this.error((short)43, javaType);
                return true;
            }
            case 2: {
                Sym sym2;
                Sym sym3 = sym.getParentSym();
                if (sym3 != null && sym3.symKind == 30 && (sym2 = sym3.getParentSym()) != null && sym2.symKind == 45) {
                    TryStmt tryStmt = (TryStmt)sym2;
                    for (CatchStmt catchStmt : tryStmt.getCatchClauses()) {
                        JavaType javaType3;
                        FormalParameterSym formalParameterSym = catchStmt.getCatchVariableSym();
                        if (formalParameterSym == null || (javaType3 = formalParameterSym.getResolvedType()) == null || !javaType.isSubtypeOf(javaType3)) continue;
                        return true;
                    }
                }
                return false;
            }
            case 5: {
                this.error((short)43, javaType);
                return true;
            }
        }
        return false;
    }

    protected final JavaMethod processMethods(ArrayList arrayList, JavaType[] javaTypeArray, JavaType[] javaTypeArray2) {
        JavaMethod javaMethod;
        if (javaTypeArray == null) {
            javaTypeArray = JavaType.EMPTY_ARRAY;
        }
        if ((javaMethod = this.processMethodsImpl(arrayList, javaTypeArray, javaTypeArray2)) == null) {
            return null;
        }
        if (!javaMethod.hasTypeParameters()) {
            return javaMethod;
        }
        if (javaTypeArray.length == 0 && (javaTypeArray = this.inferTypeArguments(javaMethod, javaTypeArray2)) == null) {
            return javaMethod;
        }
        if (javaMethod.hasActualTypeArguments()) {
            ContextImageB.panic("But it already has actual type arguments.");
        }
        return ContextImageB.createParameterizedMethod(this.compiler.provider, javaMethod, javaTypeArray);
    }

    private final JavaMethod processMethodsImpl(ArrayList arrayList, JavaType[] javaTypeArray, JavaType[] javaTypeArray2) {
        if (arrayList.isEmpty()) {
            return null;
        }
        ArrayList arrayList2 = ContextImageB.allocArrayList();
        if (arrayList2.isEmpty()) {
            this.findApplicable(1, javaTypeArray, javaTypeArray2, arrayList, arrayList2);
        }
        if (arrayList2.isEmpty()) {
            this.findApplicable(2, javaTypeArray, javaTypeArray2, arrayList, arrayList2);
        }
        if (arrayList2.isEmpty()) {
            this.findApplicable(3, javaTypeArray, javaTypeArray2, arrayList, arrayList2);
        }
        if (arrayList2.isEmpty()) {
            return null;
        }
        ArrayList arrayList3 = ContextImageB.allocArrayList();
        arrayList3.addAll(arrayList2);
        try {
            int n = arrayList3.size();
            if (n == 0) {
                JavaMethod javaMethod = null;
                ContextImageB.freeArrayList(arrayList3);
                return javaMethod;
            }
            if (n == 1) {
                JavaMethod javaMethod = (JavaMethod)arrayList3.get(0);
                ContextImageB.freeArrayList(arrayList3);
                return javaMethod;
            }
            this.findMostSpecificMethod(arrayList3);
            if (arrayList3.size() == 1) {
                JavaMethod javaMethod = (JavaMethod)arrayList3.get(0);
                ContextImageB.freeArrayList(arrayList3);
                return javaMethod;
            }
            JavaMethod javaMethod = this.chooseMostSpecificMethod(arrayList3);
            if (javaMethod != null) {
                JavaMethod javaMethod2 = javaMethod;
                ContextImageB.freeArrayList(arrayList3);
                return javaMethod2;
            }
            this.error((short)35);
            JavaMethod javaMethod3 = null;
            ContextImageB.freeArrayList(arrayList3);
            return javaMethod3;
        }
        catch (Throwable throwable) {
            ContextImageB.freeArrayList(arrayList3);
            throw throwable;
        }
    }

    private void findPotentiallyApplicable(JavaType javaType, String string, JavaType[] javaTypeArray, JavaType[] javaTypeArray2, ArrayList arrayList) {
        if (javaType == null) {
            return;
        }
        if (javaTypeArray == null) {
            javaTypeArray = JavaType.EMPTY_ARRAY;
        }
        this.findPotentiallyApplicableImpl(javaType, string, javaTypeArray, javaTypeArray2, arrayList);
        if ("<init>".equals(string)) {
            return;
        }
        for (JavaClass javaClass : javaType.getHierarchy()) {
            this.findPotentiallyApplicableImpl(javaClass, string, javaTypeArray, javaTypeArray2, arrayList);
        }
    }

    private void findPotentiallyApplicableImpl(JavaType javaType, String string, JavaType[] javaTypeArray, JavaType[] javaTypeArray2, ArrayList arrayList) {
        int n = javaTypeArray2.length;
        int n2 = javaTypeArray.length;
        boolean bl = "<init>".equals(string);
        Iterator iterator = bl ? javaType.getDeclaredConstructors().iterator() : javaType.getDeclaredMethods().iterator();
        while (iterator.hasNext()) {
            int n3;
            JavaMethod javaMethod = (JavaMethod)iterator.next();
            if (!bl && !string.equals(javaMethod.getName())) continue;
            boolean bl2 = javaMethod.isVarargs();
            int n4 = javaMethod.getParameters().size();
            if (!bl2 ? n4 != n : n < (n3 = n4 - 1)) continue;
            int n5 = javaMethod.getTypeParameters().size();
            if (n2 > 0 && n5 != n2 || !bl && !this.flag_instance && !javaMethod.isStatic() || !this.processVisible(javaMethod)) continue;
            arrayList.add(javaMethod);
        }
    }

    private void processImportedMethods(String string, JavaType[] javaTypeArray, JavaType[] javaTypeArray2, ArrayList arrayList) {
        FileSym fileSym = this.symCookie.symFile;
        if (fileSym == null) {
            return;
        }
        List list = fileSym.getSourceImports();
        boolean bl = false;
        for (ImportSym importSym : list) {
            if (!importSym.isStatic()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        ArrayList arrayList2 = ContextImageB.allocArrayList();
        ArrayList arrayList3 = ContextImageB.allocArrayList();
        for (ImportSym importSym : list) {
            String string2;
            int n;
            String string3;
            if (!importSym.isStatic() || !importSym.isNarrow() || importSym.isInvalid() || !(string3 = (n = (string2 = importSym.getName()).lastIndexOf(46)) == -1 ? string2 : string2.substring(n + 1)).equals(string)) continue;
            this.processImportedMethods(importSym, string, javaTypeArray, javaTypeArray2, arrayList2, arrayList3, arrayList);
        }
        ArrayList arrayList4 = ContextImageB.allocArrayList();
        for (ImportSym importSym : list) {
            String string4;
            if (!importSym.isStatic() || importSym.isNarrow() || importSym.isInvalid() || arrayList4.contains(string4 = importSym.getName())) continue;
            arrayList4.add(string4);
            this.processImportedMethods(importSym, string, javaTypeArray, javaTypeArray2, arrayList2, arrayList3, arrayList);
        }
        ContextImageB.freeArrayList(arrayList4);
        ContextImageB.freeArrayList(arrayList3);
        ContextImageB.freeArrayList(arrayList2);
    }

    private void processImportedMethods(ImportSym importSym, String string, JavaType[] javaTypeArray, JavaType[] javaTypeArray2, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        importSym.resolve();
        JavaClass javaClass = importSym.getQualifyingType();
        if (javaClass == null) {
            return;
        }
        arrayList2.clear();
        this.findPotentiallyApplicableImpl(javaClass, string, javaTypeArray, javaTypeArray2, arrayList2);
        if (arrayList2.isEmpty()) {
            return;
        }
        for (JavaMethod javaMethod : arrayList2) {
            String string2 = javaMethod.getSignature();
            if (arrayList.contains(string2)) continue;
            arrayList.add(string2);
            arrayList3.add(javaMethod);
            importSym.setUsed();
            ArrayList arrayList4 = importSym.getImportObj().importList;
            if (arrayList4 == null || arrayList4.contains(javaMethod)) continue;
            arrayList4.add(javaMethod);
        }
    }

    private void findApplicable(int n, JavaType[] javaTypeArray, JavaType[] javaTypeArray2, ArrayList arrayList, ArrayList arrayList2) {
        int n2 = javaTypeArray.length;
        int n3 = javaTypeArray2.length;
        Iterator iterator = arrayList.iterator();
        block0: while (iterator.hasNext()) {
            JavaMethod javaMethod = (JavaMethod)iterator.next();
            if (n2 > 0 && n == 1) {
                Collection collection = javaMethod.getTypeParameters();
                Iterator iterator2 = collection.iterator();
                int n4 = 0;
                while (iterator2.hasNext()) {
                    JavaType javaType = javaTypeArray[n4];
                }
            }
            Collection collection = javaMethod.getParameters();
            int n5 = collection.size();
            boolean bl = javaMethod.isVarargs();
            int n6 = bl && n == 3 ? n5 - 1 : n5;
            if (n6 != n3 && n < 3) continue;
            Iterator iterator3 = collection.iterator();
            JavaVariable javaVariable = null;
            int n7 = 0;
            while (n7 < n3) {
                JavaType javaType;
                if (iterator3.hasNext()) {
                    javaVariable = (JavaVariable)iterator3.next();
                }
                if ((javaType = javaTypeArray2[n7]) != null) {
                    boolean bl2;
                    JavaType javaType2 = javaVariable.getResolvedType();
                    if (n == 3 && javaType2 != null && javaVariable.isVarargs()) {
                        if (javaType2.isArray()) {
                            javaType2 = javaType2.getComponentType();
                        } else {
                            IllegalStateException illegalStateException = new IllegalStateException("Varargs parameter not an array type");
                            illegalStateException.printStackTrace();
                        }
                    }
                    if (javaType2 == null) {
                        iterator.remove();
                        continue block0;
                    }
                    boolean bl3 = bl2 = 2 <= n;
                    if (!ContextImageB.applyMethodConversion(javaType, javaType2, bl2, this.compiler.provider)) continue block0;
                }
                ++n7;
            }
            arrayList2.add(javaMethod);
        }
    }

    private void findMostSpecificMethod(ArrayList arrayList) {
        ArrayList arrayList2 = ContextImageB.allocArrayList();
        for (JavaMethod javaMethod : arrayList) {
            if (arrayList2.contains(javaMethod)) continue;
            for (JavaMethod javaMethod2 : arrayList) {
                boolean bl;
                if (arrayList2.contains(javaMethod2) || javaMethod.equals(javaMethod2) || !(bl = ContextImageB.isMoreSpecific(javaMethod, javaMethod2))) continue;
                arrayList2.add(javaMethod2);
            }
        }
        arrayList.removeAll(arrayList2);
    }

    private JavaMethod chooseMostSpecificMethod(ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        JavaMethod javaMethod = null;
        while (iterator.hasNext()) {
            JavaMethod javaMethod2 = (JavaMethod)iterator.next();
            if ((javaMethod2.getModifiers() & 0x400) != 0) continue;
            if (javaMethod != null) {
                return null;
            }
            javaMethod = javaMethod2;
        }
        if (javaMethod != null) {
            return javaMethod;
        }
        return (JavaMethod)arrayList.get(0);
    }

    private JavaType[] inferTypeArguments(JavaMethod javaMethod, JavaType[] javaTypeArray) {
        if (javaTypeArray.length == 0) {
            return null;
        }
        Collection collection = javaMethod.getTypeParameters();
        int n = collection.size();
        if (n == 0) {
            ContextImageB.panic("No parameters");
        }
        JavaType[] javaTypeArray2 = collection.toArray(new JavaType[n]);
        JavaType[] javaTypeArray3 = new JavaType[n];
        JavaType[] javaTypeArray4 = javaMethod.getParameterTypes();
        int n2 = javaTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            this.inferFromOneArgument(javaTypeArray4[n3], javaTypeArray[n3], javaTypeArray2, javaTypeArray3);
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            if (javaTypeArray3[n4] == null) {
                javaTypeArray3[n4] = javaTypeArray2[n4];
            }
            ++n4;
        }
        return javaTypeArray3;
    }

    private void inferFromOneArgument(JavaType javaType, JavaType javaType2, JavaType[] javaTypeArray, JavaType[] javaTypeArray2) {
        JavaType javaType3;
        if (javaType2 == null || javaType == null) {
            return;
        }
        if (!this.involvesTypeParameters(javaType, javaTypeArray)) {
            return;
        }
        if (javaType2.isPrimitive()) {
            if ("N".equals(javaType2.getDescriptor())) {
                return;
            }
            javaType3 = ContextImageB.applyBoxingConversion((PrimitiveType)javaType2, this.compiler.provider);
        } else {
            javaType3 = javaType2;
        }
        this.inferFromOneArgumentImpl(javaType, javaType3, javaTypeArray, javaTypeArray2);
    }

    private boolean inferFromOneArgumentImpl(JavaType javaType, JavaType javaType2, JavaType[] javaTypeArray, JavaType[] javaTypeArray2) {
        if (javaType == null || javaType2 == null) {
            return false;
        }
        block0 : switch (javaType.getElementKind()) {
            case 10: {
                int n = javaTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    if (javaType.equals(javaTypeArray[n2])) {
                        javaTypeArray2[n2] = javaType2;
                        break block0;
                    }
                    ++n2;
                }
                break;
            }
            case 3: {
                JavaClass javaClass;
                if (javaType.isArray() && javaType2.isArray()) {
                    return this.inferFromOneArgumentImpl(javaType.getComponentType(), javaType2.getComponentType(), javaTypeArray, javaTypeArray2);
                }
                if (!javaType.hasActualTypeArguments() || this.inferFromClass(javaType, javaClass = javaType.getTypeErasure(), javaType2, javaTypeArray, javaTypeArray2)) break;
                for (JavaType javaType3 : javaType2.getHierarchy()) {
                    if (this.inferFromClass(javaType, javaClass, javaType3, javaTypeArray, javaTypeArray2)) break block0;
                }
                break;
            }
        }
        return false;
    }

    private boolean inferFromClass(JavaType javaType, JavaType javaType2, JavaType javaType3, JavaType[] javaTypeArray, JavaType[] javaTypeArray2) {
        boolean bl = javaType2.equals(javaType3.getTypeErasure());
        if (javaType3.hasActualTypeArguments() && bl) {
            Iterator iterator = javaType.getActualTypeArguments().iterator();
            Iterator iterator2 = javaType3.getActualTypeArguments().iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                JavaType javaType4 = (JavaType)iterator.next();
                JavaType javaType5 = (JavaType)iterator2.next();
                this.inferFromOneArgumentImpl(javaType4, javaType5, javaTypeArray, javaTypeArray2);
            }
        }
        return bl;
    }

    private boolean involvesTypeParameters(JavaType javaType, JavaType[] javaTypeArray) {
        switch (javaType.getElementKind()) {
            case 10: {
                int n = javaTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    if (javaType.equals(javaTypeArray[n2])) {
                        return true;
                    }
                    ++n2;
                }
                break;
            }
            case 11: {
                JavaWildcardType javaWildcardType = (JavaWildcardType)javaType;
                for (JavaType javaType2 : javaWildcardType.getUpperBounds()) {
                    if (!this.involvesTypeParameters(javaType2, javaTypeArray)) continue;
                    return true;
                }
                for (JavaType javaType3 : javaWildcardType.getLowerBounds()) {
                    if (!this.involvesTypeParameters(javaType3, javaTypeArray)) continue;
                    return true;
                }
                break;
            }
            case 3: {
                if (javaType.isPrimitive()) {
                    return false;
                }
                if (javaType.isArray()) {
                    return this.involvesTypeParameters(javaType.getComponentType(), javaTypeArray);
                }
                for (JavaType javaType4 : javaType.getActualTypeArguments()) {
                    if (!this.involvesTypeParameters(javaType4, javaTypeArray)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }
}

