/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.common.QuickComponent;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.ContextImageB;
import oracle.javatools.parser.java.v2.internal.symbol.AnnotateSym;
import oracle.javatools.parser.java.v2.internal.symbol.BlockSym;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.FormalParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.ImportSym;
import oracle.javatools.parser.java.v2.internal.symbol.LocalVariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.VariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.CatchStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ForStmt;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;

abstract class ContextImageC
extends ContextImageB {
    ContextImageC(CompilerDriver compilerDriver, JavaClass javaClass) {
        super(compilerDriver, javaClass);
    }

    ContextImageC(CompilerDriver compilerDriver, Sym sym) {
        super(compilerDriver, sym);
    }

    ContextImageC(CompilerContext compilerContext) {
        super(compilerContext);
    }

    protected final JavaType findType(Sym sym, String string) {
        if (sym == null) {
            return null;
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        TreeSym treeSym = (TreeSym)sym;
        return this.lookupType(treeSym, string);
    }

    protected final JavaVariable findVariable(Sym sym, String string, boolean bl) {
        if (sym == null) {
            return null;
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        TreeSym treeSym = (TreeSym)sym;
        return this.lookupVariable(treeSym, string, bl);
    }

    protected final JavaClass findMemberType(JavaType javaType, String string) {
        if (javaType == null) {
            return null;
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        return this.lookupMemberType(javaType, string);
    }

    protected final JavaVariable findMemberVariable(JavaType javaType, String string) {
        if (javaType == null) {
            return null;
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        return this.lookupMemberVariable(javaType, string);
    }

    protected final JavaVariable findImportedVariable(String string) {
        this.flag_instance = false;
        return this.lookupImportedVariable(string);
    }

    protected final boolean findVisibleType(JavaType javaType, String string) {
        if (javaType == null) {
            return false;
        }
        for (JavaClass javaClass : javaType.getDeclaredClasses()) {
            if (!javaClass.isExported() || !string.equals(javaClass.getName())) continue;
            return true;
        }
        for (JavaClass javaClass : javaType.getHierarchy()) {
            for (JavaClass javaClass2 : javaClass.getDeclaredClasses()) {
                if (!javaClass2.isExported() || !string.equals(javaClass2.getName()) || !this.processVisible(javaClass2)) continue;
                return true;
            }
        }
        return false;
    }

    protected final boolean findVisibleVariable(JavaType javaType, String string) {
        if (javaType == null) {
            return false;
        }
        for (JavaField javaField : javaType.getDeclaredFields()) {
            if (!string.equals(javaField.getName())) continue;
            return true;
        }
        for (JavaClass javaClass : javaType.getHierarchy()) {
            for (JavaField javaField : javaClass.getDeclaredFields()) {
                if (!string.equals(javaField.getName()) || !this.processVisible(javaField)) continue;
                return true;
            }
        }
        return false;
    }

    private JavaType lookupType(TreeSym treeSym, String string) {
        byte by = treeSym.symKind;
        switch (by) {
            case 3: 
            case 19: {
                ClassSym classSym;
                Iterator iterator = treeSym.getChildren((byte)27).iterator();
                TypeParameterSym typeParameterSym = null;
                while (iterator.hasNext()) {
                    TypeParameterSym typeParameterSym2 = (TypeParameterSym)iterator.next();
                    if (!string.equals(typeParameterSym2.getName())) continue;
                    if (typeParameterSym != null) {
                        this.error((short)35, string);
                    }
                    typeParameterSym = typeParameterSym2;
                }
                if (by == 3 && string.equals((classSym = (ClassSym)treeSym).getName())) {
                    return classSym;
                }
                return typeParameterSym;
            }
            case 2: {
                BlockSym blockSym = (BlockSym)treeSym;
                Iterator iterator = blockSym.getLocalClasses().iterator();
                int n = this.symCookie.symStart;
                boolean bl = false;
                ClassSym classSym = null;
                while (iterator.hasNext()) {
                    ClassSym classSym2 = (ClassSym)iterator.next();
                    if (!string.equals(classSym2.getName())) continue;
                    if (classSym != null && bl) {
                        this.error((short)35, string);
                    }
                    bl = n == -1 || n < classSym2.symStart;
                    classSym = classSym2;
                }
                if (classSym != null && n != -1 && n < classSym.symStart) {
                    return null;
                }
                return classSym;
            }
            case 74: {
                Iterator iterator = treeSym.getChildren((byte)3).iterator();
                ClassSym classSym = null;
                while (iterator.hasNext()) {
                    ClassSym classSym3 = (ClassSym)iterator.next();
                    if (!string.equals(classSym3.getName())) continue;
                    if (classSym != null) {
                        this.error((short)35, string);
                    }
                    classSym = classSym3;
                }
                return classSym;
            }
        }
        return null;
    }

    private JavaClass lookupMemberType(JavaType javaType, String string) {
        ArrayList arrayList = ContextImageC.allocArrayList();
        JavaClass javaClass = (JavaClass)this.findRecursive(javaType, string, arrayList, true);
        ContextImageC.freeArrayList(arrayList);
        return javaClass;
    }

    private boolean matchVariable(VariableSym variableSym, String string, boolean bl) {
        if (variableSym == null || !string.equals(variableSym.getName())) {
            return false;
        }
        if (bl) {
            if (!this.allowAccess(variableSym)) {
                return false;
            }
            return this.flag_nonfinal || variableSym.isFinal();
        }
        return true;
    }

    private JavaVariable lookupVariable(TreeSym treeSym, String string, boolean bl) {
        byte by = treeSym.symKind;
        switch (by) {
            case 6: 
            case 19: {
                MethodSym methodSym = (MethodSym)treeSym;
                for (FormalParameterSym formalParameterSym : methodSym.getSourceParameters()) {
                    if (!this.matchVariable(formalParameterSym, string, bl)) continue;
                    return formalParameterSym;
                }
                return null;
            }
            case 2: {
                BlockSym blockSym = (BlockSym)treeSym;
                Iterator iterator = blockSym.getLocalVariables().iterator();
                int n = this.symCookie.symStart;
                boolean bl2 = false;
                LocalVariableSym localVariableSym = null;
                while (iterator.hasNext()) {
                    LocalVariableSym localVariableSym2 = (LocalVariableSym)iterator.next();
                    if (!this.matchVariable(localVariableSym2, string, bl)) continue;
                    if (localVariableSym != null && bl2) {
                        this.error((short)35, string);
                    }
                    bl2 = n < localVariableSym2.symStart;
                    localVariableSym = localVariableSym2;
                }
                if (localVariableSym != null && n != -1 && n < localVariableSym.symStart) {
                    return null;
                }
                return localVariableSym;
            }
            case 1: {
                AnnotateSym annotateSym = (AnnotateSym)treeSym;
                JavaType javaType = annotateSym.getAnnotationType();
                if (javaType == null) {
                    return null;
                }
                JavaMethod javaMethod = javaType.getMethod(string, null);
                if (javaMethod == null) {
                    return null;
                }
                QuickComponent quickComponent = QuickComponent.createComponent(javaMethod);
                quickComponent.setOwner(annotateSym);
                return quickComponent;
            }
            case 17: {
                LocalVariableSym localVariableSym = (LocalVariableSym)treeSym;
                if (this.matchVariable(localVariableSym, string, bl)) {
                    // empty if block
                }
                return null;
            }
            case 39: {
                ForStmt forStmt = (ForStmt)treeSym;
                for (LocalVariableSym localVariableSym : forStmt.getForVariables()) {
                    if (!this.matchVariable(localVariableSym, string, bl)) continue;
                    return localVariableSym;
                }
                return null;
            }
            case 32: {
                CatchStmt catchStmt = (CatchStmt)treeSym;
                FormalParameterSym formalParameterSym = catchStmt.getCatchVariableSym();
                if (this.matchVariable(formalParameterSym, string, bl)) {
                    return formalParameterSym;
                }
                return null;
            }
        }
        return null;
    }

    private JavaVariable lookupMemberVariable(JavaType javaType, String string) {
        ArrayList arrayList = ContextImageC.allocArrayList();
        JavaVariable javaVariable = (JavaVariable)((Object)this.findRecursive(javaType, string, arrayList, false));
        ContextImageC.freeArrayList(arrayList);
        return javaVariable;
    }

    private JavaMember findRecursive(JavaType javaType, String string, ArrayList arrayList, boolean bl) {
        if (javaType == null) {
            return null;
        }
        if (ContextImageC.classProcessed(arrayList, javaType)) {
            return null;
        }
        JavaMember javaMember = this.findDeclared(javaType, string, bl);
        if (javaMember != null) {
            return javaMember;
        }
        JavaMember javaMember2 = null;
        JavaType javaType2 = javaType.getSuperclass();
        if (javaType2 != null) {
            javaMember2 = this.findRecursive(javaType2, string, arrayList, bl);
        }
        for (JavaType javaType3 : javaType.getInterfaces()) {
            JavaMember javaMember3 = this.findRecursive(javaType3, string, arrayList, bl);
            if (javaMember3 == null) continue;
            if (javaMember2 != null) {
                this.error((short)35);
            }
            javaMember2 = javaMember3;
        }
        return javaMember2;
    }

    private JavaMember findDeclared(JavaType javaType, String string, boolean bl) {
        if (bl) {
            for (JavaClass javaClass : javaType.getDeclaredClasses()) {
                if (!javaClass.isExported() || !string.equals(javaClass.getName()) || !this.processVisible(javaClass)) continue;
                return javaClass;
            }
        } else {
            for (JavaField javaField : javaType.getDeclaredFields()) {
                if (!string.equals(javaField.getName()) || !this.processVisible(javaField)) continue;
                return javaField;
            }
        }
        return null;
    }

    private JavaVariable lookupImportedVariable(String string) {
        FileSym fileSym = this.symCookie.symFile;
        if (fileSym == null) {
            return null;
        }
        List list = fileSym.getSourceImports();
        boolean bl = false;
        for (ImportSym importSym : list) {
            if (!importSym.isStatic()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return null;
        }
        for (ImportSym importSym : list) {
            String string2;
            int n;
            String string3;
            if (!importSym.isStatic() || !importSym.isNarrow() || importSym.isInvalid() || !(string3 = (n = (string2 = importSym.getName()).lastIndexOf(46)) == -1 ? string2 : string2.substring(n + 1)).equals(string)) continue;
            importSym.resolve();
            JavaClass javaClass = importSym.getQualifyingType();
            if (javaClass == null || !this.findVisibleVariable(javaClass, string)) continue;
            JavaVariable javaVariable = this.findMemberVariable(javaClass, string);
            if (javaVariable != null) {
                importSym.setUsed();
                ArrayList arrayList = importSym.getImportObj().importList;
                if (arrayList != null && !arrayList.contains(javaVariable)) {
                    arrayList.add(javaVariable);
                }
            }
            return javaVariable;
        }
        ArrayList arrayList = ContextImageC.allocArrayList();
        for (ImportSym importSym : list) {
            String string4;
            if (!importSym.isStatic() || importSym.isNarrow() || importSym.isInvalid() || arrayList.contains(string4 = importSym.getName())) continue;
            arrayList.add(string4);
            importSym.resolve();
            JavaClass javaClass = importSym.getQualifyingType();
            if (javaClass == null || !this.findVisibleVariable(javaClass, string)) continue;
            JavaVariable javaVariable = this.findMemberVariable(javaClass, string);
            if (javaVariable != null) {
                importSym.setUsed();
                ArrayList arrayList2 = importSym.getImportObj().importList;
                if (arrayList2 != null && !arrayList2.contains(javaVariable)) {
                    arrayList2.add(javaVariable);
                }
            }
            return javaVariable;
        }
        ContextImageC.freeArrayList(arrayList);
        return null;
    }
}

