/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.ContextImageC;
import oracle.javatools.parser.java.v2.internal.compiler.InputImpl;
import oracle.javatools.parser.java.v2.internal.compiler.OutputImpl;
import oracle.javatools.parser.java.v2.internal.symbol.BlockSym;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.FormalParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.ImportSym;
import oracle.javatools.parser.java.v2.internal.symbol.LabelSym;
import oracle.javatools.parser.java.v2.internal.symbol.LocalVariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.RootSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.CatchStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ForStmt;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasName;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;

abstract class ContextImageD
extends ContextImageC
implements CallerContext.Constants {
    ContextImageD(CompilerDriver compilerDriver, JavaClass javaClass) {
        super(compilerDriver, javaClass);
    }

    ContextImageD(CompilerDriver compilerDriver, Sym sym) {
        super(compilerDriver, sym);
    }

    ContextImageD(CompilerContext compilerContext) {
        super(compilerContext);
    }

    protected final void listMembers(JavaType javaType, InputImpl inputImpl, OutputImpl outputImpl) {
        if (javaType == null) {
            return;
        }
        if ("<init>".equals(inputImpl.name)) {
            this.listMembersDeclared(javaType, inputImpl, outputImpl);
            return;
        }
        outputImpl.processed().clear();
        this.listMembersRecursive(javaType, inputImpl, outputImpl);
    }

    protected final void listNames(JavaPackage javaPackage, InputImpl inputImpl, OutputImpl outputImpl) {
        boolean bl = inputImpl.input((byte)4);
        boolean bl2 = inputImpl.input((byte)2);
        if (bl) {
            for (JavaType javaType : javaPackage.getDeclaredClasses()) {
                this.processElement(javaType, inputImpl, outputImpl);
            }
        }
        if (bl2) {
            for (JavaPackage javaPackage2 : javaPackage.getPackages()) {
                this.processElement(javaPackage2, inputImpl, outputImpl);
            }
        }
    }

    protected final void listNames(Sym sym, InputImpl inputImpl, OutputImpl outputImpl) {
        boolean bl = inputImpl.input((byte)8);
        boolean bl2 = inputImpl.input((byte)4);
        boolean bl3 = inputImpl.input((byte)16);
        byte by = sym.symKind;
        switch (by) {
            case 6: 
            case 19: {
                MethodSym methodSym = (MethodSym)sym;
                if (!bl) break;
                for (FormalParameterSym formalParameterSym : methodSym.getSourceParameters()) {
                    this.processElement(formalParameterSym, inputImpl, outputImpl);
                }
                break;
            }
            case 2: {
                BlockSym blockSym = (BlockSym)sym;
                if (bl) {
                    for (LocalVariableSym localVariableSym : blockSym.getLocalVariables()) {
                        this.processElement(localVariableSym, inputImpl, outputImpl);
                    }
                }
                if (!bl2) break;
                for (ClassSym classSym : blockSym.getLocalClasses()) {
                    this.processElement((JavaHasName)classSym, inputImpl, outputImpl);
                }
                break;
            }
            case 39: {
                ForStmt forStmt = (ForStmt)sym;
                if (!bl) break;
                for (LocalVariableSym localVariableSym : forStmt.getForVariables()) {
                    this.processElement(localVariableSym, inputImpl, outputImpl);
                }
                break;
            }
            case 32: {
                CatchStmt catchStmt = (CatchStmt)sym;
                if (!bl) break;
                FormalParameterSym formalParameterSym = catchStmt.getCatchVariableSym();
                this.processElement(formalParameterSym, inputImpl, outputImpl);
                break;
            }
            case 74: {
                if (!bl2) break;
                RootSym rootSym = (RootSym)sym;
                for (ClassSym classSym : rootSym.getSourceClasses()) {
                    this.processElement((JavaHasName)classSym, inputImpl, outputImpl);
                }
                this.listImports(inputImpl, outputImpl);
                break;
            }
        }
        if (bl3) {
            if (29 <= by && by < 47) {
                List list = sym.getChildren(16);
                if (!list.isEmpty()) {
                    for (LabelSym labelSym : list) {
                        this.processElement(labelSym, inputImpl, outputImpl);
                    }
                }
            } else if (sym.is((byte)80)) {
                inputImpl.input = (byte)(inputImpl.input & 0xFFFFFFEF);
            }
        }
    }

    private void listMembersRecursive(JavaType javaType, InputImpl inputImpl, OutputImpl outputImpl) {
        if (javaType == null) {
            return;
        }
        if (ContextImageD.classProcessed(outputImpl.processed(), javaType)) {
            return;
        }
        this.listMembersDeclared(javaType, inputImpl, outputImpl);
        JavaType javaType2 = javaType.getSuperclass();
        if (javaType2 != null) {
            this.listMembersRecursive(javaType2, inputImpl, outputImpl);
        }
        for (JavaType javaType3 : javaType.getInterfaces()) {
            this.listMembersRecursive(javaType3, inputImpl, outputImpl);
        }
    }

    private void listMembersDeclared(JavaType javaType, InputImpl inputImpl, OutputImpl outputImpl) {
        boolean bl = inputImpl.input((byte)8);
        boolean bl2 = inputImpl.input((byte)4);
        boolean bl3 = inputImpl.input((byte)1);
        if (bl) {
            for (JavaField javaField : javaType.getDeclaredFields()) {
                this.processElement(javaField, inputImpl, outputImpl);
            }
        }
        if (bl2) {
            for (JavaClass javaClass : javaType.getDeclaredClasses()) {
                if (!javaClass.isExported()) continue;
                this.processElement(javaClass, inputImpl, outputImpl);
            }
        }
        if (bl3) {
            boolean bl4 = "<init>".equals(inputImpl.name);
            Iterator iterator = bl4 ? javaType.getDeclaredConstructors().iterator() : javaType.getDeclaredMethods().iterator();
            while (iterator.hasNext()) {
                JavaMethod javaMethod = (JavaMethod)iterator.next();
                this.processElement(javaMethod, inputImpl, outputImpl);
            }
        }
    }

    private final void listImports(InputImpl inputImpl, OutputImpl outputImpl) {
        if (inputImpl.squash((byte)1)) {
            return;
        }
        FileSym fileSym = this.symCookie.symFile;
        List list = fileSym.getSourceImports();
        for (ImportSym importSym : list) {
            if (!importSym.isNarrow() || importSym.isInvalid()) continue;
            this.processImportedNarrow(importSym, inputImpl, outputImpl);
        }
        String string = fileSym.getPackageName();
        if (string.length() > 0) {
            this.processImportedPackage(string, inputImpl, outputImpl);
        }
        for (ImportSym importSym : list) {
            if (importSym.isNarrow() || importSym.isInvalid()) continue;
            if (importSym.isStatic()) {
                this.processImportedMembers(importSym.getQualifyingType(), inputImpl, outputImpl);
                continue;
            }
            this.processImportedPackage(importSym.getName(), inputImpl, outputImpl);
        }
        this.processImportedPackage("java.lang.*", inputImpl, outputImpl);
    }

    private void processImportedNarrow(ImportSym importSym, InputImpl inputImpl, OutputImpl outputImpl) {
        JavaClass javaClass;
        JavaClass javaClass2;
        String string = importSym.getName();
        int n = string.lastIndexOf(46);
        String string2 = n == -1 ? string : string.substring(n + 1);
        if (inputImpl.name != null && !inputImpl.name.equals(string2)) {
            return;
        }
        if (importSym.isStatic() && (javaClass2 = importSym.getQualifyingType()) != null) {
            JavaField javaField;
            Collection collection;
            if (inputImpl.input((byte)1) && !(collection = javaClass2.getMethods(string2)).isEmpty()) {
                for (JavaMember javaMember : collection) {
                    this.processElement(javaMember, inputImpl, outputImpl);
                }
            }
            if (inputImpl.input((byte)8) && (javaField = javaClass2.getField(string2)) != null) {
                this.processElement(javaField, inputImpl, outputImpl);
            }
        }
        if (inputImpl.input((byte)4) && (javaClass = this.compiler.provider.getClass(string)) != null) {
            this.processElement(javaClass, inputImpl, outputImpl);
        }
    }

    private void processImportedPackage(String string, InputImpl inputImpl, OutputImpl outputImpl) {
        if (inputImpl.input((byte)4)) {
            if (outputImpl.containsKey(string)) {
                return;
            }
            outputImpl.keys().add(string);
            String string2 = string.endsWith(".*") ? string.substring(0, string.length() - 2) : string;
            JavaPackage javaPackage = this.compiler.provider.getPackage(string2);
            Collection collection = javaPackage.getDeclaredClasses();
            if (!collection.isEmpty()) {
                for (JavaType javaType : collection) {
                    this.processElement(javaType, inputImpl, outputImpl);
                }
            }
        }
    }

    private void processImportedMembers(JavaType javaType, InputImpl inputImpl, OutputImpl outputImpl) {
        Collection collection;
        Collection collection2;
        Collection collection3;
        if (javaType == null) {
            return;
        }
        if (inputImpl.input((byte)1) && !(collection3 = javaType.getMethods()).isEmpty()) {
            for (JavaMember javaMember : collection3) {
                this.processElement(javaMember, inputImpl, outputImpl);
            }
        }
        if (inputImpl.input((byte)8) && !(collection2 = javaType.getFields()).isEmpty()) {
            for (JavaMember javaMember : collection2) {
                this.processElement(javaMember, inputImpl, outputImpl);
            }
        }
        if (inputImpl.input((byte)4) && !(collection = javaType.getClasses()).isEmpty()) {
            for (JavaMember javaMember : collection) {
                this.processElement(javaMember, inputImpl, outputImpl);
            }
        }
    }

    private void processElement(JavaHasName javaHasName, InputImpl inputImpl, OutputImpl outputImpl) {
        String string = javaHasName.getName();
        if (outputImpl.containsKey(string)) {
            return;
        }
        if (!this.checkFilter(javaHasName, inputImpl)) {
            return;
        }
        if (this.allowAccess(javaHasName)) {
            outputImpl.add(string, javaHasName);
        } else {
            outputImpl.add(string, null);
        }
    }

    private void processElement(JavaMethod javaMethod, InputImpl inputImpl, OutputImpl outputImpl) {
        String string = javaMethod.getName() + javaMethod.getSignature();
        if (!inputImpl.match(javaMethod) || outputImpl.containsKey(string)) {
            return;
        }
        if (!this.processVisible(javaMethod) || !this.checkFilter(javaMethod, inputImpl)) {
            return;
        }
        if (this.allowAccess(javaMethod)) {
            outputImpl.add(string, javaMethod);
        } else {
            outputImpl.add(string, null);
        }
    }

    private void processElement(JavaMember javaMember, InputImpl inputImpl, OutputImpl outputImpl) {
        String string = javaMember.getName();
        if (!inputImpl.match(javaMember) || outputImpl.containsKey(string)) {
            return;
        }
        if (!this.processVisible(javaMember) || !this.checkFilter(javaMember, inputImpl)) {
            return;
        }
        if (this.allowAccess(javaMember)) {
            outputImpl.add(string, javaMember);
        } else {
            outputImpl.add(string, null);
        }
    }

    private boolean checkFilter(JavaMember javaMember, InputImpl inputImpl) {
        if (!this.flag_static && inputImpl.squash((byte)4) && (javaMember.getElementKind() == 3 || javaMember.isStatic())) {
            return false;
        }
        if (inputImpl.squash((byte)16) && javaMember.isDeprecated()) {
            return false;
        }
        if (inputImpl.squash((byte)32) && javaMember.isHidden()) {
            return false;
        }
        return this.checkFilter((JavaElement)javaMember, inputImpl);
    }

    private boolean checkFilter(JavaElement javaElement, InputImpl inputImpl) {
        return inputImpl.filter == null || inputImpl.filter.accepts(javaElement);
    }
}

