/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.format;

import java.io.PrintWriter;
import java.io.StringWriter;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v2.internal.format.Emitter;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;

abstract class BufferedEmitter
extends Emitter {
    private final StringWriter writer;
    private final PrintWriter printer;
    final StringBuffer buffer;

    void $init$() {
        this.writer = new StringWriter();
        this.printer = new PrintWriter(this.writer);
        this.buffer = this.writer.getBuffer();
    }

    public TextBuffer getOutputBuffer() {
        TextBuffer textBuffer = TextBufferFactory.createArrayTextBuffer();
        String string = this.getBuffer().toString();
        textBuffer.insert(0, string.toCharArray());
        return textBuffer;
    }

    final StringBuffer getBuffer() {
        return this.buffer;
    }

    public final String toString() {
        return this.getBuffer().toString();
    }

    void init(Sym sym) {
        this.buffer.setLength(0);
    }

    void fini(Sym sym) {
        int n = this.buffer.length();
        int n2 = n - 1;
        while (n2 >= 0) {
            char c = this.buffer.charAt(n2);
            if (c == '\n') {
                while (n2 >= 1 && this.buffer.charAt(n2 - 1) == ' ') {
                    this.buffer.deleteCharAt(--n2);
                }
            }
            --n2;
        }
    }

    private void emitImpl(String string) {
        this.printer.print(string);
    }

    void emitIndent(int n) {
        int n2;
        if (this.formatter.preferences.getBoolean(1) && (n2 = this.formatter.preferences.getInt(2)) > 0) {
            while (n >= n2) {
                this.printer.print('\t');
                n -= n2;
            }
        }
        int n3 = 0;
        while (n3 < n) {
            this.printer.print(' ');
            ++n3;
        }
        if (this.formatter.flag_docindent) {
            this.printer.print(" * ");
        }
    }

    void emit(String string) {
        this.emitImpl(string);
    }

    void emit(short s) {
        this.emitImpl(BufferedEmitter.tk2text(s));
    }

    void emit(char c) {
        if (c == '\n') {
            this.printer.println();
        } else {
            this.printer.print(c);
        }
    }

    BufferedEmitter() {
        this.$init$();
    }
}

