/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.format;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.format.FormatConstants;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymOperation;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocCommentSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocSym;
import oracle.javatools.parser.java.v2.internal.util.FormatRegion;
import oracle.javatools.parser.java.v2.internal.util.TokenMap;
import oracle.javatools.parser.java.v2.util.OffsetPair;

public final class DamageCalculation
extends CommonUtilities
implements FormatConstants {
    private DamageCalculation() {
    }

    public static void preprocess(SymOperation[] symOperationArray) {
        int n = symOperationArray.length;
        int n2 = 0;
        while (n2 < n) {
            SymOperation symOperation = symOperationArray[n2];
            if (symOperation.opTarget != null) {
                symOperation.opTarget.symFormat = (char)(symOperation.opTarget.symFormat | '\u0001');
            }
            if (symOperation.opNewSym != null) {
                symOperation.opNewSym.symFormat = (char)(symOperation.opNewSym.symFormat | '\u0001');
            }
            if (symOperation.opParent != null) {
                symOperation.opParent.symFormat = (char)(symOperation.opParent.symFormat | '\u0001');
            }
            switch (symOperation.opKind) {
                case 4: 
                case 5: 
                case 6: {
                    symOperation.opTarget.unsaveText();
                }
            }
            ++n2;
        }
    }

    public static FormatRegion[] process(SymOperation[] symOperationArray, TokenMap tokenMap) {
        ArrayList<FormatRegion> arrayList = new ArrayList<FormatRegion>();
        ProcessingData processingData = new ProcessingData(null);
        int n = symOperationArray.length;
        int n2 = 0;
        while (n2 < n) {
            SymOperation symOperation = symOperationArray[n2];
            Object var7_7 = null;
            switch (symOperation.opKind) {
                case 3: {
                    DamageCalculation.preprocessUnlink(symOperation.opTarget, processingData);
                    break;
                }
                case 2: {
                    DamageCalculation.preprocessUnlink(symOperation.opTarget, processingData);
                    DamageCalculation.preprocessLink(symOperation.opNewSym, processingData);
                    break;
                }
                case 1: {
                    DamageCalculation.preprocessLink(symOperation.opNewSym, processingData);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    DamageCalculation.preprocessReplace(symOperation.opTarget, processingData);
                    break;
                }
                case 7: {
                    if (n > 1) {
                        DamageCalculation.panic("Format special doesn't work if count > 1");
                    }
                    FormatRegion formatRegion = (FormatRegion)symOperation.getBinding(6);
                    try {
                        formatRegion.alignSelf(tokenMap, true);
                        arrayList.add(formatRegion);
                    }
                    catch (RuntimeException runtimeException) {
                        runtimeException.printStackTrace();
                    }
                    break;
                }
                default: {
                    DamageCalculation.notImplementedYet();
                }
            }
            ++n2;
        }
        DamageCalculation.processRemoves(processingData, arrayList, tokenMap);
        DamageCalculation.processInserts(processingData, arrayList, tokenMap);
        DamageCalculation.processReplaces(processingData, arrayList, tokenMap);
        DamageCalculation.coalesceRegions(arrayList);
        int n3 = arrayList.size();
        if (n3 == 0) {
            return FormatRegion.EMPTY_ARRAY;
        }
        return arrayList.toArray(new FormatRegion[n3]);
    }

    private static void preprocessLink(Sym sym, ProcessingData processingData) {
        if (sym.is((byte)86)) {
            return;
        }
        if (sym.getParentSym() == null) {
            return;
        }
        if (sym.is((byte)88) && sym.symKind != 64) {
            DocSym docSym = (DocSym)sym;
            DocCommentSym docCommentSym = docSym.getOwningDocCommentSym();
            if (docCommentSym != null) {
                ProcessingData.mav$replaceSyms(processingData).add(docCommentSym);
            }
        } else {
            ProcessingData.mav$insertSyms(processingData).add(sym);
        }
    }

    private static void preprocessUnlink(Sym sym, ProcessingData processingData) {
        if (sym.is((byte)86)) {
            return;
        }
        if (sym.is((byte)88) && sym.symKind != 64) {
            DocSym docSym = (DocSym)sym;
            DocCommentSym docCommentSym = docSym.getOwningDocCommentSym();
            if (docCommentSym != null) {
                ProcessingData.mav$replaceSyms(processingData).add(docCommentSym);
            }
        } else {
            int n = sym.getStartIndex();
            if (n == -1) {
                return;
            }
            ProcessingData.mav$removeSyms(processingData).add(sym);
        }
    }

    private static void preprocessReplace(Sym sym, ProcessingData processingData) {
        if (sym.is((byte)88) && sym.symKind != 64) {
            DocSym docSym = (DocSym)sym;
            sym = docSym.getOwningDocCommentSym();
        }
        if (sym != null) {
            ProcessingData.mav$replaceSyms(processingData).add(sym);
        }
    }

    private static void processRemoves(ProcessingData processingData, ArrayList arrayList, TokenMap tokenMap) {
        ArrayList arrayList2 = ProcessingData.mav$removeSyms(processingData);
        if (arrayList2.isEmpty()) {
            return;
        }
        ArrayList arrayList3 = new ArrayList();
        arrayList3.addAll(arrayList2);
        Collections.sort(arrayList3);
        DamageCalculation.removeDescendants(arrayList3);
        int n = arrayList3.size();
        int n2 = 0;
        while (n2 < n) {
            block6: {
                int n3;
                Sym sym = (Sym)arrayList3.get(n2);
                int n4 = sym.getStartIndex();
                if (n4 >= 0 && (n3 = sym.getEndIndex()) >= n4) {
                    Arrays.fill(tokenMap.forwardMap, n4, n3 + 1, -1);
                    OffsetPair offsetPair = OffsetPair.createFromStartAndEnd(n4, n3);
                    FormatRegion formatRegion = new FormatRegion(offsetPair, null);
                    try {
                        formatRegion.alignSelf(tokenMap, true);
                    }
                    catch (RuntimeException runtimeException) {
                        runtimeException.printStackTrace();
                        break block6;
                    }
                    arrayList.add(formatRegion);
                }
            }
            ++n2;
        }
        for (Sym sym : arrayList2) {
            sym.clearOffsets();
        }
    }

    private static void processInserts(ProcessingData processingData, ArrayList arrayList, TokenMap tokenMap) {
        ArrayList arrayList2 = ProcessingData.mav$insertSyms(processingData);
        if (arrayList2.isEmpty()) {
            return;
        }
        ArrayList<Sym> arrayList3 = new ArrayList<Sym>();
        for (Sym sym : arrayList2) {
            Sym sym2 = sym.getMapping();
            if (sym2 == null) continue;
            arrayList3.add(sym2);
        }
        Collections.sort(arrayList3);
        DamageCalculation.removeDescendants(arrayList3);
        int n = arrayList3.size();
        int n2 = 0;
        while (n2 < n) {
            block8: {
                int n3;
                Sym sym = (Sym)arrayList3.get(n2);
                int n4 = sym.getStartIndex();
                if (n4 >= 0 && (n3 = sym.getEndIndex()) >= n4) {
                    if (n4 > 0) {
                        --n4;
                    }
                    if (n3 + 1 < tokenMap.backwardMap.length) {
                        ++n3;
                    }
                    OffsetPair offsetPair = OffsetPair.createFromStartAndEnd(n4, n3);
                    FormatRegion formatRegion = new FormatRegion(null, offsetPair);
                    try {
                        formatRegion.alignSelf(tokenMap, false);
                    }
                    catch (RuntimeException runtimeException) {
                        runtimeException.printStackTrace();
                        break block8;
                    }
                    arrayList.add(formatRegion);
                }
            }
            ++n2;
        }
    }

    private static void processReplaces(ProcessingData processingData, ArrayList arrayList, TokenMap tokenMap) {
        ArrayList arrayList2 = ProcessingData.mav$replaceSyms(processingData);
        if (arrayList2.isEmpty()) {
            return;
        }
        int n = arrayList2.size();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            Sym sym = (Sym)arrayList2.get(n2);
            int n4 = sym.getStartIndex();
            if (n4 >= 0 && (n3 = sym.getEndIndex()) >= n4) {
                int n5 = -1;
                int n6 = -1;
                Sym sym2 = sym.getMapping();
                if (sym2 != null) {
                    n5 = sym2.getStartIndex();
                    n6 = sym2.getEndIndex();
                }
                if (n5 < 0) {
                    n5 = tokenMap.mapForward(n4);
                    n6 = tokenMap.mapForward(n3);
                }
                if (n5 >= 0 && n6 >= 0) {
                    OffsetPair offsetPair = OffsetPair.createFromStartAndEnd(n4, n3);
                    OffsetPair offsetPair2 = OffsetPair.createFromStartAndEnd(n5, n6);
                    FormatRegion formatRegion = new FormatRegion(offsetPair, offsetPair2);
                    arrayList.add(formatRegion);
                }
            }
            ++n2;
        }
    }

    private static void coalesceRegions(ArrayList arrayList) {
        Collections.sort(arrayList, new FormatRegionComparator(null));
        Iterator iterator = arrayList.iterator();
        FormatRegion formatRegion = null;
        while (iterator.hasNext()) {
            FormatRegion formatRegion2 = (FormatRegion)iterator.next();
            if (formatRegion != null) {
                int n = formatRegion.toIndices.getStartOffset();
                int n2 = formatRegion2.toIndices.getStartOffset();
                int n3 = formatRegion.toIndices.getEndOffset();
                int n4 = formatRegion2.toIndices.getEndOffset();
                if (n < n2 && n4 < n3) {
                    iterator.remove();
                    continue;
                }
                if (n2 <= n3) {
                    formatRegion.toIndices.setStartAndEnd(n, n4);
                    int n5 = formatRegion.fromIndices.getStartOffset();
                    int n6 = formatRegion2.fromIndices.getStartOffset();
                    int n7 = Math.min(n5, n6);
                    int n8 = formatRegion.fromIndices.getEndOffset();
                    int n9 = formatRegion2.fromIndices.getEndOffset();
                    int n10 = Math.max(n8, n9);
                    formatRegion.fromIndices.setStartAndEnd(n7, n10);
                    iterator.remove();
                    continue;
                }
            }
            formatRegion = formatRegion2;
        }
    }

    private static void removeDescendants(ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        Sym sym = null;
        while (iterator.hasNext()) {
            Sym sym2 = (Sym)iterator.next();
            if (sym != null && sym.symStart <= sym2.symStart && sym2.symEnd <= sym.symEnd) {
                iterator.remove();
                continue;
            }
            sym = sym2;
        }
    }

    private static final class ProcessingData {
        private ArrayList insertSyms;
        private ArrayList removeSyms;
        private ArrayList replaceSyms;

        void $init$() {
            this.insertSyms = new ArrayList();
            this.removeSyms = new ArrayList();
            this.replaceSyms = new ArrayList();
        }

        private ArrayList insertSyms() {
            return this.insertSyms;
        }

        private ArrayList removeSyms() {
            return this.removeSyms;
        }

        private ArrayList replaceSyms() {
            return this.replaceSyms;
        }

        private ProcessingData() {
            this.$init$();
        }

        static ArrayList mav$replaceSyms(ProcessingData processingData) {
            return processingData.replaceSyms();
        }

        static ArrayList mav$insertSyms(ProcessingData processingData) {
            return processingData.insertSyms();
        }

        static ArrayList mav$removeSyms(ProcessingData processingData) {
            return processingData.removeSyms();
        }

        ProcessingData(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class FormatRegionComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return this.compare((FormatRegion)object, (FormatRegion)object2);
        }

        public int compare(FormatRegion formatRegion, FormatRegion formatRegion2) {
            int n;
            int n2;
            if (formatRegion == formatRegion2) {
                return 0;
            }
            int n3 = formatRegion.toIndices.getStartOffset();
            if (n3 != (n2 = formatRegion2.toIndices.getStartOffset())) {
                return n3 - n2;
            }
            int n4 = formatRegion.toIndices.getEndOffset();
            if (n4 != (n = formatRegion2.toIndices.getEndOffset())) {
                return n4 - n;
            }
            return 0;
        }

        private FormatRegionComparator() {
        }

        FormatRegionComparator(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

