/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.format;

import java.util.IdentityHashMap;
import oracle.javatools.parser.java.v2.internal.format.Emitter;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatUtilities;
import oracle.javatools.parser.java.v2.internal.symbol.BlanklineSym;
import oracle.javatools.parser.java.v2.internal.symbol.CommentSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.SqljSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.WhitespaceSym;
import oracle.javatools.parser.java.v2.scanner.TokenArray;
import oracle.javatools.parser.java.v2.write.SourcePreferences;

abstract class FormatLayer1
extends FormatUtilities {
    private short stackTop;
    private int enterDepth;
    private FormatInfo[] stack;
    private short lastToken;
    TokenArray tokens;
    SourcePreferences preferences;
    Emitter emitter;
    private IdentityHashMap handledWhitespace;
    private int newlinesPending;
    private int newlinesEmitted;
    private int blanklineSyms;
    private boolean flag_space;
    private boolean flag_init;
    boolean flag_justindent;
    boolean flag_docindent;
    boolean flag_lessindentonce;
    private int indentNumSpaces;
    private boolean wrapAlign;
    private int alignmentMark_height;
    private int markBoundary_height;

    void $init$() {
        this.stackTop = 0;
        this.enterDepth = 0;
        this.stack = new FormatInfo[]{new FormatInfo(null), new FormatInfo(null)};
        this.lastToken = 0;
        this.newlinesPending = 0;
        this.newlinesEmitted = 0;
        this.blanklineSyms = 0;
        this.flag_space = false;
        this.flag_init = false;
        this.flag_justindent = false;
        this.flag_docindent = false;
        this.flag_lessindentonce = false;
        this.indentNumSpaces = 0;
        this.wrapAlign = true;
        this.alignmentMark_height = -1;
        this.markBoundary_height = -1;
    }

    public void init(Sym sym) {
        if (this.flag_init) {
            FormatLayer1.panic("Traversal already in progress");
        }
        this.stackTop = 0;
        this.enterDepth = 0;
        this.lastToken = 0;
        this.newlinesPending = 0;
        this.newlinesEmitted = 1;
        this.handledWhitespace = new IdentityHashMap(this.tokens.tokenCount);
        this.flag_justindent = false;
        this.flag_docindent = false;
        this.flag_lessindentonce = false;
        this.alignmentMark_height = -1;
        this.markBoundary_height = -1;
        this.indentNumSpaces = this.preferences.getInt(0);
        if (this.indentNumSpaces < 0) {
            this.indentNumSpaces = 0;
        }
        try {
            this.emitter.init(sym);
        }
        finally {
            this.flag_init = true;
        }
        this.wrapAlign = this.preferences.getBoolean(51);
    }

    public void fini(Sym sym) {
        if (!this.flag_init) {
            FormatLayer1.panic("No traversal in progress");
        }
        this.flush();
        try {
            this.emitter.fini(sym);
        }
        finally {
            this.flag_init = false;
        }
    }

    protected final int newlines() {
        return this.newlinesPending + this.newlinesEmitted;
    }

    public final void print(Sym sym) {
        FormatLayer1.panic();
    }

    final void print(TreeSym treeSym) {
        int n = treeSym.treeChildren.length;
        int n2 = 0;
        while (n2 < n) {
            Sym sym = treeSym.treeChildren[n2];
            this.handle(sym);
            ++n2;
        }
    }

    public final void print(NameSym nameSym) {
        this.print(nameSym.getText());
    }

    public final void print(SqljSym sqljSym) {
        this.print(sqljSym.getText());
        this.ensureNewlines(1);
    }

    public final void print(CommentSym commentSym) {
        if (commentSym.flag_lineStart()) {
            this.ensureNewlines(1);
            this.flushNewlines(1);
        }
        int n = this.newlinesPending;
        try {
            this.newlinesPending = 0;
            if (this.newlines() == 0 && !this.flag_justindent) {
                this.flag_space = true;
            }
            this.print(commentSym.getText());
        }
        finally {
            this.newlinesPending = n;
        }
        if (commentSym.tokenValue == 24 || commentSym.flag_lineEnd()) {
            this.ensureNewlines(1);
            this.flushNewlines(1);
        }
    }

    public final void print(BlanklineSym blanklineSym) {
        int n = this.preferences.getInt(7);
        ++this.blanklineSyms;
        if (this.blanklineSyms > n) {
            this.blanklineSyms = n;
        }
        if (this.blanklineSyms > 0) {
            this.ensureNewlines(this.blanklineSyms + 1);
            this.flushNewlines(this.blanklineSyms + 1);
        }
    }

    public final void enter(Sym sym) {
        TreeSym treeSym;
        int n;
        if (this.enterDepth > 0 && (n = sym.symSiblingIndex - 1) >= 0 && (treeSym = (TreeSym)sym.symParent) != null) {
            Sym sym2;
            if (treeSym.treeChildren.length <= n) {
                FormatLayer1.panic();
            }
            if ((sym2 = treeSym.treeChildren[n]).is((byte)89)) {
                this.handle(sym2);
            }
        }
        if (this.flag_docindent) {
            this.checkIndent();
        }
        if (sym.symKind != 11) {
            ++this.enterDepth;
        }
        this.emitter.enter(sym);
    }

    public final void leave(Sym sym) {
        if (this.enterDepth > 0 && sym instanceof TreeSym) {
            TreeSym treeSym = (TreeSym)sym;
            int n = treeSym.treeChildren.length;
            if (n > 0) {
                Sym sym2 = treeSym.treeChildren[n - 1];
                if (sym2.symKind == 70) {
                    this.handle(sym2);
                }
            }
        }
        int n = sym.getEndIndex();
        if (sym.symKind != 11) {
            --this.enterDepth;
        }
        this.emitter.leave(sym);
    }

    private void handleImpl(Sym sym) {
        if (sym instanceof WhitespaceSym) {
            if (this.handledWhitespace.containsKey(sym)) {
                return;
            }
            this.handledWhitespace.put(sym, null);
        }
        sym.print((FormatDriver)this);
    }

    final void handle(Sym sym) {
        if (sym == null) {
            return;
        }
        if (sym.isSynthetic() || sym.testSymFlag((byte)4)) {
            return;
        }
        int n = this.push();
        try {
            this.handleImpl(sym);
        }
        finally {
            this.pop(n);
        }
    }

    final void handle(Sym sym, byte by) {
        if (sym == null) {
            return;
        }
        int n = this.push(by);
        try {
            switch (by) {
                case 1: {
                    if (sym.symKind == 30) {
                        boolean bl = this.preferences.getBoolean(23);
                        if (!bl) break;
                        boolean bl2 = this.preferences.getBoolean(5);
                        if (bl2) {
                            this.indent(1);
                        }
                        this.ensureNewlines(1);
                        break;
                    }
                    this.indent(1);
                    this.println();
                    break;
                }
                case 3: {
                    this.indent(1);
                }
            }
            this.handleImpl(sym);
        }
        finally {
            this.pop(n);
        }
    }

    final void indent(int n) {
        int n2 = FormatInfo.ra$indent(this.stack[this.stackTop]) + n * this.indentNumSpaces;
        if (n2 < 0) {
            n2 = 0;
        } else if (127 < n2) {
            n2 = 127;
        }
        FormatInfo.wa$indent(this.stack[this.stackTop], (byte)n2);
    }

    final int getIndent() {
        int n;
        if (FormatInfo.ra$alignmentStamp(this.stack[this.stackTop]) == this.emitter.getColumnStamp() && (n = FormatInfo.ra$alignment(this.stack[this.stackTop])) > 0) {
            return n;
        }
        byte by = FormatInfo.ra$indent(this.stack[this.stackTop]);
        if (!this.flag_lessindentonce) {
            return by;
        }
        return by - this.indentNumSpaces;
    }

    final int push() {
        return this.push((byte)0);
    }

    private int push(byte by) {
        if (this.stack.length == this.stackTop + 1) {
            FormatInfo[] formatInfoArray = new FormatInfo[this.stack.length * 2];
            System.arraycopy(this.stack, 0, formatInfoArray, 0, this.stack.length);
            this.stack = formatInfoArray;
        }
        short s = this.stackTop;
        this.stackTop = (short)(s + 1);
        short s2 = s;
        if (this.stack[this.stackTop] == null) {
            this.stack[this.stackTop] = new FormatInfo(null);
        }
        FormatInfo formatInfo = this.stack[this.stackTop];
        FormatInfo.wa$decoration(formatInfo, by);
        FormatInfo.wa$indent(formatInfo, FormatInfo.ra$indent(this.stack[s2]));
        FormatInfo.wa$alignment(formatInfo, FormatInfo.ra$alignment(this.stack[s2]));
        FormatInfo.wa$alignmentStamp(formatInfo, FormatInfo.ra$alignmentStamp(this.stack[s2]));
        FormatInfo.wa$saved_alignmentMark_height(formatInfo, -1);
        return s2;
    }

    final void pop(int n) {
        if (n < 0 || this.stackTop < n) {
            FormatLayer1.panic();
        }
        this.stackTop = (short)n;
        if (this.stackTop < 0) {
            FormatLayer1.panic();
        }
    }

    final void markWrapAlignment() {
        if (!this.wrapAlign) {
            return;
        }
        if (0 <= this.alignmentMark_height && this.alignmentMark_height < this.stackTop) {
            FormatInfo.wa$saved_alignmentMark_height(this.stack[this.stackTop], this.alignmentMark_height);
        }
        this.alignmentMark_height = this.stackTop;
    }

    final void markWrapBoundary(int n) {
        int n2 = this.preferences.getInt(n);
        if (n2 == 0) {
            return;
        }
        if (n2 != 2) {
            this.markBoundary_height = this.stackTop;
        } else {
            this.emitter.forceLineWrapping();
            this.flag_justindent = true;
        }
    }

    final void println(short s) {
        this.print(s);
        this.println();
    }

    final void print(short s, char c) {
        this.print(s);
        this.print(c);
    }

    private final void checkWrapBoundary() {
        if (this.markBoundary_height >= 0) {
            boolean bl;
            boolean bl2 = bl = this.newlines() > 0 || this.flag_justindent;
            if (!bl) {
                this.emitter.markWrapBoundary(this.markBoundary_height);
            }
            this.markBoundary_height = -1;
        }
    }

    private final void checkWrapAlignment() {
        if (this.alignmentMark_height >= 0) {
            int n = this.emitter.getColumn();
            int n2 = this.stackTop;
            while (this.alignmentMark_height >= 0) {
                byte by = FormatInfo.ra$indent(this.stack[this.alignmentMark_height]);
                int n3 = n - by;
                while (n2 >= this.alignmentMark_height) {
                    FormatInfo.wa$alignment(this.stack[n2], FormatInfo.ra$indent(this.stack[n2]) + n3);
                    FormatInfo.wa$alignmentStamp(this.stack[n2], this.emitter.getColumnStamp());
                    --n2;
                }
                FormatInfo.wa$alignment(this.stack[this.alignmentMark_height], n);
                FormatInfo.wa$alignmentStamp(this.stack[this.alignmentMark_height], this.emitter.getColumnStamp());
                int n4 = FormatInfo.ra$saved_alignmentMark_height(this.stack[this.alignmentMark_height]);
                if (this.alignmentMark_height <= n4) {
                    FormatLayer1.panic();
                }
                this.alignmentMark_height = n4;
            }
            this.alignmentMark_height = -1;
        }
    }

    final void checkIndent() {
        this.flush();
        if (this.newlines() > 0) {
            this.emitter.emitIndent(this.getIndent());
            this.newlinesEmitted = 0;
            this.newlinesPending = 0;
            this.blanklineSyms = 0;
            this.flag_justindent = true;
        }
    }

    private final void checkSpace(int n) {
        if (this.flag_justindent) {
            return;
        }
        if (this.newlines() == 0 && !this.flag_space) {
            boolean bl = false;
            if (32 <= this.lastToken && this.lastToken < 81) {
                switch (this.lastToken) {
                    case 39: {
                        bl = this.preferences.getBoolean(34);
                        break;
                    }
                    case 75: {
                        bl = this.preferences.getBoolean(36);
                        break;
                    }
                    case 55: {
                        if (n == 72) break;
                        bl = this.preferences.getBoolean(47);
                        break;
                    }
                    case 50: {
                        if (n == 71) break;
                        bl = this.preferences.getBoolean(48);
                        break;
                    }
                    case 69: {
                        break;
                    }
                    case 38: {
                        bl = this.preferences.getBoolean(40);
                        break;
                    }
                    default: {
                        if (FormatLayer1.asg_op(this.lastToken) == 0) break;
                        bl = this.preferences.getBoolean(45);
                    }
                }
            }
            if (!bl) {
                switch (n) {
                    case 39: {
                        bl = this.preferences.getBoolean(33);
                        break;
                    }
                    case 75: {
                        bl = this.preferences.getBoolean(35);
                        break;
                    }
                    case 72: {
                        if (this.lastToken == 55) break;
                        bl = this.preferences.getBoolean(47);
                        break;
                    }
                    case 71: {
                        if (this.lastToken == 50) break;
                        bl = this.preferences.getBoolean(48);
                        break;
                    }
                    case 49: {
                        bl = this.preferences.getBoolean(49);
                        break;
                    }
                    default: {
                        if (FormatLayer1.asg_op(n) == 0) break;
                        bl = this.preferences.getBoolean(45);
                    }
                }
            }
            if (this.lastToken == 119 || n == 119) {
                bl = true;
            }
            this.flag_space = bl;
        }
        if (this.flag_space) {
            this.emitter.emit(' ');
        }
        this.flag_space = false;
    }

    final void print(String string) {
        if (string.length() == 0) {
            return;
        }
        this.checkIndent();
        this.checkWrapBoundary();
        this.checkSpace(4);
        this.checkWrapAlignment();
        this.emitter.emit(string);
        this.flag_lessindentonce = false;
        this.flag_justindent = false;
        this.lastToken = (short)4;
    }

    final void print(short s) {
        this.checkIndent();
        this.checkWrapBoundary();
        this.checkSpace(s);
        this.checkWrapAlignment();
        this.emitter.emit(s);
        this.flag_lessindentonce = false;
        this.flag_justindent = false;
        this.lastToken = s;
    }

    final void print(char c) {
        switch (c) {
            case ' ': {
                this.flag_space = true;
                break;
            }
            case '\n': {
                this.println();
                break;
            }
            default: {
                this.checkIndent();
                this.emitter.emit(c);
                this.flag_justindent = false;
            }
        }
    }

    final void println() {
        this.flag_space = false;
        ++this.newlinesPending;
        this.lastToken = (short)5;
    }

    final void ensureNewlines(int n) {
        int n2 = this.newlines();
        if (n <= n2) {
            return;
        }
        this.flag_space = false;
        this.newlinesPending += n - n2;
        this.lastToken = (short)5;
    }

    private void flushNewlines(int n) {
        if (this.newlinesEmitted >= n) {
            return;
        }
        int n2 = n - this.newlinesEmitted;
        if (this.newlinesPending < n2) {
            FormatLayer1.panic("Insufficient newlines");
        }
        int n3 = 0;
        while (n3 < n2) {
            this.emitter.emit('\n');
            ++n3;
        }
        this.newlinesEmitted += n2;
        this.newlinesPending -= n2;
        this.alignmentMark_height = -1;
    }

    private void flush() {
        if (this.newlinesPending > 0) {
            int n = 0;
            while (n < this.newlinesPending) {
                this.emitter.emit('\n');
                ++n;
            }
            this.newlinesEmitted += this.newlinesPending;
            this.newlinesPending = 0;
            this.alignmentMark_height = -1;
        }
    }

    FormatLayer1() {
        this.$init$();
    }

    private static class FormatInfo {
        private int decoration;
        private byte indent;
        private int alignment;
        private int alignmentStamp;
        private int saved_alignmentMark_height;

        void $init$() {
            this.decoration = 0;
            this.indent = 0;
            this.alignment = 0;
            this.alignmentStamp = 0;
            this.saved_alignmentMark_height = -1;
        }

        private FormatInfo() {
            this.$init$();
        }

        static byte ra$indent(FormatInfo formatInfo) {
            return formatInfo.indent;
        }

        static void wa$alignment(FormatInfo formatInfo, int n) {
            formatInfo.alignment = n;
        }

        static void wa$alignmentStamp(FormatInfo formatInfo, int n) {
            formatInfo.alignmentStamp = n;
        }

        static int ra$saved_alignmentMark_height(FormatInfo formatInfo) {
            return formatInfo.saved_alignmentMark_height;
        }

        static void wa$saved_alignmentMark_height(FormatInfo formatInfo, int n) {
            formatInfo.saved_alignmentMark_height = n;
        }

        FormatInfo(1 var1_1) {
            this();
        }

        static void wa$decoration(FormatInfo formatInfo, int n) {
            formatInfo.decoration = n;
        }

        static void wa$indent(FormatInfo formatInfo, byte by) {
            formatInfo.indent = by;
        }

        static int ra$alignment(FormatInfo formatInfo) {
            return formatInfo.alignment;
        }

        static int ra$alignmentStamp(FormatInfo formatInfo) {
            return formatInfo.alignmentStamp;
        }

        public final class 1 {
        }
    }
}

