/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.format;

import oracle.javatools.parser.java.v2.internal.format.BufferedEmitter;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;

final class LineWrappingEmitter
extends BufferedEmitter {
    int resetCounter;
    private int zeroIndex;
    private int[] wrapColumns;
    private int[] columnAdjusts;
    private int wrapCount;
    private int totalAdjust;
    private byte wrapLineWidth;
    private int lastWrapBoundary;
    private int lastWrapBoundaryAlign;
    private int lastWrapBoundaryHeight;

    void $init$() {
        this.resetCounter = 0;
        this.zeroIndex = 0;
        this.wrapColumns = new int[2];
        this.columnAdjusts = new int[2];
        this.wrapCount = 0;
        this.totalAdjust = 0;
        this.wrapLineWidth = (byte)76;
    }

    void init(Sym sym) {
        int n = this.formatter.preferences.getInt(50);
        this.wrapLineWidth = n < 127 ? (byte)n : (byte)127;
        this.wrapCount = 0;
        this.totalAdjust = 0;
        this.resetCounter = 0;
        this.lastWrapBoundary = -1;
        this.lastWrapBoundaryAlign = -1;
        this.lastWrapBoundaryHeight = -1;
    }

    boolean isWrapCapable() {
        return true;
    }

    int getColumn() {
        int n = this.buffer.length();
        return n - this.zeroIndex - this.totalAdjust;
    }

    int getColumnStamp() {
        return this.resetCounter;
    }

    private void beforeNewline() {
        this.performLineWrapping();
    }

    private void afterNewline() {
        ++this.resetCounter;
        this.wrapCount = 0;
        this.totalAdjust = 0;
        this.zeroIndex = LineWrappingEmitter.lastIndexOfNewline(this.buffer) + 1;
        this.clearWrapBoundary();
    }

    final void clearWrapBoundary() {
        this.lastWrapBoundary = -1;
        this.lastWrapBoundaryAlign = -1;
        this.lastWrapBoundaryHeight = -1;
    }

    private int adjust(int n) {
        int n2 = n;
        int n3 = 0;
        while (n3 < this.wrapCount) {
            if (this.wrapColumns[n3] > n) break;
            n2 += this.columnAdjusts[n3];
            ++n3;
        }
        return n2;
    }

    void markWrapBoundary(int n) {
        int n2 = this.lastWrapBoundaryHeight;
        if (n2 >= 0) {
            if (this.shouldLineWrap()) {
                this.performLineWrapping();
            } else {
                int n3 = n;
                if (n3 > n2) {
                    return;
                }
            }
        }
        this.lastWrapBoundary = this.getColumn();
        this.lastWrapBoundaryAlign = this.formatter.getIndent();
        this.lastWrapBoundaryHeight = n;
    }

    private boolean shouldLineWrap() {
        if (this.lastWrapBoundary == -1) {
            return false;
        }
        int n = LineWrappingEmitter.lastIndexOfNewline(this.buffer) + 1;
        int n2 = this.buffer.length() - n;
        return this.wrapLineWidth <= n2;
    }

    void forceLineWrapping() {
        this.performLineWrappingImpl(this.buffer.length(), this.formatter.getIndent());
    }

    private void performLineWrapping() {
        if (this.lastWrapBoundary == -1) {
            return;
        }
        int n = LineWrappingEmitter.lastIndexOfNewline(this.buffer) + 1;
        int n2 = this.buffer.length() - n;
        if (this.wrapLineWidth <= n2) {
            int n3;
            int n4 = this.buffer.length();
            int n5 = n3 = this.adjust(this.lastWrapBoundary) + this.zeroIndex;
            while (n5 < n4 && this.buffer.charAt(n5) == ' ') {
                ++n5;
            }
            if (n5 < n4) {
                this.performLineWrappingImpl(n5, this.lastWrapBoundaryAlign);
            }
        }
    }

    private void performLineWrappingImpl(int n, int n2) {
        String string = this.buffer.substring(n);
        this.buffer.setLength(n);
        int n3 = this.getColumn();
        super.emit('\n');
        this.emitIndent(n2);
        int n4 = this.buffer.length() - n;
        if (string.length() > 0) {
            super.emit(string);
        }
        if (this.wrapColumns.length <= this.wrapCount) {
            int[] nArray = new int[this.wrapCount * 2];
            System.arraycopy(this.wrapColumns, 0, nArray, 0, this.wrapCount);
            this.wrapColumns = nArray;
            int[] nArray2 = new int[this.wrapCount * 2];
            System.arraycopy(this.columnAdjusts, 0, nArray2, 0, this.wrapCount);
            this.columnAdjusts = nArray2;
        }
        this.wrapColumns[this.wrapCount] = n3;
        this.columnAdjusts[this.wrapCount] = n4;
        ++this.wrapCount;
        this.totalAdjust += n4;
    }

    void emitIndent(int n) {
        int n2 = this.adjust(n) + this.zeroIndex;
        int n3 = LineWrappingEmitter.lastIndexOfNewline(this.buffer, n2);
        int n4 = n2 - (n3 + 1);
        super.emitIndent(n4);
    }

    void emit(String string) {
        boolean bl;
        boolean bl2 = bl = string.indexOf(10) >= 0;
        if (bl) {
            this.beforeNewline();
        }
        super.emit(string);
        if (bl) {
            this.afterNewline();
        }
    }

    void emit(char c) {
        boolean bl;
        boolean bl2 = bl = c == '\n';
        if (bl) {
            this.beforeNewline();
        }
        super.emit(c);
        if (bl) {
            this.afterNewline();
        }
    }

    public static int lastIndexOfNewline(StringBuffer stringBuffer) {
        int n = stringBuffer.lastIndexOf("\n");
        if (n != -1) {
            return n;
        }
        return stringBuffer.lastIndexOf("\r");
    }

    public static int lastIndexOfNewline(StringBuffer stringBuffer, int n) {
        int n2 = stringBuffer.lastIndexOf("\n", n);
        if (n2 != -1) {
            return n2;
        }
        return stringBuffer.lastIndexOf("\r", n);
    }

    LineWrappingEmitter() {
        this.$init$();
    }
}

